/*
 * Decompiled with CFR 0.152.
 */
package sync;

import edu.davidson.graphics.Border;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;
import sync.InertialState;
import sync.SHOState;
import sync.SyncCanvas;
import sync.SyncState;
import sync.WigglerState;

public class Sync
extends SApplet
implements SStepable {
    private String button_stop = "Stop";
    private String button_start = "Run ";
    private String label_speed = "v=";
    private String label_running = "Running";
    private String label_wiggler = "Wiggler";
    private String label_sho = "SHO";
    private String label_sync = "Sync";
    private String label_inertial = "Inertial";
    private String label_caption = "Electric Fields";
    private Scrollbar speedBar;
    private Label speedLabel;
    private Choice dynaChoice;
    public SyncCanvas dc;
    private Vector dynaSys = new Vector();
    private Button runBtn;
    private boolean showControls = true;
    private int numSteps = 100;
    private Graphics m_Graphics;
    boolean m_fStandAlone = false;
    private int m_FPS = 20;
    private double m_speed = 0.5;
    private String m_dynamics = "Wiggler";
    private int m_resolution = 2;
    private final String PARAM_FPS = "FPS";
    private final String PARAM_showControls = "ShowControls";
    private final String PARAM_speed = "Speed";
    private final String PARAM_dynamics = "Dynamics";
    private final String PARAM_resolution = "Resolution";
    private final String PARAM_numSteps = "NumSteps";

    public boolean handleEvent(Event event) {
        if (event.id == 605 || event.id == 602 || event.id == 601 || event.id == 604 || event.id == 603) {
            this.speedLabel.setText(String.valueOf(String.valueOf(this.label_speed)).concat(String.valueOf(String.valueOf((double)this.speedBar.getValue() / 100.0))));
            this.m_speed = (double)this.speedBar.getValue() / 100.0;
            boolean bl = this.clock.isRunning();
            this.clock.stopClock();
            this.dc.setSpeed(this.m_speed);
            if (bl) {
                this.clock.startClock();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.dynaChoice)) {
            boolean bl = this.clock.isRunning();
            this.clock.stopClock();
            if (((String)object).equalsIgnoreCase(this.label_sho)) {
                this.dc.setState(new SHOState());
            } else if (((String)object).equalsIgnoreCase(this.label_sync)) {
                this.dc.setState(new SyncState());
            } else if (((String)object).equalsIgnoreCase(this.label_inertial)) {
                this.dc.setState(new InertialState());
            } else if (((String)object).equalsIgnoreCase(this.label_wiggler)) {
                this.dc.setState(new WigglerState());
            }
            this.dc.setSpeed(this.m_speed);
            if (bl) {
                this.clock.startClock();
            } else {
                this.dc.repaint();
            }
        } else if (event.target.equals(this.runBtn)) {
            if (!this.clock.isRunning()) {
                this.clock.startClock();
                this.dc.message = this.label_running;
                this.runBtn.setLabel(this.button_stop);
            } else {
                this.clock.stopClock();
                this.runBtn.setLabel(this.button_start);
                this.dc.message = "";
                this.dc.repaint();
            }
        } else {
            return false;
        }
        return true;
    }

    public String getAppletInfo() {
        return "Name: Sync Ver 1.1c\r\nAuthor: Wolfgang Christian\r\nEmail: wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"FPS", "int", "FPS for screen redraws."}, {"Speed", "double", "Maximum speed of charge."}, {"Dynamics", "String", "Type of motion."}, {"Resolution", "int", "Drawing resolution for field lines."}};
        return stringArray;
    }

    protected void setResources() {
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.label_speed = this.localProperties.getProperty("label.speed", this.label_speed);
        this.label_running = this.localProperties.getProperty("label.running", this.label_running);
        this.label_wiggler = this.localProperties.getProperty("label.wiggler", this.label_wiggler);
        this.label_sho = this.localProperties.getProperty("label.sho", this.label_sho);
        this.label_sync = this.localProperties.getProperty("label.sync", this.label_sync);
        this.label_inertial = this.localProperties.getProperty("label.inertial", this.label_inertial);
        this.label_caption = this.localProperties.getProperty("label.caption", this.label_caption);
    }

    public void init() {
        this.initResources(null);
        this.dynaSys.addElement(new String(this.label_wiggler));
        this.dynaSys.addElement(new String(this.label_sho));
        this.dynaSys.addElement(new String(this.label_sync));
        this.dynaSys.addElement(new String(this.label_inertial));
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_speed = Double.valueOf(this.getParameter("Speed", "0.5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_FPS = Integer.parseInt(this.getParameter("FPS", "20"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numSteps = Integer.parseInt(this.getParameter("NumSteps", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_resolution = Integer.parseInt(this.getParameter("Resolution", "2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_dynamics = this.getParameter("Dynamics", this.label_wiggler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Applet)((Object)this)).resize(320, 360);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.setBackground(Color.lightGray);
        Border border = new Border((Component)panel, 1, 10);
        border.setBackground(Color.lightGray);
        if (this.showControls) {
            ((Container)((Object)this)).add("South", (Component)border);
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 1));
        this.speedBar = new Scrollbar(0, (int)((double)100 * this.m_speed), 4, 0, 95);
        panel2.add((Component)new Border((Component)this.speedBar, 1, 5));
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        this.speedLabel = new Label(String.valueOf(String.valueOf(this.label_speed)).concat(String.valueOf(String.valueOf(this.m_speed))));
        panel3.add(this.speedLabel);
        this.runBtn = new Button(this.button_start);
        panel3.add(this.runBtn);
        panel.add(panel3);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 3));
        panel4.add(new Label(this.label_caption));
        panel4.add(new Label(""));
        this.dynaChoice = new Choice();
        panel4.add(this.dynaChoice);
        for (int i = 0; i < this.dynaSys.size(); ++i) {
            this.dynaChoice.addItem((String)this.dynaSys.elementAt(i));
        }
        if (this.showControls) {
            ((Container)((Object)this)).add("North", panel4);
        }
        this.dc = new SyncCanvas(this);
        this.dc.setBackground(Color.white);
        ((Container)((Object)this)).add("Center", this.dc);
        this.dc.setResolution(this.m_resolution);
        this.setDynamics(this.m_dynamics);
        this.dc.setSpeed(this.m_speed);
        this.dc.setNumSteps(this.numSteps);
        this.clock.setDt((double)this.m_resolution);
        this.clock.setFPS((double)this.m_FPS);
        this.clock.addClockListener((SStepable)this);
    }

    public void destroy() {
        this.destroyed = true;
        this.clock.stopClock();
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            this.setDynamics(this.m_dynamics);
        }
    }

    public void forward() {
        this.runBtn.setLabel(this.button_stop);
        this.clock.startClock();
        this.dc.message = this.label_running;
    }

    public void pause() {
        this.runBtn.setLabel(this.button_start);
        this.clock.stopClock();
        this.dc.message = "";
        this.dc.repaint();
    }

    protected void pausingClock() {
        this.pause();
    }

    public void step(double d, double d2) {
        for (int i = 0; i < 5; ++i) {
            this.dc.incTime();
        }
        this.updateDataConnections();
        this.dc.repaint();
    }

    public void setDefault() {
        this.pause();
        this.clock.setTime(0.0);
        this.deleteDataConnections();
        this.dc.resetSource();
    }

    public void setDynamics(String string) {
        this.m_dynamics = string;
        if (string.equals("SHO")) {
            this.dc.setState(new SHOState());
            this.dynaChoice.select(this.label_sho);
        } else if (string.equals("Sync")) {
            this.dc.setState(new SyncState());
            this.dynaChoice.select(this.label_sync);
        } else if (string.equals("Inertial")) {
            this.dc.setState(new InertialState());
            this.dynaChoice.select(this.label_inertial);
        } else if (string.equals("Wiggler")) {
            this.dc.setState(new WigglerState());
            this.dynaChoice.select(this.label_wiggler);
        }
    }

    public void setCaption(String string) {
        this.dc.caption = string;
    }

    public void setSpeed(double d) {
        this.m_speed = d;
        this.speedLabel.setText(String.valueOf(String.valueOf(this.label_speed)).concat(String.valueOf(String.valueOf(this.m_speed))));
        this.speedBar.setValue((int)(this.m_speed * (double)100));
        boolean bl = this.clock.isRunning();
        this.clock.stopClock();
        this.dc.setSpeed(this.m_speed);
        if (bl) {
            this.clock.startClock();
        } else {
            this.dc.repaint();
        }
    }
}

