/*
 * Decompiled with CFR 0.152.
 */
package sync;

import edu.davidson.tools.SApplet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import sync.Generation;
import sync.State;
import sync.WigglerState;

class SyncCanvas
extends Canvas {
    SApplet applet;
    int numWaves = 100;
    private Vector genVec = new Vector();
    private int time = 0;
    private Image buff_image = this.createImage(1, 1);
    private int buff_width = 0;
    private int buff_height = 0;
    private State aState = new WigglerState();
    private int resolution;
    private int res_expand = 1;
    private int res_counter = 0;
    String message = "";
    String caption = "";
    Font font = new Font("Monospaced", 0, 14);

    public SyncCanvas(SApplet sApplet) {
        this.applet = sApplet;
        this.resetSource();
    }

    public void resetSource() {
        this.time = (int)this.aState.resetTime();
        this.aState.setOrigin(this.getSize().width / 2, this.getSize().height / 2);
        this.genVec.removeAllElements();
        this.res_counter = 0;
    }

    public void setSpeed(double d) {
        String string = this.aState.getClass().getName();
        this.res_expand = !string.equals("InertialState") ? 1 : (d < 0.8 ? 2 : (d < 0.9 ? 4 : 8));
        this.res_counter = 0;
        this.aState.setVMax(d);
        if (this.aState.t == 0.0) {
            this.genVec.removeAllElements();
        }
    }

    void setResolution(int n) {
        if (n > 0) {
            this.resolution = n;
        }
    }

    void setNumSteps(int n) {
        if (n > 0) {
            this.numWaves = n;
        }
    }

    public void setState(State state) {
        this.aState = state;
        this.aState.setOrigin(this.getSize().width / 2, this.getSize().height / 2);
        this.time = (int)this.aState.resetTime();
        this.res_counter = 0;
        while (this.genVec.size() > 0) {
            this.genVec.removeElementAt(0);
        }
    }

    void incTime() {
        this.time = (int)this.aState.incTime(this.resolution);
        double d = this.aState.getX();
        double d2 = this.aState.getY();
        double d3 = this.aState.getV();
        double d4 = this.aState.getU();
        if (this.res_counter <= 0) {
            this.genVec.addElement(new Generation(this.time, d, d2, d3, d4));
            if (this.genVec.size() > this.numWaves) {
                this.genVec.removeElementAt(0);
            }
            this.res_counter = this.res_expand - 1;
        } else {
            --this.res_counter;
        }
        if (d >= (double)this.getSize().width) {
            this.shiftSource(-this.getSize().width, 0);
        }
        if (d2 >= (double)this.getSize().height) {
            this.shiftSource(0, -this.getSize().height);
        }
    }

    void paint() {
        if (this.applet.destroyed) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        graphics.dispose();
    }

    public void shiftSource(int n, int n2) {
        int n3 = this.genVec.size();
        if (n3 <= 0) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            ((Generation)this.genVec.elementAt(i)).shift(n, n2);
        }
        this.aState.shiftOrigin(n, n2);
    }

    public void calcBuffImage() {
        double d = this.getSize().width > this.getSize().height ? (double)this.getSize().width : (double)this.getSize().height;
        Vector vector = (Vector)this.genVec.clone();
        int n = vector.size() - 1;
        Graphics graphics = this.buff_image.getGraphics();
        graphics.clearRect(0, 0, this.buff_width, this.buff_height);
        graphics.setColor(Color.black);
        if (n <= 1) {
            graphics.setColor(Color.red);
            graphics.fillOval((int)(this.aState.getX() - (double)2), (int)(this.aState.getY() - (double)2), 4, 4);
            graphics.setColor(Color.black);
            return;
        }
        Generation generation = (Generation)vector.elementAt(0);
        for (int i = 0; i < n; ++i) {
            Generation generation2 = (Generation)vector.elementAt(i);
            generation2.draw(this.time, generation, graphics);
            generation = generation2;
        }
        generation.draw(this.time, (int)this.aState.getX(), (int)this.aState.getY(), graphics);
        graphics.setColor(Color.red);
        graphics.fillOval((int)(this.aState.getX() - (double)2), (int)(this.aState.getY() - (double)2), 4, 4);
        graphics.setColor(Color.black);
        if (!this.caption.equals("")) {
            this.paintCaption(graphics);
        }
        graphics.dispose();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void paintMessage(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        String string = this.message;
        if (string == null || graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n3 = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(n - n3 - 5, n2 - 15, n3, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, n - n3 + 2, n2 - 3);
        graphics.drawRect(n - n3 - 5, n2 - 15, n3, 15);
    }

    public void paintCaption(Graphics graphics) {
        int n = this.getSize().width;
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        graphics.drawString(this.caption, (n - fontMetrics.stringWidth(this.caption)) / 2, 25);
        graphics.setFont(font);
    }

    public void paint(Graphics graphics) {
        if (this.applet.destroyed) {
            return;
        }
        if (this.getSize().width != this.buff_width || this.getSize().height != this.buff_height) {
            this.resetSource();
            this.buff_width = this.getSize().width;
            this.buff_height = this.getSize().height;
            this.buff_image = this.createImage(this.buff_width, this.buff_height);
        }
        if (this.buff_image == null) {
            return;
        }
        this.calcBuffImage();
        graphics.drawImage(this.buff_image, 0, 0, this);
        if (!this.message.equals("")) {
            this.paintMessage(graphics);
        }
    }
}

