/*
 * Decompiled with CFR 0.152.
 */
package dataGraph;

import dataGraph.SLabel;
import edu.davidson.graph.TextLine;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;

public class Bar
extends SApplet
implements SDataListener {
    boolean isStandalone = false;
    double min;
    double max;
    boolean vert;
    int numBars = 1;
    EtchedBorder etchedBorder = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    double value = 0.0;
    Color negColor = Color.blue;
    Color posColor = Color.red;
    BarGraph bar = new BarGraph();
    BorderLayout borderLayout2 = new BorderLayout();
    SLabel valField = new SLabel();
    boolean showControls = false;
    boolean autoScale = false;
    Panel panel1 = new Panel();
    Label barLabel = new Label();
    TextLine title = new TextLine();
    String titleStr = "";

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        int n = 10;
        String string = "";
        try {
            this.min = Double.valueOf(this.getParameter("Min", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.max = Double.valueOf(this.getParameter("Max", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.value = Double.valueOf(this.getParameter("Value", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.vert = Boolean.valueOf(this.getParameter("Vertical", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoScale = Boolean.valueOf(this.getParameter("AutoScale", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            n = Integer.parseInt(this.getParameter("BarWidth", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numBars = Integer.parseInt(this.getParameter("NumSeries", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = this.getParameter("Label", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.titleStr = this.getParameter("Title", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.showControls) {
            this.panel1.setVisible(false);
        }
        this.valField.setValue(this.value);
        this.bar.barWidth = n;
        if (string.equals("")) {
            this.barLabel.setVisible(false);
        } else {
            this.barLabel.setText(string);
            this.barLabel.setVisible(true);
        }
        SApplet.addDataListener((Object)((Object)this));
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.bar.setLayout(this.borderLayout2);
        this.barLabel.setAlignment(2);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.panel1.setBackground(Color.lightGray);
        this.etchedBorder.setBackground(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.etchedBorder, "Center");
        ((Container)((Object)this)).add(this.panel1, "South");
        this.panel1.add((Component)this.barLabel, null);
        this.panel1.add((Component)this.valField, null);
        this.etchedBorder.add((Component)this.bar, "Center");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Min", "double", "Minimum value"}, {"Max", "double", "Maximum value"}, {"Vertical", "boolean", "Orientation"}};
        return stringArray;
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
        }
    }

    public void setAutoscale(boolean bl) {
        this.autoScale = bl;
        this.bar.repaint();
    }

    public void setFormat(String string) {
        this.valField.setFormat(string);
    }

    public void setLabel(String string) {
        this.barLabel.setText(string);
        if (string.equals("")) {
            this.barLabel.setVisible(false);
        } else {
            this.barLabel.setVisible(true);
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setTtile(String string) {
        this.titleStr = string;
        this.bar.repaint();
    }

    public void setBarWidth(int n) {
        this.bar.barWidth = n;
        this.bar.repaint();
    }

    public void setMax(double d) {
        this.max = d;
        this.bar.repaint();
    }

    public void setMin(double d) {
        this.min = d;
        this.bar.repaint();
    }

    public void setValue(double d) {
        if (this.autoScale) {
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
        }
        this.value = d;
        this.valField.setValue(d);
        this.bar.repaint();
    }

    public void setPosRGB(int n, int n2, int n3) {
        this.posColor = new Color(n, n2, n3);
    }

    public void setNegRGB(int n, int n2, int n3) {
        this.negColor = new Color(n, n2, n3);
    }

    public void setNumericFormat(String string) {
        this.valField.setFormat(string);
    }

    public void addDatum(int n, double d, double d2) {
        this.setValue(d);
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.setValue(d);
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return;
        }
        int n2 = dArray.length;
        if (n2 < 1) {
            return;
        }
        this.setValue(dArray[n2 - 1]);
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        this.addData(n, dArray, dArray2);
    }

    public void deleteSeries(int n) {
        this.setValue(0.0);
    }

    public void clearSeries(int n) {
        this.setValue(0.0);
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    class BarGraph
    extends Panel {
        int barWidth = 10;
        Image osi = null;

        BarGraph() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n = this.getBounds().width;
            int n2 = this.getBounds().height;
            if (n < 4 || n2 < 4) {
                return;
            }
            if (this.osi == null || this.osi.getWidth(this) != n || this.osi.getHeight(this) != n2) {
                this.osi = this.createImage(n, n2);
            }
            if (this.osi == null) {
                return;
            }
            this.paintOSI();
            graphics.drawImage(this.osi, 0, 0, n, n2, this);
        }

        private void paintOSI() {
            double d = 0.0;
            if (Bar.this.min <= 0.0 && Bar.this.max > 0.0) {
                d = 0.0;
            }
            Graphics graphics = this.osi.getGraphics();
            int n = this.getBounds().width;
            int n2 = this.getBounds().height;
            Color color = ((Component)((Object)Bar.this)).getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            if (Bar.this.vert) {
                int n3;
                int n4 = (int)(0.4999999 + (double)n2 * Bar.this.max / (Bar.this.max - Bar.this.min));
                if ((n2 = (int)((double)n2 * (Bar.this.value - d) / (Bar.this.max - Bar.this.min))) >= 0) {
                    n3 = n4 - n2;
                    graphics.setColor(Bar.this.posColor);
                } else {
                    n3 = n4;
                    n2 = -n2;
                    graphics.setColor(Bar.this.negColor);
                }
                graphics.fillRect(n / 2 - this.barWidth, n3, 2 * this.barWidth, n2);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n4, n - 1, n4);
            } else {
                int n5;
                int n6 = (int)(0.4999999 - (double)n * Bar.this.min / (Bar.this.max - Bar.this.min));
                if ((n = (int)((double)n * (Bar.this.value - d) / (Bar.this.max - Bar.this.min))) >= 0) {
                    n5 = n6;
                    graphics.setColor(Bar.this.posColor);
                } else {
                    n = -n;
                    n5 = n6 - n;
                    graphics.setColor(Bar.this.negColor);
                }
                graphics.fillRect(n5, n2 / 2 - this.barWidth, n, 2 * this.barWidth);
                graphics.setColor(Color.black);
                graphics.drawLine(n6, 0, n6, n2 - 1);
            }
            if (!Bar.this.titleStr.equals("")) {
                Bar.this.title.setText(Bar.this.titleStr);
                Bar.this.title.draw(graphics, n / 2, 15, 0);
            }
            graphics.dispose();
        }
    }
}

