/*
 * Decompiled with CFR 0.152.
 */
package dataGraph;

import edu.davidson.display.Format;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

public class SLabel
extends Panel {
    double val = 0.0;
    int preferredW = 20;
    double chopVal = 1.0E-12;
    Format format = new Format("%-+6.2g");
    Format formatI = new Format("%-+6d");
    Dimension ms = new Dimension(20, 17);
    Dimension ps = new Dimension(this.preferredW, 17);

    public SLabel() {
        this.setBackground(Color.white);
    }

    public void setValue(double d) {
        this.val = d;
        this.repaint();
    }

    public void setFormat(String string) {
        this.format = new Format(string);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getBounds().height;
        int n2 = this.getBounds().width;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n2, n);
        graphics.setColor(Color.black);
        String string = Math.abs(this.val - (double)((int)this.val)) <= this.chopVal ? this.formatI.form((long)((int)this.val)) : this.format.form(SUtil.chop((double)this.val, (double)this.chopVal));
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n3 = fontMetrics.stringWidth(string);
        if (n3 > this.preferredW) {
            this.preferredW = n3 + 4;
            this.ps = new Dimension(this.preferredW, 17);
            this.getParent().invalidate();
            this.getParent().validate();
        }
        graphics.drawString(string, (n2 - n3) / 2, n - fontMetrics.getDescent() - 2);
    }

    public Dimension getMinimumSize() {
        return this.ms;
    }

    public void setMinimumSize(Dimension dimension) {
        this.ms = dimension;
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public void setPreferredSize(Dimension dimension) {
        this.ps = dimension;
    }
}

