/*
 * Decompiled with CFR 0.152.
 */
package energyEigenvalue;

import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.ThreadButton;
import edu.davidson.tools.SApplet;
import energyEigenvalue.EnergyGraph;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class EnergyEigenvalue
extends SApplet {
    boolean autoscalePotential = false;
    boolean sa;
    boolean sf;
    boolean isStandalone = false;
    boolean noscale = false;
    double energy;
    double hBar;
    double xmin;
    double xmax;
    double breakvalue;
    double ymin;
    double ymax;
    double tolerance;
    int iterations;
    String potentialStr;
    int nump;
    int lower;
    int higher;
    boolean showControls;
    boolean ss;
    boolean sc;
    boolean sp;
    EtchedBorder controlpanel = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EnergyGraph energyGraph = new EnergyGraph(this);
    Panel panel1 = new Panel();
    Panel potentialpanel = new Panel();
    Label label1 = new Label();
    TextField potentialFcn = new TextField();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    Button update = new Button();
    Panel panel3 = new Panel();
    Panel panel4 = new Panel();
    SNumber evalue = new SNumber();
    Label label2 = new Label();
    ThreadButton forward = new ThreadButton();
    ThreadButton rewind = new ThreadButton();
    ThreadButton frewind = new ThreadButton();
    ThreadButton fforward = new ThreadButton();
    SInteger elevel = new SInteger();
    Button find = new Button();
    Label label3 = new Label();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.xmin = Double.valueOf(this.getParameter("XMin", "-5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmax = Double.valueOf(this.getParameter("XMax", "5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymin = Double.valueOf(this.getParameter("YMin", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymax = Double.valueOf(this.getParameter("YMax", "25"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.hBar = Double.valueOf(this.getParameter("HBarTwoM", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.energy = Double.valueOf(this.getParameter("Energy", "1.0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.potentialStr = this.getParameter("Potential", "x*x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoscalePotential = Boolean.valueOf(this.getParameter("AutoScaleY", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ss = Boolean.valueOf(this.getParameter("ShowSpectrum", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sp = Boolean.valueOf(this.getParameter("ShowPotential", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sf = Boolean.valueOf(this.getParameter("ShowFunctions", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.nump = Integer.valueOf(this.getParameter("NumPts", "200"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.lower = Integer.valueOf(this.getParameter("Lowest", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.higher = Integer.valueOf(this.getParameter("Highest", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.tolerance = Double.valueOf(this.getParameter("Tolerance", "1e-8"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.iterations = Integer.valueOf(this.getParameter("MaxIterations", "40"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.breakvalue = Double.valueOf(this.getParameter("BreakValue", "1e12"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sa = Boolean.valueOf(this.getParameter("ScaleToArea", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.energyGraph.setShowWavefunction(this.sf);
        this.energyGraph.setAutoscalePotential(this.autoscalePotential);
        this.energyGraph.setNumpts(this.nump);
        this.energyGraph.setIterations(this.iterations);
        this.energyGraph.setTolerance(this.tolerance);
        this.energyGraph.setBreakValue(this.breakvalue);
        this.energyGraph.showSpectrum(this.ss);
        this.setShowControls(this.sc);
        this.setShowPotential(this.sp);
        this.energyGraph.scaleToArea(this.sa);
        this.energyGraph.sethBar(this.hBar);
        this.energyGraph.setEnergy(this.energy);
        this.energyGraph.setMinMaxX(this.xmin, this.xmax);
        this.potentialFcn.setText(this.potentialStr);
        this.energyGraph.setPotential(this.potentialStr);
        this.energyGraph.setMinMaxY(this.ymin, this.ymax);
        this.energyGraph.setGraphBackground(SystemColor.control);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout2);
        this.potentialpanel.setLayout(this.borderLayout1);
        this.energyGraph.setLabelY("Energy");
        this.energyGraph.setEnableMouse(false);
        ((Component)((Object)this)).setSize(new Dimension(387, 342));
        this.etchedBorder2.setLayout(this.borderLayout5);
        ((Component)((Object)this.energyGraph)).setBackground(SystemColor.control);
        this.energyGraph.setSampleData(false);
        this.energyGraph.setBorders("0,10,100,0");
        this.energyGraph.setAutoscaleX(false);
        this.energyGraph.setAutoscaleY(false);
        this.energyGraph.setLabelX("X");
        this.label1.setAlignment(1);
        this.label1.setText("Potential");
        this.potentialFcn.setText("x*x");
        this.update.setLabel("Update");
        this.panel3.setLayout(this.flowLayout2);
        this.panel4.setLayout(this.flowLayout1);
        this.evalue.setColumns(8);
        this.evalue.setValue(1.0);
        this.evalue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.evalue_actionPerformed(actionEvent);
            }
        });
        this.label2.setAlignment(2);
        this.label2.setText("Energy =");
        this.forward.setLabel(">");
        this.forward.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EnergyEigenvalue.this.forward_mouseReleased(mouseEvent);
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.forward_actionPerformed(actionEvent);
            }
        });
        this.rewind.setLabel("<");
        this.rewind.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EnergyEigenvalue.this.rewind_mouseReleased(mouseEvent);
            }
        });
        this.rewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.rewind_actionPerformed(actionEvent);
            }
        });
        this.frewind.setLabel("<<");
        this.frewind.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EnergyEigenvalue.this.frewind_mouseReleased(mouseEvent);
            }
        });
        this.frewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.frewind_actionPerformed(actionEvent);
            }
        });
        this.fforward.setLabel(">>");
        this.fforward.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EnergyEigenvalue.this.fforward_mouseReleased(mouseEvent);
            }
        });
        this.fforward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.fforward_actionPerformed(actionEvent);
            }
        });
        this.elevel.setValue(1);
        this.find.setLabel("Find");
        this.label3.setAlignment(2);
        this.label3.setText("n =");
        this.borderLayout2.setHgap(20);
        this.flowLayout1.setHgap(1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout2.setHgap(0);
        this.flowLayout2.setAlignment(2);
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.find_actionPerformed(actionEvent);
            }
        });
        this.update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyEigenvalue.this.update_actionPerformed(actionEvent);
            }
        });
        this.controlpanel.setLayout(this.borderLayout4);
        ((Container)((Object)this)).setLayout(this.borderLayout3);
        this.controlpanel.setBackground(Color.lightGray);
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "Center");
        this.etchedBorder2.add((Component)((Object)this.energyGraph), "Center");
        ((Container)((Object)this)).add((Component)this.controlpanel, "South");
        this.controlpanel.add((Component)this.potentialpanel, "North");
        this.potentialpanel.add((Component)this.potentialFcn, "Center");
        this.potentialpanel.add((Component)this.label1, "West");
        this.potentialpanel.add((Component)this.update, "East");
        this.controlpanel.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.panel4, "Center");
        this.panel4.add((Component)this.label2, null);
        this.panel4.add((Component)this.evalue, null);
        this.panel4.add((Component)this.frewind, null);
        this.panel4.add((Component)this.rewind, null);
        this.panel4.add((Component)this.forward, null);
        this.panel4.add((Component)this.fforward, null);
        this.panel1.add((Component)this.panel3, "East");
        this.panel3.add((Component)this.find, null);
        this.panel3.add((Component)this.label3, null);
        this.panel3.add((Component)this.elevel, null);
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            super.start();
            this.energyGraph.setOwner(this);
            this.energyGraph.updated = true;
            this.energyGraph.setTitle(null);
            this.energyGraph.purgeHashtable();
            this.energyGraph.setPotential(this.potentialStr);
            this.energyGraph.updated = false;
            this.findEnergyLevel(this.lower);
            this.findEnergyLevels(this.lower, this.higher);
        }
    }

    public void destroy() {
        this.energyGraph.destroy();
        this.forward.destroy();
        this.rewind.destroy();
        this.frewind.destroy();
        this.fforward.destroy();
        super.destroy();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Energy", "double", "Initial energy"}, {"Potential", "String", "Potential Energy"}, {"ShowControls", "boolean", "Show user controls"}, {"HBar", "double", "hBar value"}, {"AutoscalePotential", "boolean", "autoscales the ys axis based on potential."}, {"ShowPotential", "boolean", "shows or hides potential panel"}, {"Lower", "int", "lowest e level to find"}, {"Higher", "int", "highest e level to find"}, {"NumPts", "int", "number of points to graph"}, {"MaxIterations", "int", "number of iterations for binary search to perform"}, {"BreakValue", "double", "max divergent value allowed value before Psi algorithm quits"}};
        return stringArray;
    }

    public int getWavefunctionID(int n) {
        return this.energyGraph.getWavefunctionID(n);
    }

    public int getActiveWavefunctionID() {
        return this.energyGraph.getActiveWavefunctionID();
    }

    public int getActiveStateID() {
        return this.energyGraph.getActiveStateID();
    }

    public double getActiveEnergy() {
        return this.energyGraph.getActiveEnergy();
    }

    public int getActiveQuantumNumber() {
        return this.energyGraph.getActiveQuantumNumber();
    }

    void update_actionPerformed(ActionEvent actionEvent) {
        this.energyGraph.updated = true;
        this.energyGraph.setTitle(null);
        this.energyGraph.purgeHashtable();
        this.energyGraph.setPotential(this.potentialFcn.getText());
        this.energyGraph.updated = false;
    }

    void find_actionPerformed(ActionEvent actionEvent) {
        int n = this.elevel.getValue();
        if (n < 1) {
            this.elevel.setBackground(Color.red);
        } else {
            this.energyGraph.updated = true;
            this.energyGraph.setPotential(this.potentialFcn.getText());
            this.energyGraph.updated = false;
            this.energyGraph.resetE = true;
            double d = this.energyGraph.findElevel(n, true);
            if (!this.noscale) {
                this.energyGraph.scaleData(d, true);
            }
            this.evalue.setValue(d);
        }
    }

    void fforward_actionPerformed(ActionEvent actionEvent) {
        double d = this.evalue.getValue();
        this.setPsi(d);
        this.evalue.setValue(d += 0.1);
    }

    void frewind_actionPerformed(ActionEvent actionEvent) {
        double d = this.evalue.getValue();
        this.setPsi(d);
        this.evalue.setValue(d -= 0.1);
    }

    void forward_actionPerformed(ActionEvent actionEvent) {
        double d = this.evalue.getValue();
        this.setPsi(d);
        this.evalue.setValue(d += 0.005);
    }

    void rewind_actionPerformed(ActionEvent actionEvent) {
        double d = this.evalue.getValue();
        this.setPsi(d);
        this.evalue.setValue(d -= 0.005);
    }

    public void setAutoscaleY(boolean bl) {
        this.autoscalePotential = bl;
        this.energyGraph.setAutoscalePotential(bl);
    }

    public void setScaleToArea(boolean bl) {
        this.energyGraph.scaleToArea(bl);
    }

    public void setShowControls(boolean bl) {
        this.controlpanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setPsi(double d) {
        this.energyGraph.setEnergy(d);
        this.energyGraph.calculatePsi(d);
        this.energyGraph.scaleData(d, true);
        this.energyGraph.drawEnergyLine(this.energyGraph.pixFromY(d));
    }

    public void setPotential(String string, double d, double d2) {
        this.potentialStr = string;
        this.potentialFcn.setText(string);
        this.energyGraph.setMinMaxX(d, d2);
        this.energyGraph.updated = true;
        this.energyGraph.setTitle(null);
        this.energyGraph.purgeHashtable();
        this.energyGraph.setPotential(string);
        this.energyGraph.updated = false;
    }

    public void setShowPotential(boolean bl) {
        this.potentialpanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setMinMaxX(double d, double d2) {
        String string = this.energyGraph.potFunc.getFunctionString();
        this.setPotential(string, d, d2);
    }

    public void setMinMaxY(double d, double d2) {
        this.energyGraph.setMinMaxY(d, d2);
    }

    public void findEnergyLevels(int n, int n2) {
        this.energyGraph.calculateLevels(n, n2);
    }

    public void findEnergyLevel(int n) {
        this.elevel.setValue(n);
        this.energyGraph.updated = false;
        this.energyGraph.resetE = true;
        double d = this.energyGraph.findElevel(n, true);
        if (!this.noscale) {
            this.energyGraph.scaleData(d, true);
        }
        this.evalue.setValue(d);
    }

    void frewind_mouseReleased(MouseEvent mouseEvent) {
    }

    void rewind_mouseReleased(MouseEvent mouseEvent) {
    }

    void forward_mouseReleased(MouseEvent mouseEvent) {
    }

    void fforward_mouseReleased(MouseEvent mouseEvent) {
    }

    void evalue_actionPerformed(ActionEvent actionEvent) {
        this.setPsi(this.evalue.getValue());
    }
}

