/*
 * Decompiled with CFR 0.152.
 */
package energyEigenvalue;

import edu.davidson.display.Format;
import edu.davidson.display.SGraph;
import edu.davidson.display.SGraphFrame;
import edu.davidson.graph.Graph2D;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import energyEigenvalue.EnergyEigenvalue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class EnergyGraph
extends SGraph {
    Vector dataSources = new Vector();
    ActiveWavefunction activeWavefunction = null;
    ActiveState activeState = null;
    Parser potFunc;
    boolean showLevels;
    boolean rclicked;
    boolean lines;
    boolean divergence = false;
    boolean broke = false;
    boolean resetE = false;
    boolean updated;
    boolean showWavefunction = true;
    private int active = 0;
    private double breakv;
    private int max;
    private int low = 0;
    private Hashtable eValues = new Hashtable();
    int boxWidth = 0;
    int ktemp = 0;
    int kcheck = 0;
    int maxiterations;
    Format format = new Format("%-+6.3g");
    int numPts;
    private double[] psi = null;
    private double[] psigraphed = null;
    private double[] y = null;
    private double[] x = null;
    private double eGuess;
    private double h;
    private double energy;
    private double dx;
    private double eMax;
    private double eMin;
    private double datamax;
    private double funcmin;
    private double funcmax;
    private double tolerance;
    EnergyEigenvalue owner = null;
    private boolean autoscalePotential = false;
    private double sum = 0.0;
    private boolean scalearea = false;
    private boolean energyDragMode = false;

    public EnergyGraph(EnergyEigenvalue energyEigenvalue) {
        this.owner = energyEigenvalue;
        this.setOwner(energyEigenvalue);
        try {
            this.jbInit();
            this.setSeriesStyle(1, Color.red, true, 0);
            this.setSeriesStyle(2, Color.blue, true, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAutoscalePotential(boolean bl) {
        this.autoscalePotential = bl;
    }

    synchronized boolean setPotential(String string) {
        boolean bl = false;
        this.datamax = 0.0;
        this.funcmin = 0.0;
        this.potFunc = new Parser(1);
        this.potFunc.defineVariable(1, "x");
        this.potFunc.define(string);
        this.potFunc.parse();
        if (this.potFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse V(x): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.potFunc.getErrorString()).append(" at function 1, position ").append(this.potFunc.getErrorPosition()))));
            bl = true;
            string = "0";
            this.potFunc.define(string);
            this.potFunc.parse();
        } else {
            bl = false;
        }
        this.dx = (this.getMaxX() - this.getMinX()) / (double)(this.numPts - 1);
        this.x[0] = this.getMinX();
        this.y[0] = this.potFunc.evaluate(this.x[0]);
        this.funcmin = this.y[0];
        this.funcmax = this.y[0];
        for (int i = 1; i < this.numPts; ++i) {
            this.x[i] = this.x[i - 1] + this.dx;
            this.y[i] = this.potFunc.evaluate(this.x[i]);
            if (this.y[i] > this.funcmax) {
                this.funcmax = this.y[i];
            }
            if (!(this.y[i] < this.funcmin)) continue;
            this.funcmin = this.y[i];
        }
        this.eMin = this.funcmin;
        this.eMax = this.funcmax;
        this.setAutoRefresh(false);
        if (this.autoscalePotential) {
            this.setAutoscaleY(true);
        }
        this.setAutoReplaceData(1, false);
        this.setAutoReplaceData(2, false);
        this.clearSeriesData(2);
        this.clearSeriesData(1);
        this.setAutoReplaceData(1, true);
        this.setAutoReplaceData(2, true);
        if (this.showWavefunction) {
            this.addData(1, this.x, this.y);
        }
        if (!this.updated) {
            if (this.showWavefunction) {
                this.addData(2, this.x, this.psigraphed);
            }
            if (this.activeWavefunction != null) {
                this.activeWavefunction.updateValues(this.energy);
            }
            if (this.activeState != null) {
                this.activeState.updateValues(this.energy, this.active);
            }
        }
        if (this.autoscalePotential) {
            this.setAutoscaleY(false);
        }
        if (this.autoscalePotential) {
            double d;
            double d2 = this.funcmin;
            double d3 = this.funcmax;
            Enumeration enumeration = this.eValues.elements();
            while (enumeration.hasMoreElements()) {
                d = (Double)enumeration.nextElement();
                d2 = Math.min(d2, d);
                d3 = Math.max(d3, d);
            }
            d = d3 - d2;
            this.setMinMaxY(d2 - 0.12 * d, d3 + 0.12 * d);
        }
        this.setAutoRefresh(true);
        return !bl;
    }

    void setIterations(int n) {
        this.maxiterations = n;
    }

    void setBreakValue(double d) {
        this.breakv = d;
    }

    void setEnergy(double d) {
        this.energy = d;
        this.active = 0;
    }

    void sethBar(double d) {
        this.h = d;
    }

    void setNumpts(int n) {
        this.numPts = n;
        this.psi = new double[this.numPts];
        this.psigraphed = new double[this.numPts];
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
    }

    void setTolerance(double d) {
        this.tolerance = d;
    }

    void scaleToArea(boolean bl) {
        this.scalearea = bl;
    }

    void setShowWavefunction(boolean bl) {
        this.showWavefunction = bl;
        if (bl) {
            this.setShowAxis(true);
            ((Graph2D)this).frame = true;
            this.setDataBackground(Color.white);
        } else {
            this.setShowAxis(false);
            ((Graph2D)this).frame = false;
            this.setDataBackground(SystemColor.control);
        }
    }

    public int calculatePsi(double d) {
        int n;
        if (this.psi == null) {
            this.divergence = true;
            return 0;
        }
        this.divergence = false;
        int n2 = 0;
        double d2 = 1.0E-4;
        double d3 = this.h * (10.0 * this.dx * this.dx) / 12.0;
        double d4 = this.h * this.dx * this.dx / 12.0;
        this.psi[0] = 0.0;
        this.psi[1] = 1.0E-12;
        this.sum = this.psi[1] * this.psi[1] * this.dx;
        for (n = 1; n < this.numPts - 1; ++n) {
            double d5 = this.y[n] - d;
            double d6 = this.y[n - 1] - d;
            double d7 = this.y[n + 1] - d;
            double d8 = this.psi[n] * ((double)2 + d3 * (this.y[n] - d)) - this.psi[n - 1] * (1.0 - d4 * (this.y[n - 1] - d));
            double d9 = 1.0 - d4 * (this.y[n + 1] - d);
            this.psi[n + 1] = d8 / d9;
            if (this.psi[n + 1] > this.breakv) {
                this.broke = true;
                System.out.println("psi>breakvalue: wavefunction not accurate");
                break;
            }
            this.sum += this.psi[n + 1] * this.psi[n + 1] * this.dx;
        }
        n = 0;
        for (int i = 1; i < this.numPts; ++i) {
            if (this.psi[i] != 0.0 && !(this.psi[i - 1] / this.psi[i] < 0.0)) continue;
            ++n2;
            n = i;
        }
        if (n2 < 1 || n < 4) {
            n = this.numPts;
        }
        this.datamax = 0.0;
        double d10 = 0.0;
        for (int i = 1; i < n; ++i) {
            d10 = Math.abs(this.psi[i]);
            if (!(this.datamax < d10)) continue;
            this.datamax = d10;
        }
        if (Math.abs(this.psi[this.numPts - 1]) >= this.datamax) {
            this.divergence = true;
        }
        return n2;
    }

    public void purgeHashtable() {
        Enumeration enumeration = this.eValues.keys();
        while (enumeration.hasMoreElements()) {
            this.eValues.remove(enumeration.nextElement());
        }
        this.dataSources.removeAllElements();
        this.owner.deleteDataConnections();
    }

    public double findElevel(int n, boolean bl) {
        this.active = n;
        this.checkPotential(n);
        String string = "".concat(String.valueOf(String.valueOf(n)));
        int n2 = 0;
        if (this.resetE) {
            this.eMax = this.funcmax;
            this.eMin = this.funcmin;
            this.energy = (this.funcmax - this.funcmin) / 2.0;
            this.resetE = false;
        }
        if (this.eValues.get(string) != null) {
            this.energy = (Double)this.eValues.get(string);
            this.calculatePsi(this.energy);
            this.active = n;
            this.scaleData(this.energy, bl);
            this.setTitle(null);
        } else {
            for (int i = 0; this.calculatePsi(this.eMax) < n && i < 100; ++i) {
                this.eMax = 1.1 * this.eMax + 1.0;
            }
            for (int i = 1; i < this.maxiterations; ++i) {
                n2 = this.calculatePsi(this.energy);
                if (Math.abs(this.psi[this.numPts - 1]) < this.tolerance && n2 == n) break;
                if (n2 > n) {
                    this.eMax = this.energy;
                }
                if (n2 < n) {
                    this.eMin = this.energy;
                }
                if (n2 == n) {
                    if (this.psi[this.numPts - 1] < 0.0) {
                        this.eGuess = this.eMax = this.energy;
                    }
                    if (this.psi[this.numPts - 1] > 0.0) {
                        this.eGuess = this.eMax = this.energy;
                    }
                }
                if (n2 > n) {
                    this.energy = this.eGuess = (this.eGuess + this.eMin) / 2.0;
                } else if (n2 < n) {
                    this.energy = this.eGuess = (this.eMax + this.eGuess) / 2.0;
                } else if (n2 == n) {
                    if (this.psi[this.numPts - 1] < 0.0) {
                        this.energy = (this.eMax + this.eMin) / 2.0;
                    }
                    if (this.psi[this.numPts - 1] > 0.0) {
                        this.energy = (this.eMax + this.eMin) / 2.0;
                    }
                }
                if (i != this.maxiterations - 1) continue;
                System.out.println("Hit maximum iterations. n=".concat(String.valueOf(String.valueOf(n))));
            }
            if (!this.divergence && !(this.broke | (!this.autoscalePotential && this.energy > this.getMaxY()))) {
                this.eValues.put(string, new Double(this.energy));
                this.divergence = false;
            }
        }
        if (this.energy > this.getMaxY() && !this.autoscalePotential) {
            this.owner.noscale = true;
            this.setTitle("Level out of Range");
        } else {
            this.owner.noscale = false;
        }
        this.active = n;
        return this.energy;
    }

    public void scaleData(double d, boolean bl) {
        double d2;
        double d3;
        this.setAutoRefresh(false);
        this.clearSeriesData(2);
        double d4 = this.getMaxY() - this.getMinY();
        if (this.autoscalePotential && d > this.getMaxY() - 0.12 * d4) {
            d3 = d;
            d2 = this.getMinY();
            this.setMinMaxY(d2, d3 + 0.12 * (d3 - d2));
        }
        if (this.autoscalePotential && d < this.getMinY()) {
            d3 = this.getMaxY();
            d2 = d;
            if (!(d < this.funcmax)) {
                this.setMinMaxY(d2 - 0.12 * (d2 - d3), d3);
            }
        }
        d3 = (this.getMaxY() - this.getMinY()) * 0.1 / this.datamax;
        d2 = (this.getMaxY() - this.getMinY()) * (this.getMaxX() - this.getMinX()) * 0.02 / Math.sqrt(this.sum);
        for (int i = 0; i < this.numPts; ++i) {
            this.psigraphed[i] = this.scalearea ? d2 * this.psi[i] + d : d3 * this.psi[i] + d;
        }
        if (this.showWavefunction) {
            this.addData(2, this.x, this.psigraphed);
        }
        if (this.activeWavefunction != null) {
            this.activeWavefunction.updateValues(this.energy);
        }
        if (this.activeState != null) {
            this.activeState.updateValues(this.energy, this.active);
        }
        if ((this.divergence || this.broke) && !this.rclicked) {
            this.setTitle("No Convergence");
        } else {
            this.setTitle(null);
        }
        if (this.rclicked) {
            this.setTitle(null);
        }
        this.divergence = false;
        this.broke = false;
        this.setAutoRefresh(true);
    }

    private void checkPotential(int n) {
        if (this.eMax == this.eMin) {
            this.eMax = this.eMin + 10.0;
            this.energy = (this.eMax + this.eMin) / 2.0;
            int n2 = this.calculatePsi(this.energy);
            if (n2 < n) {
                while (n2 < n) {
                    this.eMax += 10.0;
                    this.eMin = this.energy;
                    this.energy = (this.eMax + this.eMin) / 2.0;
                    n2 = this.calculatePsi(this.energy);
                }
            }
        }
    }

    public void showSpectrum(boolean bl) {
        this.showLevels = bl;
    }

    public void calculateLevels(int n, int n2) {
        if (n > n2 || n == 0) {
            System.out.println("Error: parameter Higher>Lower");
        } else {
            this.max = n2 - n + 1;
            int n3 = n2;
            for (int i = n2; i > n - 1; --i) {
                this.energy = (this.funcmax - this.funcmin) / 2.0;
                this.eMax = this.funcmax;
                this.eMin = this.funcmin;
                this.findElevel(n3, true);
                if (n3 == n) {
                    this.scaleData(this.energy, true);
                    this.owner.evalue.setValue(this.energy);
                    this.owner.elevel.setValue(n);
                }
                --n3;
            }
        }
        double d = this.funcmin;
        double d2 = this.funcmax;
        if (this.autoscalePotential) {
            double d3;
            Enumeration enumeration = this.eValues.elements();
            while (enumeration.hasMoreElements()) {
                d3 = (Double)enumeration.nextElement();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            d3 = d2 - d;
            this.setMinMaxY(d - 0.12 * d3, d2 + 0.12 * d3);
            double d4 = this.findElevel(n, true);
        }
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        super.paintLast(graphics, rectangle);
        graphics.setClip(0, 0, ((Component)((Object)this)).getBounds().width, ((Component)((Object)this)).getBounds().width);
        if (this.energyDragMode) {
            this.drawMyEnergy(graphics, this.energy);
        }
    }

    public void paintBeforeData(Graphics graphics, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n4 = ((Component)((Object)this)).getSize().width;
        if (this.showLevels) {
            n5 = ((Graph2D)this).borderRight = 80;
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = fontMetrics.getAscent();
            String string = "Energy Levels";
            graphics.drawString(string, n4 - ((int)((double)((Graph2D)this).borderRight / 2.0) + (int)((double)fontMetrics.stringWidth(string) / 2.0)), n6);
            graphics.fillRect(n4 - (((Graph2D)this).borderRight - 5), n6 + 2, ((Graph2D)this).borderRight - 10, this.pixFromY(this.getMinY()) - this.pixFromY(this.getMaxY()));
            ((Graph2D)this).borderTop = n6 + 2;
            Enumeration enumeration = this.eValues.elements();
            Enumeration enumeration2 = this.eValues.keys();
            graphics.setColor(Color.green);
            while (enumeration.hasMoreElements()) {
                n3 = this.pixFromY((Double)enumeration.nextElement());
                if (this.active == Integer.valueOf((String)enumeration2.nextElement()) && !this.lines) {
                    graphics.setColor(Color.red);
                    bl = true;
                    n = n4;
                    n2 = n3;
                } else {
                    graphics.setColor(Color.green);
                }
                graphics.drawLine(n4 - (n5 - 9), n3, n4 - 9, n3);
            }
            if (bl) {
                graphics.setColor(Color.red);
                graphics.drawLine(n - (n5 - 9), n2, n - 9, n2);
            }
        } else {
            ((Graph2D)this).borderRight = 10;
        }
        this.lines = false;
    }

    public EnergyGraph(SApplet sApplet) {
        this.setOwner(sApplet);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSampleData(false);
        ((Component)((Object)this)).addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                EnergyGraph.this.this_mouseDragged(mouseEvent);
            }
        });
        ((Component)((Object)this)).addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EnergyGraph.this.this_mouseReleased(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                EnergyGraph.this.this_mousePressed(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EnergyGraph.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EnergyGraph.this.this_mouseExited(mouseEvent);
            }
        });
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.energyDragMode = false;
        this.setAutoRefresh(false);
        int n = mouseEvent.getY();
        int n2 = ((Component)((Object)this)).getSize().width;
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        ((Component)((Object)this)).repaint(0, rectangle.height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
        if (this.rclicked) {
            Graphics graphics = ((Component)((Object)this)).getGraphics();
            graphics.setColor(Color.black);
            graphics.drawLine(n2 - (((Graph2D)this).borderRight - 9), n, n2 - 9, n);
            this.owner.evalue.setValue(this.yFromPix(n));
            graphics.dispose();
            this.rclicked = false;
        }
        this.setAutoRefresh(true);
    }

    public void determineClosest(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 70000.0;
        int n5 = ((Component)((Object)this)).getSize().width;
        Enumeration enumeration = this.eValues.elements();
        Enumeration enumeration2 = this.eValues.keys();
        this.ktemp = this.active;
        if (n > n5 - (((Graph2D)this).borderRight - 5) && n < n5 - 5 && n2 > this.pixFromY(this.getMaxY()) && n2 < this.pixFromY(this.getMinY())) {
            while (enumeration.hasMoreElements()) {
                d = (Double)enumeration.nextElement();
                n4 = Integer.valueOf((String)enumeration2.nextElement());
                d2 = this.yFromPix(n2);
                d3 = Math.abs(d - d2);
                if (!(d3 < d4)) continue;
                d4 = d3;
                this.energy = d;
                this.kcheck = n3 = n4;
                this.active = n3;
            }
            if (this.ktemp == this.kcheck && !this.rclicked) {
                return;
            }
            if (this.energy == this.funcmax) {
                this.resetE = true;
                this.findElevel(n3, true);
                this.active = n3;
                this.scaleData(this.energy, true);
                this.owner.elevel.setValue(n3);
                this.owner.evalue.setValue(this.energy);
            } else {
                this.calculatePsi(this.energy);
                this.active = n3;
                this.scaleData(this.energy, true);
                this.owner.elevel.setValue(n3);
                this.owner.evalue.setValue(this.energy);
            }
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        int n = ((Component)((Object)this)).getSize().width;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0 && n2 > n - (((Graph2D)this).borderRight - 5) && n2 < n - 5) {
            if (n3 > this.pixFromY(this.getMaxY()) && n3 < this.pixFromY(this.funcmin)) {
                this.setAutoRefresh(false);
                this.rclicked = true;
                this.active = 0;
                this.energy = this.yFromPix(n3);
                if (!(this.energy > (double)10 * this.funcmax)) {
                    this.calculatePsi(this.energy);
                    this.scaleData(this.energy, true);
                    if (this.autoscalePotential && n3 < this.pixFromY((double)10 * this.funcmax)) {
                        this.drawEnergyLine(this.pixFromY((double)10 * this.funcmax));
                    } else {
                        this.drawEnergyLine(n3);
                    }
                }
                this.drawMyCoords(n2, n3);
            }
        } else if (n2 > n - (((Graph2D)this).borderRight - 5) && n2 < n - 5 && n3 > this.pixFromY(this.getMaxY()) && n3 < this.pixFromY(this.getMinY())) {
            this.determineClosest(n2, n3);
        } else if (n2 < n - (((Graph2D)this).borderRight - 5) && (mouseEvent.getModifiers() & 4) == 0) {
            this.drawMyCoords(n2, n3);
        } else if ((mouseEvent.getModifiers() & 4) != 0) {
            SGraphFrame sGraphFrame = new SGraphFrame((SGraph)this.clone());
            sGraphFrame.setSize(((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
            sGraphFrame.show();
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = ((Component)((Object)this)).getSize().width;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0 && n2 > n - (((Graph2D)this).borderRight - 5) && n2 < n - 5) {
            if (n3 > this.pixFromY(this.getMaxY()) && n3 < this.pixFromY(this.funcmin)) {
                this.setAutoRefresh(false);
                this.rclicked = true;
                this.active = 0;
                this.energy = this.yFromPix(n3);
                if (!(this.energy > (double)10 * this.funcmax)) {
                    this.calculatePsi(this.energy);
                    this.scaleData(this.energy, true);
                    if (this.autoscalePotential && n3 < this.pixFromY((double)10 * this.funcmax)) {
                        this.drawEnergyLine(this.pixFromY((double)10 * this.funcmax));
                    } else {
                        this.drawEnergyLine(n3);
                    }
                }
                this.drawMyCoords(n2, n3);
            }
        } else if (n2 > n - (((Graph2D)this).borderRight - 5) && n2 < n - 5 && n3 > this.pixFromY(this.getMaxY()) && n3 < this.pixFromY(this.getMinY())) {
            this.determineClosest(n2, n3);
        } else if (n2 < n - (((Graph2D)this).borderRight - 5) && (mouseEvent.getModifiers() & 4) == 0) {
            this.drawMyCoords(n2, n3);
        }
    }

    void drawEnergyLine(int n) {
        this.lines = true;
        int n2 = ((Component)((Object)this)).getSize().width;
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        graphics.setColor(Color.red);
        graphics.drawLine(n2 - (((Graph2D)this).borderRight - 9), n, n2 - 9, n);
        graphics.dispose();
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
    }

    private int amplitude(int n) {
        double d = 0.0;
        double d2 = this.pixFromX(this.getMaxX());
        double d3 = this.pixFromX(this.getMinX());
        d = Math.round((double)this.numPts * (((double)n - d3) / (d2 - d3)));
        return (int)d;
    }

    public void drawMyCoords(int n, int n2) {
        int n3 = ((Component)((Object)this)).getSize().width;
        String string = null;
        if (n > n3 - (((Graph2D)this).borderRight - 5) && n < n3 - 5 && n2 > this.pixFromY(this.getMaxY()) && n2 < this.pixFromY(this.getMinY())) {
            string = "E:".concat(String.valueOf(String.valueOf(this.format.form(this.yFromPix(n2)))));
            this.energyDragMode = true;
            return;
        }
        if (n < n3 - ((Graph2D)this).borderRight) {
            int n4 = this.amplitude(n);
            string = n4 >= 0 && n4 < this.numPts ? String.valueOf(String.valueOf(new StringBuffer("x:").append(this.format.form(this.xFromPix(n))).append(", E:").append(this.format.form(this.yFromPix(n2))).append(" Psi:").append(this.format.form(this.psigraphed[n4])))) : String.valueOf(String.valueOf(new StringBuffer("x:").append(this.format.form(this.xFromPix(n))).append(", E:").append(this.format.form(this.yFromPix(n2)))));
        }
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.dispose();
    }

    public void drawMyEnergy(Graphics graphics, double d) {
        int n = ((Component)((Object)this)).getSize().width;
        String string = "E:".concat(String.valueOf(String.valueOf(this.format.form(d))));
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
    }

    int getActiveWavefunctionID() {
        if (this.activeWavefunction != null) {
            return this.activeWavefunction.getID();
        }
        this.activeWavefunction = new ActiveWavefunction();
        this.activeWavefunction.updateValues(this.energy);
        return this.activeWavefunction.getID();
    }

    int getActiveStateID() {
        if (this.activeState != null) {
            return this.activeState.getID();
        }
        this.activeState = new ActiveState(this.energy, this.active);
        return this.activeState.getID();
    }

    public int getActiveQuantumNumber() {
        return this.active;
    }

    public double getActiveEnergy() {
        return this.energy;
    }

    int getWavefunctionID(int n) {
        Wavefunction wavefunction = null;
        Enumeration enumeration = this.dataSources.elements();
        while (enumeration.hasMoreElements()) {
            wavefunction = (Wavefunction)enumeration.nextElement();
            if (wavefunction.qnumber != n) continue;
            return wavefunction.getID();
        }
        wavefunction = new Wavefunction(n);
        this.dataSources.addElement(wavefunction);
        return wavefunction.getID();
    }

    public class ActiveState
    implements SDataSource {
        String[] varStrings = new String[]{"n", "energy"};
        double[][] ds = new double[1][2];
        double eigenenergy = 0.0;
        double qn = 0.0;

        ActiveState(double d, int n) {
            this.eigenenergy = d;
            this.qn = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void updateValues(double d, int n) {
            this.eigenenergy = d;
            this.qn = n;
            EnergyGraph.this.owner.updateDataConnections();
        }

        public double[][] getVariables() {
            this.ds[0][0] = this.qn;
            this.ds[0][1] = this.eigenenergy;
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return EnergyGraph.this.owner;
        }
    }

    public class ActiveWavefunction
    implements SDataSource {
        String[] varStrings = new String[]{"x", "p", "psi", "energy"};
        double[][] ds = new double[1][4];
        double eigenenergy = 0.0;

        ActiveWavefunction() {
            this.ds = new double[EnergyGraph.this.numPts][4];
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void updateValues(double d) {
            int n;
            this.eigenenergy = d;
            if (EnergyGraph.this.x == null || EnergyGraph.this.y == null || EnergyGraph.this.psigraphed == null) {
                return;
            }
            int n2 = EnergyGraph.this.x.length;
            if (this.ds == null || this.ds.length != EnergyGraph.this.x.length) {
                this.ds = new double[n2][4];
            }
            double d2 = Math.abs(EnergyGraph.this.psigraphed[0] - d);
            double d3 = 0.0;
            double d4 = Math.abs(EnergyGraph.this.x[1] - EnergyGraph.this.x[0]);
            for (n = 1; n < n2; ++n) {
                double d5 = EnergyGraph.this.psigraphed[n] - d;
                d2 = Math.max(d2, Math.abs(d5));
                d3 += d5 * d5 * d4;
            }
            d3 = Math.sqrt(d3);
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            if (d3 == 0.0) {
                d3 = 1.0;
            }
            for (n = 0; n < n2; ++n) {
                this.ds[n][0] = EnergyGraph.this.x[n];
                this.ds[n][1] = EnergyGraph.this.y[n];
                this.ds[n][2] = EnergyGraph.this.scalearea ? (EnergyGraph.this.psigraphed[n] - d) / d3 : (EnergyGraph.this.psigraphed[n] - d) / d2;
                this.ds[n][3] = d;
            }
            EnergyGraph.this.owner.updateDataConnections();
        }

        public double[][] getVariables() {
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return EnergyGraph.this.owner;
        }
    }

    public class Wavefunction
    implements SDataSource {
        String[] varStrings = new String[]{"x", "p", "psi", "energy"};
        double[][] ds = new double[1][4];
        int qnumber = 0;
        double eigenenergy = 0.0;

        Wavefunction(int n) {
            int n2;
            this.qnumber = n;
            this.eigenenergy = EnergyGraph.this.findElevel(this.qnumber, false);
            this.ds = new double[EnergyGraph.this.numPts][4];
            double d = Math.abs(EnergyGraph.this.psi[0]);
            double d2 = 0.0;
            double d3 = Math.abs(EnergyGraph.this.x[1] - EnergyGraph.this.x[0]);
            for (n2 = 1; n2 < EnergyGraph.this.numPts; ++n2) {
                d = Math.max(d, Math.abs(EnergyGraph.this.psi[n2]));
                d2 += EnergyGraph.this.psi[n2] * EnergyGraph.this.psi[n2] * d3;
            }
            d2 = Math.sqrt(d2);
            if (d == 0.0) {
                d = 1.0;
            }
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            for (n2 = 0; n2 < EnergyGraph.this.numPts; ++n2) {
                this.ds[n2][0] = EnergyGraph.this.x[n2];
                this.ds[n2][1] = EnergyGraph.this.y[n2];
                this.ds[n2][2] = EnergyGraph.this.scalearea ? EnergyGraph.this.psi[n2] / d2 : EnergyGraph.this.psi[n2] / d;
                this.ds[n2][3] = this.eigenenergy;
            }
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return EnergyGraph.this.owner;
        }
    }
}

