/*
 * Decompiled with CFR 0.152.
 */
package ripple;

import edu.davidson.display.ArrowThing;
import edu.davidson.display.BoxThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.Constraint;
import edu.davidson.display.ImageThing;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.ProtractorThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.TextThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import ripple.RippleCanvas;
import ripple.Source;

public class Ripple
extends SApplet
implements Runnable {
    String button_start = "Forward";
    String button_stop = "Stop";
    String button_forward = "Step>>";
    String button_back = "<<Step";
    String button_edit = "Edit";
    String button_cancel = "Cancel";
    String button_calculate = "Calculate";
    String button_add = "Add";
    String button_delete = "Delete";
    String label_stopped = "Stopped";
    String label_drag = "Click-Drag any source.";
    String label_wait = "Please Wait...";
    String label_wavelength = "Wavelength=";
    String label_nosource = "No Sources.";
    String label_running = "running";
    String label_frame = "frame:";
    String label_clickdrag = "Click and drag.";
    boolean m_fStandAlone = false;
    private double zscale = 0.0;
    private int m_numSources = 2;
    private int m_pixPerUnit = 20;
    private double m_wavelength = 2.0;
    private boolean m_canDrag = true;
    private boolean m_showControls = true;
    private boolean m_showIntensity = false;
    boolean m_animate = false;
    private int m_fps = 20;
    private String m_caption = "Ripple Tank";
    private final String PARAM_numOfSources = "numberOfSources";
    private final String PARAM_pixPerUnit = "pixPerUnit";
    private final String PARAM_wavelength = "wavelength";
    private final String PARAM_showControls = "showControls";
    private final String PARAM_showIntensity = "showIntensity";
    private final String PARAM_animate = "animate";
    private final String PARAM_fps = "fps";
    private final String PARAM_caption = "caption";
    private final String PARAM_helpFile = "helpFile";
    private int iwidth = 0;
    private int iheight = 0;
    Button startBtn;
    Button stopBtn;
    Button stepFBtn;
    Button stepBBtn;
    Button editBtn;
    private RippleCanvas rc;
    private Thread calcThread = null;
    int[] M_RED = new int[256];
    int[] M_GREEN = new int[256];
    int[] M_BLUE = new int[256];
    double[] SIN = new double[100];
    int pixPerWave;
    double timePhase = 0.0;
    double maxAmp = 0.0;
    int imgCount = 0;
    int[] c = new int[4];
    int numPix = 4;
    int[] pixels = new int[this.numPix];

    String GetParameter(String string, String[] stringArray) {
        if (stringArray == null) {
            return ((Applet)((Object)this)).getParameter(string);
        }
        String string2 = String.valueOf(String.valueOf(string)).concat("=");
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i].substring(0, string2.length())) || !(string3 = stringArray[i].substring(string2.length())).startsWith("\"") || !(string3 = string3.substring(1)).endsWith("\"")) continue;
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    void GetParameters(String[] stringArray) {
        String string = this.GetParameter("numberOfSources", stringArray);
        if (string != null) {
            this.m_numSources = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("pixPerUnit", stringArray)) != null) {
            this.m_pixPerUnit = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("wavelength", stringArray)) != null) {
            this.m_wavelength = Double.valueOf(string);
        }
        if ((string = this.GetParameter("showControls", stringArray)) != null) {
            this.m_showControls = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("showIntensity", stringArray)) != null) {
            this.m_showIntensity = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("animate", stringArray)) != null) {
            this.m_animate = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("fps", stringArray)) != null) {
            this.m_fps = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("caption", stringArray)) != null) {
            this.m_caption = string;
        }
    }

    public static void main(String[] stringArray) {
        Ripple ripple = new Ripple();
        ripple.m_fStandAlone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String string) {
                super.setTitle(string);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Applet Frame");
        frame.add((Component)((Object)ripple), "Center");
        ripple.init();
        ripple.start();
        ((Component)frame).setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: Ripple Ver 1.1\r\nAuthor: Wolfgang Christian\r\nEmail: WOCHRISTIAN@Davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"numberOfSources", "int", "Number of sources."}, {"pixPerUnit", "int", "Pixels per unit."}, {"wavelength", "double", "Wavelength"}, {"showControls", "boolean", "Show controls on the screen."}, {"showIntensity", "boolean", "Show intensity instead of amplitude."}, {"animate", "boolean", "Animate pattern."}, {"fps", "int", "Frames per second for during animation."}, {"caption", "String", "Applet caption"}, {"helpFile", "String", "Applet help file URL"}};
        return stringArray;
    }

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.button_back = this.localProperties.getProperty("button.back", this.button_back);
        this.button_edit = this.localProperties.getProperty("button.edit", this.button_edit);
        this.button_cancel = this.localProperties.getProperty("button.cancel", this.button_cancel);
        this.button_calculate = this.localProperties.getProperty("button.calculate", this.button_calculate);
        this.button_add = this.localProperties.getProperty("button.add", this.button_add);
        this.button_delete = this.localProperties.getProperty("button.delete", this.button_delete);
        this.label_stopped = this.localProperties.getProperty("label.stopped", this.label_stopped);
        this.label_drag = this.localProperties.getProperty("label.drag", this.label_drag);
        this.label_wait = this.localProperties.getProperty("label.wait", this.label_wait);
        this.label_wavelength = this.localProperties.getProperty("label.wavelength", this.label_wavelength);
        this.label_nosource = this.localProperties.getProperty("label.nosource", this.label_nosource);
        this.label_running = this.localProperties.getProperty("label.running", this.label_running);
        this.label_frame = this.localProperties.getProperty("label.frame", this.label_frame);
        this.label_clickdrag = this.localProperties.getProperty("label.clickdrag", this.label_clickdrag);
    }

    public void init() {
        this.initResources(null);
        if (!this.m_fStandAlone) {
            this.GetParameters(null);
        }
        this.pixPerWave = (int)((double)this.m_pixPerUnit * this.m_wavelength);
        ((Applet)((Object)this)).resize(320, 370);
        this.generatePallete();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setBackground(Color.lightGray);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new GridLayout(1, 4));
        this.startBtn = new Button(this.button_start);
        panel.add(this.startBtn);
        this.stopBtn = new Button(this.button_stop);
        panel.add(this.stopBtn);
        this.stepBBtn = new Button(this.button_back);
        panel.add(this.stepBBtn);
        this.stepFBtn = new Button(this.button_forward);
        panel.add(this.stepFBtn);
        this.editBtn = new Button(this.button_edit);
        panel.add(this.editBtn);
        if (this.m_showControls) {
            ((Container)((Object)this)).add("South", panel);
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 1));
        this.rc = new RippleCanvas(this);
        this.rc.setBackground(Color.white);
        panel2.add(this.rc);
        ((Container)((Object)this)).add("Center", panel2);
        this.rc.setPixPerUnit(this.m_pixPerUnit);
        this.rc.setWavelength(this.m_wavelength);
        this.rc.setSleepTime((int)Math.round(this.m_wavelength * (double)1000 / (double)this.m_fps));
        this.rc.setShowInfo(this.m_showControls);
        boolean bl = this.m_animate;
        for (int i = 0; i < this.m_numSources; ++i) {
            this.addSource(-this.m_numSources / 2 + i, 0.0, 1.0, 0.0);
        }
        this.m_animate = bl;
        if (!this.m_animate) {
            this.rc.msgStr = this.label_drag;
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
            this.startBtn.setLabel(this.button_calculate);
        }
    }

    public void setDrag(boolean bl) {
        this.m_canDrag = bl;
    }

    public void setZScale(double d) {
        this.zscale = d;
    }

    public void setWavelength(double d) {
        if (d < 0.1) {
            return;
        }
        if (d > (double)10) {
            return;
        }
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.m_wavelength = d;
        this.pixPerWave = (int)((double)this.m_pixPerUnit * this.m_wavelength);
        this.rc.setSleepTime((int)Math.round(d * (double)1000 / (double)this.m_fps));
        this.rc.setWavelength(this.m_wavelength);
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.rc.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        return true;
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        return this.rc.setColor(n, new Color(n2, n3, n4));
    }

    public boolean setDragable(int n, boolean bl) {
        return this.rc.setDragable(n, bl);
    }

    public void showIntensity(boolean bl) {
        this.m_showIntensity = bl;
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
    }

    public void cancel() {
        if (this.calcThread == null) {
            this.stopAnimate();
        } else {
            this.stop();
            this.rc.stop();
            this.rc.msgStr = this.label_clickdrag;
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
            this.startBtn.setLabel(this.button_calculate);
            this.stepFBtn.setLabel(this.button_add);
            this.stepBBtn.setLabel(this.button_delete);
            this.m_animate = false;
        }
    }

    public void pause() {
        this.stopAnimate();
    }

    protected void pausingClock() {
        this.pause();
    }

    public void stopAnimate() {
        this.m_animate = false;
        if (this.calcThread != null) {
            return;
        }
        if (this.rc.isRunning()) {
            this.rc.stop();
            this.rc.msgStr = this.label_stopped;
        }
    }

    public synchronized void startAnimate() {
        this.setRunningID(this);
        this.m_animate = true;
        if (this.calcThread != null) {
            return;
        }
        if (this.rc.getImage() == null) {
            this.rc.msgStr = this.label_wait;
            this.rc.repaint();
            this.start();
            this.startBtn.setLabel(this.button_cancel);
            this.stepFBtn.setLabel("--");
            this.stepBBtn.setLabel("--");
            return;
        }
        if (this.rc.getImageNumber() < 8) {
            this.start();
            this.startBtn.setLabel(this.button_cancel);
            this.stepFBtn.setLabel("--");
            this.stepBBtn.setLabel("--");
        } else {
            this.rc.start();
        }
    }

    public void destroy() {
        this.stop();
        this.deleteAll();
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
        } else if (this.rc.getImage() != null && this.calcThread == null && this.rc.getImageNumber() == 8) {
            this.rc.start();
            return;
        }
        if (this.calcThread == null && this.m_animate) {
            this.calcThread = new Thread(this);
            this.calcThread.start();
            this.setControlBtn(true);
        }
    }

    public void stop() {
        block4: {
            super.stop();
            Thread thread = this.calcThread;
            try {
                if (thread == null) break block4;
                this.calcThread = null;
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.startBtn.setLabel(this.button_calculate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.calcThread = null;
        this.rc.stop();
    }

    public void stepTimeForward() {
        if (this.rc.isRunning()) {
            this.rc.stop();
            return;
        }
        this.rc.step(1);
    }

    public void stepForward() {
        this.stepTimeForward();
    }

    public void stepTimeBack() {
        if (this.rc.isRunning()) {
            this.rc.stop();
            return;
        }
        this.rc.step(-1);
    }

    public void stepBack() {
        this.stepTimeBack();
    }

    public synchronized void recalculate() {
        this.stop();
        this.rc.stop();
        this.rc.msgStr = "";
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.start();
    }

    private void setControlBtn(boolean bl) {
        if (bl) {
            if (this.calcThread != null) {
                this.startBtn.setLabel(this.button_cancel);
                this.stepFBtn.setLabel("--");
                this.stepBBtn.setLabel("--");
            } else {
                this.startBtn.setLabel(this.button_calculate);
                this.stepFBtn.setLabel(this.button_add);
                this.stepBBtn.setLabel(this.button_delete);
            }
            this.stopBtn.setLabel("--");
            this.editBtn.setLabel("--");
        } else {
            this.startBtn.setLabel(this.button_start);
            this.stopBtn.setLabel(this.button_stop);
            this.stepFBtn.setLabel(this.button_forward);
            this.stepBBtn.setLabel(this.button_back);
            this.editBtn.setLabel(this.button_edit);
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (this.calcThread != thread) {
            return;
        }
        this.rc.stop();
        double d = this.pixPerWave > 0 ? 16.0 / (double)this.pixPerWave : 1.0;
        if (d > 1.0) {
            d = 1.0;
        }
        int n = (int)((double)this.rc.getSize().width * d);
        int n2 = (int)((double)this.rc.getSize().height * d);
        if (this.rc.getSize().width != this.iwidth || this.rc.getSize().height != this.iheight) {
            this.iwidth = this.rc.getSize().width;
            this.iheight = this.rc.getSize().height;
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
        }
        int n3 = 0;
        int n4 = 0;
        n3 = this.rc.getImageNumber();
        block2: while (n3 < 8 && this.calcThread != null) {
            this.pixels = new int[n * n2];
            this.numPix = n * n2;
            Vector vector = (Vector)this.rc.sources.clone();
            if (this.rc.isImageLoaded() || n4 > 100) {
                int n5 = 0;
                n4 = 0;
                this.timePhase = (double)n3 * 100.0 / 8.0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (this.calcThread == null) break block2;
                        this.c[2] = 0;
                        this.c[1] = 0;
                        this.c[0] = 0;
                        this.c[3] = 255;
                        this.ampFunction(this.c, j, i, n, n2, d, this.timePhase, vector);
                        this.pixels[n5++] = this.c[3] << 24 | this.c[0] << 16 | this.c[1] << 8 | this.c[2] << 0;
                    }
                }
                if (this.rc.addImage(n, n2, this.pixels, 0, n, n3)) {
                    ++n3;
                }
            }
            ++n4;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.calcThread = null;
        this.setControlBtn(false);
        this.rc.msgStr = this.label_stopped;
        if (this.m_animate) {
            this.rc.start();
        }
    }

    public void forward() {
        if (this.calcThread == null) {
            this.startAnimate();
        }
    }

    public void edit() {
        this.stop();
        this.rc.stop();
        this.rc.msgStr = this.label_drag;
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.startBtn.setLabel(this.button_calculate);
        this.stepFBtn.setLabel(this.button_add);
        this.stepBBtn.setLabel(this.button_delete);
        this.m_animate = false;
        this.editSources();
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.startBtn)) {
            if (this.calcThread == null) {
                this.startAnimate();
            } else {
                this.cancel();
            }
            return true;
        }
        if (event.target.equals(this.stopBtn)) {
            this.stopAnimate();
            return true;
        }
        if (event.target.equals(this.stepFBtn)) {
            if (this.startBtn.getLabel().equals(this.button_calculate)) {
                this.addSource();
                return true;
            }
            this.m_animate = false;
            if (this.rc.isRunning() && this.calcThread == null) {
                this.rc.stop();
            }
            this.rc.step(1);
            return true;
        }
        if (event.target.equals(this.stepBBtn)) {
            if (this.startBtn.getLabel().equals(this.button_calculate)) {
                this.deleteAll();
                return true;
            }
            this.m_animate = false;
            if (this.rc.isRunning() && this.calcThread == null) {
                this.rc.stop();
            }
            this.rc.step(-1);
            return true;
        }
        if (event.target.equals(this.editBtn)) {
            this.cancel();
            this.editSources();
            return true;
        }
        return false;
    }

    void ampFunction(int[] nArray, int n, int n2, int n3, int n4, double d, double d2, Vector vector) {
        Source source;
        int n5;
        int n6 = n3;
        int n7 = n4;
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = 0;
        double d3 = 0.0;
        double d4 = 100.0 / (double)this.pixPerWave / d;
        int n11 = vector.size();
        double d5 = 0.0;
        for (n5 = 0; n5 < n11; ++n5) {
            source = (Source)((Object)vector.elementAt(n5));
            source.setDisplayCoordinates(this.m_pixPerUnit);
        }
        for (n5 = 0; n5 < n11; ++n5) {
            source = (Source)((Object)vector.elementAt(n5));
            d3 = source.phase / 0.36 / 2.0;
            double d6 = (double)(n - n8) - source.displayX * (double)this.m_pixPerUnit * d;
            double d7 = (double)(n2 - n9) + source.displayY * (double)this.m_pixPerUnit * d;
            double d8 = d6 * d6 + d7 * d7;
            int n12 = (int)(-d2 - d3 + Math.sqrt(d8) * d4) % 100;
            if (n12 < 0) {
                d5 -= this.SIN[-n12] * source.amp;
                continue;
            }
            d5 += this.SIN[n12] * source.getAmp();
        }
        n10 = this.maxAmp <= 0.0 ? 0 : (this.m_showIntensity ? (int)Math.round(d5 * d5 / this.maxAmp / this.maxAmp / (double)255) : (int)Math.round(((double)255 + d5 / this.maxAmp) / (double)2));
        n10 = Math.min(Math.max(0, n10), 255);
        nArray[0] = this.M_RED[n10];
        nArray[1] = this.M_GREEN[n10];
        nArray[2] = this.M_BLUE[n10];
    }

    void generatePallete() {
        int n;
        for (n = 0; n < 256; ++n) {
            this.M_RED[n] = n;
        }
        for (n = 0; n < 256; ++n) {
            this.M_GREEN[n] = n;
        }
        for (n = 0; n < 256; ++n) {
            this.M_BLUE[n] = n;
        }
        for (n = 0; n < 100; ++n) {
            this.SIN[n] = (double)255 * Math.sin(Math.PI * 2 * (double)n / (double)100);
        }
    }

    public void editSources() {
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.rc.msgStr = this.label_clickdrag;
        this.rc.repaint();
        this.setControlBtn(true);
        this.m_animate = false;
    }

    public int addSource() {
        this.stopAnimate();
        int n = 0;
        if (this.rc.sources.size() > 0) {
            Source source = (Source)((Object)this.rc.sources.lastElement());
            double d = source.getX();
            double d2 = source.getY();
            double d3 = source.getAmp();
            double d4 = source.getPhase();
            n = this.addSource(d + 1.0, d2 - 1.0, d3, d4);
        } else {
            n = this.addSource(0.0, 0.0, 1.0, 0.0);
        }
        return n;
    }

    public int addSource(double d, double d2, double d3, double d4) {
        d3 = Math.abs(d3);
        this.maxAmp += d3;
        if (this.zscale != 0.0) {
            this.maxAmp = this.zscale;
        }
        this.stop();
        this.rc.stop();
        int n = this.rc.addSource(d, d2, d3, d4, 5);
        this.setDragable(n, this.m_canDrag);
        this.setControlBtn(true);
        this.m_animate = false;
        return n;
    }

    public synchronized int addObject(String string, String string2) {
        this.stopAnimate();
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        int n4 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("source")) {
            double d3 = 1.0;
            double d4 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"amp=")) {
                d3 = SUtil.getParam((String)string2, (String)"amp=");
            }
            if (SUtil.parameterExist((String)string2, (String)"phase=")) {
                d4 = SUtil.getParam((String)string2, (String)"phase=");
            }
            int n5 = this.addSource(d, d2, d3, d4);
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
                object = this.rc.getThing(n5);
                object.setWidth(n3);
                object.setHeight(n3);
            }
            return n5;
        }
        if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.rc, d, d2, n, n2);
        } else if (string.equals("protractor")) {
            n4 = 40;
            double d5 = 0.0;
            double d6 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta=")) {
                d5 = SUtil.getParam((String)string2, (String)"theta=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta0=")) {
                d6 = SUtil.getParam((String)string2, (String)"theta0=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            ProtractorThing protractorThing = new ProtractorThing((SApplet)this, (SScalable)this.rc, n4, d5, d6, d, d2);
            if (SUtil.parameterExist((String)string2, (String)"fixedbase")) {
                protractorThing.fixedBase = true;
            }
            if (SUtil.parameterExist((String)string2, (String)"fixedlength")) {
                protractorThing.fixedlength = true;
            }
            object = protractorThing;
        } else if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new RectangleThing((SApplet)this, (SScalable)this.rc, d, d2, n, n2);
        } else if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new CircleThing((SApplet)this, (SScalable)this.rc, d, d2, n3);
        } else if (string.equals("cursor")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new MarkerThing((SApplet)this, (SScalable)this.rc, 2 * n3 + 1, d, d2);
        } else if (string.equals("shell")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new ShellThing((SApplet)this, (SScalable)this.rc, d, d2, n3);
        } else if (string.equals("arrow")) {
            double d7 = 1.0;
            double d8 = 1.0;
            n4 = 4;
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d7 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d8 = SUtil.getParam((String)string2, (String)"v=");
            }
            object = new ArrowThing((SApplet)this, (SScalable)this.rc, n4, d7, d8, d, d2);
        } else if (string.equals("text")) {
            String string4 = "";
            Object var14_25 = null;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            object = new TextThing((SApplet)this, (SScalable)this.rc, string4, d, d2);
        } else if (string.equals("caption")) {
            String string5 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string5 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string5 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            object = new CaptionThing((SApplet)this, (SScalable)this.rc, string5, d, d2);
        } else if (string.equals("image")) {
            String string6 = " ";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"gif=");
            }
            if (SUtil.parameterExist((String)string2, (String)"file=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"file=");
            }
            if (string6 == null) {
                return 0;
            }
            Image image = Util.getImage((String)string6, (Applet)((Object)this));
            object = image != null ? new ImageThing((SApplet)this, (SScalable)this.rc, image, d, d2) : null;
        } else if (string.equals("constraint")) {
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d9 = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d11 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d10 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d12 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            object = new Constraint((SApplet)this, (SScalable)this.rc, d9, d10, d11, d12);
        }
        if (object != null && SUtil.parameterExist((String)string2, (String)"label=")) {
            object.setLabel(SUtil.getParamStr((String)string3, (String)"label="));
        }
        if (object == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return 0;
        }
        object.setDragable(this.m_canDrag);
        this.rc.addThing((Thing)object);
        this.rc.repaint();
        return object.hashCode();
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.rc.getThing(n);
        Thing thing2 = this.rc.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        return true;
    }

    public boolean setConstraint(int n, int n2) {
        Thing thing = this.rc.getThing(n);
        Thing thing2 = this.rc.getThing(n2);
        if (thing == null) {
            return false;
        }
        if (thing2 == null) {
            return false;
        }
        if (!(thing2 instanceof Constraint)) {
            return false;
        }
        thing.setConstraint((Constraint)thing2);
        return true;
    }

    public void setDefault() {
        this.m_canDrag = true;
        this.deleteAll();
    }

    public void deleteAll() {
        this.stopAnimate();
        this.rc.sources.removeAllElements();
        this.rc.frames.removeAllElements();
        Thing thing = null;
        Enumeration enumeration = this.rc.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            this.removeDataSource(thing.hashCode());
        }
        this.rc.things.removeAllElements();
        this.deleteDataConnections();
        this.maxAmp = 0.0;
        this.recalculate();
    }
}

