/*
 * Decompiled with CFR 0.152.
 */
package ripple;

import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import ripple.Ripple;
import ripple.Source;

class RippleCanvas
extends Canvas
implements Runnable,
SScalable {
    Image img;
    Image osi;
    Format format = new Format("%-+8.4g");
    int pixPerUnit = 10;
    double gridUnit = 1.0;
    int sleepTime = 100;
    Vector sources = new Vector();
    Vector things = new Vector();
    public String msgStr = "";
    private int iwidth = 0;
    private int iheight = 0;
    private boolean showCoord = true;
    private double mouseX;
    private double mouseY;
    private boolean mousePressed = false;
    private int boxWidth = 0;
    private Thread movieThread;
    Vector frames = new Vector();
    int current = 0;
    boolean imageLoaded = true;
    Source dragSource = null;
    Thing dragThing = null;
    double wavelength = 0.0;
    boolean showInfo = true;
    Ripple owner = null;
    boolean shouldRun = false;

    public synchronized void stop() {
        Thread thread = this.movieThread;
        if (this.movieThread == null) {
            return;
        }
        if (thread != null) {
            this.movieThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.movieThread = null;
    }

    public synchronized void start() {
        if (this.movieThread == null) {
            this.movieThread = new Thread(this);
            this.movieThread.start();
        }
        this.imageLoaded = true;
    }

    public void run() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            this.movieThread = null;
            return;
        }
        while (this.movieThread != null && this.sources.size() > 0 && this.frames.size() > 1 && this.owner.getRunningID() == this.owner) {
            try {
                if (this.current >= this.frames.size()) {
                    this.current = 0;
                }
                if (this.frames.size() > 0) {
                    this.img = (Image)this.frames.elementAt(this.current);
                }
                if (this.movieThread != null) {
                    this.paint(graphics);
                    if (this.mousePressed) {
                        this.paintCoordinates(graphics, this.mouseX, this.mouseY);
                    }
                }
                ++this.current;
                if (this.movieThread == null) continue;
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.movieThread = null;
        graphics.dispose();
        this.imageLoaded = true;
        this.repaint();
    }

    void setSleepTime(int n) {
        this.sleepTime = n;
    }

    void setWavelength(double d) {
        this.wavelength = d;
    }

    void setShowInfo(boolean bl) {
        this.showInfo = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
    }

    public void paint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.iwidth = this.getSize().width;
        this.iheight = this.getSize().height;
        int n = this.iwidth / 2;
        int n2 = this.iheight / 2;
        if (this.sources.size() == 0) {
            this.msgStr = this.owner.label_nosource;
        }
        if (this.osi == null || this.osi.getHeight(this) != this.iheight || this.osi.getWidth(this) != this.iwidth) {
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        if (this.img == null) {
            super.paint(graphics);
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (this.iwidth - fontMetrics.stringWidth(this.msgStr)) / 2;
            graphics.drawString(this.msgStr, n3, 30);
            n3 = (this.iwidth - fontMetrics.stringWidth(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_wavelength))).append(" ").append(this.wavelength))))) / 2;
            if (this.showInfo) {
                graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_wavelength))).append(" ").append(this.wavelength))), n3, 60);
            }
            this.paintThings(graphics);
        } else if (this.sources.size() > 0) {
            if (this.things.size() > 0) {
                Graphics graphics2 = this.osi.getGraphics();
                graphics2.drawImage(this.img, 0, 0, this.iwidth, this.iheight, this);
                this.paintThings(graphics2);
                graphics2.dispose();
                graphics.drawImage(this.osi, 0, 0, this.iwidth, this.iheight, this);
            } else {
                graphics.drawImage(this.img, 0, 0, this.iwidth, this.iheight, this);
            }
            this.paintThings(graphics);
            graphics.setColor(Color.red);
            if (this.movieThread != null) {
                graphics.drawString(this.owner.label_running, 10, 15);
            } else {
                graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_frame))).append(" ").append(this.current))), 10, 15);
            }
        }
    }

    public Dimension minimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension preferredSize() {
        return new Dimension(200, 200);
    }

    public Image getImage() {
        return this.img;
    }

    public int getImageNumber() {
        return this.frames.size();
    }

    public boolean isRunning() {
        return this.movieThread != null;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public synchronized void setImage(Image image) {
        this.img = image;
        this.repaint();
        this.imageLoaded = true;
    }

    private void showImageSize() {
        System.out.print("Image w: ".concat(String.valueOf(String.valueOf(this.img.getWidth(this)))));
        System.out.println("Image h: ".concat(String.valueOf(String.valueOf(this.img.getHeight(this)))));
    }

    public void addThing(Thing thing) {
        this.things.addElement(thing);
    }

    public int addSource(double d, double d2, double d3, double d4, int n) {
        Source source = new Source(this.owner, this, d, d2, d3, d4, n);
        this.sources.addElement(source);
        this.things.addElement(source);
        this.setImage(null);
        this.frames.removeAllElements();
        this.msgStr = this.owner.label_clickdrag;
        this.repaint();
        return ((Object)((Object)source)).hashCode();
    }

    synchronized boolean addImage(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        Image image;
        this.imageLoaded = false;
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n4);
        if (memoryImageSource == null) {
            System.out.println("MemoryImageSource not created.");
            return false;
        }
        this.img = image = this.createImage(memoryImageSource);
        if (n5 < 8) {
            this.frames.addElement(image);
            this.current = n5;
        }
        this.paintImage();
        return true;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.imageLoaded = true;
        }
        return true;
    }

    public void paintImage() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
        graphics.dispose();
    }

    private void paintThings(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }

    public void step(int n) {
        int n2 = this.frames.size() - 1;
        if (n2 < 1) {
            return;
        }
        this.current += n;
        while (this.current > n2) {
            this.current = this.current - n2 - 1;
        }
        while (this.current < 0) {
            this.current = this.current + n2 + 1;
        }
        this.img = (Image)this.frames.elementAt(this.current);
        this.imageLoaded = true;
        this.paintImage();
    }

    public double xFromPix(int n) {
        int n2 = this.iwidth / 2;
        return (double)(n - n2) / (1.0 * (double)this.pixPerUnit);
    }

    public double yFromPix(int n) {
        int n2 = this.iheight / 2;
        return (double)(-(n - n2)) / (1.0 * (double)this.pixPerUnit);
    }

    public int pixFromX(double d) {
        return (int)((double)this.iwidth / 2.0 + d * (double)this.pixPerUnit);
    }

    public int pixFromY(double d) {
        return (int)((double)this.iheight / 2.0 - d * (double)this.pixPerUnit);
    }

    public int getPixWidth() {
        return this.iwidth;
    }

    public int getPixHeight() {
        return this.iheight;
    }

    public void setDragSource(int n, int n2) {
        int n3 = this.sources.size();
        this.dragSource = null;
        if (this.img != null) {
            return;
        }
        if (n3 < 1) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            Source source = (Source)((Object)this.sources.elementAt(i));
            if (!source.isInsideThing(n, n2)) continue;
            this.dragSource = source;
        }
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    boolean setColor(int n, Color color) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setColor(color);
        return true;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.isNoDrag() || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    public void paintCoordinates(double d, double d2) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintCoordinates(graphics, d, d2);
        graphics.dispose();
    }

    void paintCoordinates(Graphics graphics, double d, double d2) {
        if (!this.showCoord) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = "";
        string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append(" y=").append(this.format.form(d2))));
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        this.boxWidth = 20 + fontMetrics.stringWidth(string);
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 8, this.getBounds().height - 2);
    }

    public RippleCanvas(Ripple ripple) {
        this();
        this.owner = ripple;
        this.msgStr = this.owner.label_wait;
    }

    public RippleCanvas() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RippleCanvas.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                RippleCanvas.this.this_mouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                RippleCanvas.this.this_mouseMoved(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                RippleCanvas.this.this_mouseDragged(mouseEvent);
            }
        });
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        if (this.isInsideDragableThing(mouseEvent.getX(), mouseEvent.getY())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        this.mousePressed = true;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mouseX = this.xFromPix(n);
        this.mouseY = this.yFromPix(n2);
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!thing.isNoDrag() && thing.isInsideThing(n, n2)) {
                this.dragThing = thing;
                if (this.dragThing instanceof Source) {
                    this.shouldRun = this.owner.m_animate;
                }
            }
            this.paintCoordinates(this.mouseX, this.mouseY);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        this.mouseX = this.xFromPix(n);
        this.mouseY = this.yFromPix(n2);
        if (this.dragThing != null) {
            if (this.dragThing instanceof Source) {
                this.owner.stopAnimate();
            }
            this.dragThing.setXY(this.mouseX, this.mouseY);
            this.dragThing.updateMySlaves();
            if (this.owner != null) {
                this.owner.updateDataConnection(this.dragThing.hashCode());
            }
        }
        this.paint();
        this.paintCoordinates(this.mouseX, this.mouseY);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed = false;
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        boolean bl = false;
        if (this.dragThing != null) {
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            if (this.owner != null) {
                this.owner.updateDataConnections();
            }
            bl = this.dragThing instanceof Source;
            Vector vector = this.dragThing.getSlaves();
            Thing thing = null;
            if (!bl) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    thing = (Thing)enumeration.nextElement();
                    if (!(thing instanceof Source)) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.boxWidth = 0;
        if (bl) {
            if (this.shouldRun) {
                this.owner.recalculate();
                this.owner.startAnimate();
            } else {
                this.owner.recalculate();
            }
        } else {
            this.paint();
        }
        this.dragThing = null;
    }
}

