/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.tools;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;

public class SDataConnection {
    int series;
    SDataSource ds = null;
    SDataListener dl = null;
    String xStr;
    String yStr;
    double[] x = null;
    double[] y = null;
    Parser xparser = null;
    Parser yparser = null;
    String[] vars = null;
    int smooth = 1;
    int stride = 1;
    int strideCounter = 1;
    double[] tempX = new double[this.smooth];
    double[] tempY = new double[this.smooth];
    double lastX = 0.0;
    double lastY = 0.0;
    boolean block = false;
    double xmin = 0.0;
    double xmax = 0.0;
    boolean windowX = false;
    double ymin = 0.0;
    double ymax = 0.0;
    boolean windowY = false;

    public SDataConnection(SDataSource sDataSource, SDataListener sDataListener, int n, String string, String string2) {
        this.series = n;
        this.ds = sDataSource;
        this.dl = sDataListener;
        this.xStr = string;
        this.yStr = string2;
        this.vars = sDataSource.getVarStrings();
        if (this.vars == null) {
            System.out.println("Error:Data source variables have not been initialized.");
        } else {
            this.setXStr(string);
            this.setYStr(string2);
        }
        sDataListener.clearSeries(n);
    }

    public final void setWindowX(double d, double d2) {
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        this.xmin = d;
        this.xmax = d2;
        this.windowX = true;
    }

    public final void setWindowY(double d, double d2) {
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        this.ymin = d;
        this.ymax = d2;
        this.windowY = true;
    }

    public void setSmooth(int n) {
        if (n < 2) {
            this.smooth = 1;
            this.tempX = null;
            this.tempY = null;
            return;
        }
        this.smooth = n;
        this.tempX = new double[this.smooth];
        this.tempY = new double[this.smooth];
        for (int i = 0; i < this.smooth; ++i) {
            this.tempX[i] = this.lastX;
            this.tempY[i] = this.lastY;
        }
    }

    public void setStride(int n) {
        this.stride = Math.max(1, n);
        this.strideCounter = 1;
    }

    public boolean setXStr(String string) {
        int n;
        this.xStr = string.trim();
        if (this.xStr.equals("") || this.xStr.equals("0")) {
            this.xparser = null;
            return true;
        }
        this.xparser = new Parser(this.vars.length);
        for (n = 0; n < this.vars.length; ++n) {
            this.xparser.defineVariable(n + 1, this.vars[n]);
        }
        this.xparser.define(this.xStr);
        this.xparser.parse();
        if (this.xparser.getErrorCode() != 0) {
            System.out.println("Failed to parse horizontal datasource): ".concat(String.valueOf(String.valueOf(this.xStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.xparser.getErrorString()).append(" at function 1, position ").append(this.xparser.getErrorPosition()))));
            for (n = 0; n < this.vars.length; ++n) {
                System.out.println("vars ".concat(String.valueOf(String.valueOf(this.vars[n]))));
            }
            return false;
        }
        return true;
    }

    public boolean setYStr(String string) {
        int n;
        this.yStr = string.trim();
        if (this.yStr.equals("") || this.yStr.equals("0")) {
            this.yparser = null;
            return true;
        }
        this.yparser = new Parser(this.vars.length);
        for (n = 0; n < this.vars.length; ++n) {
            this.yparser.defineVariable(n + 1, this.vars[n]);
        }
        this.yparser.define(this.yStr);
        this.yparser.parse();
        if (this.yparser.getErrorCode() != 0) {
            System.out.println("Failed to parse vertical datasource: ".concat(String.valueOf(String.valueOf(this.yStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.yparser.getErrorString()).append(" at function 1, position ").append(this.yparser.getErrorPosition()))));
            for (n = 0; n < this.vars.length; ++n) {
                System.out.println("vars ".concat(String.valueOf(String.valueOf(this.vars[n]))));
            }
            return false;
        }
        return true;
    }

    public void registerDatum() {
        int n;
        if (this.block) {
            return;
        }
        --this.strideCounter;
        if (this.strideCounter > 0) {
            return;
        }
        this.strideCounter = this.stride;
        double[][] dArray = this.ds.getVariables();
        if (dArray == null || this.ds.getVarStrings() == null) {
            return;
        }
        if (this.ds.getVarStrings()[0].equals("blocked")) {
            return;
        }
        if (this.ds.getVarStrings()[0].equals("surfacedata") && dArray.length > 1) {
            this.dl.addData(this.ds, this.series, null, null);
        }
        if ((n = dArray.length) == 1) {
            this.lastX = this.xparser != null ? this.xparser.evaluate(dArray[0]) : 0.0;
            this.lastY = this.yparser != null ? this.yparser.evaluate(dArray[0]) : 0.0;
            if (this.windowX && (this.lastX < this.xmin || this.lastX > this.xmax)) {
                return;
            }
            if (this.windowY && (this.lastY < this.ymin || this.lastY > this.ymax)) {
                return;
            }
            if (this.smooth > 1) {
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 1; i < this.smooth; ++i) {
                    this.tempX[i - 1] = this.tempX[i];
                    this.tempY[i - 1] = this.tempY[i];
                    d += this.tempX[i];
                    d2 += this.tempY[i];
                }
                this.tempX[this.smooth - 1] = this.lastX;
                this.tempY[this.smooth - 1] = this.lastY;
                this.dl.addDatum(this.ds, this.series, (d += this.lastX) / (double)this.smooth, (d2 += this.lastY) / (double)this.smooth);
            } else {
                this.dl.addDatum(this.ds, this.series, this.lastX, this.lastY);
            }
            return;
        }
        if (this.x == null || this.x.length != n) {
            this.x = new double[n];
        }
        if (this.y == null || this.y.length != n) {
            this.y = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            this.x[i] = this.xparser != null ? this.xparser.evaluate(dArray[i]) : 0.0;
            this.y[i] = this.yparser != null ? this.yparser.evaluate(dArray[i]) : 0.0;
        }
        if (this.windowX) {
            double[][] dArray2 = this.windowx(this.x, this.y);
            this.x = dArray2[0];
            this.y = dArray2[1];
        }
        if (this.windowY) {
            double[][] dArray3 = this.windowy(this.x, this.y);
            this.x = dArray3[0];
            this.y = dArray3[1];
        }
        if (this.smooth > 2) {
            this.x = this.smoothData(this.x);
            this.y = this.smoothData(this.y);
        }
        this.dl.addData(this.ds, this.series, this.x, this.y);
    }

    private double[][] windowx(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] < this.xmin) && !(dArray[i] > this.xmax)) continue;
            System.arraycopy(dArray, i + 1, dArray, i, n - i - 1);
            System.arraycopy(dArray2, i + 1, dArray2, i, n - i - 1);
            --n;
            --i;
        }
        double[][] dArray3 = new double[2][n];
        System.arraycopy(dArray, 0, dArray3[0], 0, n);
        System.arraycopy(dArray2, 0, dArray3[1], 0, n);
        return dArray3;
    }

    private double[][] windowy(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(dArray2[i] < this.ymin) && !(dArray2[i] > this.ymax)) continue;
            System.arraycopy(dArray, i + 1, dArray, i, n - i - 1);
            System.arraycopy(dArray2, i + 1, dArray2, i, n - i - 1);
            --n;
            --i;
        }
        double[][] dArray3 = new double[2][n];
        System.arraycopy(dArray, 0, dArray3[0], 0, n);
        System.arraycopy(dArray2, 0, dArray3[1], 0, n);
        return dArray3;
    }

    private double[] smoothData(double[] dArray) {
        int n = dArray.length;
        int n2 = this.smooth / 2;
        double[] dArray2 = new double[n];
        for (int i = n2; i < n - n2; ++i) {
            double d = 0.0;
            for (int j = -n2; j <= n2; ++j) {
                d += dArray[i + j];
            }
            dArray2[i] = d / (double)(2 * n2 + 1);
        }
        return dArray2;
    }

    public void clearData() {
        this.dl.clearSeries(this.series);
    }

    public void deleteData() {
        this.dl.deleteSeries(this.series);
    }

    public final SDataSource getDataSource() {
        return this.ds;
    }

    public final SDataListener getDataListener() {
        return this.dl;
    }
}

