/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.tools;

import edu.davidson.tools.TimerClient;

public final class STimer
implements Runnable {
    Thread thread = null;
    private boolean running = false;
    private boolean oneShot = false;
    private TimerClient client = null;
    private int interval = 100;
    boolean keepRunning = false;

    public void start(int n) {
        this.interval = n;
        this.start();
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            this.running = true;
        }
    }

    public void stop() {
        this.keepRunning = false;
    }

    public void stopThread() {
        Thread thread = this.thread;
        if (thread != null) {
            this.keepRunning = false;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        this.keepRunning = false;
    }

    public void resume() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.resume();
            this.running = true;
        } else {
            this.start();
        }
    }

    public void resume(int n) {
        this.interval = n;
        this.resume();
    }

    public void pause() {
        if (this.thread != null) {
            this.thread.suspend();
            this.running = false;
        }
    }

    public void destroy() {
        this.stopThread();
    }

    public void run() {
        this.keepRunning = true;
        while (this.keepRunning && this.client != null) {
            try {
                Thread.sleep(this.interval);
                this.client.tick();
                if (!this.oneShot) continue;
                this.keepRunning = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
        this.running = false;
    }

    public final void doOneShot() {
        this.doOneShot(this.interval);
    }

    public final void doOneShot(int n) {
        this.setOneShot(true);
        this.start();
    }

    public final void setOneShot(boolean bl) {
        this.oneShot = bl;
    }

    public final boolean isOneShot() {
        return this.oneShot;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setInterval(int n) {
        this.interval = n;
    }

    public final int getInterval() {
        return this.interval;
    }

    public final void setClient(TimerClient timerClient) {
        this.client = timerClient;
    }

    public final TimerClient getClient() {
        return this.client;
    }
}

