/*
 * Decompiled with CFR 0.152.
 */
package reflection;

import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import reflection.ReflectionThing;
import reflection.WavePanel;

public class EMThing
extends ReflectionThing {
    public EMThing() {
    }

    public EMThing(double d, double d2, WavePanel wavePanel) {
        super(d2, wavePanel);
        this.indexN = d;
        this.wavenumber = this.indexN * (double)2 * Math.PI / this.owner.lambda;
        this.phaseShift = this.width * this.wavenumber;
    }

    int rescale(int n) {
        this.left = n;
        this.right = (int)((this.pos + this.width) * this.owner.ppu);
        this.pwidth = this.right - this.left;
        this.leftW = new double[this.pwidth];
        this.rightW = new double[this.pwidth];
        this.xpoints = new int[this.pwidth];
        this.ypoints = new int[this.pwidth];
        this.originY = (int)(0.5 * (double)this.owner.currenth);
        for (int i = 0; i < this.pwidth; ++i) {
            this.leftW[i] = 0.0;
            this.rightW[i] = 0.0;
            this.xpoints[i] = 0;
            this.ypoints[i] = 0;
        }
        return this.right;
    }

    void calcBoundaryMatrix(ReflectionThing reflectionThing) {
        double d = 1.0;
        if (reflectionThing != null) {
            d = reflectionThing.indexN;
        }
        this.boundaryMatrix[0][0] = (this.indexN + d) / ((double)2 * this.indexN);
        this.boundaryMatrix[0][1] = (this.indexN - d) / ((double)2 * this.indexN);
        this.boundaryMatrix[1][0] = (this.indexN - d) / ((double)2 * this.indexN);
        this.boundaryMatrix[1][1] = (this.indexN + d) / ((double)2 * this.indexN);
        this.wavenumber = this.indexN * (double)2 * Math.PI / this.owner.lambda;
        this.phaseShift = this.width * this.wavenumber;
        double d2 = Math.cos(this.phaseShift);
        double d3 = Math.sin(this.phaseShift);
        if (reflectionThing == null) {
            this.rightE[0] = this.magRight * d2;
            this.rightE[1] = -this.magRight * d3;
            this.leftE[0] = 0.0;
            this.leftE[1] = 0.0;
            return;
        }
        double d4 = this.boundaryMatrix[0][0] * reflectionThing.rightE[0] + this.boundaryMatrix[0][1] * reflectionThing.leftE[0];
        double d5 = this.boundaryMatrix[0][0] * reflectionThing.rightE[1] + this.boundaryMatrix[0][1] * reflectionThing.leftE[1];
        double d6 = this.boundaryMatrix[1][0] * reflectionThing.rightE[0] + this.boundaryMatrix[1][1] * reflectionThing.leftE[0];
        double d7 = this.boundaryMatrix[1][0] * reflectionThing.rightE[1] + this.boundaryMatrix[1][1] * reflectionThing.leftE[1];
        this.rightE[0] = d4 * d2 + d5 * d3;
        this.rightE[1] = d5 * d2 - d4 * d3;
        this.leftE[0] = d6 * d2 - d7 * d3;
        this.leftE[1] = d7 * d2 + d6 * d3;
    }

    int calcField(ReflectionThing reflectionThing, int n) {
        double d;
        double d2 = this.owner.ppu;
        double d3 = 0.0;
        double d4 = Math.cos(this.phaseShift);
        double d5 = Math.sin(this.phaseShift);
        this.magRight = d = this.owner.ampScale;
        this.magLeft = 0.0;
        if (reflectionThing == null) {
            this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
            for (int i = 0; i < this.pwidth; ++i) {
                d3 = (double)i / d2;
                this.rightW[i] = this.magRight * Math.cos(this.wavenumber * d3 - this.owner.timePhase - this.phaseShift);
                this.leftW[i] = 0.0;
                if (n + i - this.pwidth + 1 >= this.owner.rightWave.length) continue;
                this.owner.rightWave[n + i - this.pwidth] = this.rightW[i];
                this.owner.leftWave[n + i - this.pwidth] = this.leftW[i];
            }
            return n - this.pwidth;
        }
        this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
        double d6 = Math.atan2(this.rightE[1], this.rightE[0]);
        this.magLeft = d * Math.sqrt(this.leftE[0] * this.leftE[0] + this.leftE[1] * this.leftE[1]);
        double d7 = Math.atan2(this.leftE[1], this.leftE[0]);
        for (int i = 0; i < this.pwidth; ++i) {
            d3 = (double)i / d2;
            this.rightW[i] = this.magRight * Math.cos(this.wavenumber * d3 - this.owner.timePhase + d6);
            this.leftW[i] = this.magLeft * Math.cos(-this.wavenumber * d3 - this.owner.timePhase + d7);
            if (n + i - this.pwidth + 1 >= this.owner.rightWave.length) continue;
            this.owner.rightWave[n + i - this.pwidth] = this.rightW[i];
            this.owner.leftWave[n + i - this.pwidth] = this.leftW[i];
        }
        return n - this.pwidth;
    }

    void paintOS(Graphics graphics) {
        ReflectionThing reflectionThing = this.owner.getLeftNeighbor(this);
        graphics.setColor(this.color);
        if (this.visibility) {
            if (reflectionThing == null) {
                graphics.fillRect(this.left, 0, this.pwidth, this.owner.currenth);
            } else if (this.pwidth < 1) {
                if (reflectionThing.pwidth < 1) {
                    graphics.fillRect(this.left + 1, 0, 1, this.owner.currenth);
                } else {
                    graphics.fillRect(this.left, 0, 1, this.owner.currenth);
                }
            } else if (reflectionThing.pwidth < 1) {
                graphics.fillRect(this.left + 1, 0, this.pwidth - 1, this.owner.currenth);
            } else {
                graphics.fillRect(this.left, 0, this.pwidth, this.owner.currenth);
            }
        }
        this.paintRightWave(graphics);
        this.paintLeftWave(graphics);
        if (this.showCaption) {
            this.paintCaption(graphics);
        }
    }

    void fillToEnd(Graphics graphics) {
        double d = this.owner.ampScale;
        double d2 = this.owner.ppu;
        double d3 = 0.0;
        double d4 = Math.cos(this.phaseShift);
        double d5 = Math.sin(this.phaseShift);
        this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
        for (int i = this.right; i < this.owner.rightWave.length; ++i) {
            d3 = (double)(i - this.right) / d2;
            this.owner.rightWave[i] = this.magRight * Math.cos(this.wavenumber * d3 - this.owner.timePhase);
            this.owner.leftWave[i] = 0.0;
            if (!this.owner.showRWave || i <= 0) continue;
            int n = this.originY + (int)(this.owner.rightWave[i] * this.owner.ppu) - this.owner.rightPixOffset;
            int n2 = this.originY + (int)(this.owner.rightWave[i - 1] * this.owner.ppu) - this.owner.rightPixOffset;
            graphics.setColor(Color.blue);
            graphics.drawLine(i, n, i - 1, n2);
        }
    }

    void paintLeftWave(Graphics graphics) {
        if (!this.owner.showLWave) {
            return;
        }
        if (this.owner.getRightNeighbor(this) == null) {
            return;
        }
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this.originY + (int)(this.leftW[i] * this.owner.ppu) - this.owner.leftPixOffset;
        }
        graphics.setColor(Color.red);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.pwidth);
    }

    void paintRightWave(Graphics graphics) {
        if (!this.owner.showRWave) {
            return;
        }
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this.originY + (int)(this.rightW[i] * this.owner.ppu) - this.owner.rightPixOffset;
        }
        graphics.setColor(Color.blue);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.pwidth);
    }

    void paintSumWave(Graphics graphics) {
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this.originY + this.vertOffset + (int)((this.leftW[i] + this.rightW[i]) * this.owner.ppu);
        }
        graphics.setColor(Color.green);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.pwidth);
    }

    double calcRefCoeff(EMThing eMThing, EMThing eMThing2) {
        double d = eMThing2.indexN / eMThing.indexN;
        double d2 = (1.0 - d) / (1.0 + d);
        return d2 * d2;
    }

    double calcTransCoeff(EMThing eMThing, EMThing eMThing2) {
        double d = this.calcRefCoeff(eMThing, eMThing2);
        double d2 = Math.sqrt(1.0 - d * d);
        return d2 * d2;
    }

    void setIndexN(double d) {
        if (d < 1.0) {
            System.out.println("Cannot have index n<1 ");
        } else {
            this.indexN = d;
        }
    }

    void paintValue(Graphics graphics) {
        if (!this.showValue) {
            return;
        }
        String string = "n = ".concat(String.valueOf(String.valueOf(this.format.form(SUtil.chop((double)this.indexN, (double)1.0E-12)))));
        Font font = graphics.getFont();
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = fontMetrics.stringWidth(string);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.left + (int)(0.5 * (double)(this.pwidth - n)), (int)(0.9 * (double)this.owner.currenth));
        graphics.setFont(font);
    }
}

