/*
 * Decompiled with CFR 0.152.
 */
package reflection;

import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import reflection.ReflectionThing;
import reflection.WavePanel;

public class QMThing
extends ReflectionThing {
    double indexRight = 1.0;

    public QMThing() {
    }

    public QMThing(double d, double d2, WavePanel wavePanel) {
        super(d2, wavePanel);
        this.varStrings = new String[]{"pos", "width", "n", "pot", "im", "re", "energy", "transmission", "reflection"};
        this.potential = d;
        this.energy = this.owner.qmEnergy;
        if (this.potential == this.energy) {
            this.potential = this.energy * 0.9999;
        }
        this.wavenumber = this.indexN = Math.sqrt(Math.abs(this.potential - this.energy));
        this.phaseShift = this.width * this.wavenumber;
    }

    private void calcBoundaryMatrix1(ReflectionThing reflectionThing) {
        this.phaseShift = this.width * this.wavenumber;
        this.absorption = 0.0;
        this.boundaryMatrix[0][0] = (this.wavenumber + this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[0][1] = (this.wavenumber - this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[1][0] = (this.wavenumber - this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[1][1] = (this.wavenumber + this.indexRight) / ((double)2 * this.wavenumber);
        this.imMatrix[0][0] = 0.0;
        this.imMatrix[0][1] = 0.0;
        this.imMatrix[1][0] = 0.0;
        this.imMatrix[1][1] = 0.0;
    }

    private void calcBoundaryMatrix2(ReflectionThing reflectionThing) {
        this.phaseShift = 0.0;
        this.absorption = this.width * this.wavenumber;
        this.boundaryMatrix[0][0] = (this.wavenumber + this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[0][1] = (this.wavenumber - this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[1][0] = (this.wavenumber - this.indexRight) / ((double)2 * this.wavenumber);
        this.boundaryMatrix[1][1] = (this.wavenumber + this.indexRight) / ((double)2 * this.wavenumber);
        this.imMatrix[0][0] = 0.0;
        this.imMatrix[0][1] = 0.0;
        this.imMatrix[1][0] = 0.0;
        this.imMatrix[1][1] = 0.0;
    }

    private void calcBoundaryMatrix3(ReflectionThing reflectionThing) {
        this.absorption = 0.0;
        this.phaseShift = this.width * this.wavenumber;
        this.boundaryMatrix[0][0] = 0.5;
        this.boundaryMatrix[0][1] = 0.5;
        this.boundaryMatrix[1][0] = 0.5;
        this.boundaryMatrix[1][1] = 0.5;
        this.imMatrix[0][0] = 0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[0][1] = -0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[1][0] = -0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[1][1] = 0.5 * this.indexRight / this.wavenumber;
    }

    private void calcBoundaryMatrix4(ReflectionThing reflectionThing) {
        this.phaseShift = 0.0;
        this.absorption = this.width * this.wavenumber;
        this.boundaryMatrix[0][0] = 0.5;
        this.boundaryMatrix[0][1] = 0.5;
        this.boundaryMatrix[1][0] = 0.5;
        this.boundaryMatrix[1][1] = 0.5;
        this.imMatrix[0][0] = -0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[0][1] = 0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[1][0] = 0.5 * this.indexRight / this.wavenumber;
        this.imMatrix[1][1] = -0.5 * this.indexRight / this.wavenumber;
    }

    void calcBoundaryMatrix(ReflectionThing reflectionThing) {
        this.wavenumber = this.indexN;
        this.phaseShift = this.width * this.wavenumber;
        this.absorption = this.width * this.wavenumber;
        if (reflectionThing != null) {
            this.indexRight = reflectionThing.wavenumber;
            if (this.potential < this.energy && reflectionThing.potential <= this.energy) {
                this.calcBoundaryMatrix1(reflectionThing);
            } else if (this.potential > this.energy && reflectionThing.potential >= this.energy) {
                this.calcBoundaryMatrix2(reflectionThing);
            } else if (this.potential < this.energy && reflectionThing.potential >= this.energy) {
                this.calcBoundaryMatrix3(reflectionThing);
            } else if (this.potential > this.energy && reflectionThing.potential <= this.energy) {
                this.calcBoundaryMatrix4(reflectionThing);
            }
        } else {
            this.indexRight = this.wavenumber;
            if (this.potential > this.energy) {
                this.phaseShift = 0.0;
                this.absorption = this.wavenumber * this.width;
            } else {
                this.phaseShift = this.wavenumber * this.width;
                this.absorption = 0.0;
            }
        }
        double d = Math.cos(this.phaseShift);
        double d2 = Math.sin(this.phaseShift);
        if (reflectionThing == null) {
            this.rightE[0] = this.magRight * d * Math.exp(this.absorption);
            this.rightE[1] = -this.magRight * d2 * Math.exp(this.absorption);
            this.leftE[0] = 0.0;
            this.leftE[1] = 0.0;
            return;
        }
        double d3 = this.boundaryMatrix[0][0] * reflectionThing.rightE[0] + this.boundaryMatrix[0][1] * reflectionThing.leftE[0] - this.imMatrix[0][0] * reflectionThing.rightE[1] - this.imMatrix[0][1] * reflectionThing.leftE[1];
        double d4 = this.boundaryMatrix[0][0] * reflectionThing.rightE[1] + this.boundaryMatrix[0][1] * reflectionThing.leftE[1] + this.imMatrix[0][0] * reflectionThing.rightE[0] + this.imMatrix[0][1] * reflectionThing.leftE[0];
        double d5 = this.boundaryMatrix[1][0] * reflectionThing.rightE[0] + this.boundaryMatrix[1][1] * reflectionThing.leftE[0] - this.imMatrix[1][0] * reflectionThing.rightE[1] - this.imMatrix[1][1] * reflectionThing.leftE[1];
        double d6 = this.boundaryMatrix[1][0] * reflectionThing.rightE[1] + this.boundaryMatrix[1][1] * reflectionThing.leftE[1] + this.imMatrix[1][0] * reflectionThing.rightE[0] + this.imMatrix[1][1] * reflectionThing.leftE[0];
        this.rightE[0] = d3 * d * Math.exp(this.absorption) + d4 * d2 * Math.exp(this.absorption);
        this.rightE[1] = d4 * d * Math.exp(this.absorption) - d3 * d2 * Math.exp(this.absorption);
        this.leftE[0] = d5 * d * Math.exp(-this.absorption) - d6 * d2 * Math.exp(-this.absorption);
        this.leftE[1] = d6 * d * Math.exp(-this.absorption) + d5 * d2 * Math.exp(-this.absorption);
    }

    int calcField(ReflectionThing reflectionThing, int n) {
        double d;
        double d2 = this.owner.ppu;
        double d3 = 0.0;
        double d4 = Math.cos(this.phaseShift);
        double d5 = Math.sin(this.phaseShift);
        this.magRight = d = this.owner.ampScale;
        this.magLeft = 0.0;
        if (reflectionThing == null) {
            this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
            double d6 = Math.atan2(this.rightE[1], this.rightE[0]);
            for (int i = 0; i < this.pwidth; ++i) {
                d3 = (double)i / d2;
                if (this.energy > this.potential) {
                    this.rightW[i] = this.magRight * Math.cos(this.wavenumber * d3 + d6 - this.owner.timePhase);
                    this.leftW[i] = this.magRight * Math.sin(this.wavenumber * d3 + d6 - this.owner.timePhase);
                } else {
                    this.rightW[i] = this.magRight * Math.exp(-this.wavenumber * d3) * Math.cos(d6 - this.owner.timePhase);
                    this.leftW[i] = this.magRight * Math.exp(-this.wavenumber * d3) * Math.sin(d6 - this.owner.timePhase);
                }
                if (n + i - this.pwidth + 1 >= this.owner.rightWave.length) continue;
                this.owner.rightWave[n + i - this.pwidth] = this.rightW[i];
                this.owner.leftWave[n + i - this.pwidth] = this.leftW[i];
            }
            return n - this.pwidth;
        }
        this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
        double d7 = Math.atan2(this.rightE[1], this.rightE[0]);
        this.magLeft = d * Math.sqrt(this.leftE[0] * this.leftE[0] + this.leftE[1] * this.leftE[1]);
        double d8 = Math.atan2(this.leftE[1], this.leftE[0]);
        for (int i = 0; i < this.pwidth; ++i) {
            d3 = (double)i / d2;
            if (this.energy > this.potential) {
                this.rightW[i] = this.magRight * Math.cos(this.wavenumber * d3 + d7 - this.owner.timePhase) + this.magLeft * Math.cos(-this.wavenumber * d3 + d8 - this.owner.timePhase);
                this.leftW[i] = this.magRight * Math.sin(this.wavenumber * d3 + d7 - this.owner.timePhase) + this.magLeft * Math.sin(-this.wavenumber * d3 + d8 - this.owner.timePhase);
            } else {
                this.rightW[i] = this.magRight * Math.exp(-this.wavenumber * d3) * Math.cos(d7 - this.owner.timePhase) + this.magLeft * Math.exp(this.wavenumber * d3) * Math.cos(d8 - this.owner.timePhase);
                this.leftW[i] = this.magRight * Math.exp(-this.wavenumber * d3) * Math.sin(d7 - this.owner.timePhase) + this.magLeft * Math.exp(this.wavenumber * d3) * Math.sin(d8 - this.owner.timePhase);
            }
            if (n + i - this.pwidth + 1 >= this.owner.rightWave.length) continue;
            this.owner.rightWave[n + i - this.pwidth] = this.rightW[i];
            this.owner.leftWave[n + i - this.pwidth] = this.leftW[i];
        }
        return n - this.pwidth;
    }

    void fillToEnd(Graphics graphics) {
        double d = this.owner.ampScale;
        double d2 = this.owner.ppu;
        double d3 = 0.0;
        double d4 = Math.cos(this.phaseShift);
        double d5 = Math.sin(this.phaseShift);
        this.magRight = d * Math.sqrt(this.rightE[0] * this.rightE[0] + this.rightE[1] * this.rightE[1]);
        double d6 = Math.atan2(this.rightE[1], this.rightE[0]);
        for (int i = this.right; i < this.owner.rightWave.length; ++i) {
            int n;
            int n2;
            d3 = (double)(i - this.right) / d2;
            if (this.potential > this.energy) {
                this.owner.rightWave[i] = this.magRight * Math.exp(-this.wavenumber * d3 - this.absorption) * Math.cos(d6 - this.owner.timePhase);
                this.owner.leftWave[i] = this.magRight * Math.exp(-this.wavenumber * d3 - this.absorption) * Math.sin(d6 - this.owner.timePhase);
            } else {
                this.owner.rightWave[i] = this.magRight * Math.cos(this.wavenumber * d3 + d6 + this.phaseShift - this.owner.timePhase);
                this.owner.leftWave[i] = this.magRight * Math.sin(this.wavenumber * d3 + d6 + this.phaseShift - this.owner.timePhase);
            }
            if (!this.owner.showPhaseColor && this.owner.showRWave) {
                n2 = (int)(this.owner.rightWave[i] * d2) + this.owner.currenth / 2 - this.vertOffset;
                n = (int)(this.owner.rightWave[i - 1] * d2) + this.owner.currenth / 2 - this.vertOffset;
                graphics.setColor(Color.yellow);
                graphics.drawLine(i, n2, i - 1, n);
            }
            if (this.owner.showPhaseColor || !this.owner.showLWave) continue;
            n2 = (int)(this.owner.leftWave[i] * d2) + this.owner.currenth / 2;
            n = (int)(this.owner.leftWave[i - 1] * d2) + this.owner.currenth / 2;
            graphics.setColor(Color.red);
            graphics.drawLine(i, n2, i - 1, n);
        }
    }

    void paintOS(Graphics graphics) {
        ReflectionThing reflectionThing = this.owner.getLeftNeighbor(this);
        graphics.setColor(this.color);
        if (this.visibility) {
            if (reflectionThing == null) {
                graphics.fillRect(this.left, 0, this.pwidth, this.owner.currenth);
            } else if (this.pwidth < 1) {
                if (reflectionThing.pwidth < 1) {
                    graphics.fillRect(this.left + 1, 0, 1, this.owner.currenth);
                } else {
                    graphics.fillRect(this.left, 0, 1, this.owner.currenth);
                }
            } else if (reflectionThing.pwidth < 1) {
                graphics.fillRect(this.left + 1, 0, this.pwidth - 1, this.owner.currenth);
            } else {
                graphics.fillRect(this.left, 0, this.pwidth, this.owner.currenth);
            }
        }
        if (!this.owner.showPhaseColor && this.owner.showRWave) {
            this.paintRightWave(graphics);
        }
        if (!this.owner.showPhaseColor && this.owner.showLWave) {
            this.paintLeftWave(graphics);
        }
        if (this.showCaption) {
            this.paintCaption(graphics);
        }
    }

    void paintValue(Graphics graphics) {
        if (!this.showValue) {
            return;
        }
        String string = "V = ".concat(String.valueOf(String.valueOf(this.format.form(SUtil.chop((double)this.potential, (double)1.0E-12)))));
        Font font = graphics.getFont();
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = fontMetrics.stringWidth(string);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.left + (int)(0.5 * (double)(this.pwidth - n)), (int)(0.9 * (double)this.owner.currenth));
        graphics.setFont(font);
    }

    public double[][] getVariables() {
        this.vars[0][0] = this.pos;
        this.vars[0][1] = this.width;
        this.vars[0][2] = this.indexN;
        this.vars[0][3] = this.potential;
        this.vars[0][4] = this.magLeft;
        this.vars[0][5] = this.magRight;
        this.vars[0][6] = this.owner.qmEnergy;
        this.vars[0][8] = this.owner.refC * this.owner.refC;
        this.vars[0][7] = 1.0 - this.vars[0][8];
        return this.vars;
    }
}

