/*
 * Decompiled with CFR 0.152.
 */
package reflection;

import edu.davidson.display.ArrowThing;
import edu.davidson.display.BoxThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.TextThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import reflection.ReflectionThing;
import reflection.WavePanel;

public class ReflectionApplet
extends SApplet {
    String button_start = "Run";
    String button_stop = "Stop";
    String button_reset = "Reset";
    String button_forward = "Step";
    String button_add = "Add/Change";
    String label_number = "#:";
    String label_refraction = "n =";
    String label_left_wave = "Left Wave";
    String label_right_wave = "Right Wave";
    String label_sum = "Sum";
    String label_energy = "Energy =";
    String label_time = "Time:";
    String label_no_phase = "Phase not available.";
    String label_phase = "Phase =";
    boolean showControls;
    int fps;
    String mode;
    String m;
    double ppu;
    double magMax;
    double lam;
    double fq;
    double wv;
    int selectedMedia = 0;
    WavePanel wavePanel = new WavePanel(this);
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button initBtn = new Button();
    Button changeBtn = new Button();
    SNumber indexField = new SNumber();
    Label label1 = new Label();
    Label label2 = new Label();
    SInteger mediaField = new SInteger();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    Button runBtn = new Button();
    SPanel panel1 = new SPanel();
    SPanel panel2 = new SPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    Panel panel3 = new Panel();
    BorderLayout borderLayout5 = new BorderLayout();
    Button stepBtn = new Button();
    FlowLayout flowLayout2 = new FlowLayout();

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.button_add = this.localProperties.getProperty("button.add", this.button_add);
        this.label_number = this.localProperties.getProperty("label.number", this.label_number);
        this.label_refraction = this.localProperties.getProperty("label.refraction", this.label_refraction);
        this.label_left_wave = this.localProperties.getProperty("label.left_wave", this.label_left_wave);
        this.label_right_wave = this.localProperties.getProperty("label.right_wave", this.label_right_wave);
        this.label_sum = this.localProperties.getProperty("label.sum", this.label_sum);
        this.label_energy = this.localProperties.getProperty("label.energy", this.label_energy);
        this.label_time = this.localProperties.getProperty("label.time", this.label_time);
        this.label_no_phase = this.localProperties.getProperty("label.no_phase", this.label_no_phase);
        this.label_phase = this.localProperties.getProperty("label.phase", this.label_phase);
    }

    public void init() {
        this.initResources(null);
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ppu = Double.valueOf(this.getParameter("PPU", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.magMax = Double.valueOf(this.getParameter("MaxAmp", "3"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.lam = Double.valueOf(this.getParameter("Wavelength", "6"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.wv = Double.valueOf(this.getParameter("WaveVelocity", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.valueOf(this.getParameter("FPS", "4"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m = String.valueOf(this.getParameter("Mode", "EM")).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.addClockListener((SStepable)this.wavePanel);
        this.setMode(this.m);
        this.setShowControls(this.showControls);
        this.setPPU(this.ppu);
        this.setMagMax(this.magMax);
        this.setWavelength(this.lam);
        this.setFPS(this.fps);
        this.setWaveVelocity(this.wv);
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        this.etchedBorder2.setLayout(this.flowLayout2);
        this.etchedBorder3.setLayout(this.flowLayout1);
        this.initBtn.setLabel(this.button_reset);
        this.initBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectionApplet.this.initBtn_actionPerformed(actionEvent);
            }
        });
        this.changeBtn.setLabel(this.button_add);
        this.changeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectionApplet.this.changeBtn_actionPerformed(actionEvent);
            }
        });
        this.indexField.setText("1");
        this.indexField.setValue(1.0);
        this.label1.setAlignment(2);
        this.label1.setText(this.label_refraction);
        this.label2.setAlignment(2);
        this.label2.setText(this.label_number);
        this.mediaField.setText("1");
        this.mediaField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectionApplet.this.mediaField_actionPerformed(actionEvent);
            }
        });
        this.runBtn.setLabel(this.button_start);
        this.runBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectionApplet.this.runBtn_actionPerformed(actionEvent);
            }
        });
        this.panel2.setLayout(this.borderLayout3);
        this.panel1.setLayout(this.borderLayout4);
        this.panel3.setLayout(this.borderLayout5);
        this.panel2.setMinimumSize(new Dimension(100, 20));
        this.panel2.setPreferredSize(new Dimension(100, 20));
        this.panel1.setMinimumSize(new Dimension(150, 20));
        this.panel1.setPreferredSize(new Dimension(150, 20));
        this.stepBtn.setLabel(this.button_forward);
        this.stepBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectionApplet.this.stepBtn_actionPerformed(actionEvent);
            }
        });
        this.controlPanel.setBackground(Color.lightGray);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.flowLayout2.setAlignment(2);
        this.flowLayout2.setHgap(2);
        ((Container)((Object)this)).add(this.wavePanel, "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.etchedBorder2, "Center");
        this.etchedBorder2.add((Component)this.panel3, null);
        this.panel3.add((Component)this.changeBtn, "West");
        this.etchedBorder2.add((Component)this.panel2, null);
        this.panel2.add((Component)this.label2, "Center");
        this.panel2.add((Component)this.mediaField, "East");
        this.etchedBorder2.add((Component)this.panel1, null);
        this.panel1.add((Component)this.label1, "West");
        this.panel1.add((Component)this.indexField, "Center");
        this.controlPanel.add((Component)this.etchedBorder3, "West");
        this.etchedBorder3.add((Component)this.initBtn, null);
        this.etchedBorder3.add((Component)this.runBtn, null);
        this.etchedBorder3.add((Component)this.stepBtn, null);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", "true or false"}};
        return stringArray;
    }

    public void setShowControls(boolean bl) {
        this.controlPanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setDefault() {
        this.clock.stopClock();
        this.wavePanel.setDefault();
    }

    public void setMessage(String string) {
        this.wavePanel.message = string;
        this.wavePanel.showMessage = true;
    }

    public void setIndexN(int n, double d) {
        this.wavePanel.setIndexN(n, d);
    }

    public void setDragEnergy(int n, boolean bl) {
        this.wavePanel.setDragEnergy(n, bl);
    }

    public void setPPU(double d) {
        this.wavePanel.ppu = d;
    }

    public void setQMEnergy(double d) {
        this.wavePanel.setQMEnergy(d);
    }

    public double getQMEnergy() {
        return this.wavePanel.getQMEnergy();
    }

    public void setQMPotential(int n, double d) {
        this.setIndexN(n, d);
    }

    public void setMode(String string) {
        if (string.equals("QM")) {
            this.wavePanel.setMode(1);
        } else {
            this.wavePanel.setMode(0);
        }
        this.mode = string;
    }

    public void pause() {
        this.clock.stopClock();
        this.runBtn.setLabel(this.button_start);
    }

    public void forward() {
        this.clock.setDt(this.clock.getDt());
        this.recalculate();
        this.clock.startClock();
        this.runBtn.setLabel(this.button_stop);
    }

    public void reverse() {
        this.clock.setDt(-this.clock.getDt());
        this.recalculate();
        this.clock.startClock();
        this.runBtn.setLabel(this.button_stop);
    }

    public void step() {
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        this.clock.doStep();
        this.runBtn.setLabel(this.button_start);
    }

    public void stepTimeForward() {
        this.wavePanel.showMessage = false;
        if (this.clock.isRunning()) {
            this.pause();
            this.runBtn.setLabel(this.button_start);
            return;
        }
        boolean bl = false;
        if (this.clock.getDt() < 0.0) {
            bl = true;
        }
        this.clock.setDt(Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (bl) {
            this.clock.setDt(-Math.abs(this.clock.getDt()));
        }
    }

    public void stepForward() {
        this.stepTimeForward();
    }

    public void stepTimeBack() {
        this.wavePanel.showMessage = false;
        if (this.clock.isRunning()) {
            this.pause();
            this.runBtn.setLabel(this.button_start);
            return;
        }
        boolean bl = false;
        if (this.clock.getDt() < 0.0) {
            bl = true;
        }
        this.clock.setDt(-Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (!bl) {
            this.clock.setDt(Math.abs(this.clock.getDt()));
        }
    }

    public void stepBack() {
        this.stepTimeBack();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime && this.showControls) {
            this.setAutoRefresh(false);
            this.setAutoRefresh(true);
            this.forward();
            this.firstTime = false;
        }
        super.start();
    }

    public void setWaveVelocity(double d) {
        this.wavePanel.setWaveVelocity(d);
    }

    public synchronized int addObject(String string, String string2) {
        int n = 0;
        double d = 1.0;
        double d2 = 1.0;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("film") || string.equals("layer") || string.equals("medium")) {
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                d = SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                d2 = SUtil.getParam((String)string2, (String)"n=");
            }
            if (SUtil.parameterExist((String)string2, (String)"e=")) {
                d2 = SUtil.getParam((String)string2, (String)"e=");
            }
            n = this.addMedium(d2, d);
        }
        if (n == 0) {
            n = this.addDrawingObject(string, string3);
        }
        if (n == 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
        }
        return n;
    }

    private int addDrawingObject(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        int n4 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        BoxThing boxThing = null;
        if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            boxThing = new BoxThing((SApplet)this, (SScalable)this.wavePanel, d, d2, n, n2);
        } else if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            boxThing = new RectangleThing((SApplet)this, (SScalable)this.wavePanel, d, d2, n, n2);
        } else if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            boxThing = new CircleThing((SApplet)this, (SScalable)this.wavePanel, d, d2, n3);
        } else if (string.equals("arrow")) {
            double d3 = 1.0;
            double d4 = 1.0;
            n4 = 4;
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d3 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d4 = SUtil.getParam((String)string2, (String)"v=");
            }
            boxThing = new ArrowThing((SApplet)this, (SScalable)this.wavePanel, n4, d3, d4, d, d2);
            if (SUtil.parameterExist((String)string2, (String)"thickness=")) {
                ((ArrowThing)boxThing).thickness = Math.max((int)SUtil.getParam((String)string2, (String)"thickness="), 1);
            }
        } else if (string.equals("text") || string.equals("calculation")) {
            String string4 = "";
            String string5 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            boxThing = new TextThing((SApplet)this, (SScalable)this.wavePanel, string4, string5, d, d2);
        } else if (string.equals("caption")) {
            String string6 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            boxThing = new CaptionThing((SApplet)this, (SScalable)this.wavePanel, string6, d, d2);
        }
        if (boxThing != null && SUtil.parameterExist((String)string2, (String)"label=")) {
            boxThing.setLabel(SUtil.getParamStr((String)string3, (String)"label="));
        }
        if (boxThing != null) {
            this.wavePanel.drawingThings.addElement(boxThing);
            return boxThing.getID();
        }
        return 0;
    }

    public void removeObject(int n) {
        this.wavePanel.removeObject(n);
    }

    public int addMedium(double d, double d2) {
        ReflectionThing reflectionThing = this.wavePanel.addMedium(d, d2);
        this.indexField.setValue(d);
        this.mediaField.setValue(this.wavePanel.thingVector.size());
        return reflectionThing.hashCode();
    }

    public int getWaveID() {
        return this.wavePanel.getWaveID();
    }

    public double getReflection() {
        return Math.max(0.0, this.wavePanel.refC);
    }

    public double getTransmission() {
        return Math.max(0.0, this.wavePanel.tranC);
    }

    public void removeAllMedia() {
        this.wavePanel.removeAllThings();
        this.indexField.setValue(1.0);
        this.mediaField.setValue(1);
    }

    public boolean setDragable(int n, boolean bl) {
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThing(n);
        if (reflectionThing != null) {
            reflectionThing.dragable = bl;
            return true;
        }
        Thing thing = this.wavePanel.getDrawingThing(n);
        if (thing != null) {
            thing.setDragable(bl);
            return true;
        }
        return false;
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        this.wavePanel.setRGB(n, n2, n3, n4);
    }

    public void setMagMax(double d) {
        this.wavePanel.setMagMax(d);
    }

    public void setWavelength(double d) {
        if (d > 0.0) {
            this.wavePanel.setWavelength(d);
        }
    }

    public void setMediaWidth(int n, double d) {
        this.wavePanel.setMediaWidth(n, d);
    }

    public void recalculate() {
        this.wavePanel.recalc();
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.wavePanel.setAutoRefresh(bl);
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        if (font == null) {
            return false;
        }
        Thing thing = this.wavePanel.getDrawingThing(n);
        if (thing != null) {
            thing.setFont(font);
            return true;
        }
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThing(n);
        if (reflectionThing == null && (n == 0 || n == this.wavePanel.hashCode())) {
            this.wavePanel.font = font;
            return true;
        }
        if (reflectionThing == null) {
            return false;
        }
        reflectionThing.font = font;
        if (this.wavePanel.autoRefresh) {
            this.wavePanel.repaint();
        }
        return true;
    }

    public boolean setObjectFont(int n, String string, int n2, int n3) {
        return this.setFont(n, string, n2, n3);
    }

    public boolean setFormat(int n, String string) {
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThing(n);
        if (reflectionThing == null && (n == 0 || n == this.wavePanel.hashCode())) {
            return this.wavePanel.setFormat(string);
        }
        boolean bl = reflectionThing.setFormat(string);
        if (this.wavePanel.autoRefresh) {
            this.wavePanel.repaint();
        }
        return bl;
    }

    public void setLabel(int n, String string) {
        this.wavePanel.setCaption(n, string);
    }

    public void setTitle(String string) {
        this.wavePanel.setTitle(string);
    }

    public void setEnergyDisplay(boolean bl) {
        this.wavePanel.setEnergyDisplay(bl);
        if (this.autoRefresh) {
            this.wavePanel.repaint();
        }
    }

    public void setTimeDisplay(boolean bl) {
        this.wavePanel.setTimeDisplay(bl);
        if (this.autoRefresh) {
            this.wavePanel.repaint();
        }
    }

    public void setAmpDisplay(boolean bl) {
        this.wavePanel.setAmpDisplay(bl);
    }

    public void setCoordDisplay(boolean bl) {
        this.wavePanel.setCoordDisplay(bl);
    }

    public void setPhaseDisplay(boolean bl) {
        this.wavePanel.setPhaseDisplay(bl);
    }

    public boolean setShowValue(int n, boolean bl) {
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThing(n);
        if (reflectionThing == null) {
            return false;
        }
        reflectionThing.setShowValue(bl);
        return true;
    }

    public boolean setVisibility(int n, boolean bl) {
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThing(n);
        if (reflectionThing != null) {
            reflectionThing.setVisibility(bl);
            return true;
        }
        Thing thing = this.wavePanel.getDrawingThing(n);
        if (thing != null) {
            thing.setDragable(bl);
            return true;
        }
        return false;
    }

    public void setShowWave(boolean bl) {
        this.wavePanel.showWave = bl;
        if (this.autoRefresh) {
            this.wavePanel.recalc();
        }
    }

    public void setShowLWave(boolean bl, int n) {
        this.wavePanel.showLWave = bl;
        this.wavePanel.leftPixOffset = n;
        if (this.autoRefresh) {
            this.wavePanel.recalc();
        }
    }

    public void setShowPhaseColor(boolean bl) {
        this.wavePanel.showPhaseColor = bl;
        if (bl) {
            this.wavePanel.showWave = true;
        }
        if (this.autoRefresh) {
            this.wavePanel.recalc();
        }
    }

    public void setShowRWave(boolean bl, int n) {
        this.wavePanel.showRWave = bl;
        this.wavePanel.rightPixOffset = n;
        if (this.autoRefresh) {
            this.wavePanel.recalc();
        }
    }

    void initBtn_actionPerformed(ActionEvent actionEvent) {
        this.setDefault();
    }

    void changeBtn_actionPerformed(ActionEvent actionEvent) {
        double d = this.indexField.getValue();
        if (d < 0.0) {
            this.indexField.setBackground(Color.red);
            return;
        }
        this.indexField.setBackground(Color.white);
        int n = this.mediaField.getValue();
        if (n < 1) {
            this.mediaField.setBackground(Color.red);
            return;
        }
        this.mediaField.setBackground(Color.white);
        if (n > this.wavePanel.thingVector.size()) {
            this.setAutoRefresh(false);
            double d2 = 40.0 / this.ppu;
            if (n == 1) {
                d2 = 60.0;
            }
            int n2 = this.addMedium(d, d2);
            this.setDragable(n2, true);
            this.setRGB(n2, (int)((double)255 * Math.random()), 255, (int)((double)255 * Math.random()));
            this.mediaField.setBackground(Color.white);
            this.setAutoRefresh(true);
            return;
        }
        ReflectionThing reflectionThing = (ReflectionThing)this.wavePanel.thingVector.elementAt(n - 1);
        this.wavePanel.setIndexN(reflectionThing.getID(), d);
        this.recalculate();
    }

    void runBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.clock.isRunning()) {
            this.pause();
            this.runBtn.setLabel(this.button_start);
        } else {
            this.forward();
            this.runBtn.setLabel(this.button_stop);
        }
    }

    void stepBtn_actionPerformed(ActionEvent actionEvent) {
        this.step();
    }

    void mediaField_actionPerformed(ActionEvent actionEvent) {
        int n = this.mediaField.getValue();
        ReflectionThing reflectionThing = this.wavePanel.getReflectionThingFromIndex(n - 1);
        if (reflectionThing != null) {
            this.indexField.setValue(reflectionThing.indexN);
        }
    }
}

