/*
 * Decompiled with CFR 0.152.
 */
package reflection;

import edu.davidson.display.Format;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import reflection.EMThing;
import reflection.QMThing;
import reflection.WavePanel;

public class ReflectionThing
implements SDataSource {
    int vertOffset = 0;
    WavePanel owner = null;
    SApplet applet = null;
    String caption;
    boolean dragPotential = false;
    boolean dragable = false;
    boolean showValue = true;
    boolean visibility = true;
    boolean showCaption = false;
    double indexN = 1.0;
    double energy = 2.0;
    double potential = 1.0;
    double magRight = 1.0;
    double magLeft = 0.0;
    double[] leftW2 = null;
    double[] leftW = null;
    double[] rightW = null;
    int[] xpoints = null;
    int[] ypoints = null;
    double pos;
    double width;
    int pwidth;
    Color color = Color.white;
    int originX = 0;
    int originY = 0;
    int left;
    int right;
    double phaseLeft = 0.0;
    double phaseLeft2 = 0.0;
    double wavenumber = 0.0;
    String[] varStrings = new String[]{"pos", "width", "n", "p", "magLeft", "magRight", "wavelength", "transmission", "reflection"};
    double[][] vars = new double[1][9];
    double[][] boundaryMatrix = new double[2][2];
    double[][] imMatrix = new double[2][2];
    double phaseShift = 0.0;
    double absorption = 0.0;
    double[] leftE = new double[2];
    double[] rightE = new double[2];
    Format format = new Format("%6.2g");
    Font font = null;

    public ReflectionThing() {
    }

    public ReflectionThing(double d, WavePanel wavePanel) {
        this();
        this.owner = wavePanel;
        this.applet = this.owner.owner;
        this.pos = 0.0;
        ReflectionThing reflectionThing = this.owner.getRightMost();
        if (reflectionThing != null) {
            this.pos = reflectionThing.pos + reflectionThing.width;
        }
        this.width = d;
        this.rescale(0);
    }

    int rescale(int n) {
        this.left = n;
        this.right = (int)((this.pos + this.width) * this.owner.ppu);
        this.pwidth = this.right - this.left;
        this.leftW = new double[this.pwidth];
        this.rightW = new double[this.pwidth];
        this.xpoints = new int[this.pwidth];
        this.ypoints = new int[this.pwidth];
        this.originY = (int)(0.5 * (double)this.owner.currenth);
        for (int i = 0; i < this.pwidth; ++i) {
            this.leftW[i] = 0.0;
            this.rightW[i] = 0.0;
            this.xpoints[i] = 0;
            this.ypoints[i] = 0;
        }
        return this.right;
    }

    void calcBoundaryMatrix(ReflectionThing reflectionThing) {
        this.boundaryMatrix[0][0] = 0.0;
        this.boundaryMatrix[0][1] = 0.0;
        this.boundaryMatrix[1][0] = 0.0;
        this.boundaryMatrix[1][1] = 0.0;
    }

    int calcField(ReflectionThing reflectionThing, int n) {
        return n;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = n >= 0 && n2 >= 0 && n3 >= 0 && n <= 255 && n2 <= 255 && n3 <= 255 ? new Color(n, n2, n3) : Color.blue;
    }

    void paintOS(Graphics graphics) {
        graphics.setColor(this.color);
        graphics.fillRect(this.left, 0, this.pwidth, this.owner.currenth);
        if (this instanceof EMThing) {
            this.paintRightWave(graphics);
            this.paintLeftWave(graphics);
            this.paintSumWave(graphics);
        } else {
            this.paintRightWave(graphics);
            this.paintLeftWave(graphics);
        }
        if (this.showValue) {
            this.paintValue(graphics);
        }
        if (this.showCaption) {
            this.paintCaption(graphics);
        }
    }

    void fillToEnd(Graphics graphics) {
    }

    void paintLeftWave(Graphics graphics) {
        if (!this.owner.showLWave) {
            return;
        }
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this.originY + (int)(this.leftW[i] * this.owner.ppu) - this.owner.leftPixOffset;
        }
        graphics.setColor(Color.red);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.xpoints.length);
    }

    void paintRightWave(Graphics graphics) {
        if (!this.owner.showRWave) {
            return;
        }
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this.originY - this.vertOffset + (int)(this.rightW[i] * this.owner.ppu) - this.owner.rightPixOffset;
        }
        graphics.setColor(Color.yellow);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.xpoints.length);
    }

    void paintSumWave(Graphics graphics) {
        for (int i = 0; i < this.pwidth; ++i) {
            this.xpoints[i] = i + this.left;
            this.ypoints[i] = this instanceof EMThing ? this.originY + this.vertOffset + (int)((this.leftW[i] + this.rightW[i]) * this.owner.ppu) : this.originY + this.vertOffset + (int)((this.leftW[i] * this.leftW[i] + this.rightW[i] * this.rightW[i]) * this.owner.ppu);
        }
        graphics.setColor(Color.green);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.xpoints.length);
    }

    void paintCaption(Graphics graphics) {
        Font font = graphics.getFont();
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = fontMetrics.stringWidth(this.caption);
        graphics.setColor(Color.black);
        graphics.drawString(this.caption, this.left + (int)(0.5 * (double)(this.pwidth - n)), (int)(0.9 * (double)this.owner.currenth));
        graphics.setFont(font);
    }

    void paintValue(Graphics graphics) {
    }

    void setPos(double d) {
        this.pos = d;
    }

    void setWidth(double d) {
        this.width = d;
        if (this instanceof QMThing) {
            this.setPotential(this.potential);
        }
    }

    void setIndexN(double d) {
        this.indexN = d;
    }

    void setPotential(double d) {
        if (this instanceof EMThing) {
            return;
        }
        this.potential = d;
        this.energy = this.owner.qmEnergy;
        if (this.potential == this.energy) {
            this.potential = this.energy * 0.9999;
        }
        this.wavenumber = this.indexN = Math.sqrt(Math.abs(this.potential - this.energy));
        this.phaseShift = this.width * this.indexN;
    }

    void scaleWaves(double d, double d2) {
        int n = 0;
        while (n < this.pwidth) {
            int n2 = n;
            this.leftW[n2] = this.leftW[n2] * (d2 / d);
            int n3 = n++;
            this.rightW[n3] = this.rightW[n3] * (d2 / d);
        }
    }

    public void setShowValue(boolean bl) {
        this.showValue = bl;
    }

    public void setVisibility(boolean bl) {
        this.visibility = bl;
    }

    boolean isNearBoundary(int n, int n2) {
        if (!this.dragable) {
            return false;
        }
        return Math.abs(this.right - n) < 4;
    }

    boolean isInside(int n, int n2) {
        return !this.dragable ? n > this.left && n < this.right : n > this.left + 3 && n < this.right - 3;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
        this.applet = sApplet;
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Illegal numeric format:".concat(String.valueOf(String.valueOf(string))));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public SApplet getOwner() {
        return this.applet;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public double[][] getVariables() {
        this.vars[0][0] = this.pos;
        this.vars[0][1] = this.width;
        this.vars[0][2] = this.indexN;
        this.vars[0][3] = this.potential;
        this.vars[0][4] = this.magLeft;
        this.vars[0][5] = this.magRight;
        this.vars[0][6] = this.owner.lambda;
        this.vars[0][7] = this.owner.tranC;
        this.vars[0][8] = this.owner.refC;
        return this.vars;
    }
}

