/*
 * Decompiled with CFR 0.152.
 */
package reflection;

import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.graph.TextLine;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;
import reflection.EMThing;
import reflection.QMThing;
import reflection.ReflectionApplet;
import reflection.ReflectionThing;
import reflection.WaveFrame;

public class WavePanel
extends Panel
implements SStepable,
SScalable {
    static int QM_MODE = 1;
    static int EM_MODE = 0;
    private Color[] colors = new Color[101];
    private boolean wasRunning = false;
    private boolean dragEnergy = false;
    private double lowestN = 0.0;
    private double highestN = 0.0;
    private boolean sendData = true;
    Font boldFont;
    Font font = this.boldFont = new Font("Helvetica", 1, 12);
    boolean showPhaseColor = true;
    boolean showTime = false;
    Color waveColor = new Color(128, 0, 0);
    boolean showRWave = false;
    boolean showLWave = false;
    boolean showWave = true;
    boolean showEnergy = true;
    boolean coordDisplay = true;
    boolean ampDisplay = false;
    boolean phaseDisplay = false;
    boolean mouseDown = false;
    int rightPixOffset = 0;
    int leftPixOffset = 0;
    int mousex = 0;
    int mousey = 0;
    private Format mouseFormat = new Format("%-+6.3g");
    private Format format = new Format("%6.3g");
    double[] leftWave = null;
    double[] rightWave = null;
    int[] xpoints = null;
    int[] ypoints = null;
    Vector thingVector = new Vector(4, 1);
    Vector drawingThings = new Vector();
    String message = null;
    private int boxWidth = 0;
    private int mode = EM_MODE;
    boolean showMessage = false;
    ReflectionApplet owner = null;
    Image osi = null;
    int currentw = 1;
    int currenth = 1;
    double ppu = 10.0;
    boolean autoRefresh = true;
    double magMax = 1.0;
    double lambda = 2.0;
    ReflectionThing dragThing = null;
    ReflectionThing insideThing = null;
    double qmEnergy = 0.0;
    double waveVel = 0.0;
    double time = 0.0;
    double timePhase = 0.0;
    double refC = 0.0;
    double tranC = 1.0;
    double ampScale = 1.0;
    WaveDataSource waveDataSource = null;
    TextLine title = new TextLine();
    String titleStr = "";

    public WavePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initColors();
    }

    public WavePanel(ReflectionApplet reflectionApplet) {
        this();
        this.owner = reflectionApplet;
    }

    public void setAmpDisplay(boolean bl) {
        this.ampDisplay = bl;
    }

    public void setPhaseDisplay(boolean bl) {
        this.phaseDisplay = bl;
    }

    public void setCoordDisplay(boolean bl) {
        this.coordDisplay = bl;
    }

    public void setEnergyDisplay(boolean bl) {
        this.showEnergy = bl;
    }

    public void setTimeDisplay(boolean bl) {
        this.showTime = bl;
    }

    public void setMode(int n) {
        n = Math.abs(n);
        this.mode = n = Math.min(n, 1);
        this.removeAllThings();
    }

    public void setArrayBounds() {
        this.currentw = this.getBounds().width;
        this.currenth = this.getBounds().height;
        if (this.currentw <= 4 || this.currenth <= 4) {
            return;
        }
        this.leftWave = new double[this.currentw];
        this.rightWave = new double[this.currentw];
        this.xpoints = new int[this.currentw];
        this.ypoints = new int[this.currentw];
        this.osi = this.createImage(this.currentw, this.currenth);
        this.arrangeMedia();
    }

    public void step(double d, double d2) {
        if (!this.autoRefresh) {
            return;
        }
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            this.setArrayBounds();
        }
        if (this.osi == null) {
            return;
        }
        this.time = d2;
        this.makeWaves(d2);
        this.paintOffScreen();
        if (this.sendData) {
            this.owner.updateDataConnections();
        }
    }

    private void calcMinMaxN() {
        this.lowestN = 0.0;
        this.highestN = 0.0;
        ReflectionThing reflectionThing = this.getRightMost();
        if (reflectionThing == null) {
            return;
        }
        this.lowestN = reflectionThing.indexN;
        this.highestN = reflectionThing.indexN;
        reflectionThing = this.getLeftNeighbor(reflectionThing);
        while (reflectionThing != null) {
            if (this.lowestN > reflectionThing.indexN) {
                this.lowestN = reflectionThing.indexN;
            }
            if (this.highestN < reflectionThing.indexN) {
                this.highestN = reflectionThing.indexN;
            }
            reflectionThing = this.getLeftNeighbor(reflectionThing);
        }
    }

    public synchronized void recalc() {
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            this.setArrayBounds();
        }
        if (this.osi == null) {
            return;
        }
        this.calcAmps();
        this.calcMinMaxN();
        this.paintOffScreen();
        if (bl) {
            this.owner.clock.startClock();
        } else if (this.autoRefresh && this.sendData) {
            this.owner.updateDataConnections();
        }
    }

    Thing getDrawingThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.drawingThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    ReflectionThing getReflectionThing(int n) {
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            if (reflectionThing.hashCode() != n) continue;
            return reflectionThing;
        }
        return null;
    }

    ReflectionThing getReflectionThingFromIndex(int n) {
        int n2 = this.thingVector.size();
        if (n < 0 || n >= n2) {
            return null;
        }
        return (ReflectionThing)this.thingVector.elementAt(n);
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Illegal numeric format:".concat(String.valueOf(String.valueOf(string))));
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setDragEnergy(int n, boolean bl) {
        if (n == 0) {
            this.dragEnergy = bl;
            return;
        }
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing != null) {
            reflectionThing.dragPotential = bl;
        }
    }

    public void setDefault() {
        this.showMessage = false;
        if (this.waveDataSource != null) {
            this.owner.removeDataSource(this.waveDataSource.getID());
        }
        this.waveDataSource = null;
        this.removeAllThings();
        this.showPhaseColor = true;
        this.dragEnergy = false;
        this.showRWave = false;
        this.showLWave = false;
        this.showWave = true;
        this.rightPixOffset = 0;
        this.leftPixOffset = 0;
    }

    public void setIndexN(int n, double d) {
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing != null) {
            if (reflectionThing instanceof EMThing) {
                reflectionThing.setIndexN(d);
            } else {
                reflectionThing.setPotential(d);
            }
        }
        if (this.autoRefresh) {
            this.recalc();
        }
    }

    public double getQMEnergy() {
        return this.qmEnergy;
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing != null) {
            reflectionThing.setColor(n2, n3, n4);
            return;
        }
        Thing thing = this.getDrawingThing(n);
        if (thing != null) {
            thing.setColor(new Color(n2, n3, n4));
            return;
        }
    }

    public void removeObject(int n) {
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing == null) {
            return;
        }
        this.thingVector.removeElement(reflectionThing);
        this.arrangeMedia();
        if (this.autoRefresh) {
            this.recalc();
        }
        try {
            this.owner.removeDataSource(reflectionThing.hashCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("error in addMediaDataSource()");
        }
    }

    public ReflectionThing addMedium(double d, double d2) {
        ReflectionThing reflectionThing = this.mode == EM_MODE ? new EMThing(d, d2, this) : new QMThing(d, d2, this);
        this.thingVector.addElement(reflectionThing);
        this.arrangeMedia();
        if (this.autoRefresh) {
            this.recalc();
        }
        try {
            SApplet.addDataSource((Object)reflectionThing);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("error in addMediaDataSource()");
        }
        return reflectionThing;
    }

    void arrangeMedia() {
        double d = 0.0;
        int n = 0;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            reflectionThing.setPos(d);
            n = reflectionThing.rescale(n);
            d += reflectionThing.width;
        }
    }

    void removeAllThings() {
        Vector vector;
        this.drawingThings.removeAllElements();
        Vector vector2 = this.thingVector;
        synchronized (vector2) {
            vector = (Vector)this.thingVector.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            this.owner.removeDataSource(reflectionThing.getID());
        }
        this.thingVector.removeAllElements();
        this.arrangeMedia();
        if (this.autoRefresh) {
            this.recalc();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            this.recalc();
        }
    }

    public void calcAmps() {
        double d = 0.0;
        double d2 = 1.0;
        ReflectionThing reflectionThing = this.getRightMost();
        if (reflectionThing == null) {
            return;
        }
        ReflectionThing reflectionThing2 = null;
        while (reflectionThing != null) {
            reflectionThing.calcBoundaryMatrix(reflectionThing2);
            reflectionThing2 = reflectionThing;
            reflectionThing = this.getLeftNeighbor(reflectionThing);
        }
        reflectionThing = this.getLeftMost();
        d2 = Math.sqrt(reflectionThing.rightE[0] * reflectionThing.rightE[0] + reflectionThing.rightE[1] * reflectionThing.rightE[1]);
        d = Math.sqrt(reflectionThing.leftE[0] * reflectionThing.leftE[0] + reflectionThing.leftE[1] * reflectionThing.leftE[1]);
        reflectionThing = this.getRightMost();
        if (d2 > 0.0) {
            this.ampScale = this.magMax * 1.0 / d2;
        } else {
            System.out.println("Error: The output is nonzero but the input is zero!");
        }
        this.refC = d / d2;
        this.tranC = 1.0 - this.refC;
        this.makeWaves(this.time);
    }

    void makeWaves(double d) {
        int n = this.rightWave.length;
        ReflectionThing reflectionThing = this.getRightMost();
        ReflectionThing reflectionThing2 = null;
        if (reflectionThing == null) {
            return;
        }
        n = reflectionThing.right;
        do {
            this.timePhase = this.mode == EM_MODE ? d * this.waveVel : d * this.qmEnergy / 5.0;
            n = reflectionThing.calcField(reflectionThing2, n);
            reflectionThing2 = reflectionThing;
        } while ((reflectionThing = this.getLeftNeighbor(reflectionThing)) != null);
    }

    static double[][] multTransMatrices(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[2][2];
        double d = dArray[0][0];
        double d2 = dArray[0][1];
        double d3 = dArray[1][0];
        double d4 = dArray[1][1];
        double d5 = dArray2[0][0];
        double d6 = dArray2[0][1];
        double d7 = dArray2[1][0];
        double d8 = dArray2[1][1];
        dArray3[0][0] = d * d5 - d2 * d7;
        dArray3[0][1] = d * d6 + d2 * d8;
        dArray3[1][0] = d5 * d3 + d4 * d7;
        dArray3[1][1] = d4 * d8 - d6 * d3;
        return dArray3;
    }

    public static double calcRefCoeff(double[][] dArray, double d, double d2) {
        double d3 = dArray[0][0];
        double d4 = dArray[0][1];
        double d5 = dArray[1][0];
        double d6 = dArray[1][1];
        double d7 = d3 * d - d6 * d2;
        double d8 = d4 * d * d2 - d5;
        double d9 = d3 * d + d6 * d2;
        double d10 = d4 * d2 * d + d5;
        double d11 = (d7 * d7 + d8 * d8) / (d9 * d9 + d10 * d10);
        System.out.println("r =".concat(String.valueOf(String.valueOf(d11))));
        return d11;
    }

    public static double calcTransCoeff(double[][] dArray, double d, double d2) {
        double d3 = dArray[0][0];
        double d4 = dArray[0][1];
        double d5 = dArray[1][0];
        double d6 = dArray[1][1];
        double d7 = (double)2 * d;
        double d8 = 0.0;
        double d9 = d3 * d + d6 * d2;
        double d10 = d4 * d2 * d + d5;
        double d11 = (d7 * d7 + d8 * d8) / (d9 * d9 + d10 * d10);
        System.out.println("t =".concat(String.valueOf(String.valueOf(d11))));
        return d11;
    }

    private void scaleWaves(double d, double d2) {
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            if (reflectionThing == null) continue;
            reflectionThing.scaleWaves(d, d2);
        }
    }

    public void setMagMax(double d) {
        if (d > 0.0) {
            this.magMax = d;
        }
        if (this.autoRefresh) {
            this.recalc();
        }
    }

    public void setMediaWidth(int n, double d) {
        this.sendData = false;
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        if (d <= 0.0) {
            return;
        }
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing == null) {
            return;
        }
        reflectionThing.setWidth(d);
        this.arrangeMedia();
        if (this.autoRefresh) {
            this.recalc();
        }
        if (bl) {
            this.owner.clock.startClock();
        }
        this.sendData = true;
    }

    void setWaveVelocity(double d) {
        this.sendData = false;
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        this.waveVel = d;
        this.arrangeMedia();
        this.recalc();
        if (bl) {
            this.owner.clock.startClock();
        }
        this.sendData = true;
    }

    public void setQMEnergy(double d) {
        if (this.mode != QM_MODE) {
            return;
        }
        this.sendData = false;
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        this.qmEnergy = d;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            reflectionThing.setPotential(reflectionThing.potential);
        }
        if (this.autoRefresh) {
            this.recalc();
        }
        if (bl) {
            this.owner.clock.startClock();
        }
        this.sendData = true;
    }

    public void setWavelength(double d) {
        this.sendData = false;
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        this.lambda = d;
        this.arrangeMedia();
        this.recalc();
        if (bl) {
            this.owner.clock.startClock();
        }
        this.sendData = true;
    }

    public ReflectionThing getRightMost() {
        double d = -1000.0;
        ReflectionThing reflectionThing = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing2 = (ReflectionThing)enumeration.nextElement();
            if (!(reflectionThing2.pos > d)) continue;
            d = reflectionThing2.pos;
            reflectionThing = reflectionThing2;
        }
        return reflectionThing;
    }

    public ReflectionThing getLeftMost() {
        double d = 100000.0;
        ReflectionThing reflectionThing = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing2 = (ReflectionThing)enumeration.nextElement();
            if (!(reflectionThing2.pos < d)) continue;
            d = reflectionThing2.pos;
            reflectionThing = reflectionThing2;
        }
        return reflectionThing;
    }

    public ReflectionThing getLeftNeighbor(ReflectionThing reflectionThing) {
        double d = reflectionThing.pos;
        double d2 = -100000.0;
        ReflectionThing reflectionThing2 = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing3 = (ReflectionThing)enumeration.nextElement();
            if (!(reflectionThing3.pos < d) || !(reflectionThing3.pos > d2)) continue;
            d2 = reflectionThing3.pos;
            reflectionThing2 = reflectionThing3;
        }
        return reflectionThing2;
    }

    public ReflectionThing getRightNeighbor(ReflectionThing reflectionThing) {
        double d = reflectionThing.pos;
        double d2 = 1.0E7;
        ReflectionThing reflectionThing2 = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing3 = (ReflectionThing)enumeration.nextElement();
            if (!(reflectionThing3.pos > d) || !(reflectionThing3.pos < d2)) continue;
            d2 = reflectionThing3.pos;
            reflectionThing2 = reflectionThing3;
        }
        return reflectionThing2;
    }

    void paintDrawingThings(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.drawingThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintOSI() {
        Graphics graphics;
        block14: {
            block13: {
                graphics = null;
                try {
                    try {
                        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
                            this.setArrayBounds();
                        }
                        if (this.osi == null) {
                            Object var5_2 = null;
                            if (graphics == null) return;
                            graphics.dispose();
                            return;
                        }
                        graphics = this.osi.getGraphics();
                        if (graphics == null) {
                            break block13;
                        }
                        ReflectionThing reflectionThing = this.getRightMost();
                        if (reflectionThing != null) {
                            graphics.setColor(reflectionThing.color);
                        } else {
                            graphics.setColor(Color.black);
                        }
                        graphics.fillRect(0, 0, this.currentw, this.currenth);
                        this.paintReflectionThings(graphics, reflectionThing);
                        this.paintDrawingThings(graphics);
                        graphics.setColor(Color.black);
                        if (this.showMessage) {
                            this.paintMessage(graphics);
                        }
                        if (this.mode == QM_MODE && this.showEnergy) {
                            this.paintQMEnergy(graphics);
                        }
                        this.paintTime(graphics);
                        if (!this.titleStr.equals("")) {
                            this.title.setText(this.titleStr);
                            Font font = graphics.getFont();
                            graphics.setFont(this.font);
                            this.title.draw(graphics, this.currentw / 2, 15, 0);
                            this.setFont(font);
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        Object var5_5 = null;
                        if (graphics == null) return;
                        graphics.dispose();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (graphics == null) throw throwable;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var5_3 = null;
            if (graphics == null) return;
            graphics.dispose();
            return;
        }
        Object var5_4 = null;
        if (graphics == null) return;
        graphics.dispose();
    }

    void paintQMEnergy(Graphics graphics) {
        if (!this.showEnergy) {
            return;
        }
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        String string = String.valueOf(String.valueOf(this.owner.label_energy)).concat(String.valueOf(String.valueOf(this.format.form(SUtil.chop((double)this.qmEnergy, (double)1.0E-12)))));
        if (this.showTime) {
            graphics.drawString(string, 10, 42);
        } else {
            graphics.drawString(string, 10, 25);
        }
        graphics.setFont(font);
    }

    void paintTime(Graphics graphics) {
        if (!this.showTime || this.owner == null) {
            return;
        }
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        String string = this.format.form(SUtil.chop((double)this.owner.clock.getTime(), (double)1.0E-12));
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_time))).append(" ").append(string))), 10, 25);
        graphics.setFont(font);
    }

    void paintReflectionThings(Graphics graphics, ReflectionThing reflectionThing) {
        ReflectionThing reflectionThing2;
        ReflectionThing reflectionThing3 = null;
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            reflectionThing2 = (ReflectionThing)enumeration.nextElement();
            if (reflectionThing2 != null) {
                reflectionThing2.paintOS(graphics);
            }
            reflectionThing3 = reflectionThing2;
        }
        this.paintLast(graphics, reflectionThing);
        graphics.setColor(Color.black);
        if (this.mode == QM_MODE) {
            graphics.drawLine(0, this.currenth / 2, this.currentw, this.currenth / 2);
        }
        enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            reflectionThing2 = (ReflectionThing)enumeration.nextElement();
            if (reflectionThing2 == null) continue;
            reflectionThing2.paintValue(graphics);
        }
        enumeration = this.drawingThings.elements();
        while (enumeration.hasMoreElements()) {
            reflectionThing2 = enumeration.nextElement();
        }
    }

    void paintWave(Graphics graphics) {
        if (this.showPhaseColor && this.mode == QM_MODE) {
            this.paintWave_color(graphics);
        } else {
            this.paintWave_function(graphics);
        }
    }

    void paintWave_color(Graphics graphics) {
        if (!this.showWave || this.leftWave.length < 2) {
            return;
        }
        for (int i = 0; i < this.leftWave.length; ++i) {
            this.xpoints[i] = i;
            this.ypoints[i] = this.mode == QM_MODE ? (int)(Math.sqrt(this.leftWave[i] * this.leftWave[i] + this.rightWave[i] * this.rightWave[i]) * this.ppu) : (int)((this.leftWave[i] + this.rightWave[i]) * this.ppu);
            graphics.setColor(this.colorFromPhase(Math.atan2(this.leftWave[i], this.rightWave[i])));
            graphics.drawLine(i, this.currenth / 2 - this.ypoints[i], i, this.currenth / 2 + this.ypoints[i]);
        }
    }

    void paintWave_function(Graphics graphics) {
        if (!this.showWave || this.leftWave.length < 2) {
            return;
        }
        for (int i = 0; i < this.leftWave.length; ++i) {
            this.xpoints[i] = i;
            this.ypoints[i] = this.mode == QM_MODE ? -((int)(Math.sqrt(this.leftWave[i] * this.leftWave[i] + this.rightWave[i] * this.rightWave[i]) * this.ppu)) + this.currenth / 2 : (int)((this.leftWave[i] + this.rightWave[i]) * this.ppu) + this.currenth / 2;
        }
        this.ypoints[this.leftWave.length - 1] = this.ypoints[this.leftWave.length - 2];
        graphics.setColor(this.waveColor);
        graphics.drawPolyline(this.xpoints, this.ypoints, this.leftWave.length);
    }

    public void paintLast(Graphics graphics, ReflectionThing reflectionThing) {
        ReflectionThing reflectionThing2 = reflectionThing;
        if (reflectionThing2 == null) {
            return;
        }
        reflectionThing2.fillToEnd(graphics);
        this.paintWave(graphics);
        if (this.mouseDown) {
            this.paintCoords(graphics, this.mousex, this.mousey);
        }
    }

    void paintCoords(int n, int n2) {
        if (!(this.coordDisplay || this.ampDisplay || this.phaseDisplay)) {
            return;
        }
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        double d;
        if (!(this.coordDisplay || this.ampDisplay || this.phaseDisplay)) {
            return;
        }
        String string = "";
        if (this.coordDisplay) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("x=").append(this.mouseFormat.form(this.xFromPix(n))).append(" y=").append(this.mouseFormat.form(this.yFromPix(n2))))))));
        }
        if (this.ampDisplay) {
            if (this.mode == QM_MODE) {
                d = Math.sqrt(this.leftWave[n] * this.leftWave[n] + this.rightWave[n] * this.rightWave[n]);
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(" |Psi|=".concat(String.valueOf(String.valueOf(this.mouseFormat.form(d)))))));
            } else {
                d = this.leftWave[n] + this.rightWave[n];
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(" E=".concat(String.valueOf(String.valueOf(this.mouseFormat.form(d)))))));
            }
        }
        if (this.phaseDisplay) {
            if (this.mode == QM_MODE) {
                d = Math.atan2(this.rightWave[n], -this.leftWave[n]);
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_phase).append(" ").append(this.mouseFormat.form(d))));
            } else {
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.owner.label_no_phase)));
            }
        }
        if (string.equals("")) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(0, rectangle.height - 20, this.boxWidth - 1, 20);
    }

    public int getPixWidth() {
        return this.currentw;
    }

    public int getPixHeight() {
        return this.currenth;
    }

    public double xFromPix(int n) {
        return (double)n / (1.0 * this.ppu);
    }

    public double yFromPix(int n) {
        int n2 = this.currenth / 2;
        return (double)(n2 - n) / (1.0 * this.ppu);
    }

    public int pixFromX(double d) {
        return (int)(this.ppu * d);
    }

    public int pixFromY(double d) {
        return (int)((double)this.currenth / 2.0 - d * this.ppu);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintOffScreen() {
        this.paintOSI();
        Graphics graphics = this.getGraphics();
        if (graphics == null || this.osi == null) {
            return;
        }
        graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            this.setArrayBounds();
        }
        if (this.osi == null || this.owner.clock.isRunning()) {
            return;
        }
        graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
    }

    void paintMessage(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = Math.max(110, 10 + fontMetrics.stringWidth(this.message));
        graphics.setColor(Color.yellow);
        graphics.fillRect(this.currentw - n - 3, this.currenth - 18, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.message, this.currentw - n, this.currenth - 6);
    }

    void paintLegend(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = this.owner.label_left_wave;
        String string2 = this.owner.label_right_wave;
        String string3 = this.owner.label_sum;
        int n = Math.max(110, 10 + fontMetrics.stringWidth(string2));
        int n2 = 45;
        graphics.setColor(Color.white);
        graphics.fillRect(5, 5, n - 2, n2 - 2);
        graphics.setColor(Color.blue);
        graphics.drawString(string2, 10, 20);
        graphics.setColor(Color.red);
        graphics.drawString(string, 10, 32);
        graphics.setColor(Color.green);
        graphics.drawString(string3, 10, 44);
    }

    public void setCaption(int n, String string) {
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing == null) {
            return;
        }
        reflectionThing.caption = string;
        reflectionThing.showCaption = true;
    }

    public void setTitle(String string) {
        this.titleStr = string;
    }

    public void clearCaption(int n) {
        ReflectionThing reflectionThing = this.getReflectionThing(n);
        if (reflectionThing == null) {
            return;
        }
        reflectionThing.showCaption = false;
        if (this.autoRefresh) {
            this.paintOffScreen();
        }
    }

    public void clearAllCaptions() {
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            reflectionThing.showCaption = false;
        }
        if (this.autoRefresh) {
            this.paintOffScreen();
        }
    }

    public void pause() {
        this.owner.pause();
    }

    public void forward() {
        this.owner.forward();
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                WavePanel.this.this_mouseMoved(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                WavePanel.this.this_mouseDragged(mouseEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                WavePanel.this.this_componentResized(componentEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                WavePanel.this.this_mousePressed(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                WavePanel.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                WavePanel.this.this_mouseExited(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                WavePanel.this.this_mouseReleased(mouseEvent);
            }
        });
    }

    private ReflectionThing isInsideThing(int n, int n2) {
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            if (!reflectionThing.isInside(n, n2)) continue;
            return reflectionThing;
        }
        return null;
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.osi == null) {
                return;
            }
            WaveFrame waveFrame = new WaveFrame(this.osi);
            waveFrame.show();
        } else {
            this.mouseDown = true;
            this.mousex = mouseEvent.getX();
            this.mousey = mouseEvent.getY();
            Enumeration enumeration = this.thingVector.elements();
            while (enumeration.hasMoreElements()) {
                ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
                if (!reflectionThing.isNearBoundary(this.mousex, this.mousey)) continue;
                if (this.owner.clock.isRunning()) {
                    this.pause();
                    this.wasRunning = true;
                }
                this.dragThing = reflectionThing;
            }
            this.insideThing = this.isInsideThing(this.mousex, this.mousey);
        }
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.setArrayBounds();
        this.paintOffScreen();
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        Enumeration enumeration = this.thingVector.elements();
        while (enumeration.hasMoreElements()) {
            ReflectionThing reflectionThing = (ReflectionThing)enumeration.nextElement();
            if (!reflectionThing.isNearBoundary(mouseEvent.getX(), mouseEvent.getY())) continue;
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = this.mousey - mouseEvent.getY();
        if (this.insideThing != null && this.insideThing.dragPotential) {
            this.insideThing.setPotential(this.insideThing.potential + (double)n / 100.0);
            this.recalc();
        } else if (this.dragThing == null && this.dragEnergy) {
            if (this.mode == EM_MODE) {
                this.setWavelength(Math.max(this.lambda + (double)n / 100.0, this.highestN * 3.0 * Math.PI / this.ppu));
            } else {
                double d = this.qmEnergy + (double)n / 100.0;
                d = Math.max(d, this.lowestN - 1.0);
                this.setQMEnergy(d);
            }
        }
        this.mousex = mouseEvent.getX();
        this.mousey = mouseEvent.getY();
        if (this.dragThing != null) {
            this.setMediaWidth(this.dragThing.hashCode(), (double)(mouseEvent.getX() - this.dragThing.left) / this.ppu);
            this.owner.updateDataConnections();
        }
        this.paintCoords(this.mousex, this.mousey);
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dragThing = null;
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mousex = mouseEvent.getX();
        this.mousey = mouseEvent.getY();
        this.dragThing = null;
        this.insideThing = null;
        this.mouseDown = false;
        this.boxWidth = 0;
        this.paintOSI();
        this.repaint();
        if (this.wasRunning) {
            this.forward();
            this.wasRunning = false;
        }
    }

    private Color colorFromPhase(double d) {
        int n = (int)((double)50 + (double)50 * d / Math.PI);
        return this.colors[n];
    }

    private void initColors() {
        double d = Math.PI;
        for (int i = 0; i < 101; ++i) {
            int n = (int)((double)255 * Math.sin(d * (double)i / (double)100) * Math.sin(d * (double)i / (double)100));
            int n2 = (int)((double)255 * Math.sin(d * (double)i / (double)100 + d / (double)3) * Math.sin(d * (double)i / (double)100 + d / (double)3));
            int n3 = (int)((double)255 * Math.sin(d * (double)i / (double)100 + (double)2 * d / (double)3) * Math.sin(d * (double)i / (double)100 + (double)2 * d / (double)3));
            this.colors[i] = new Color(n3, n2, n);
        }
    }

    public int getWaveID() {
        if (this.waveDataSource == null) {
            this.waveDataSource = new WaveDataSource();
        }
        return this.waveDataSource.getID();
    }

    public class WaveDataSource
    implements SDataSource {
        String[] varStrings = new String[]{"x", "re", "im", "a"};
        double[][] ds;

        WaveDataSource() {
            this.ds = new double[WavePanel.this.currentw][4];
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            if (this.ds.length != WavePanel.this.leftWave.length) {
                this.ds = new double[WavePanel.this.leftWave.length][4];
            }
            for (int i = 0; i < WavePanel.this.leftWave.length; ++i) {
                this.ds[i][0] = (double)i / WavePanel.this.ppu;
                this.ds[i][1] = WavePanel.this.rightWave[i];
                this.ds[i][2] = WavePanel.this.leftWave[i];
                this.ds[i][3] = WavePanel.this.mode == QM_MODE ? Math.sqrt(WavePanel.this.leftWave[i] * WavePanel.this.leftWave[i] + WavePanel.this.rightWave[i] * WavePanel.this.rightWave[i]) : WavePanel.this.leftWave[i] + WavePanel.this.rightWave[i];
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return WavePanel.this.owner;
        }
    }
}

