/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import faraday.Fluxable;
import faraday.Schematic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class CalcThing
extends Thing {
    private double[] tempVars = new double[5];
    private String calcStr;
    Parser calcFunc;
    Schematic schematic;
    private String text;

    public CalcThing(SApplet sApplet, Schematic schematic, String string, String string2, double d, double d2) {
        super((SScalable)schematic, d, d2);
        this.schematic = schematic;
        this.applet = sApplet;
        this.font = new Font("Helvetica", 1, 14);
        this.text = string;
        this.calcStr = string2;
        if (this.calcStr == null) {
            return;
        }
        this.calcFunc = new Parser(5);
        this.calcFunc.defineVariable(1, "t");
        this.calcFunc.defineVariable(2, "x");
        this.calcFunc.defineVariable(3, "y");
        this.calcFunc.defineVariable(4, "flux");
        this.calcFunc.defineVariable(5, "v");
        this.calcFunc.define(this.calcStr);
        this.calcFunc.parse();
        if (this.calcFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse calc-text: ".concat(String.valueOf(String.valueOf(this.calcStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.calcFunc.getErrorString()).append(" at function 1, position ").append(this.calcFunc.getErrorPosition()))));
            return;
        }
    }

    public final String getText() {
        double d = 0.0;
        Thing thing = this.getMaster();
        if (this.calcStr == null || this.calcFunc == null) {
            return this.text;
        }
        if (thing != null) {
            this.tempVars[0] = this.schematic.time;
            this.tempVars[1] = thing.getX();
            this.tempVars[2] = thing.getY();
            if (thing instanceof Fluxable) {
                this.tempVars[3] = ((Fluxable)thing).getFlux();
                this.tempVars[4] = ((Fluxable)thing).getVolt();
            }
        } else {
            this.tempVars[0] = this.schematic.time;
            this.tempVars[1] = this.x;
            this.tempVars[2] = this.y;
            this.tempVars[3] = 0.0;
            this.tempVars[4] = 0.0;
        }
        try {
            d = this.calcFunc.evaluate(this.tempVars);
            d = SUtil.chop((double)d, (double)1.0E-8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.text))).append(" ").append(this.format.form(d))));
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        int n = Math.round(this.canvas.pixFromX(this.x)) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.y)) - this.yDisplayOff;
        graphics.setColor(this.color);
        graphics.drawString(this.getText(), n, n2);
        graphics.setColor(Color.black);
        graphics.setFont(font);
    }
}

