/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import edu.davidson.display.ArrowThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.Constraint;
import edu.davidson.display.ImageThing;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.SGraph;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import faraday.CalcThing;
import faraday.Faraday_forwardBtn_actionAdapter;
import faraday.Faraday_resetBtn_actionAdapter;
import faraday.Faraday_runBtn_actionAdapter;
import faraday.FluxBox;
import faraday.FluxCircle;
import faraday.FluxRectangle;
import faraday.FluxShell;
import faraday.Schematic;
import faraday.UWire;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Faraday
extends SApplet
implements SStepable {
    String button_reset = "Clear";
    String button_start = "Run";
    String button_stop = "Stop";
    String button_forward = ">>";
    String label_udrag = "U Drag";
    String label_yaxis = "Voltage (mV)";
    String label_xaxis = "Time(s)";
    String label_bxt = "B(x,t)";
    String label_xt = "x(t)";
    String label_time = "Time:";
    String label_current = "Current";
    int pixPerUnit;
    int fps;
    boolean showControls;
    String fieldStr;
    String posStr;
    String stopMessage = null;
    boolean showGraph;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button runBtn = new Button();
    Button resetBtn = new Button();
    EtchedBorder etchedBorder4 = new EtchedBorder();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    Label label1 = new Label();
    Label label2 = new Label();
    TextField posField = new TextField();
    TextField fieldField = new TextField();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    EtchedBorder etchedBorder7 = new EtchedBorder();
    SGraph graph = new SGraph();
    Schematic schematic = new Schematic(this);
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    private boolean dragMode = true;
    private double maxTime = 10.0;
    private boolean uwireExists = false;
    private int schematicWidth = 200;
    private boolean showSchematic = true;
    private boolean showGrid = true;
    private boolean showColor = true;
    private boolean showCurrentArrow = true;
    Button forwardBtn = new Button();
    Checkbox dragBox = new Checkbox();

    protected void setResources() {
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.label_udrag = this.localProperties.getProperty("label.udrag", this.label_udrag);
        this.label_yaxis = this.localProperties.getProperty("label.yaxis", this.label_yaxis);
        this.label_xaxis = this.localProperties.getProperty("label.xaxis", this.label_xaxis);
        this.label_bxt = this.localProperties.getProperty("label.bxt", this.label_bxt);
        this.label_xt = this.localProperties.getProperty("label.xt", this.label_xt);
        this.label_time = this.localProperties.getProperty("label.time", this.label_time);
        this.label_current = this.localProperties.getProperty("label.current", this.label_current);
    }

    public void init() {
        this.initResources(null);
        double d = 0.1;
        boolean bl = true;
        try {
            this.maxTime = Double.valueOf(this.getParameter("MaxTime", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.pixPerUnit = Integer.parseInt(this.getParameter("PixPerUnit", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.schematicWidth = Integer.parseInt(this.getParameter("SchematicWidth", "200"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fieldStr = this.getParameter("FieldFunction", "10*sin(pi*x/5)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.posStr = this.getParameter("PositionFunction", "1.0+3.0*t");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showSchematic = Boolean.valueOf(this.getParameter("ShowSchematic", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGrid = Boolean.valueOf(this.getParameter("ShowGrid", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showColor = Boolean.valueOf(this.getParameter("ShowColor", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showCurrentArrow = Boolean.valueOf(this.getParameter("ShowCurrentArrow", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            bl = Boolean.valueOf(this.getParameter("ShowMeter", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dragMode = Boolean.valueOf(this.getParameter("DragMode", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.schematic.showSchematic = this.showSchematic;
        this.clock.setDt(d);
        this.clock.setFPS((double)this.fps);
        this.clock.setCycle(0.0, this.maxTime);
        this.clock.addClockListener((SStepable)this);
        if (!this.showControls) {
            this.etchedBorder1.setVisible(false);
        }
        this.autoRefresh = false;
        this.posField.setText(this.posStr);
        this.posField.setEnabled(!this.dragMode);
        this.dragBox.setState(this.dragMode);
        this.fieldField.setText(this.fieldStr);
        this.graph.setEnableMouse(true);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.graph.setBackground(Color.white);
        this.graph.setVisible(this.showGraph);
        this.setRunningID((Object)this);
        this.graph.deleteAllSeries();
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setBorders("0,10,10,5");
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.graph.setMinMaxX(0.0, this.maxTime);
        this.graph.setAutoscaleY(true);
        this.schematic.parsePosFunction(this.posStr);
        this.schematic.parseFieldFunction(this.fieldStr);
        this.schematic.pixPerUnit = this.pixPerUnit;
        this.schematic.setDragMode(this.dragMode);
        this.schematic.fillApplet = !this.showGraph;
        this.schematic.setPreferredWidth(this.schematicWidth);
        this.schematic.showGrid = this.showGrid;
        this.schematic.showColor = this.showColor;
        this.schematic.setShowCurrentArrow(this.showCurrentArrow);
        this.schematic.setShowMeter(bl);
        this.autoRefresh = true;
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setSize(new Dimension(669, 401));
        this.runBtn.setLabel(this.button_start);
        this.runBtn.addActionListener(new Faraday_runBtn_actionAdapter(this));
        this.resetBtn.setLabel(this.button_reset);
        this.resetBtn.addActionListener(new Faraday_resetBtn_actionAdapter(this));
        this.label1.setAlignment(2);
        this.label1.setText(this.label_bxt);
        this.label2.setAlignment(2);
        this.label2.setText("   ".concat(String.valueOf(String.valueOf(this.label_xt))));
        this.graph.setSampleData(false);
        this.graph.setLabelY(this.label_yaxis);
        this.forwardBtn.setLabel(this.button_forward);
        this.dragBox.setLabel(this.label_udrag);
        this.dragBox.setBackground(Color.lightGray);
        this.dragBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Faraday.this.dragBox_itemStateChanged(itemEvent);
            }
        });
        this.fieldField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Faraday.this.fieldField_actionPerformed(actionEvent);
            }
        });
        this.posField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Faraday.this.posField_actionPerformed(actionEvent);
            }
        });
        this.forwardBtn.addActionListener(new Faraday_forwardBtn_actionAdapter(this));
        this.graph.setLabelX(this.label_xaxis);
        this.etchedBorder4.setLayout(this.borderLayout4);
        this.panel2.setLayout(this.borderLayout1);
        this.panel1.setLayout(this.borderLayout2);
        this.etchedBorder3.setLayout(this.borderLayout6);
        this.etchedBorder1.setLayout(this.borderLayout3);
        this.etchedBorder2.setLayout(this.flowLayout1);
        this.etchedBorder7.setLayout(this.borderLayout7);
        ((Container)((Object)this)).setLayout(this.borderLayout5);
        ((Container)((Object)this)).add((Component)this.etchedBorder4, "Center");
        this.etchedBorder4.add((Component)this.graph, "Center");
        this.etchedBorder7.add((Component)this.schematic, "Center");
        this.etchedBorder4.add((Component)this.etchedBorder7, "West");
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "South");
        this.etchedBorder1.add((Component)this.etchedBorder2, "West");
        this.etchedBorder2.add((Component)this.dragBox, null);
        this.etchedBorder2.add((Component)this.runBtn, null);
        this.etchedBorder2.add((Component)this.resetBtn, null);
        this.etchedBorder2.add((Component)this.forwardBtn, null);
        this.etchedBorder1.add((Component)this.etchedBorder3, "Center");
        this.etchedBorder3.add((Component)this.panel1, "North");
        this.panel1.add((Component)this.label2, "West");
        this.panel1.add((Component)this.posField, "Center");
        this.etchedBorder3.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, "West");
        this.panel2.add((Component)this.fieldField, "Center");
    }

    public void forward() {
        this.schematic.setMessage(null);
        if (this.clock.getDt() < 0.0) {
            this.clock.setDt(-this.clock.getDt());
        }
        this.runBtn.setLabel(this.button_stop);
        this.clock.startClock();
    }

    public void reverse() {
        this.schematic.setMessage(null);
        if (this.clock.getDt() > 0.0) {
            this.clock.setDt(-this.clock.getDt());
        }
        this.runBtn.setLabel(this.button_stop);
        this.clock.startClock();
    }

    public void stepTimeForward() {
        double d;
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
        if ((d = this.clock.getDt()) < 0.0) {
            this.clock.setDt(-d);
        }
        this.clock.doStep();
    }

    public void stepForward() {
        this.stepTimeForward();
    }

    public void stepTimeBack() {
        double d;
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
        if ((d = this.clock.getDt()) > 0.0) {
            this.clock.setDt(-d);
        }
        this.clock.doStep();
    }

    public void stepBack() {
        this.stepTimeBack();
    }

    public void destroy() {
        this.clock.stopClock();
        this.graph.destroy();
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.graph.setOwner((SApplet)this);
            this.schematic.paint();
            this.schematic.invalidateOSI();
            int n = 0;
            if (this.showSchematic) {
                n = this.addObject("uwire", "x=0");
                this.setDragable(n, this.dragMode);
                this.forward();
            }
        }
        super.start();
    }

    public void step(double d, double d2) {
        double d3 = this.schematic.step(d, d2);
        if (d2 > 0.0) {
            this.graph.addDatum(1, d2 + d, d3);
        }
    }

    public void cyclingClock() {
        this.schematic.resetTime();
        this.graph.clearSeriesData(1);
        this.clearAllData();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public int getGraphID() {
        return this.graph.getID();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MaxTime", "double", "Length of time the animation should run in seconds."}, {"PixPerUnit", "int", "Pixesl per unit"}, {"FPS", "int", "Frames per second in anmination"}, {"ShowControls", "boolean", "Show controls"}, {"FieldFunction", "String", "Magnetic Field: B(x,t)"}, {"PositionFunction", "String", "The postion of the wire: x(t)"}, {"ShowSchematic", "boolean", "Show the schematic at start up."}, {"ShowGraph", "boolean", "Show the voltage graph: V(t)."}, {"DragMode", "boolean", "Let the user drag the wire."}};
        return stringArray;
    }

    void runBtn_actionPerformed(ActionEvent actionEvent) {
        this.fieldField_actionPerformed(actionEvent);
        this.posField_actionPerformed(actionEvent);
        if (this.clock.isRunning()) {
            this.clock.stopClock();
            this.runBtn.setLabel(this.button_start);
        } else {
            this.clock.startClock();
            this.runBtn.setLabel(this.button_stop);
        }
    }

    public synchronized void setDefault() {
        this.deleteDataConnections();
        this.clock.stopClock();
        this.schematic.setDefault();
        this.uwireExists = false;
        this.runBtn.setLabel(this.button_start);
        this.clock.setTime(0.0);
        this.setPosFunction(null);
        this.showSchematic = true;
        this.schematic.showSchematic = true;
        this.graph.clearSeriesData(1);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public synchronized void reset() {
        this.clock.stopClock();
        this.runBtn.setLabel(this.button_start);
        this.clock.setTime(0.0);
        this.schematic.resetTime();
        this.graph.clearSeriesData(1);
        this.clearAllData();
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    void resetBtn_actionPerformed(ActionEvent actionEvent) {
        this.reset();
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("uwire")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (!this.uwireExists) {
                object = new UWire(this, this.schematic, d);
            } else {
                this.uwireExists = true;
            }
        } else if (string.equals("constraint")) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d3 = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d5 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d4 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d6 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            object = new Constraint((SApplet)this, (SScalable)this.schematic, d3, d4, d5, d6);
        } else if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new FluxBox(this, this.schematic, d, d2, n, n2);
        } else if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new FluxRectangle(this, this.schematic, d, d2, n, n2);
        } else if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new FluxCircle(this, this.schematic, d, d2, n3);
        } else if (string.equals("cursor")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new MarkerThing((SApplet)this, (SScalable)this.schematic, 2 * n3 + 1, d, d2);
        } else if (string.equals("shell")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new FluxShell(this, this.schematic, d, d2, n3);
        } else if (string.equals("arrow")) {
            double d7 = 1.0;
            double d8 = 1.0;
            int n4 = 4;
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d7 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d8 = SUtil.getParam((String)string2, (String)"v=");
            }
            object = new ArrowThing((SApplet)this, (SScalable)this.schematic, n4, d7, d8, d, d2);
        } else if (string.equals("text")) {
            String string4 = "";
            String string5 = null;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            object = new CalcThing(this, this.schematic, string4, string5, d, d2);
        } else if (string.equals("image")) {
            String string6 = " ";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"gif=");
            }
            if (SUtil.parameterExist((String)string2, (String)"file=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"file=");
            }
            if (string6 == null) {
                return 0;
            }
            Image image = Util.getImage((String)string6, (Applet)((Object)this));
            object = image != null ? new ImageThing((SApplet)this, (SScalable)this.schematic, image, d, d2) : null;
        } else if (string.equals("caption")) {
            String string7 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string7 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string7 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            object = new CaptionThing((SApplet)this, (SScalable)this.schematic, string7, d, d2);
        }
        if (object == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return 0;
        }
        this.schematic.addThing((Thing)object);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return object.hashCode();
    }

    public boolean setConstraint(int n, int n2) {
        Thing thing = this.schematic.getThing(n);
        Thing thing2 = this.schematic.getThing(n2);
        if (thing == null) {
            return false;
        }
        if (thing2 == null) {
            return false;
        }
        if (!(thing2 instanceof Constraint)) {
            return false;
        }
        thing.setConstraint((Constraint)thing2);
        return true;
    }

    public synchronized void setAutoRefresh(boolean bl) {
        if (this.autoRefresh == bl) {
            return;
        }
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(bl);
        if (!this.autoRefresh) {
            return;
        }
        this.schematic.invalidateOSI();
        this.schematic.paint();
        this.graph.repaint();
    }

    public void setShowColor(boolean bl) {
        this.schematic.showColor = this.showColor = bl;
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public void setShowGrid(boolean bl) {
        this.schematic.showGrid = this.showGrid = bl;
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public void setShowBOnDrag(boolean bl) {
        this.schematic.showBOnDrag = bl;
    }

    public void setShowCurrentArrow(int n, boolean bl) {
        this.showCurrentArrow = bl;
        this.schematic.setShowCurrentArrow(n, bl);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public boolean setShowCoordinates(int n, boolean bl) {
        if (n == 0 || n == this.schematic.hashCode()) {
            this.schematic.coordDisplay = bl;
            return true;
        }
        return false;
    }

    public void setShowMeter(int n, boolean bl) {
        this.schematic.setShowMeter(n, bl);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public void setDragMode(boolean bl) {
        this.dragMode = bl;
        this.dragBox.setState(this.dragMode);
        this.posField.setEnabled(!bl);
        this.schematic.setDragMode(bl);
    }

    public void setMeterMinMax(double d, double d2) {
        this.schematic.setMeterMinMax(d, d2);
        this.graph.setMinMaxY(d, d2);
        if (this.autoRefresh) {
            this.graph.repaint();
            this.schematic.repaint();
        }
    }

    public void setPixPerUnit(int n) {
        this.schematic.pixPerUnit = this.pixPerUnit = n;
    }

    public void setShowGraph(boolean bl) {
        if (this.graph.isVisible() == bl) {
            return;
        }
        this.showGraph = bl;
        this.schematic.fillApplet = !this.showGraph;
        this.graph.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public synchronized boolean setPosFunction(String string) {
        boolean bl = this.clock.isRunning();
        this.clock.stopClock();
        if (string == null) {
            string = "";
        }
        this.posStr = string;
        this.posField.setText(this.posStr);
        boolean bl2 = this.schematic.parsePosFunction(this.posStr);
        if (bl) {
            this.clock.startClock();
        } else if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return bl2;
    }

    public boolean setTrajectory(int n, String string) {
        Thing thing = this.schematic.getThing(n);
        if (thing == null) {
            return false;
        }
        this.schematic.setDefaultCircuit(thing);
        return this.setPosFunction(string);
    }

    public synchronized void setFieldFunction(String string) {
        boolean bl = this.clock.isRunning();
        this.clock.stopClock();
        this.fieldStr = string;
        this.fieldField.setText(this.fieldStr);
        this.schematic.parseFieldFunction(this.fieldStr);
        if (bl) {
            this.clock.startClock();
        } else if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public void setBScale(double d, double d2) {
        this.schematic.setBScale(d, d2);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
    }

    public void setMaxTime(double d) {
        this.maxTime = d;
        this.clock.setCycle(0.0, this.maxTime);
        this.graph.setMinMaxX(0.0, this.maxTime);
    }

    public void setTimeCycle(double d) {
        this.setTimeInterval(0.0, d);
    }

    public void setTimeInterval(double d, double d2) {
        this.clock.setCycle(d, d2);
        this.schematic.setTime(d);
    }

    public void setTimeContinuous() {
        this.clock.setContinuous();
    }

    public void setTimeOneShot(double d, String string) {
        this.clock.setOneShot(0.0, d);
        this.stopMessage = string;
    }

    protected void stoppingClock() {
        this.schematic.setMessage(this.stopMessage);
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        Thing thing = this.schematic.getThing(n);
        if (thing == null || font == null) {
            return false;
        }
        thing.setFont(font);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return true;
    }

    public boolean setObjectFont(int n, String string, int n2, int n3) {
        return this.setFont(n, string, n2, n3);
    }

    public boolean setFormat(int n, String string) {
        Thing thing = this.schematic.getThing(n);
        if (thing == null && (n == 0 || n == this.schematic.hashCode())) {
            return this.schematic.setFormat(string);
        }
        boolean bl = thing.setFormat(string);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return bl;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.schematic.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return true;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.schematic.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        this.schematic.dragMode = bl;
        return true;
    }

    public boolean setVisibility(int n, boolean bl) {
        if (n == this.getClockID()) {
            this.schematic.showTime = bl;
            if (this.autoRefresh) {
                this.schematic.repaint();
            }
            return true;
        }
        Thing thing = this.schematic.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        return true;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.schematic.getThing(n);
        Thing thing2 = this.schematic.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        this.schematic.invalidateOSI();
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return true;
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        if (n == this.schematic.hashCode()) {
            this.schematic.setBackground(new Color(n2, n3, n4));
            return true;
        }
        Thing thing = this.schematic.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setColor(new Color(n2, n3, n4));
        if (this.autoRefresh) {
            this.schematic.repaint();
        }
        return true;
    }

    void forwardBtn_actionPerformed(ActionEvent actionEvent) {
        this.clock.doStep();
    }

    void posField_actionPerformed(ActionEvent actionEvent) {
        if (this.schematic.parsePosFunction(this.posField.getText())) {
            this.posField.setBackground(Color.white);
        } else {
            this.posField.setBackground(Color.red);
        }
    }

    void fieldField_actionPerformed(ActionEvent actionEvent) {
        if (this.schematic.parseFieldFunction(this.fieldField.getText())) {
            this.fieldField.setBackground(Color.white);
            this.schematic.repaint();
        } else {
            this.fieldField.setBackground(Color.red);
        }
    }

    void dragBox_itemStateChanged(ItemEvent itemEvent) {
        this.schematic.setDragMode(this.dragBox.getState());
        this.reset();
        this.fieldField_actionPerformed(new ActionEvent((Object)this, 0, null));
        this.posField_actionPerformed(new ActionEvent((Object)this, 0, null));
        this.posField.setEnabled(!this.dragBox.getState());
    }
}

