/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import edu.davidson.display.BoxThing;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import faraday.Fluxable;
import faraday.Schematic;
import java.awt.Graphics;

public class FluxBox
extends BoxThing
implements Fluxable {
    Schematic schematic;
    double measurementTime = 0.0;
    double flux = 0.0;
    double volt = 0.0;
    double lastTime = 0.0;
    double lastFlux = 0.0;
    boolean firstDatum = true;
    boolean secondDatum = false;
    boolean showCurrentArrow = true;
    int np = 5;
    double[] readings = new double[this.np];

    public FluxBox(SApplet sApplet, Schematic schematic, double d, double d2, int n, int n2) {
        super(sApplet, (SScalable)schematic, d, d2, n, n2);
        this.schematic = schematic;
        ((Thing)this).varStrings = new String[]{"t", "x", "y", "flux", "v"};
        ((Thing)this).ds = new double[1][5];
        this.doFluxIntegral();
    }

    public void setShowCurrentArrow(boolean bl) {
        this.showCurrentArrow = bl;
    }

    public void reset() {
        this.measurementTime = this.schematic.time;
        this.lastTime = this.schematic.time;
        this.lastFlux = 0.0;
        this.firstDatum = true;
        this.volt = 0.0;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintCurrentArrow(graphics);
    }

    public void paintCurrentArrow(Graphics graphics) {
        if (!this.showCurrentArrow) {
            return;
        }
        if (this.volt == 0.0) {
            return;
        }
        int n = ((Thing)this).canvas.pixFromY(((Thing)this).y) - ((Thing)this).h / 2 - ((Thing)this).yDisplayOff - 15;
        int n2 = ((Thing)this).canvas.pixFromX(((Thing)this).x) + ((Thing)this).yDisplayOff;
        int n3 = n2 - 10;
        int n4 = n2 + 30;
        graphics.drawLine(n3, n, n4, n);
        graphics.drawLine(n3, n + 1, n4, n + 1);
        if (this.volt < 0.0) {
            graphics.drawLine(n4, n, n4 - 5, n - 5);
            graphics.drawLine(n4, n, n4 - 5, n + 5);
            graphics.drawLine(n4, n + 1, n4 - 5, n - 4);
            graphics.drawLine(n4, n + 1, n4 - 5, n + 6);
        } else {
            graphics.drawLine(n3, n, n3 + 5, n - 5);
            graphics.drawLine(n3, n, n3 + 5, n + 5);
            graphics.drawLine(n3, n + 1, n3 + 5, n - 4);
            graphics.drawLine(n3, n + 1, n3 + 5, n + 6);
        }
        graphics.drawString(this.schematic.owner.label_current, n2 - 10, n + 15);
    }

    public double getFlux() {
        return this.flux;
    }

    public double getVolt() {
        return this.volt;
    }

    private double average(double d) {
        if (this.firstDatum) {
            this.lastTime = this.measurementTime;
            this.lastFlux = this.flux;
            this.firstDatum = false;
            this.secondDatum = true;
            return 0.0;
        }
        if (this.secondDatum) {
            for (int i = 0; i < this.np; ++i) {
                this.readings[i] = d;
            }
            this.secondDatum = false;
            return d;
        }
        for (int i = this.np - 1; i > 0; --i) {
            this.readings[i] = this.readings[i - 1];
        }
        this.readings[0] = d;
        double d2 = 0.0;
        for (int i = 0; i < this.np; ++i) {
            d2 += this.readings[i];
        }
        return d2 / (double)this.np;
    }

    private void calcVoltage() {
        if (this.measurementTime == this.lastTime) {
            return;
        }
        double d = -(this.flux - this.lastFlux) / (this.measurementTime - this.lastTime);
        this.lastTime = this.measurementTime;
        this.lastFlux = this.flux;
        this.volt = this.average(d);
    }

    public double doFluxIntegral() {
        int n = Math.max(((Thing)this).w, 100);
        double d = this.schematic.xFromPix(((Thing)this).w) - this.schematic.xFromPix(0);
        double d2 = ((Thing)this).x - d / (double)2;
        d /= (double)n;
        this.flux = 0.0;
        for (int i = 0; i < n; ++i) {
            this.flux += this.schematic.getFieldValue(d2);
            d2 += d;
        }
        this.flux = this.flux * d * (double)((Thing)this).h / (double)this.schematic.pixPerUnit;
        this.measurementTime = this.schematic.time;
        this.calcVoltage();
        return this.flux;
    }

    public final double[][] getVariables() {
        ((Thing)this).ds[0][0] = this.measurementTime;
        ((Thing)this).ds[0][1] = ((Thing)this).x;
        ((Thing)this).ds[0][2] = ((Thing)this).y;
        ((Thing)this).ds[0][3] = this.flux;
        ((Thing)this).ds[0][4] = this.volt;
        return ((Thing)this).ds;
    }
}

