/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.Parser;
import faraday.Faraday;
import faraday.Fluxable;
import faraday.Schematic_mouseAdapter;
import faraday.Schematic_mouseMotionAdapter;
import faraday.UWire;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public class Schematic
extends Panel
implements SScalable {
    private Font f = new Font("Helvetica", 1, 12);
    private String message = null;
    private String[] varStrings = new String[]{"t", "x", "v", "f"};
    private double[][] variables = new double[1][4];
    private Parser posFunc = new Parser(1);
    private Parser checkFunc = new Parser(1);
    private Parser fieldFunc = new Parser(2);
    private boolean explicitTime = true;
    private double zmin = -2.0;
    private double zmax = 2.0;
    private boolean autoscalez = false;
    private boolean backgroundInvalid = true;
    private boolean osiInvalid = true;
    private double[] fieldValues = null;
    private boolean showCurrentArrow = true;
    private boolean showMeter = true;
    boolean showTime = true;
    boolean coordDisplay = true;
    Thing dragThing = null;
    int iwidth = 0;
    int iheight = 0;
    Format format = new Format("%-+6.2f");
    Image backgroundOSI = null;
    Image osi = null;
    boolean fillApplet = false;
    int pixPerUnit = 10;
    boolean showSchematic = true;
    boolean showGrid = true;
    boolean showColor = true;
    boolean showBOnDrag = false;
    private int xOffset = 0;
    private int yOffset = 0;
    private Vector things = new Vector();
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private int boxWidth = 0;
    double metermin = -200.0;
    double metermax = 200.0;
    double time = 0.0;
    boolean dragMode = true;
    private int preferredWidth = 200;
    private int mouseX = 0;
    private int mouseY = 0;
    private boolean mouseDown = false;
    Faraday owner = null;
    private Thing defaultCircuit = null;

    public Schematic(Faraday faraday) {
        this.owner = faraday;
        this.mouseMotionAdapter = new Schematic_mouseMotionAdapter(this);
        this.addMouseMotionListener(this.mouseMotionAdapter);
        this.mouseAdapter = new Schematic_mouseAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.setBackground(new Color(224, 224, 224));
    }

    public void setShowCurrentArrow(boolean bl) {
        this.showCurrentArrow = bl;
        if (this.defaultCircuit != null && this.defaultCircuit instanceof Fluxable) {
            ((Fluxable)this.defaultCircuit).setShowCurrentArrow(bl);
        }
    }

    public void setShowCurrentArrow(int n, boolean bl) {
        Thing thing = this.getThing(n);
        if (thing != null && thing instanceof Fluxable) {
            ((Fluxable)thing).setShowCurrentArrow(bl);
        }
    }

    public void setShowMeter(boolean bl) {
        this.showMeter = bl;
        if (this.defaultCircuit != null && this.defaultCircuit instanceof UWire) {
            ((UWire)this.defaultCircuit).setShowMeter(bl);
        }
    }

    public void setShowMeter(int n, boolean bl) {
        Thing thing = this.getThing(n);
        if (thing != null && thing instanceof UWire) {
            ((UWire)thing).setShowMeter(bl);
        }
    }

    int addThing(Thing thing) {
        this.things.addElement(thing);
        if (this.defaultCircuit == null) {
            this.defaultCircuit = thing;
            if (this.posFunc != null && this.posFunc.getFunctionString() != null && !this.posFunc.getFunctionString().equals("")) {
                thing.setX(this.posFunc.evaluate(this.time));
                thing.updateMySlaves();
                if (thing instanceof Fluxable) {
                    ((Fluxable)thing).doFluxIntegral();
                }
            }
        }
        if (thing instanceof Fluxable) {
            ((Fluxable)thing).setShowCurrentArrow(this.showCurrentArrow);
        }
        if (thing instanceof Fluxable) {
            ((Fluxable)thing).doFluxIntegral();
        }
        if (thing instanceof UWire) {
            ((UWire)thing).setShowMeter(this.showMeter);
        }
        this.osiInvalid = true;
        return thing.hashCode();
    }

    Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    public void update(Graphics graphics) {
        if (this.owner == null || this.owner != null && !this.owner.isClockRunning()) {
            this.paint(graphics);
        }
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getPixWidth() {
        return this.iwidth;
    }

    public int getPixHeight() {
        return this.iheight;
    }

    double getFieldValue(int n) {
        if (this.fieldValues == null) {
            return 0.0;
        }
        if (n < 0 || n >= this.iwidth) {
            double d = this.xFromPix(n);
            return this.fieldFunc.evaluate(d, this.time);
        }
        return this.fieldValues[n];
    }

    double getFieldValue(double d) {
        return this.fieldFunc.evaluate(d, this.time);
    }

    public double xFromPix(int n) {
        return (double)(n - this.xOffset - this.iwidth / 2) / (double)this.pixPerUnit;
    }

    public double yFromPix(int n) {
        return (double)(-(n - this.yOffset - this.iheight / 2)) / (double)this.pixPerUnit;
    }

    public int pixFromX(double d) {
        return (int)(d * (double)this.pixPerUnit + (double)this.xOffset + (double)(this.iwidth / 2));
    }

    public int pixFromY(double d) {
        return (int)(-d * (double)this.pixPerUnit + (double)this.yOffset + (double)(this.iheight / 2));
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getPreferredSize() {
        Applet applet = Util.getApplet((Component)this);
        if (this.fillApplet && applet != null) {
            return new Dimension(applet.getBounds().width - 6, applet.getBounds().height);
        }
        return new Dimension(this.preferredWidth, this.preferredWidth);
    }

    void paint() {
        try {
            Graphics graphics = this.getGraphics();
            this.backgroundInvalid = true;
            this.paint(graphics);
            graphics.dispose();
        }
        catch (Exception exception) {
            this.osiInvalid = true;
            this.backgroundInvalid = true;
        }
    }

    public synchronized void paint(Graphics graphics) {
        try {
            if (!this.showSchematic) {
                super.paint(graphics);
                return;
            }
            if (this.getSize().width <= 2 || this.getSize().height <= 2) {
                return;
            }
            if (this.backgroundOSI == null || this.backgroundInvalid || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
                this.paintBackgroundOSI();
                this.osiInvalid = true;
            }
            if (this.osiInvalid) {
                this.paintOSI();
            }
            graphics.drawImage(this.osi, 0, 0, this);
            this.paintMessage(graphics, this.message);
        }
        catch (Exception exception) {
            this.osiInvalid = true;
            this.backgroundInvalid = true;
        }
    }

    public void paintMessage(Graphics graphics, String string) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iwidth - n + 2, this.iheight - 3);
    }

    public void paintTime() {
        Graphics graphics = this.getGraphics();
        this.paintTime(graphics);
        graphics.dispose();
    }

    public void paintTime(Graphics graphics) {
        if (!this.showTime) {
            return;
        }
        String string = String.valueOf(String.valueOf(this.owner.label_time)).concat(String.valueOf(String.valueOf(this.format.form(this.time))));
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, 15);
    }

    public void paintGrid(Graphics graphics) {
        if (!this.showGrid) {
            return;
        }
        graphics.setColor(Color.gray);
        for (int i = 0; i < 1 + this.iheight / this.pixPerUnit; ++i) {
            for (int j = 0; j < 1 + this.iwidth / this.pixPerUnit; ++j) {
                double d = this.xFromPix(this.pixPerUnit * j);
                double d2 = this.fieldFunc.evaluate(d, this.time);
                if (d2 >= 0.0) {
                    graphics.drawLine(this.pixPerUnit * j, this.pixPerUnit * i, this.pixPerUnit * j, this.pixPerUnit * i);
                    continue;
                }
                graphics.drawLine(this.pixPerUnit * j - 2, this.pixPerUnit * i, this.pixPerUnit * j + 2, this.pixPerUnit * i);
                graphics.drawLine(this.pixPerUnit * j, this.pixPerUnit * i - 2, this.pixPerUnit * j, this.pixPerUnit * i + 2);
            }
        }
        graphics.setColor(Color.black);
    }

    public void paintBackground(Graphics graphics) {
        double d;
        if (this.fieldValues == null) {
            return;
        }
        double d2 = this.xFromPix(0);
        if (this.fieldFunc == null) {
            return;
        }
        this.fieldValues[0] = d = this.fieldFunc.evaluate(d2, this.time);
        double d3 = d;
        double d4 = d;
        for (int i = 1; i < this.iwidth; ++i) {
            d2 = this.xFromPix(i);
            this.fieldValues[i] = d = this.fieldFunc.evaluate(d2, this.time);
            if (d > d3) {
                d3 = d;
            }
            if (!(d < d4)) continue;
            d4 = d;
        }
        if (!this.showColor) {
            graphics.setColor(new Color(223, 223, 223));
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            return;
        }
        if (this.autoscalez) {
            double d5;
            if ((d3 = Math.max(0.0, d3)) == (d4 = Math.min(0.0, d4))) {
                d3 = Math.max(2.0, d3);
                d4 = Math.min(-2.0, d4);
            }
            if ((d5 = d3 - d4) == 0.0) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.iwidth, this.iheight);
                return;
            }
        } else {
            d4 = this.zmin;
            d3 = this.zmax;
        }
        for (int i = 0; i < this.iwidth; ++i) {
            d = this.fieldValues[i];
            d = Math.min(d, d3);
            if ((d = Math.max(d, d4)) > 0.0) {
                d = d3 > -d4 ? (double)255 * d / d3 : (double)-255 * d / d4;
                graphics.setColor(new Color(255, 255 - (int)d, 255 - (int)d));
                graphics.drawLine(i, 0, i, this.iheight);
                continue;
            }
            if (d < 0.0) {
                d = d3 > -d4 ? (double)-255 * d / d3 : (double)255 * d / d4;
                graphics.setColor(new Color(255 - (int)d, 255 - (int)d, 255));
                graphics.drawLine(i, 0, i, this.iheight);
                continue;
            }
            graphics.setColor(Color.white);
            graphics.drawLine(i, 0, i, this.iheight);
        }
        graphics.setColor(Color.black);
    }

    public void paintThings(Graphics graphics) {
        this.owner.lock.getBusyFlag();
        for (int i = 0; i < this.things.size(); ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            thing.paint(graphics);
        }
        this.owner.lock.freeBusyFlag();
    }

    void invalidateOSI() {
        this.osiInvalid = true;
        this.backgroundInvalid = true;
    }

    public void paintOSI() {
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.backgroundInvalid = true;
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        graphics.drawImage(this.osi, 0, 0, this);
        graphics.drawImage(this.backgroundOSI, 0, 0, this);
        this.paintThings(graphics);
        this.paintTime(graphics);
        if (this.mouseDown) {
            this.paintCoords(graphics, this.mouseX, this.mouseY);
        }
        graphics.dispose();
        this.osiInvalid = false;
    }

    public void paintBackgroundOSI() {
        if (this.backgroundOSI == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.backgroundOSI = this.createImage(this.iwidth, this.iheight);
            this.osi = this.createImage(this.iwidth, this.iheight);
            this.fieldValues = new double[this.iwidth];
        }
        Graphics graphics = this.backgroundOSI.getGraphics();
        this.paintBackground(graphics);
        this.paintGrid(graphics);
        graphics.dispose();
        this.updateFlux();
        this.backgroundInvalid = false;
    }

    void setDragMode(boolean bl) {
        this.dragMode = bl;
        if (this.defaultCircuit != null) {
            this.defaultCircuit.setDragable(this.dragMode);
        }
    }

    void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    void setMeterMinMax(double d, double d2) {
        this.metermin = d;
        this.metermax = d2;
        if (this.defaultCircuit != null && this.defaultCircuit instanceof UWire) {
            ((UWire)this.defaultCircuit).meter.min = d;
            ((UWire)this.defaultCircuit).meter.max = d2;
        }
    }

    public void setBScale(double d, double d2) {
        this.zmin = d;
        this.zmax = d2;
        this.backgroundInvalid = true;
    }

    public double step(double d, double d2) {
        this.time = d2 + d;
        if (this.explicitTime) {
            this.backgroundInvalid = true;
        }
        if (!this.dragMode && this.defaultCircuit != null && this.posFunc != null) {
            this.defaultCircuit.setX(this.posFunc.evaluate(this.time));
            this.defaultCircuit.updateMySlaves();
        }
        this.paint();
        double d3 = 0.0;
        if (this.defaultCircuit != null && this.defaultCircuit instanceof Fluxable) {
            d3 = ((Fluxable)this.defaultCircuit).getVolt();
        }
        this.owner.updateDataConnections();
        return d3;
    }

    void setDefaultCircuit(Thing thing) {
        this.defaultCircuit = thing;
        if (thing == null || !(thing instanceof Fluxable)) {
            this.defaultCircuit = null;
            return;
        }
        this.defaultCircuit = thing;
        if (this.posFunc != null && this.posFunc.getFunctionString() != null && !this.posFunc.getFunctionString().equals("")) {
            thing.setX(this.posFunc.evaluate(this.time));
            thing.updateMySlaves();
            ((Fluxable)thing).doFluxIntegral();
        }
    }

    void setDefault() {
        this.time = 0.0;
        this.message = null;
        this.defaultCircuit = null;
        this.things.removeAllElements();
        this.osiInvalid = true;
        this.backgroundInvalid = true;
    }

    void resetTime() {
        this.time = 0.0;
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof Fluxable)) continue;
            ((Fluxable)thing).reset();
            ((Fluxable)thing).doFluxIntegral();
        }
        this.backgroundInvalid = true;
    }

    public void setMessage(String string) {
        this.message = string == null || string.trim().equals("") ? null : string;
        if (this.owner == null || this.owner != null && !this.owner.isClockRunning()) {
            this.osiInvalid = true;
            this.repaint();
        }
    }

    void setTime(double d) {
        this.time = d;
        this.backgroundInvalid = true;
    }

    void checkFieldFunctionForTime(String string) {
        String string2 = new String(string);
        this.checkFunc.defineVariable(1, "x");
        this.checkFunc.define(string2.toLowerCase());
        this.checkFunc.parse();
        if (this.checkFunc.getErrorCode() != 0) {
            this.explicitTime = true;
        }
        this.explicitTime = false;
    }

    boolean parseFieldFunction(String string) {
        this.checkFieldFunctionForTime(string);
        this.fieldFunc.defineVariable(1, "x");
        this.fieldFunc.defineVariable(2, "t");
        this.fieldFunc.define(string.toLowerCase());
        this.fieldFunc.parse();
        if (this.fieldFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse field function, B(x,t): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.fieldFunc.getErrorString()).append(" at B(x,t) function, position ").append(this.fieldFunc.getErrorPosition()))));
            return false;
        }
        if (this.defaultCircuit != null && this.defaultCircuit instanceof Fluxable) {
            ((Fluxable)this.defaultCircuit).reset();
            ((Fluxable)this.defaultCircuit).doFluxIntegral();
        }
        this.osiInvalid = true;
        this.backgroundInvalid = true;
        return true;
    }

    boolean parsePosFunction(String string) {
        if (string == null || string.equals("")) {
            this.posFunc = null;
            return true;
        }
        if (this.posFunc == null) {
            this.posFunc = new Parser(1);
        }
        this.posFunc.defineVariable(1, "t");
        this.posFunc.define(string.toLowerCase());
        this.posFunc.parse();
        if (this.posFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse x(t): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.posFunc.getErrorString()).append(" at x(t) function, charcter ").append(this.posFunc.getErrorPosition()))));
            return false;
        }
        if (this.defaultCircuit != null) {
            if (this.defaultCircuit instanceof Fluxable) {
                ((Fluxable)this.defaultCircuit).reset();
            }
            this.defaultCircuit.setX(this.posFunc.evaluate(this.time));
            this.defaultCircuit.updateMySlaves();
            if (this.defaultCircuit instanceof Fluxable) {
                ((Fluxable)this.defaultCircuit).doFluxIntegral();
            }
        }
        this.osiInvalid = true;
        return true;
    }

    void paintCoords(int n, int n2) {
        if (!this.coordDisplay) {
            return;
        }
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        if (!this.coordDisplay) {
            return;
        }
        double d = (double)(n - this.xOffset - this.iwidth / 2) / (double)this.pixPerUnit;
        double d2 = (double)(-(n2 - this.yOffset - this.iheight / 2)) / (double)this.pixPerUnit;
        String string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append("  y=").append(this.format.form(d2))));
        if (this.showBOnDrag) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("  B=".concat(String.valueOf(String.valueOf(this.format.form(this.fieldFunc.evaluate(d, this.time))))))));
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
    }

    void updateFlux() {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof Fluxable)) continue;
            ((Fluxable)thing).doFluxIntegral();
        }
    }

    Thing isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.isNoDrag() || !thing.isInsideThing(n, n2)) continue;
            return thing;
        }
        return null;
    }

    void schematic_mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.isInsideDragableThing(this.mouseX, this.mouseY) != null) {
            this.dragThing = this.isInsideDragableThing(this.mouseX, this.mouseY);
        }
        this.paintCoords(this.mouseX, this.mouseY);
    }

    void schematic_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.iwidth;
        int n2 = 0;
        if (this.mouseX < n2) {
            this.mouseX = n2;
        } else if (this.mouseX > n - 2) {
            this.mouseX = n - 2;
        }
        double d = this.xFromPix(this.mouseX);
        n2 = 0;
        n = this.iheight;
        if (this.mouseY < n2) {
            this.mouseY = n2;
        } else if (this.mouseY > n - 2) {
            this.mouseY = n - 2;
        }
        double d2 = this.yFromPix(this.mouseY);
        if (this.dragThing != null) {
            this.owner.lock.getBusyFlag();
            this.dragThing.setXY(d, d2);
            this.dragThing.updateMySlaves();
            this.owner.lock.freeBusyFlag();
            if (this.owner == null || this.owner != null && !this.owner.isClockRunning()) {
                if (this.dragThing instanceof Fluxable) {
                    ((Fluxable)this.dragThing).doFluxIntegral();
                }
                this.owner.updateDataConnections();
                this.osiInvalid = true;
                this.paint();
            }
        }
        if (this.owner != null && !this.owner.isClockRunning()) {
            this.paintCoords(this.mouseX, this.mouseY);
        }
    }

    void schematic_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        this.dragThing = null;
        this.boxWidth = 0;
        Rectangle rectangle = this.getBounds();
        if (this.owner == null || this.owner != null && !this.owner.isClockRunning()) {
            this.osiInvalid = true;
            this.repaint();
        }
    }

    public void schematic_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void schematic_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void schematic_mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.isInsideDragableThing(n2, n = mouseEvent.getY()) != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }
}

