/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import faraday.Fluxable;
import faraday.Schematic;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class UWire
extends Thing
implements Fluxable {
    Schematic schematic;
    Meter meter = null;
    double area = 0.0;
    double measurementTime = 0.0;
    double flux = 0.0;
    double volt = 0.0;
    double lastTime = 0.0;
    double lastFlux = 0.0;
    boolean firstDatum = true;
    boolean secondDatum = false;
    boolean showCurrentArrow = true;
    boolean showMeter = true;
    int np = 12;
    double[] readings = new double[this.np];

    public UWire(SApplet sApplet, Schematic schematic, double d) {
        super((SScalable)schematic, d, 0.0);
        this.schematic = schematic;
        this.meter = new Meter();
        this.color = new Color(64, 64, 64);
        this.w = 3;
        this.h = 30;
        int n = (int)((double)this.schematic.iwidth * 0.1) + this.xDisplayOff;
        int n2 = this.canvas.pixFromX(d) + this.xDisplayOff;
        this.area = (double)Math.abs(n2 - n) * ((double)this.schematic.iheight * 0.8) / (double)this.schematic.pixPerUnit / (double)this.schematic.pixPerUnit;
        this.varStrings = new String[]{"t", "x", "y", "flux", "v"};
        this.ds = new double[1][5];
        this.doFluxIntegral();
    }

    public void setShowCurrentArrow(boolean bl) {
        this.showCurrentArrow = bl;
    }

    public void setShowMeter(boolean bl) {
        this.showMeter = bl;
    }

    public void paintCurrentArrow(Graphics graphics) {
        if (!this.showCurrentArrow) {
            return;
        }
        int n = (int)((double)this.schematic.iheight * 0.02) - this.yDisplayOff;
        if (this.volt == 0.0) {
            return;
        }
        int n2 = n + 3;
        int n3 = this.schematic.iwidth / 2 - 10;
        int n4 = this.schematic.iwidth / 2 + 30;
        graphics.drawLine(n3, n2, n4, n2);
        graphics.drawLine(n3, n2 + 1, n4, n2 + 1);
        if (this.volt < 0.0) {
            graphics.drawLine(n4, n2, n4 - 5, n2 - 5);
            graphics.drawLine(n4, n2, n4 - 5, n2 + 5);
            graphics.drawLine(n4, n2 + 1, n4 - 5, n2 - 4);
            graphics.drawLine(n4, n2 + 1, n4 - 5, n2 + 6);
        } else {
            graphics.drawLine(n3, n2, n3 + 5, n2 - 5);
            graphics.drawLine(n3, n2, n3 + 5, n2 + 5);
            graphics.drawLine(n3, n2 + 1, n3 + 5, n2 - 4);
            graphics.drawLine(n3, n2 + 1, n3 + 5, n2 + 6);
        }
        graphics.setColor(Color.darkGray);
        graphics.drawString(this.schematic.owner.label_current, this.schematic.iwidth / 2 - 10, n2 + 12);
        graphics.setColor(Color.black);
    }

    public void paintWire(Graphics graphics) {
        int n = this.canvas.pixFromX(this.x) + this.xDisplayOff;
        int n2 = this.schematic.iheight / 2 - this.yDisplayOff;
        int n3 = n2 - this.h / 2;
        int n4 = n2 + this.h / 2;
        graphics.setColor(this.color);
        for (int i = -this.w; i <= this.w; ++i) {
            graphics.drawLine(n + i, n3, n + i, n4);
        }
        graphics.setColor(new Color(255, 128, 128));
        graphics.fillOval(n - this.w, n3 - this.w / 2, 2 * this.w, this.w);
        graphics.fillOval(n - this.w, n4 - this.w / 2, 2 * this.w, this.w);
        graphics.setColor(Color.black);
        graphics.drawOval(n - this.w, n3 - this.w / 2, 2 * this.w, this.w);
        graphics.drawOval(n - this.w, n4 - this.w / 2, 2 * this.w, this.w);
    }

    public void paintU(Graphics graphics) {
        int n;
        int n2 = (int)((double)this.schematic.iwidth * 0.1) + this.xDisplayOff;
        int n3 = (int)((double)this.schematic.iwidth * 0.9) + this.xDisplayOff;
        int n4 = this.schematic.iheight / 2 - this.yDisplayOff;
        int n5 = n4 - (int)((double)this.schematic.iheight * 0.8) / 2;
        int n6 = n4 + (int)((double)this.schematic.iheight * 0.8) / 2;
        graphics.setColor(Color.black);
        for (n = -this.w; n <= this.w; ++n) {
            graphics.drawLine(n2 + n, n5, n2 + n, n6);
        }
        for (n = -this.w; n <= this.w; ++n) {
            graphics.drawLine(n2 - this.w, n5 + n, n3, n5 + n);
            graphics.drawLine(n2 - this.w, n6 + n, n3, n6 + n);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.h = (int)((double)this.schematic.iheight * 0.9);
        this.paintU(graphics);
        this.paintWire(graphics);
        if (this.showMeter) {
            this.meter.paint(graphics);
        }
        this.paintCurrentArrow(graphics);
    }

    public final boolean isInsideThing(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.x) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.y) - this.yDisplayOff;
        return Math.abs(n - n3) < this.w + 1 && Math.abs(n2 - n4) < this.h / 2 + 1;
    }

    public void setXY(double d, double d2) {
        double d3 = this.canvas.xFromPix((int)((double)this.schematic.iwidth * 0.1) + this.xDisplayOff);
        double d4 = this.canvas.xFromPix((int)((double)this.schematic.iwidth * 0.9) + this.xDisplayOff);
        d = Math.max(d, d3);
        d = Math.min(d, d4);
        super.setXY(d, d2);
    }

    public void setX(double d) {
        if (this.schematic.iwidth != this.schematic.getSize().width) {
            super.setX(d);
            return;
        }
        double d2 = this.canvas.xFromPix((int)((double)this.schematic.iwidth * 0.1 + (double)(2 * this.w)) + this.xDisplayOff);
        double d3 = this.canvas.xFromPix((int)((double)this.schematic.iwidth * 0.9) + this.xDisplayOff);
        d = Math.max(d, d2);
        d = Math.min(d, d3);
        super.setX(d);
    }

    public void reset() {
        this.measurementTime = this.schematic.time;
        this.lastTime = this.schematic.time;
        this.lastFlux = 0.0;
        this.firstDatum = true;
        this.volt = 0.0;
    }

    public double getFlux() {
        return this.flux;
    }

    public double getVolt() {
        return this.volt;
    }

    private double average(double d) {
        if (this.firstDatum) {
            this.lastTime = this.measurementTime;
            this.lastFlux = this.flux;
            this.firstDatum = false;
            this.secondDatum = true;
            return 0.0;
        }
        if (this.secondDatum) {
            for (int i = 0; i < this.np; ++i) {
                this.readings[i] = d;
            }
            this.secondDatum = false;
            return d;
        }
        for (int i = this.np - 1; i > 0; --i) {
            this.readings[i] = this.readings[i - 1];
        }
        this.readings[0] = d;
        double d2 = 0.0;
        for (int i = 0; i < this.np; ++i) {
            d2 += this.readings[i];
        }
        return d2 / (double)this.np;
    }

    private void calcVoltage() {
        if (this.measurementTime == this.lastTime) {
            this.lastFlux = this.flux;
            return;
        }
        double d = -(this.flux - this.lastFlux) / (this.measurementTime - this.lastTime);
        this.lastTime = this.measurementTime;
        this.lastFlux = this.flux;
        this.volt = this.average(d);
    }

    public double doFluxIntegral() {
        int n = Math.max(this.w, 200);
        int n2 = (int)((double)this.schematic.iwidth * 0.1);
        double d = this.schematic.xFromPix(n2);
        double d2 = (this.x - d) / (double)n;
        double d3 = (double)this.schematic.iheight * 0.8 / (double)this.schematic.pixPerUnit;
        this.flux = 0.0;
        for (int i = 0; i < n; ++i) {
            this.flux += this.schematic.getFieldValue(d);
            d += d2;
        }
        this.flux = d2 > 0.0 ? this.flux * d2 * d3 : 0.0;
        this.measurementTime = this.schematic.time;
        this.calcVoltage();
        return this.flux;
    }

    public final double[][] getVariables() {
        this.ds[0][0] = this.measurementTime;
        this.ds[0][1] = this.x;
        this.ds[0][2] = this.y;
        this.ds[0][3] = this.flux;
        this.ds[0][4] = this.volt;
        return this.ds;
    }

    Format getFormat() {
        return this.format;
    }

    public class Meter {
        int r = 20;
        double min = -200.0;
        double max = 200.0;
        int textOffset = 0;
        double sqrt2 = Math.sqrt(2.0);
        Color color = Color.black;
        Font bigFont = new Font("Dialog", 1, 18);

        public Meter() {
            this.min = UWire.this.schematic.metermin;
            this.max = UWire.this.schematic.metermax;
        }

        public void paint(Graphics graphics) {
            int n = (int)((double)UWire.this.schematic.iwidth * 0.1);
            int n2 = UWire.this.schematic.iheight / 2;
            int n3 = n2 + (int)(0.8 * (double)this.r);
            boolean bl = false;
            graphics.setColor(new Color(192, 255, 255));
            graphics.fillOval(n - this.r, n2 - this.r, 2 * this.r, 2 * this.r);
            graphics.setColor(Color.black);
            graphics.drawOval(n - this.r, n2 - this.r, 2 * this.r, 2 * this.r);
            int n4 = this.r - 1;
            graphics.drawLine(n, n3, n - n4, n3 - n4);
            graphics.drawLine(n, n3, n + n4, n3 - n4);
            n4 = (int)((double)n4 * this.sqrt2 - (double)4);
            graphics.setColor(Color.red);
            double d = UWire.this.volt < this.min ? -0.7853981633974483 : (UWire.this.volt > this.max ? 0.7853981633974483 : -0.7853981633974483 + 1.5707963267948966 * (UWire.this.volt - this.min) / (this.max - this.min));
            graphics.drawLine(n, n3, n + (int)((double)n4 * Math.sin(d)), n3 - (int)((double)n4 * Math.cos(d)));
            graphics.drawLine(n - 1, n3, n + (int)((double)n4 * Math.sin(d)) - 1, n3 - (int)((double)n4 * Math.cos(d)));
            Format format = UWire.this.getFormat();
            String string = "".concat(String.valueOf(String.valueOf(format.form(UWire.this.volt))));
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            int n5 = fontMetrics.stringWidth(string) / 2 + 5;
            graphics.setColor(Color.yellow);
            graphics.fillRect(n - n5 + this.textOffset, n3 + 12, 2 * n5, 20);
            graphics.setColor(Color.black);
            graphics.drawString(string, n - (n5 -= 5) + this.textOffset, n3 + 25);
            Font font = graphics.getFont();
            graphics.setFont(this.bigFont);
            graphics.drawString("+", n - 15, n2 - this.r);
            graphics.setFont(font);
        }
    }
}

