/*
 * Decompiled with CFR 0.152.
 */
package soundOut;

import edu.davidson.display.Format;
import edu.davidson.graphics.EtchedBorder;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.PrintGraphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import soundOut.SoundCanvas_this_mouseAdapter;
import soundOut.SoundCanvas_this_mouseMotionAdapter;

public class SoundCanvas
extends Panel {
    private Format mouseFormat = new Format("%-+8.5g");
    private int numPts = 0;
    private int iwidth = 0;
    private int iheight = 0;
    private int[] xPix;
    private int[] yPix;
    private int startDraw;
    private int drawPts;
    private double[] yVec = null;
    private int c1 = 0;
    private int c2 = 0;
    private int c3;
    private boolean noCursors = false;
    private boolean dragC1 = true;
    private ActionListener actionListener = null;
    EtchedBorder bevelPanel1 = new EtchedBorder();

    public void setYVec(double[] dArray) {
        this.yVec = dArray;
        this.numPts = this.yVec != null ? this.yVec.length : 0;
        this.setYVec(dArray, 0, this.numPts - 1);
    }

    public void setYVec(double[] dArray, int n, int n2) {
        this.yVec = dArray;
        if (this.yVec == null) {
            this.numPts = 0;
            this.c1 = 0;
            this.c2 = 0;
            this.yPix = null;
            this.xPix = null;
            return;
        }
        this.numPts = this.yVec.length;
        if (this.xPix == null || this.numPts != this.xPix.length) {
            this.xPix = new int[this.numPts];
            this.yPix = new int[this.numPts];
            this.c1 = this.getSize().width / 2 - 20;
            this.c2 = this.getSize().width / 2 + 20;
            if (this.c1 < 0) {
                this.c1 = 0;
            }
            if (this.c2 > this.numPts - 1) {
                this.c2 = this.numPts - 1;
            }
            this.notifyActionListeners();
        }
        this.startDraw = n;
        this.drawPts = n2 - n + 1;
        if (this.drawPts > this.numPts) {
            this.drawPts = this.numPts;
        }
        this.recalc();
    }

    public void setNoCursors(boolean bl) {
        if (this.noCursors == bl) {
            return;
        }
        this.noCursors = bl;
        this.repaint();
    }

    public boolean isNoCursors() {
        return this.noCursors;
    }

    public double getTimeFromPix(int n) {
        if (n < 0 || n > this.iwidth - 1) {
            return 0.0;
        }
        double d = (double)n / ((double)this.iwidth - 1.0);
        return ((double)this.startDraw + d * ((double)this.drawPts - 1.0)) / 8000.0;
    }

    public void setC1(int n) {
        this.c1 = n;
        this.repaint();
    }

    public int getC1() {
        if (this.noCursors || this.yVec == null || this.iwidth < 2) {
            return 0;
        }
        double d = (double)this.c1 / ((double)this.iwidth - 1.0);
        return (int)(d * (double)(this.numPts - 1));
    }

    public void setC2(int n) {
        this.c2 = n;
        this.repaint();
    }

    public int getC2() {
        if (this.noCursors || this.yVec == null || this.iwidth < 2) {
            return this.numPts;
        }
        double d = (double)this.c2 / ((double)this.iwidth - 1.0);
        return (int)(d * (double)(this.numPts - 1));
    }

    public double getMin(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[1];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public double getMax(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[1];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private void recalc() {
        this.iwidth = this.getSize().width;
        this.iheight = this.getSize().height;
        double d = this.getMin(this.yVec);
        double d2 = this.getMax(this.yVec);
        int n = 5;
        int n2 = this.iheight - 2 * n;
        if (d2 == d) {
            d2 += 0.5;
            d -= 0.5;
        }
        double d3 = 1.0 * (double)this.numPts / (double)this.drawPts;
        for (int i = 0; i < this.drawPts; ++i) {
            this.xPix[i] = (int)(d3 * (double)i * ((double)this.iwidth - 1.0) / ((double)this.numPts - 1.0));
            this.yPix[i] = n + (int)((double)n2 * (d2 - this.yVec[this.startDraw + i]) / (d2 - d));
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.c1 = this.getSize().width / 2 - 20;
            this.c2 = this.getSize().width / 2 + 20;
            if (this.c1 < 0) {
                this.c1 = 0;
            }
            if (this.c2 > this.numPts - 1) {
                this.c2 = this.numPts - 1;
            }
            this.recalc();
            this.notifyActionListeners();
        }
        if (this.noCursors) {
            graphics.setColor(new Color(255, 255, 200));
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            if (graphics instanceof PrintGraphics) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.drawPolyline(this.xPix, this.yPix, this.drawPts);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            graphics.setColor(new Color(255, 255, 200));
            graphics.fillRect(this.c1, 0, this.c2 - this.c1, this.iheight - 1);
            if (graphics instanceof PrintGraphics) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.blue);
            }
            graphics.drawPolyline(this.xPix, this.yPix, this.drawPts);
            graphics.setColor(Color.red);
            graphics.drawLine(this.c1, 0, this.c1, this.iheight - 1);
            graphics.drawLine(this.c2, 0, this.c2, this.iheight - 1);
        }
        graphics.setColor(Color.black);
    }

    public SoundCanvas() {
        try {
            this.numPts = 0;
            this.yVec = null;
            this.xPix = null;
            this.yPix = null;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.addMouseListener(new SoundCanvas_this_mouseAdapter(this));
        this.addMouseMotionListener(new SoundCanvas_this_mouseMotionAdapter(this));
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        if (!this.noCursors) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        double d = this.getTimeFromPix(n);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            String string = String.valueOf(String.valueOf(new StringBuffer("t= ").append(this.mouseFormat.form(d)).append("s")));
            graphics.setColor(Color.yellow);
            int n2 = 15 + fontMetrics.stringWidth("t= +000.00000 s");
            graphics.fillRect(0, this.iheight - 15, n2, 15);
            graphics.setColor(Color.black);
            graphics.drawString(string, 10, this.iheight - 2);
            if (!this.noCursors) {
                graphics.setColor(Color.red);
                graphics.setXORMode(this.getBackground());
                graphics.drawLine(this.c3, 0, this.c3, this.iheight - 1);
                this.c3 = n;
                graphics.drawLine(this.c3, 0, this.c3, this.iheight - 1);
            }
            graphics.dispose();
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if (this.noCursors) {
            return;
        }
        int n = mouseEvent.getX();
        if (Math.abs(n - this.c1) <= Math.abs(n - this.c2)) {
            this.c3 = this.c1;
            this.dragC1 = true;
        } else {
            this.c3 = this.c2;
            this.dragC1 = false;
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        if (this.noCursors) {
            this.repaint();
            return;
        }
        int n = mouseEvent.getX();
        if (this.dragC1) {
            this.c1 = n;
        } else {
            this.c2 = n;
        }
        if (this.c1 > this.c2) {
            int n2 = this.c2;
            this.c2 = this.c1;
            this.c1 = n2;
        }
        if (this.c1 == this.c2) {
            this.c2 = this.c1 + 1;
        }
        if (this.c1 < 0) {
            this.c1 = 0;
        }
        if (this.c1 >= this.iwidth) {
            this.c1 = this.iwidth - 1;
        }
        if (this.c2 < 0) {
            this.c2 = 0;
        }
        if (this.c2 >= this.iwidth) {
            this.c2 = this.iwidth - 1;
        }
        this.repaint();
        this.notifyActionListeners();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void notifyActionListeners() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "CMove");
            this.actionListener.actionPerformed(actionEvent);
        }
    }
}

