/*
 * Decompiled with CFR 0.152.
 */
package soundOut;

import edu.davidson.numerics.Parser;

public class SoundData {
    private int numPts;
    private Parser ampFunc;
    private String ampStr;
    private double[] ampVec;

    public SoundData(int n) {
        this.numPts = n;
        this.ampVec = new double[n];
        this.ampStr = "sin(400*pi*t)";
        this.ampFunc = new Parser(1);
        this.ampFunc.defineVariable(1, "t");
        this.addAmpFunc(this.ampStr);
    }

    public double[] getAmpVec() {
        return this.ampVec;
    }

    public void addAmpFunc(String string) {
        double d = 1.25E-4;
        double d2 = 0.0;
        double d3 = 0.0;
        this.ampStr = string;
        this.ampFunc.define(this.ampStr);
        this.ampFunc.parse();
        if (this.ampFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse amp(t): ".concat(String.valueOf(String.valueOf(this.ampStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.ampFunc.getErrorString()).append(" at function 1, position ").append(this.ampFunc.getErrorPosition()))));
            return;
        }
        int n = 0;
        while (n < this.numPts) {
            d2 = (double)n * d;
            try {
                d3 = this.ampFunc.evaluate(d2);
            }
            catch (Exception exception) {
                d3 = 0.0;
            }
            int n2 = n++;
            this.ampVec[n2] = this.ampVec[n2] + d3;
        }
    }

    public void newAmpFunc(String string) {
        for (int i = 0; i < this.numPts; ++i) {
            this.ampVec[i] = 0.0;
        }
        this.addAmpFunc(string);
    }
}

