/*
 * Decompiled with CFR 0.152.
 */
package soundOut;

import edu.davidson.display.SSlider;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import soundOut.SoundCanvas;
import soundOut.SoundData;
import soundOut.SoundOut_addBtn_actionAdapter;
import soundOut.SoundOut_clearBtn_actionAdapter;
import soundOut.SoundOut_sndCKBox_itemAdapter;
import soundOut.SoundOut_volSlider_adjustmentAdapter;
import soundOut.SoundPlayer;

public class SoundOut
extends SApplet
implements ActionListener {
    Button clearBtn = new Button();
    Button addBtn = new Button();
    Checkbox sndCkBox = new Checkbox();
    EtchedBorder bevelPanel3 = new EtchedBorder();
    Label label1 = new Label();
    TextField funcField = new TextField();
    SoundCanvas sonogram;
    SoundCanvas sonogramDetail;
    SoundPlayer soundPlayer;
    SoundData soundData;
    private int numPts = 8000;
    private String ampFunc = "sin(400*pi*t)+sin(404*pi*t)";
    private boolean showControls = true;
    private double volume = 1.0;
    private boolean mute = true;
    EtchedBorder bevelPanel2 = new EtchedBorder();
    Panel splitPanel1 = new Panel();
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder bevelPanel5 = new EtchedBorder();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    EtchedBorder bevelPanel6 = new EtchedBorder();
    Panel groupBox1 = new Panel();
    SSlider volSlider = new SSlider();
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    Panel groupBox2 = new Panel();
    BorderLayout borderLayout6 = new BorderLayout();
    private boolean oneShot = false;
    GridLayout gridLayout2 = new GridLayout();

    public void init() {
        this.initResources(null);
        try {
            this.numPts = Integer.parseInt(this.getParameter("numPts", "8000"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("showControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ampFunc = this.getParameter("ampFunc", "sin(2*pi*400*t)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.volume = Double.valueOf(this.getParameter("volume", "1.0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.mute = Boolean.valueOf(this.getParameter("mute", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.soundData = new SoundData(this.numPts);
        this.funcField.setText(this.ampFunc);
        this.soundData.newAmpFunc(this.ampFunc);
        this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        this.calc();
        this.soundPlayer.setMute(this.sndCkBox.getState());
    }

    public void jbInit() throws Exception {
        this.bevelPanel2.setLayout(this.borderLayout1);
        this.clearBtn.setActionCommand("ClearSnd");
        this.clearBtn.addActionListener(new SoundOut_clearBtn_actionAdapter(this));
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Component)((Object)this)).setSize(new Dimension(500, 500));
        this.clearBtn.setLabel("New");
        this.addBtn.setActionCommand("AddSnd");
        this.addBtn.addActionListener(new SoundOut_addBtn_actionAdapter(this));
        this.addBtn.setLabel("Add");
        this.sndCkBox.setState(this.mute);
        this.sndCkBox.setLabel("Mute");
        this.sndCkBox.addItemListener(new SoundOut_sndCKBox_itemAdapter(this));
        this.bevelPanel3.setLayout(this.borderLayout4);
        this.label1.setAlignment(1);
        this.label1.setText("f(t)=");
        this.splitPanel1.setBackground(Color.black);
        this.splitPanel1.setLayout(this.gridLayout2);
        this.controlPanel.setLayout(this.borderLayout3);
        this.borderLayout1.setHgap(5);
        this.borderLayout1.setVgap(5);
        this.groupBox1.setLayout(this.gridLayout1);
        this.volSlider.setDValue(this.volume);
        this.volSlider.addAdjustmentListener(new SoundOut_volSlider_adjustmentAdapter(this));
        this.borderLayout5.setHgap(2);
        this.bevelPanel6.setLayout(this.borderLayout5);
        this.bevelPanel5.setLayout(this.borderLayout6);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        this.sonogram = new SoundCanvas();
        this.sonogram.addActionListener(this);
        this.sonogramDetail = new SoundCanvas();
        this.sonogramDetail.setNoCursors(true);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        ((Container)((Object)this)).add(this.splitPanel1, "Center");
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        }
        this.controlPanel.add((Component)this.bevelPanel2, "Center");
        this.bevelPanel2.add((Component)this.bevelPanel5, "West");
        this.bevelPanel5.add((Component)this.groupBox2, "Center");
        this.groupBox2.add((Component)this.addBtn, null);
        this.groupBox2.add((Component)this.clearBtn, null);
        this.bevelPanel2.add((Component)this.bevelPanel6, "East");
        this.bevelPanel6.add((Component)this.sndCkBox, "Center");
        this.bevelPanel2.add((Component)this.groupBox1, "Center");
        this.groupBox1.add((Component)this.volSlider, null);
        this.controlPanel.add((Component)this.bevelPanel3, "North");
        this.bevelPanel3.add((Component)this.label1, "West");
        this.bevelPanel3.add((Component)this.funcField, "Center");
        this.splitPanel1.add((Component)this.sonogram, null);
        this.splitPanel1.add((Component)this.sonogramDetail, null);
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
    }

    public String getAppletInfo() {
        return "SoundOut by Wolfgang Christian. email:wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"numPts", "int", "Number of sample points"}, {"showControls", "boolean", "Show controls."}, {"ampFunc", "String", "Amplitude function"}, {"volume", "double", "Volume"}, {"mute", "boolean", "Mute Sound"}};
        return stringArray;
    }

    public void destroy() {
        this.setMute(true);
        this.soundPlayer.closeStream();
        super.destroy();
    }

    public void stop() {
        this.setMute(true);
        super.stop();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
        }
        this.setRunningID(this);
        super.start();
    }

    void calc() {
        double[] dArray = this.soundData.getAmpVec();
        this.soundPlayer.setYVec(dArray);
        this.sonogram.setYVec(dArray);
        this.sonogramDetail.setYVec(dArray, this.sonogram.getC1(), this.sonogram.getC2());
    }

    void addBtn_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.mute;
        this.ampFunc = this.funcField.getText();
        this.soundData.addAmpFunc(this.ampFunc);
        if (this.oneShot) {
            this.setMute(true);
            this.soundPlayer.closeStream();
            this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        }
        this.calc();
    }

    public void setNumPts(int n) {
        boolean bl = this.mute;
        this.soundPlayer.closeStream();
        this.soundData = new SoundData(this.numPts);
        this.funcField.setText(this.ampFunc);
        this.soundData.newAmpFunc(this.ampFunc);
        this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        this.calc();
    }

    public synchronized void setSound(String string) {
        this.soundData.newAmpFunc(string);
        this.calc();
    }

    public synchronized void addSound(String string) {
        boolean bl = this.mute;
        this.soundData.addAmpFunc(string);
        if (this.oneShot) {
            this.soundPlayer.closeStream();
            this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        }
        this.calc();
    }

    public synchronized void setMute(boolean bl) {
        this.mute = bl;
        this.sndCkBox.setState(this.mute);
        this.soundPlayer.setMute(this.sndCkBox.getState());
    }

    void splitPanel1_actionPerformed(ActionEvent actionEvent) {
        this.sonogram.repaint();
        this.sonogramDetail.repaint();
    }

    void sndCKBox_itemStateChanged(ItemEvent itemEvent) {
        this.soundPlayer.setMute(this.sndCkBox.getState());
    }

    void volSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.soundPlayer.setVolume(this.volSlider.getDValue());
    }

    void clearBtn_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.mute;
        this.ampFunc = this.funcField.getText();
        if (this.oneShot) {
            this.setMute(true);
            this.playOnce(this.ampFunc);
            return;
        }
        this.soundData.newAmpFunc(this.ampFunc);
        this.calc();
    }

    public void playOnce(String string) {
        this.oneShot = true;
        this.ampFunc = string;
        boolean bl = this.mute;
        this.soundPlayer.closeStream();
        this.soundData = new SoundData(this.numPts);
        this.funcField.setText(string);
        this.soundData.newAmpFunc(this.ampFunc);
        this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        this.calc();
    }

    public void playLoop(String string) {
        this.oneShot = false;
        this.ampFunc = string;
        boolean bl = this.mute;
        this.soundPlayer.closeStream();
        this.funcField.setText(string);
        this.soundData.newAmpFunc(this.ampFunc);
        this.soundPlayer = new SoundPlayer(this.numPts, this.oneShot);
        this.calc();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double[] dArray = this.soundData.getAmpVec();
        this.sonogramDetail.setYVec(dArray, this.sonogram.getC1(), this.sonogram.getC2());
    }
}

