/*
 * Decompiled with CFR 0.152.
 */
package soundOut;

import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class SoundPlayer {
    private InputStream soundStream;
    private boolean mute = true;
    private byte[] sound = null;
    private double volume = 1.0;
    private double[] yVec;

    public SoundPlayer() {
        this(100, false);
    }

    public SoundPlayer(int n, boolean bl) {
        this.sound = new byte[n];
        this.soundStream = bl ? new AudioDataStream(new AudioData(this.sound)) : new ContinuousAudioDataStream(new AudioData(this.sound));
    }

    public void setYVec(double[] dArray) {
        this.yVec = dArray;
        this.calcSound();
    }

    public void closeStream() {
        try {
            this.soundStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void calcSound() {
        double d = 0.0;
        if (!this.mute) {
            AudioPlayer.player.stop(this.soundStream);
        }
        int n = this.yVec.length;
        if (this.sound == null || n != this.sound.length) {
            this.sound = new byte[n];
            this.soundStream = new ContinuousAudioDataStream(new AudioData(this.sound));
        }
        for (int i = 0; i < n; ++i) {
            d = this.volume * (double)8160 * this.yVec[i];
            this.sound[i] = SoundPlayer.int2ulaw((int)d);
        }
        if (!this.mute) {
            AudioPlayer.player.start(this.soundStream);
        }
    }

    public void setVolume(double d) {
        this.volume = d;
        this.calcSound();
    }

    public double getVolume() {
        return this.volume;
    }

    public void setMute(boolean bl) {
        this.mute = bl;
        if (this.mute) {
            AudioPlayer.player.stop(this.soundStream);
        } else {
            AudioPlayer.player.start(this.soundStream);
        }
    }

    public static byte int2ulaw(int n) {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 127;
        } else {
            n2 = 255;
        }
        n = n < 32 ? 0xF0 | 15 - n / 2 : (n < 96 ? 0xE0 | 15 - (n - 32) / 4 : (n < 224 ? 0xD0 | 15 - (n - 96) / 8 : (n < 480 ? 0xC0 | 15 - (n - 224) / 16 : (n < 992 ? 0xB0 | 15 - (n - 480) / 32 : (n < 2016 ? 0xA0 | 15 - (n - 992) / 64 : (n < 4064 ? 0x90 | 15 - (n - 2016) / 128 : (n < 8160 ? 0x80 | 15 - (n - 4064) / 256 : 128)))))));
        return (byte)(n2 & n);
    }
}

