/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import wave3d.ThreeDPanel;

public class Figure {
    public int numLines = 0;
    double[][] pts = null;
    Color color = Color.blue;
    String figType = "line";
    double pixPerUnit;
    boolean visible = true;
    double wavelength = 200.0;
    double speed = 5.0;
    Font font = new Font("Monospaced", 1, 16);
    double polarization = 0.0;
    ThreeDPanel threeDPanel;
    int lineDensity;
    double xyFactor = 1.0;

    public Figure(ThreeDPanel threeDPanel) {
        this.threeDPanel = threeDPanel;
        this.lineDensity = threeDPanel.lineDensity;
    }

    public int getID() {
        return this.hashCode();
    }

    public void translate(double d, double d2) {
    }

    public void setWavelength(double d) {
        this.wavelength = d;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public double getPtsValue(int n, int n2) {
        if (n2 == 0 || n2 == 1) {
            return this.xyFactor * this.pts[n][n2];
        }
        return this.pts[n][n2];
    }

    public int getNumPts() {
        return 2 * this.numLines;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public void setZ(double d) {
    }

    public void setPolarization(double d) {
        this.polarization = d;
    }

    public void drawFigure(Graphics graphics, double[][] dArray) {
        graphics.setColor(this.color);
        for (int i = 0; i < this.getNumPts(); ++i) {
            graphics.drawLine((int)Math.round(dArray[0][0] * this.getPtsValue(i, 0) + dArray[0][1] * this.getPtsValue(i, 1) + dArray[0][2] * this.getPtsValue(i, 2)), (int)Math.round(dArray[1][0] * this.getPtsValue(i, 0) + dArray[1][1] * this.getPtsValue(i, 1) + dArray[1][2] * this.getPtsValue(i, 2)), (int)Math.round(dArray[0][0] * this.getPtsValue(++i, 0) + dArray[0][1] * this.getPtsValue(i, 1) + dArray[0][2] * this.getPtsValue(i, 2)), (int)Math.round(dArray[1][0] * this.getPtsValue(i, 0) + dArray[1][1] * this.getPtsValue(i, 1) + dArray[1][2] * this.getPtsValue(i, 2)));
        }
    }
}

