/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import java.awt.Color;
import wave3d.ThreeDPanel;
import wave3d.Wave;

public class LinearWave
extends Wave {
    public LinearWave(ThreeDPanel threeDPanel, double d, double d2, double d3, double d4, double d5, Color color) {
        super(threeDPanel);
        this.zPropagate = d;
        this.zTerminate = d2;
        this.amplitude = d3;
        this.phase = d4;
        this.polarization = d5;
        this.length = this.zTerminate - this.zPropagate;
        this.numLines = (int)Math.round(this.length / (double)threeDPanel.lineDensity);
        this.pts = new double[2 * this.numLines][3];
        this.color = color;
        int n = 1;
        int n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = Math.cos(this.polarization) * this.amplitude * Math.sin((double)n2 * this.h + this.phase);
            this.pts[n][1] = Math.sin(this.polarization) * this.amplitude * Math.sin((double)n2 * this.h + this.phase);
            this.pts[n][2] = (double)(n2 * threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = 0.0;
            this.pts[n][1] = 0.0;
            this.pts[n][2] = (double)(n2 * threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
    }

    public void setFirstStick(int n, int n2) {
        this.pts[0][0] = 0.0;
        this.pts[0][1] = 0.0;
        this.pts[0][2] = this.zPropagate + (double)n2;
        this.pts[1][0] = Math.cos(this.polarization) * this.amplitude * Math.sin((double)n * this.h + this.phase);
        this.pts[1][1] = Math.sin(this.polarization) * this.amplitude * Math.sin((double)n * this.h + this.phase);
        this.pts[1][2] = this.zPropagate + (double)n2;
    }
}

