/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import wave3d.Figure;
import wave3d.Text;

public class ThreeDPanel
extends Panel {
    double theta;
    double alpha;
    double phi;
    double[][] trans = new double[2][3];
    Vector figs = new Vector();
    Image osi = null;
    int iwidth;
    int iheight;
    int xOrigin;
    int yOrigin;
    int lineDensity = 6;
    String message = "";

    public void setOrigin(int n, int n2) {
        this.xOrigin = n;
        this.yOrigin = n2;
    }

    public Figure getThing(int n) {
        Enumeration enumeration = this.figs.elements();
        while (enumeration.hasMoreElements()) {
            Figure figure = (Figure)enumeration.nextElement();
            if (figure.hashCode() != n) continue;
            return figure;
        }
        return null;
    }

    public void setIsometric() {
        this.trans[0][0] = (double)-1 / Math.sqrt(2.0);
        this.trans[0][1] = -this.trans[0][0];
        this.trans[0][2] = 0.0;
        this.trans[1][0] = (double)-1 / Math.sqrt(6.0);
        this.trans[1][1] = this.trans[1][0];
        this.trans[1][2] = (double)-2 * this.trans[1][0];
        this.repaint();
    }

    public void transformMatrix() {
        this.trans[0][0] = Math.cos(this.alpha) * Math.cos(this.theta);
        this.trans[0][1] = -(-Math.cos(this.alpha) * Math.sin(this.theta));
        this.trans[0][2] = -Math.sin(this.alpha);
        this.trans[1][0] = -Math.cos(this.theta) * Math.sin(this.alpha) * Math.sin(this.phi) + Math.cos(this.phi) * Math.sin(this.theta);
        this.trans[1][1] = -(Math.cos(this.phi) * Math.cos(this.theta) + Math.sin(this.alpha) * Math.sin(this.phi) * Math.sin(this.theta));
        this.trans[1][2] = -Math.cos(this.alpha) * Math.sin(this.phi);
    }

    public void addFigure(Figure figure) {
        this.figs.addElement(figure);
    }

    public boolean deleteObject(int n) {
        Figure figure = this.getThing(n);
        if (figure == null) {
            return false;
        }
        this.figs.removeElement(figure);
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.osi == null || rectangle.width != this.iwidth || rectangle.height != this.iheight) {
            this.iheight = rectangle.height;
            this.iwidth = rectangle.width;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        Graphics graphics2 = this.osi.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        for (int i = 0; i < this.figs.size(); ++i) {
            Figure figure = (Figure)this.figs.elementAt(i);
            if (!figure.visible) continue;
            if (!(figure instanceof Text)) {
                graphics2.translate(this.xOrigin, this.yOrigin);
            }
            figure.drawFigure(graphics2, this.trans);
            if (figure instanceof Text) continue;
            graphics2.translate(-this.xOrigin, -this.yOrigin);
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
        this.paintMessage(graphics);
    }

    void paintMessage(Graphics graphics) {
        if (this.message == null || this.message.equals("")) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(this.message);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.message, this.iwidth - n + 2, this.iheight - 3);
        graphics.drawRect(this.iwidth - n - 5, this.iheight - 16, n, 15);
    }

    public void translate(double d, double d2) {
        for (int i = 0; i < this.figs.size(); ++i) {
            Figure figure = (Figure)this.figs.elementAt(i);
            figure.translate(d, d2);
        }
        this.repaint();
    }

    public void setMessage(String string) {
        if (string == null) {
            this.message = "";
        }
        this.message = string;
        this.repaint();
    }

    public void setAngles(double d, double d2, double d3) {
        this.theta = d;
        this.alpha = d2;
        this.phi = d3;
        this.transformMatrix();
        this.repaint();
    }

    private final void drawLabel(Graphics graphics) {
        Figure figure = (Figure)this.figs.elementAt(0);
        graphics.setFont(new Font("SansSerif", 1, 14));
        graphics.drawString("x", (int)Math.round(this.trans[0][0] * figure.getPtsValue(1, 0) + this.trans[0][1] * figure.getPtsValue(1, 1) + this.trans[0][2] * figure.getPtsValue(1, 2)), (int)Math.round(this.trans[1][0] * figure.getPtsValue(1, 0) + this.trans[1][1] * figure.getPtsValue(1, 1) + this.trans[1][2] * figure.getPtsValue(1, 2)));
        graphics.drawString("y", (int)Math.round(this.trans[0][0] * figure.getPtsValue(3, 0) + this.trans[0][1] * figure.getPtsValue(3, 1) + this.trans[0][2] * figure.getPtsValue(3, 2)), (int)Math.round(this.trans[1][0] * figure.getPtsValue(3, 0) + this.trans[1][1] * figure.getPtsValue(3, 1) + this.trans[1][2] * figure.getPtsValue(3, 2)));
        graphics.drawString("z", (int)Math.round(this.trans[0][0] * figure.getPtsValue(5, 0) + this.trans[0][1] * figure.getPtsValue(5, 1) + this.trans[0][2] * figure.getPtsValue(5, 2)), (int)Math.round(this.trans[1][0] * figure.getPtsValue(5, 0) + this.trans[1][1] * figure.getPtsValue(5, 1) + this.trans[1][2] * figure.getPtsValue(5, 2)));
    }

    public boolean registrationCheck(Object object) {
        Object object2 = object;
        boolean bl = this.figs.contains(object2);
        return bl;
    }

    public void setTheta(double d) {
        this.theta = d;
        this.transformMatrix();
        this.repaint();
    }

    public void setAlpha(double d) {
        this.alpha = d;
        this.transformMatrix();
        this.repaint();
    }

    public void setPhi(double d) {
        this.phi = d;
        this.transformMatrix();
        this.repaint();
    }

    public void clear() {
        this.figs.removeAllElements();
    }
}

