/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import java.awt.Color;
import wave3d.Figure;
import wave3d.ThreeDPanel;

public class Wave
extends Figure {
    double h;
    int incrementer = 0;
    double zPropagate = -100.0;
    double zTerminate = 100.0;
    double length;
    double amplitude = 100.0;
    double phase = 0.0;
    int translation = 2;
    int zOnDeck = 0;
    int zRelative = 0;
    int offset = 0;

    public Wave(ThreeDPanel threeDPanel) {
        super(threeDPanel);
        this.lineDensity = threeDPanel.lineDensity;
        this.length = this.zTerminate - this.zPropagate;
        this.numLines = (int)Math.round(this.length / (double)threeDPanel.lineDensity);
        this.pts = new double[2 * this.numLines][3];
        this.h = this.length / this.wavelength * (double)2 * Math.PI / (double)this.numLines;
        this.color = Color.blue;
        this.figType = "line";
    }

    public void setWavelength(double d) {
        this.wavelength = d;
        this.h = this.length * (double)2 * Math.PI / this.wavelength / (double)(this.numLines - 1);
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public void translate(double d, double d2) {
        int n;
        d = d * this.speed / (double)5;
        for (n = 0; n < 2 * this.numLines; ++n) {
            double[] dArray = this.pts[n];
            dArray[2] = dArray[2] + d;
        }
        this.zOnDeck = (int)((double)this.zOnDeck + d);
        this.zRelative = this.zOnDeck / this.lineDensity;
        if (this.zRelative >= 1) {
            this.offset = this.zOnDeck % this.lineDensity;
            for (n = 0; n < this.zRelative; ++n) {
                for (int i = 2 * this.numLines - 1; i > 1; --i) {
                    this.pts[i][0] = this.pts[i - 2][0];
                    this.pts[i][1] = this.pts[i - 2][1];
                    this.pts[i][2] = this.pts[i - 2][2];
                }
                --this.incrementer;
                this.setFirstStick(this.incrementer, this.lineDensity * (this.zRelative - n - 1) + this.offset);
            }
            this.zOnDeck = this.offset;
        }
    }

    public void setFirstStick(int n, int n2) {
    }

    public void setPolarization(double d) {
        this.polarization = d;
        int n = 1;
        int n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = Math.cos(this.polarization) * this.amplitude * Math.sin((double)this.incrementer * this.h + (double)n2 * this.h + this.phase);
            this.pts[n][1] = Math.sin(this.polarization) * this.amplitude * Math.sin((double)this.incrementer * this.h + (double)n2 * this.h + this.phase);
            this.pts[n][2] = (double)(n2 * this.threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = 0.0;
            this.pts[n][1] = 0.0;
            this.pts[n][2] = (double)(n2 * this.threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
    }
}

