/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import edu.davidson.display.SSlider;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import wave3d.AxesLabel;
import wave3d.Axis3D;
import wave3d.Box3D;
import wave3d.CircularWaveLeft;
import wave3d.CircularWaveRight;
import wave3d.Figure;
import wave3d.FilledRectangle;
import wave3d.FilledSquare;
import wave3d.Grid;
import wave3d.LinearWave;
import wave3d.Rectangle2D;
import wave3d.Square;
import wave3d.Text;
import wave3d.ThreeDPanel;
import wave3d.VerticalFlowLayout;
import wave3d.Wave3d_this_componentAdapter;
import wave3d.Wave3d_threeDView_mouseMotionAdapter;
import wave3d.Wavefunction;

public class Wave3d
extends SApplet
implements SStepable {
    boolean isStandalone = false;
    Color color = Color.black;
    boolean showControls = true;
    int pixPerUnit = 10;
    double rotateZAxis = 0.0;
    double rotateYAxis = 0.0;
    double rotateXAxis = 0.0;
    int xPrevious;
    int yPrevious;
    boolean rotate = true;
    int orientation = 1;
    int fps = 20;
    double dz;
    ThreeDPanel threeDView = new ThreeDPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    EtchedBorder sliderPanel = new EtchedBorder();
    Panel panel1 = new Panel();
    SSlider alpha = new SSlider();
    BorderLayout borderLayout2 = new BorderLayout();
    Panel panel2 = new Panel();
    Panel panel3 = new Panel();
    SSlider theta = new SSlider();
    SSlider phi = new SSlider();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    SPanel panel4 = new SPanel();
    Label label2 = new Label();
    SPanel panel5 = new SPanel();
    SPanel panel6 = new SPanel();
    Label label3 = new Label();
    Label label1 = new Label();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    boolean fixedAlpha = false;
    boolean fixedTheta = false;
    boolean fixedPhi = false;

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.orientation = Integer.parseInt(this.getParameter("Orientation", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "20"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dz = (double)this.pixPerUnit * Double.valueOf(this.getParameter("Dz", ".2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sliderPanel.setVisible(this.showControls);
        if (this.orientation == 0) {
            this.rotateZAxis = 0.7853981633974483;
            this.rotateYAxis = 0.0;
            this.rotateXAxis = 0.7853981633974483;
            this.threeDView.setAngles(this.rotateZAxis, this.rotateYAxis, this.rotateXAxis);
        }
        if (this.orientation == 1) {
            this.rotateZAxis = 0.7853981633974483;
            this.rotateYAxis = 0.7853981633974483;
            this.rotateXAxis = 0.0;
            this.threeDView.setAngles(this.rotateZAxis, this.rotateYAxis, this.rotateXAxis);
        }
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.white);
        ((Component)((Object)this)).setSize(new Dimension(600, 650));
        ((Component)((Object)this)).addComponentListener(new Wave3d_this_componentAdapter(this));
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.sliderPanel.setLayout(this.verticalFlowLayout1);
        this.sliderPanel.setLocale(Locale.getDefault());
        this.sliderPanel.setThickness(1);
        this.alpha.setDMax(6.28);
        this.alpha.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Wave3d.this.alpha_adjustmentValueChanged(adjustmentEvent);
            }
        });
        this.alpha.setDValue(this.rotateYAxis);
        this.alpha.setDMin(0.0);
        this.panel1.setLayout(this.borderLayout2);
        this.theta.setDMax(6.28);
        this.theta.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Wave3d.this.theta_adjustmentValueChanged(adjustmentEvent);
            }
        });
        this.theta.setDValue(this.rotateZAxis);
        this.theta.setDMin(0.0);
        this.phi.setDMax(6.28);
        this.phi.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Wave3d.this.phi_adjustmentValueChanged(adjustmentEvent);
            }
        });
        this.phi.setDValue(this.rotateXAxis);
        this.phi.setDMin(0.0);
        this.panel3.setLayout(this.borderLayout3);
        this.panel2.setLayout(this.borderLayout4);
        this.label2.setText("theta = ");
        this.label2.setAlignment(2);
        this.label3.setText("  phi = ");
        this.label3.setAlignment(2);
        this.label1.setAlignment(2);
        this.label1.setText("alpha = ");
        this.panel4.setMinimumSize(new Dimension(50, 20));
        this.panel4.setPreferredSize(new Dimension(50, 20));
        this.panel4.setLayout(this.borderLayout5);
        this.panel5.setMinimumSize(new Dimension(50, 20));
        this.panel5.setPreferredSize(new Dimension(50, 20));
        this.panel5.setLayout(this.borderLayout6);
        this.panel6.setMinimumSize(new Dimension(50, 20));
        this.panel6.setPreferredSize(new Dimension(50, 20));
        this.panel6.setLayout(this.borderLayout7);
        ((Container)((Object)this)).add(this.threeDView, "Center");
        ((Container)((Object)this)).add((Component)this.sliderPanel, "South");
        this.sliderPanel.add((Component)this.panel3, null);
        this.panel3.add((Component)this.theta, "Center");
        this.panel3.add((Component)this.panel4, "West");
        this.panel4.add((Component)this.label2, "Center");
        this.sliderPanel.add((Component)this.panel2, null);
        this.panel2.add((Component)this.phi, "Center");
        this.panel2.add((Component)this.panel5, "West");
        this.panel5.add((Component)this.label3, "West");
        this.sliderPanel.add((Component)this.panel1, null);
        this.panel1.add((Component)this.alpha, "Center");
        this.panel1.add((Component)this.panel6, "West");
        this.panel6.add((Component)this.label1, "West");
        this.clock.setFPS((double)this.fps);
        this.clock.setDt(1.0 / (double)this.fps);
        this.clock.addClockListener((SStepable)this);
        this.threeDView.setBackground(Color.white);
        this.threeDView.addMouseMotionListener(new Wave3d_threeDView_mouseMotionAdapter(this));
    }

    public String getAppletInfo() {
        return "Wave3d animates wave motion along the z axis.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", "Show sliders"}, {"Orientation", "int", "orientation of figure"}, {"FPS", "int", "frames per second"}, {"Dz", "double", "translation distance of wave"}};
        return stringArray;
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
        }
        this.threeDView.setOrigin(((Component)((Object)this)).getSize().width / 2, ((Component)((Object)this)).getSize().height / 2);
        this.threeDView.paint();
    }

    public void forward() {
        this.threeDView.paint();
        this.oneShotMsg = "";
        this.clock.startClock();
    }

    public void stop() {
        this.clock.stopClock();
    }

    public void pause() {
        this.clock.stopClock();
    }

    public void destroy() {
        super.destroy();
    }

    public void step(double d, double d2) {
        this.threeDView.translate(this.dz, (double)this.fps * d2);
    }

    public void setFixedTheta(boolean bl) {
        this.fixedTheta = bl;
    }

    public void setFixedAlpha(boolean bl) {
        this.fixedAlpha = bl;
    }

    public void setFixedPhi(boolean bl) {
        this.fixedPhi = bl;
    }

    public boolean setAngles(double d, double d2, double d3) {
        this.rotateZAxis = d;
        this.rotateYAxis = d2;
        this.rotateXAxis = d3;
        this.threeDView.setAngles(this.rotateZAxis, this.rotateYAxis, this.rotateXAxis);
        return true;
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
    }

    public boolean setWavelength(int n, double d) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.setWavelength(d * (double)this.pixPerUnit);
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public boolean setWaveSpeed(int n, double d) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.setSpeed(d);
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.font = font;
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public void setLineDensity(int n) {
        this.threeDView.lineDensity = n;
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        if (n == 0 || n == this.threeDView.hashCode()) {
            this.threeDView.setBackground(new Color(n2, n3, n4));
            return true;
        }
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.color = new Color(n2, n3, n4);
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public void setShapeRGB(int n, int n2, int n3) {
        this.color = new Color(n, n2, n3);
    }

    public boolean setVisibility(int n, boolean bl) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.visible = bl;
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public boolean setZ(int n, double d) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        figure.setZ(d * (double)this.pixPerUnit);
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public void setOneShot(double d, double d2, String string) {
        this.clock.setOneShot(d, d2);
        this.clock.setTime(d);
        this.oneShotMsg = string;
    }

    public void setMessage(String string) {
        this.threeDView.setMessage(string);
    }

    public void stoppingClock() {
        this.threeDView.setMessage(this.oneShotMsg);
    }

    public boolean setPolarization(int n, double d) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        boolean bl = this.clock.isRunning();
        if (bl) {
            this.clock.stopClock();
        }
        figure.setPolarization(d);
        if (bl) {
            this.clock.startClock();
        } else if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public boolean setXYFactor(int n, double d) {
        Figure figure = this.threeDView.getThing(n);
        if (figure == null) {
            return false;
        }
        boolean bl = this.clock.isRunning();
        if (bl) {
            this.clock.stopClock();
        }
        figure.xyFactor = d;
        if (bl) {
            this.clock.startClock();
        } else if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return true;
    }

    public boolean deleteObject(int n) {
        boolean bl = this.threeDView.deleteObject(n);
        if (this.autoRefresh) {
            this.threeDView.repaint();
        }
        return bl;
    }

    public int addText(String string, int n, int n2) {
        Text text = new Text(this.threeDView, string, n, n2);
        this.threeDView.addFigure(text);
        return text.getID();
    }

    public int addAxes(double d, double d2, double d3, double d4) {
        Axis3D axis3D = new Axis3D(this.threeDView, (int)(d * (double)this.pixPerUnit), (int)(d2 * (double)this.pixPerUnit), (int)(d3 * (double)this.pixPerUnit), d4 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(axis3D);
        AxesLabel axesLabel = new AxesLabel(this.threeDView, (int)d * this.pixPerUnit, (int)d2 * this.pixPerUnit, (int)(d3 * (double)this.pixPerUnit), d4 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(axesLabel);
        return axis3D.getID();
    }

    public int addSquare(double d, double d2) {
        Square square = new Square(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(square);
        return square.getID();
    }

    public int addRectangle(double d, double d2, double d3) {
        Rectangle2D rectangle2D = new Rectangle2D(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(rectangle2D);
        return rectangle2D.getID();
    }

    public int addBox(double d, double d2, double d3) {
        Box3D box3D = new Box3D(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit);
        this.threeDView.addFigure(box3D);
        return box3D.getID();
    }

    public int addFilledSquare(double d, double d2) {
        FilledSquare filledSquare = new FilledSquare(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(filledSquare);
        return filledSquare.getID();
    }

    public int addFilledRectangle(double d, double d2, double d3) {
        FilledRectangle filledRectangle = new FilledRectangle(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, this.color);
        this.threeDView.addFigure(filledRectangle);
        return filledRectangle.getID();
    }

    public int addLinear(double d, double d2, double d3, double d4, double d5) {
        LinearWave linearWave = new LinearWave(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, d4, d5, this.color);
        this.threeDView.addFigure(linearWave);
        return linearWave.getID();
    }

    public int addCircularRight(double d, double d2, double d3, double d4) {
        CircularWaveRight circularWaveRight = new CircularWaveRight(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, d4, this.color);
        this.threeDView.addFigure(circularWaveRight);
        return circularWaveRight.getID();
    }

    public int addCircularLeft(double d, double d2, double d3, double d4) {
        CircularWaveLeft circularWaveLeft = new CircularWaveLeft(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, d4, this.color);
        this.threeDView.addFigure(circularWaveLeft);
        return circularWaveLeft.getID();
    }

    public int addGrid(double d, double d2, double d3, double d4) {
        Grid grid = new Grid(this.threeDView, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, d3 * (double)this.pixPerUnit, d4, this.color);
        this.threeDView.addFigure(grid);
        return grid.getID();
    }

    public int addWavefunction(String string, double d, double d2, double d3) {
        Wavefunction wavefunction = new Wavefunction(this.threeDView, string, d * (double)this.pixPerUnit, d2 * (double)this.pixPerUnit, this.pixPerUnit, d3, this.color);
        this.threeDView.addFigure(wavefunction);
        return wavefunction.getID();
    }

    public void deleteAll() {
        this.threeDView.clear();
    }

    public void setDefault() {
        this.clock.stopClock();
        super.deleteDataConnections();
        this.clock.setContinuous();
        this.oneShotMsg = "";
        this.threeDView.clear();
        this.clock.setTime(0.0);
    }

    void theta_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.threeDView.setTheta(this.theta.getDValue());
    }

    void alpha_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.threeDView.setAlpha(this.alpha.getDValue());
    }

    void phi_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.threeDView.setPhi(this.phi.getDValue());
    }

    void threeDView_mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.orientation == 0) {
            this.threeDView.setAlpha(0.0);
            if (n < this.xPrevious && !this.fixedTheta) {
                this.threeDView.setTheta(this.rotateZAxis += 0.08);
            }
            if (n > this.xPrevious && !this.fixedTheta) {
                this.threeDView.setTheta(this.rotateZAxis -= 0.08);
            }
            if (n2 < this.yPrevious && this.rotateXAxis <= 1.5 && !this.fixedPhi) {
                this.threeDView.setPhi(this.rotateXAxis += 0.08);
            }
            if (n2 > this.yPrevious && this.rotateXAxis >= 0.0 && !this.fixedPhi) {
                this.threeDView.setPhi(this.rotateXAxis -= 0.08);
            }
        }
        if (this.orientation == 1) {
            this.threeDView.setPhi(0.0);
            if (n2 < this.yPrevious) {
                if (this.rotateYAxis > 0.0) {
                    if (!this.fixedTheta) {
                        this.threeDView.setTheta(this.rotateZAxis -= 0.08);
                    }
                } else if (!this.fixedTheta) {
                    this.threeDView.setTheta(this.rotateZAxis += 0.08);
                }
            }
            if (n2 > this.yPrevious) {
                if (this.rotateYAxis > 0.0) {
                    if (!this.fixedTheta) {
                        this.threeDView.setTheta(this.rotateZAxis += 0.08);
                    }
                } else if (!this.fixedTheta) {
                    this.threeDView.setTheta(this.rotateZAxis -= 0.08);
                }
            }
            if (n < this.xPrevious && this.rotateYAxis <= 1.5707963267948966 && !this.fixedAlpha) {
                this.threeDView.setAlpha(this.rotateYAxis += 0.08);
            }
            if (n > this.xPrevious && this.rotateYAxis >= -1.5707963267948966 && !this.fixedAlpha) {
                this.threeDView.setAlpha(this.rotateYAxis -= 0.08);
            }
        }
        this.xPrevious = n;
        this.yPrevious = n2;
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.threeDView.setOrigin(((Component)((Object)this)).getSize().width / 2, ((Component)((Object)this)).getSize().height / 2);
    }
}

