/*
 * Decompiled with CFR 0.152.
 */
package wave3d;

import edu.davidson.numerics.Parser;
import java.awt.Color;
import wave3d.ThreeDPanel;
import wave3d.Wave;

public class Wavefunction
extends Wave {
    Parser parser;

    public Wavefunction(ThreeDPanel threeDPanel, String string, double d, double d2, double d3, double d4, Color color) {
        super(threeDPanel);
        this.zPropagate = d;
        this.zTerminate = d2;
        this.pixPerUnit = d3;
        this.polarization = d4;
        this.length = this.zTerminate - this.zPropagate;
        this.numLines = (int)Math.round(this.length / (double)threeDPanel.lineDensity);
        this.pts = new double[2 * this.numLines][3];
        this.h = this.length / this.pixPerUnit / (double)this.numLines;
        this.color = color;
        this.parser = new Parser(2);
        this.parser.defineVariable(1, "z");
        this.parser.defineVariable(2, "t");
        this.parser.define(string);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println("Failed to parse f(z,t): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function 1, position ").append(this.parser.getErrorPosition()))));
            string = "0";
            this.parser.define(string);
            this.parser.parse();
        }
        int n = 1;
        int n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = this.pixPerUnit * Math.cos(this.polarization) * this.parser.evaluate((double)n2 * this.h + this.zPropagate / this.pixPerUnit, 0.0);
            this.pts[n][1] = this.pixPerUnit * Math.sin(this.polarization) * this.parser.evaluate((double)n2 * this.h + this.zPropagate / this.pixPerUnit, 0.0);
            this.pts[n][2] = (double)(n2 * threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = 0.0;
            this.pts[n][1] = 0.0;
            this.pts[n][2] = (double)(n2 * threeDPanel.lineDensity) + this.zPropagate;
            n += 2;
            ++n2;
        }
    }

    public void translate(double d, double d2) {
        int n = 1;
        int n2 = 0;
        while (n < 2 * this.numLines) {
            this.pts[n][0] = this.pixPerUnit * Math.cos(this.polarization) * this.parser.evaluate((double)n2 * this.h + this.zPropagate / this.pixPerUnit, d2);
            this.pts[n][1] = this.pixPerUnit * Math.sin(this.polarization) * this.parser.evaluate((double)n2 * this.h + this.zPropagate / this.pixPerUnit, d2);
            n += 2;
            ++n2;
        }
    }
}

