/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.javascript.Label;

class ExceptionTableEntry {
    private int itsStartLabel;
    private int itsEndLabel;
    private int itsHandlerLabel;
    private short itsCatchType;

    ExceptionTableEntry(int startLabel, int endLabel, int handlerLabel, short catchType) {
        this.itsStartLabel = startLabel;
        this.itsEndLabel = endLabel;
        this.itsHandlerLabel = handlerLabel;
        this.itsCatchType = catchType;
    }

    short getStartPC(Label[] labelTable) {
        short pc = labelTable[this.itsStartLabel & Integer.MAX_VALUE].getPC();
        if (pc == -1) {
            throw new RuntimeException("start label not defined");
        }
        return pc;
    }

    short getEndPC(Label[] labelTable) {
        short pc = labelTable[this.itsEndLabel & Integer.MAX_VALUE].getPC();
        if (pc == -1) {
            throw new RuntimeException("end label not defined");
        }
        return pc;
    }

    short getHandlerPC(Label[] labelTable) {
        short pc = labelTable[this.itsHandlerLabel & Integer.MAX_VALUE].getPC();
        if (pc == -1) {
            throw new RuntimeException("handler label not defined");
        }
        return pc;
    }

    short getCatchType() {
        return this.itsCatchType;
    }
}

