/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class Arguments
extends ScriptableObject {
    private NativeCall activation;
    private Object[] args;
    private boolean hasCaller;

    public Arguments(NativeCall activation) {
        this.activation = activation;
        Scriptable parent = activation.getParentScope();
        this.setParentScope(parent);
        this.setPrototype(ScriptableObject.getObjectPrototype(parent));
        this.args = activation.getOriginalArguments();
        int length = this.args.length;
        NativeFunction callee = activation.funObj;
        this.defineProperty("length", new Integer(length), 2);
        this.defineProperty("callee", callee, 2);
        this.hasCaller = activation.funObj.version <= 130 && activation.funObj.version != 0;
    }

    public String getClassName() {
        return "Arguments";
    }

    public boolean has(String name, Scriptable start) {
        return this.hasCaller && name.equals("caller") || super.has(name, start);
    }

    public boolean has(int index, Scriptable start) {
        Object[] args = this.activation.getOriginalArguments();
        return index >= 0 && index < args.length || super.has(index, start);
    }

    public Object get(String name, Scriptable start) {
        if (this.hasCaller && name.equals("caller")) {
            NativeCall caller = this.activation.caller;
            if (caller == null || caller.originalArgs == null) {
                return null;
            }
            return caller.get("arguments", (Scriptable)caller);
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.args.length) {
            NativeFunction f = this.activation.funObj;
            if (index < f.argCount) {
                return this.activation.get(f.argNames[index], (Scriptable)this.activation);
            }
            return this.args[index];
        }
        return super.get(index, start);
    }

    public void put(String name, Scriptable start, Object value) {
        if (name.equals("caller")) {
            this.hasCaller = false;
        }
        super.put(name, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        if (index >= 0 && index < this.args.length) {
            NativeFunction f = this.activation.funObj;
            if (index < f.argCount) {
                this.activation.put(f.argNames[index], (Scriptable)this.activation, value);
            } else {
                this.args[index] = value;
            }
            return;
        }
        super.put(index, start, value);
    }

    public void delete(String name) {
        if (name.equals("caller")) {
            this.hasCaller = false;
        }
        super.delete(name);
    }

    public void delete(int index) {
        if (index >= 0 && index < this.args.length) {
            NativeFunction f = this.activation.funObj;
            if (index < f.argCount) {
                this.activation.delete(f.argNames[index]);
            } else {
                this.args[index] = Undefined.instance;
            }
        }
    }
}

