/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DebuggableEngineImpl;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.ListenerArray;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebugReader;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.debug.Debugger;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    private static Class codegenClass;
    private static ClassNameHelper nameHelper;
    private static boolean requireSecurityDomain;
    private static boolean resourceMissing;
    static final String securityResourceName = "org.mozilla.javascript.resources.Security";
    static final boolean useJSObject = false;
    NativeCall currentActivation;
    Hashtable iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    static boolean isCachingEnabled;
    private SecuritySupport securitySupport;
    private ErrorReporter errorReporter;
    private Thread currentThread;
    private static Hashtable threadContexts;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    WrapHandler wrapHandler;
    Debugger debugger;
    DebuggableEngine debuggableEngine;
    boolean inLineStepMode;
    Stack frameStack;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private Hashtable activationNames;
    private static final Object staticDataLock;
    private static Object[] contextListeners;
    int interpreterLine;
    String interpreterSourceFile;
    int instructionCount;
    int instructionThreshold;
    static Class class$org$mozilla$javascript$Interpreter;

    public Context() {
        this.init();
    }

    public Context(SecuritySupport securitySupport) {
        this.securitySupport = securitySupport;
        this.init();
    }

    private void init() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        Object[] array = contextListeners;
        if (array != null) {
            int i = array.length;
            while (i-- != 0) {
                ((ContextListener)array[i]).contextCreated(this);
            }
        }
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context context;
        Thread t = Thread.currentThread();
        Context current = (Context)threadContexts.get(t);
        if (current != null) {
            context = current;
            synchronized (context) {
                ++current.enterCount;
            }
        }
        if (cx != null) {
            context = cx;
            synchronized (context) {
                if (cx.currentThread == null) {
                    cx.currentThread = t;
                    threadContexts.put(t, cx);
                    ++cx.enterCount;
                }
            }
            current = cx;
        } else {
            current = new Context();
            current.currentThread = t;
            threadContexts.put(t, current);
            current.enterCount = 1;
        }
        Object[] array = contextListeners;
        if (array != null) {
            int i = array.length;
            while (i-- != 0) {
                ((ContextListener)array[i]).contextEntered(current);
            }
        }
        return current;
    }

    public static void exit() {
        Context cx = Context.getCurrentContext();
        boolean released = false;
        if (cx != null) {
            Context context = cx;
            synchronized (context) {
                if (--cx.enterCount == 0) {
                    threadContexts.remove(cx.currentThread);
                    cx.currentThread = null;
                    released = true;
                }
            }
            Object[] array = contextListeners;
            if (array != null) {
                int i = array.length;
                while (i-- != 0) {
                    ContextListener l = (ContextListener)array[i];
                    l.contextExited(cx);
                    if (!released) continue;
                    l.contextReleased(cx);
                }
            }
        }
    }

    public static Context getCurrentContext() {
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        Object[] array = this.listeners;
        if (array != null && version != this.version) {
            this.firePropertyChangeImpl(array, languageVersionProperty, new Integer(this.version), new Integer(version));
        }
        this.version = version;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 2 2001 07 27";
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        ErrorReporter result = this.errorReporter;
        Object[] array = this.listeners;
        if (array != null && this.errorReporter != reporter) {
            this.firePropertyChangeImpl(array, errorReporterProperty, this.errorReporter, reporter);
        }
        this.errorReporter = reporter;
        return result;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale loc) {
        Locale result = this.locale;
        this.locale = loc;
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.add(this.listeners, listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.remove(this.listeners, listener);
        }
    }

    void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object[] array = this.listeners;
        if (array != null) {
            this.firePropertyChangeImpl(array, property, oldValue, newValue);
        }
    }

    private void firePropertyChangeImpl(Object[] array, String property, Object oldValue, Object newValue) {
        int i = array.length;
        while (i-- != 0) {
            Object obj = array[i];
            if (!(obj instanceof PropertyChangeListener)) continue;
            PropertyChangeListener l = (PropertyChangeListener)obj;
            l.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
        }
    }

    public static void reportWarning(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportWarning(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportWarning(message, filename, linep[0], null, 0);
    }

    public static void reportError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportError(message, filename, linep[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            ++cx.errorCount;
            return cx.getErrorReporter().runtimeError(message, sourceName, lineno, lineSource, lineOffset);
        }
        throw new EvaluatorException(message);
    }

    static EvaluatorException reportRuntimeError0(String messageId) {
        return Context.reportRuntimeError(Context.getMessage0(messageId));
    }

    static EvaluatorException reportRuntimeError1(String messageId, Object arg1) {
        return Context.reportRuntimeError(Context.getMessage1(messageId, arg1));
    }

    static EvaluatorException reportRuntimeError2(String messageId, Object arg1, Object arg2) {
        return Context.reportRuntimeError(Context.getMessage2(messageId, arg1, arg2));
    }

    static EvaluatorException reportRuntimeError3(String messageId, Object arg1, Object arg2, Object arg3) {
        return Context.reportRuntimeError(Context.getMessage3(messageId, arg1, arg2, arg3));
    }

    public static EvaluatorException reportRuntimeError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        return Context.reportRuntimeError(message, filename, linep[0], null, 0);
    }

    public Scriptable initStandardObjects(ScriptableObject scope) {
        return this.initStandardObjects(scope, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scope, boolean sealed) {
        if (scope == null) {
            scope = new NativeObject();
        }
        BaseFunction.init(this, scope, sealed);
        NativeObject.init(this, scope, sealed);
        Scriptable objectProto = ScriptableObject.getObjectPrototype(scope);
        Scriptable functionProto = ScriptableObject.getFunctionPrototype(scope);
        functionProto.setPrototype(objectProto);
        if (scope.getPrototype() == null) {
            scope.setPrototype(objectProto);
        }
        NativeError.init(this, scope, sealed);
        NativeGlobal.init(this, scope, sealed);
        NativeArray.init(this, scope, sealed);
        NativeString.init(this, scope, sealed);
        NativeBoolean.init(this, scope, sealed);
        NativeNumber.init(this, scope, sealed);
        NativeDate.init(this, scope, sealed);
        NativeMath.init(this, scope, sealed);
        NativeWith.init(this, scope, sealed);
        NativeCall.init(this, scope, sealed);
        NativeScript.init(this, scope, sealed);
        new LazilyLoadedCtor(scope, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", sealed);
        new LazilyLoadedCtor(scope, "Packages", "org.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "java", "org.mozilla.javascript.NativeJavaPackage", sealed);
        new LazilyLoadedCtor(scope, "getClass", "org.mozilla.javascript.NativeJavaPackage", sealed);
        String adapterClass = "org.mozilla.javascript.JavaAdapter";
        String adapterProperty = "JavaAdapter";
        new LazilyLoadedCtor(scope, adapterProperty, adapterClass, sealed);
        return scope;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public Object evaluateString(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) throws JavaScriptException {
        try {
            StringReader in = new StringReader(source);
            Object object = this.evaluateReader(scope, in, sourceName, lineno, securityDomain);
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public Object evaluateReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws JavaScriptException, IOException {
        Script script = this.compileReader(scope, in, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean stringIsCompilableUnit(String source) {
        StringReader in = new StringReader(source);
        TokenStream ts = new TokenStream(in, null, null, 1);
        ErrorReporter currentReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean errorseen = false;
        try {
            try {
                IRFactory irf = new IRFactory(ts, null);
                Parser p = new Parser(irf);
                p.parse(ts);
            }
            catch (IOException ioe) {
                errorseen = true;
                Object var9_11 = null;
                this.setErrorReporter(currentReporter);
                return !errorseen || !ts.eof();
            }
            catch (EvaluatorException ee) {
                errorseen = true;
                Object var9_12 = null;
                this.setErrorReporter(currentReporter);
                return !errorseen || !ts.eof();
            }
            Object var9_10 = null;
            this.setErrorReporter(currentReporter);
            return !errorseen || !ts.eof();
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.setErrorReporter(currentReporter);
            throw throwable;
        }
    }

    public Script compileReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        return (Script)this.compile(scope, in, sourceName, lineno, securityDomain, false);
    }

    public Function compileFunction(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        StringReader in = new StringReader(source);
        try {
            Function function = (Function)this.compile(scope, in, sourceName, lineno, securityDomain, true);
            return function;
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public String decompileScript(Script script, Scriptable scope, int indent) {
        NativeScript ns = (NativeScript)script;
        ns.initScript(scope);
        return ns.decompile(this, indent, false);
    }

    public String decompileFunction(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, false);
        }
        return String.valueOf(String.valueOf(new StringBuffer("function ").append(fun.getClassName()).append("() {\n\t[native code]\n}\n")));
    }

    public String decompileFunctionBody(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(this, indent, true);
        }
        return "[native code]\n";
    }

    public Scriptable newObject(Scriptable scope) throws JavaScriptException, NotAFunctionException, PropertyException {
        return this.newObject(scope, "Object", null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName) throws JavaScriptException, NotAFunctionException, PropertyException {
        return this.newObject(scope, constructorName, null);
    }

    public Scriptable newObject(Scriptable scope, String constructorName, Object[] args) throws JavaScriptException, NotAFunctionException, PropertyException {
        Object ctorVal = ScriptRuntime.getTopLevelProp(scope, constructorName);
        if (ctorVal == Scriptable.NOT_FOUND) {
            String message = Context.getMessage1("msg.ctor.not.found", constructorName);
            throw new PropertyException(message);
        }
        if (!(ctorVal instanceof Function)) {
            String message = Context.getMessage1("msg.not.ctor", constructorName);
            throw new NotAFunctionException(message);
        }
        Function ctor = (Function)ctorVal;
        return ctor.construct(this, ctor.getParentScope(), args == null ? ScriptRuntime.emptyArgs : args);
    }

    public Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(length);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Scriptable newArray(Scriptable scope, Object[] elements) {
        NativeArray result = new NativeArray(elements);
        this.newArrayHelper(scope, result);
        return result;
    }

    public Object[] getElements(Scriptable object) {
        double doubleLen = NativeArray.getLengthProperty(object);
        if (doubleLen != doubleLen) {
            return null;
        }
        int len = (int)doubleLen;
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object elem = object.get(i, object);
            result[i] = elem == Scriptable.NOT_FOUND ? Undefined.instance : elem;
        }
        return result;
    }

    public static boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(value);
    }

    public static double toNumber(Object value) {
        return ScriptRuntime.toNumber(value);
    }

    public static String toString(Object value) {
        return ScriptRuntime.toString(value);
    }

    public static Scriptable toObject(Object value, Scriptable scope) {
        return ScriptRuntime.toObject(scope, value, null);
    }

    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        if (value == null && staticType != null) {
            return null;
        }
        return ScriptRuntime.toObject(scope, value, staticType);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public void setGeneratingDebug(boolean generatingDebug) {
        this.generatingDebugChanged = true;
        if (generatingDebug) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = generatingDebug;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean generatingSource) {
        this.generatingSource = generatingSource;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        if (optimizationLevel < 0) {
            optimizationLevel = -1;
        } else if (optimizationLevel > 9) {
            optimizationLevel = 9;
        }
        if (codegenClass == null) {
            optimizationLevel = -1;
        }
        this.optimizationLevel = optimizationLevel;
    }

    public String getTargetClassFileName() {
        return nameHelper == null ? null : nameHelper.getTargetClassFileName();
    }

    public void setTargetClassFileName(String classFileName) {
        if (nameHelper != null) {
            nameHelper.setTargetClassFileName(classFileName);
        }
    }

    public String getTargetPackage() {
        return nameHelper == null ? null : nameHelper.getTargetPackage();
    }

    public void setTargetPackage(String targetPackage) {
        if (nameHelper != null) {
            nameHelper.setTargetPackage(targetPackage);
        }
    }

    public ClassOutput getClassOutput() {
        return nameHelper == null ? null : nameHelper.getClassOutput();
    }

    public void setClassOutput(ClassOutput classOutput) {
        if (nameHelper != null) {
            nameHelper.setClassOutput(classOutput);
        }
    }

    public static void addContextListener(ContextListener listener) {
        Object object = staticDataLock;
        synchronized (object) {
            contextListeners = ListenerArray.add(contextListeners, listener);
        }
    }

    public static void removeContextListener(ContextListener listener) {
        Object object = staticDataLock;
        synchronized (object) {
            contextListeners = ListenerArray.remove(contextListeners, listener);
        }
    }

    public synchronized void setSecuritySupport(SecuritySupport supportObj) {
        if (this.securitySupport != null) {
            throw new SecurityException("Cannot overwrite existing SecuritySupport object");
        }
        this.securitySupport = supportObj;
    }

    public static boolean isSecurityDomainRequired() {
        return requireSecurityDomain;
    }

    public Object getInterpreterSecurityDomain() {
        return this.interpreterSecurityDomain;
    }

    public boolean isInterpreterClass(Class cl) {
        return cl == (class$org$mozilla$javascript$Interpreter == null ? (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")) : class$org$mozilla$javascript$Interpreter);
    }

    public void setTargetExtends(Class extendsClass) {
        if (nameHelper != null) {
            nameHelper.setTargetExtends(extendsClass);
        }
    }

    public void setTargetImplements(Class[] implementsClasses) {
        if (nameHelper != null) {
            nameHelper.setTargetImplements(implementsClasses);
        }
    }

    public Object getThreadLocal(Object key) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    public void putThreadLocal(Object key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public void removeThreadLocal(Object key) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(key);
    }

    public boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public void setCompileFunctionsWithDynamicScope(boolean flag) {
        this.compileFunctionsWithDynamicScopeFlag = flag;
    }

    public static void setCachingEnabled(boolean cachingEnabled) {
        if (isCachingEnabled && !cachingEnabled) {
            JavaMembers.classTable = new Hashtable();
            nameHelper.reset();
        }
        isCachingEnabled = cachingEnabled;
        FunctionObject.setCachingEnabled(cachingEnabled);
    }

    public void setWrapHandler(WrapHandler wrapHandler) {
        this.wrapHandler = wrapHandler;
    }

    public WrapHandler getWrapHandler() {
        return this.wrapHandler;
    }

    public DebuggableEngine getDebuggableEngine() {
        if (this.debuggableEngine == null) {
            this.debuggableEngine = new DebuggableEngineImpl(this);
        }
        return this.debuggableEngine;
    }

    public boolean hasFeature(int featureIndex) {
        if (featureIndex == 1) {
            return this.version == 100 || this.version == 110 || this.version == 120;
        }
        throw new RuntimeException("Bad feature index: ".concat(String.valueOf(String.valueOf(featureIndex))));
    }

    public int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public void setInstructionObserverThreshold(int threshold) {
        this.instructionThreshold = threshold;
    }

    protected void observeInstructionCount(int instructionCount) {
    }

    void pushFrame(DebugFrame frame) {
        if (this.frameStack == null) {
            this.frameStack = new Stack();
        }
        this.frameStack.push(frame);
    }

    void popFrame() {
        this.frameStack.pop();
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Thread t = Thread.currentThread();
        Context cx = (Context)threadContexts.get(t);
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx != null ? cx.getLocale() : Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(defaultResource, locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property ".concat(String.valueOf(String.valueOf(messageId))));
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    private Object compile(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain, boolean returnFunction) throws IOException {
        if (this.debugger != null && in != null) {
            in = new DebugReader(in);
        }
        TokenStream ts = new TokenStream(in, scope, sourceName, lineno);
        return this.compile(scope, ts, securityDomain, in, returnFunction);
    }

    private Interpreter getCompiler() {
        if (codegenClass != null) {
            try {
                Interpreter interpreter = (Interpreter)codegenClass.newInstance();
                return interpreter;
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new Interpreter();
    }

    private Object compile(Scriptable scope, TokenStream ts, Object securityDomain, Reader in, boolean returnFunction) throws IOException {
        Interpreter compiler = this.optimizationLevel == -1 ? new Interpreter() : this.getCompiler();
        this.errorCount = 0;
        IRFactory irf = compiler.createIRFactory(ts, nameHelper, scope);
        Parser p = new Parser(irf);
        Node tree = (Node)p.parse(ts);
        if (tree == null) {
            return null;
        }
        tree = compiler.transform(tree, ts, scope);
        if (returnFunction) {
            Node first = tree.getFirstChild();
            if (first == null) {
                return null;
            }
            tree = (Node)first.getProp(5);
            if (tree == null) {
                return null;
            }
        }
        if (in instanceof DebugReader) {
            DebugReader dr = (DebugReader)in;
            tree.putProp(31, dr.getSaved());
        }
        Object result = compiler.compile(this, scope, tree, securityDomain, this.securitySupport, nameHelper);
        return this.errorCount == 0 ? result : null;
    }

    static String getSourcePositionFromStack(int[] linep) {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            return null;
        }
        if (cx.interpreterLine > 0 && cx.interpreterSourceFile != null) {
            linep[0] = cx.interpreterLine;
            return cx.interpreterSourceFile;
        }
        CharArrayWriter writer = new CharArrayWriter();
        RuntimeException re = new RuntimeException();
        re.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        int open = -1;
        int close = -1;
        int colon = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ':') {
                colon = i;
                continue;
            }
            if (c == '(') {
                open = i;
                continue;
            }
            if (c == ')') {
                close = i;
                continue;
            }
            if (c != '\n' || open == -1 || close == -1 || colon == -1 || open >= colon || colon >= close) continue;
            String fileStr = s.substring(open + 1, colon);
            if (fileStr.endsWith(".js")) {
                String lineStr = s.substring(colon + 1, close);
                try {
                    linep[0] = Integer.parseInt(lineStr);
                    String string = fileStr;
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            colon = -1;
            close = -1;
            open = -1;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> c = Class.forName("org.mozilla.javascript.regexp.RegExpImpl");
                RegExpProxy regExpProxy = this.regExpProxy = (RegExpProxy)c.newInstance();
                return regExpProxy;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.regExpProxy;
    }

    private void newArrayHelper(Scriptable scope, Scriptable array) {
        array.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Array");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s = (Scriptable)ctor;
            array.setPrototype((Scriptable)s.get("prototype", s));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    Object getSecurityDomainFromClass(Class cl) {
        if (cl == (class$org$mozilla$javascript$Interpreter == null ? (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")) : class$org$mozilla$javascript$Interpreter)) {
            return this.interpreterSecurityDomain;
        }
        return this.securitySupport.getSecurityDomain(cl);
    }

    SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    Object getSecurityDomainForStackDepth(int depth) {
        Class[] classes;
        Object result = null;
        if (this.securitySupport != null && (classes = this.securitySupport.getClassContext()) != null) {
            if (depth != -1) {
                int depth1 = depth + 1;
                result = this.getSecurityDomainFromClass(classes[depth1]);
            } else {
                for (int i = 1; i < classes.length && (result = this.getSecurityDomainFromClass(classes[i])) == null; ++i) {
                }
            }
        }
        if (result != null) {
            return result;
        }
        if (requireSecurityDomain) {
            Context.checkSecurityDomainRequired();
        }
        return null;
    }

    public static final void checkSecurityDomainRequired() {
        if (requireSecurityDomain) {
            String msg = "Required security context not found";
            if (resourceMissing) {
                msg = String.valueOf(String.valueOf(msg)).concat(". Didn't find properties file at org.mozilla.javascript.resources.Security");
            }
            throw new SecurityException(msg);
        }
    }

    public boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String name) {
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(name, name);
    }

    public boolean isActivationNeeded(String name) {
        if ("arguments".equals(name)) {
            return true;
        }
        return this.activationNames != null && this.activationNames.containsKey(name);
    }

    public void removeActivationName(String name) {
        if (this.activationNames != null) {
            this.activationNames.remove(name);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        languageVersionProperty = languageVersionProperty;
        errorReporterProperty = errorReporterProperty;
        VERSION_UNKNOWN = -1;
        VERSION_DEFAULT = 0;
        VERSION_1_0 = 100;
        VERSION_1_1 = 110;
        VERSION_1_2 = 120;
        VERSION_1_3 = 130;
        VERSION_1_4 = 140;
        VERSION_1_5 = 150;
        FEATURE_NON_ECMA_GET_YEAR = 1;
        defaultResource = defaultResource;
        printTrees = false;
        codegenClass = null;
        requireSecurityDomain = false;
        resourceMissing = false;
        securityResourceName = securityResourceName;
        useJSObject = false;
        isCachingEnabled = true;
        threadContexts = new Hashtable(11);
        staticDataLock = new Object();
    }
}

