/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FlattenedObject {
    private Scriptable obj;

    public FlattenedObject(Scriptable object) {
        this.obj = object;
    }

    public Scriptable getObject() {
        return this.obj;
    }

    public boolean hasProperty(Object id) {
        String stringId = ScriptRuntime.toString(id);
        String s = ScriptRuntime.getStringId(stringId);
        if (s == null) {
            return FlattenedObject.getBase(this.obj, ScriptRuntime.getIntId(stringId)) != null;
        }
        return FlattenedObject.getBase(this.obj, s) != null;
    }

    public Object getProperty(Object id) {
        Object result;
        block2: {
            String s = ScriptRuntime.getStringId(id);
            int index = s == null ? ScriptRuntime.getIntId(id) : 0;
            Scriptable m = this.obj;
            do {
                Object object = result = s == null ? m.get(index, this.obj) : m.get(s, this.obj);
                if (result != Scriptable.NOT_FOUND) break block2;
            } while ((m = m.getPrototype()) != null);
            return Undefined.instance;
        }
        if (result instanceof Scriptable) {
            return new FlattenedObject((Scriptable)result);
        }
        return result;
    }

    public void putProperty(Object id, Object value) {
        String s = ScriptRuntime.getStringId(id);
        if (value instanceof FlattenedObject) {
            value = ((FlattenedObject)value).getObject();
        }
        if (s == null) {
            int index = ScriptRuntime.getIntId(id);
            Scriptable x = FlattenedObject.getBase(this.obj, index);
            if (x == null) {
                x = this.obj;
            }
            x.put(index, this.obj, value);
            return;
        }
        Scriptable x = FlattenedObject.getBase(this.obj, s);
        if (x == null) {
            x = this.obj;
        }
        x.put(s, this.obj, value);
    }

    public boolean deleteProperty(Object id) {
        String s = ScriptRuntime.getStringId(id);
        if (s == null) {
            int index = ScriptRuntime.getIntId(id);
            Scriptable base = FlattenedObject.getBase(this.obj, index);
            if (base == null) {
                return true;
            }
            base.delete(index);
            return !base.has(index, base);
        }
        Scriptable base = FlattenedObject.getBase(this.obj, s);
        if (base == null) {
            return true;
        }
        base.delete(s);
        return !base.has(s, base);
    }

    public Object[] getIds() {
        Hashtable<Object, Boolean> h = new Hashtable<Object, Boolean>(11);
        for (Scriptable m = this.obj; m != null; m = m.getPrototype()) {
            Object[] e = m.getIds();
            for (int i = 0; i < e.length; ++i) {
                h.put(e[i], Boolean.TRUE);
            }
        }
        Enumeration keys = h.keys();
        Object[] result = new Object[h.size()];
        int index = 0;
        while (keys.hasMoreElements()) {
            Object elem = keys.nextElement();
            result[index++] = elem;
        }
        return result;
    }

    public Object call(Context cx, Scriptable thisObj, Object[] args) throws JavaScriptException, NotAFunctionException {
        if (!(this.obj instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.call(cx, this.obj, thisObj, args, (Function)this.obj);
    }

    public Scriptable construct(Context cx, Object[] args) throws JavaScriptException, NotAFunctionException {
        if (!(this.obj instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.newObject(cx, (Object)this.obj, args, null);
    }

    public Object callMethod(Object id, Object[] args) throws JavaScriptException, NotAFunctionException, PropertyException {
        if (!this.hasProperty(id)) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        Object o = this.getProperty(id);
        if (o instanceof FlattenedObject) {
            return ((FlattenedObject)o).call(Context.getContext(), this.obj, args);
        }
        throw new NotAFunctionException();
    }

    private static Scriptable getBase(Scriptable obj, String s) {
        for (Scriptable m = obj; m != null; m = m.getPrototype()) {
            if (!m.has(s, obj)) continue;
            return m;
        }
        return null;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        for (Scriptable m = obj; m != null; m = m.getPrototype()) {
            if (!m.has(index, obj)) continue;
            return m;
        }
        return null;
    }
}

