/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class FunctionObject
extends NativeFunction {
    private static final String INVOKER_MASTER_CLASS = "org.mozilla.javascript.optimizer.InvokerImpl";
    static Invoker invokerMaster;
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    Method method;
    Constructor ctor;
    private Class[] types;
    Invoker invoker;
    private short parmsLength;
    private short lengthPropertyValue;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;
    static Class class$org$mozilla$javascript$Scriptable;
    static Class class$org$mozilla$javascript$Context;

    public FunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        short length;
        String methodName;
        if (methodOrConstructor instanceof Constructor) {
            this.ctor = (Constructor)methodOrConstructor;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            methodName = this.ctor.getName();
        } else {
            this.method = (Method)methodOrConstructor;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            methodName = this.method.getName();
        }
        this.functionName = name;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context) || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", methodName);
                }
                this.parmsLength = (short)-2;
            } else {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context) || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", methodName);
                }
                this.parmsLength = (short)-1;
            }
            length = 1;
        } else {
            this.parmsLength = (short)this.types.length;
            for (int i = 0; i < this.parmsLength; ++i) {
                Class type = this.types[i];
                if (type == ScriptRuntime.ObjectClass || type == ScriptRuntime.StringClass || type == ScriptRuntime.BooleanClass || ScriptRuntime.NumberClass.isAssignableFrom(type) || (class$org$mozilla$javascript$Scriptable == null ? FunctionObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable).isAssignableFrom(type) || type == Boolean.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Double.TYPE) continue;
                throw Context.reportRuntimeError1("msg.bad.parms", methodName);
            }
            length = this.parmsLength;
        }
        this.lengthPropertyValue = length;
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        this.argCount = length;
        this.setParentScope(scope);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        Context cx = Context.getCurrentContext();
        this.useDynamicScope = cx != null && cx.hasCompileFunctionsWithDynamicScope();
    }

    public int getLength() {
        return this.lengthPropertyValue;
    }

    public void setLength(short length) {
        this.lengthPropertyValue = length;
    }

    public static Method[] findMethods(Class clazz, String name) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), name);
    }

    static Method[] findMethods(Method[] methods, String name) {
        Vector<Method> v = null;
        Method first = null;
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] == null || !methods[i].getName().equals(name)) continue;
            if (first == null) {
                first = methods[i];
                continue;
            }
            if (v == null) {
                v = new Vector<Method>(5);
                v.addElement(first);
            }
            v.addElement(methods[i]);
        }
        if (v == null) {
            if (first == null) {
                return null;
            }
            Method[] single = new Method[]{first};
            return single;
        }
        Object[] result = new Method[v.size()];
        v.copyInto(result);
        return result;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] cached = methodsCache;
        if (cached != null && cached[0].getDeclaringClass() == clazz) {
            return cached;
        }
        Method[] methods = null;
        try {
            if (!sawSecurityException) {
                methods = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException e) {
            sawSecurityException = true;
        }
        if (methods == null) {
            methods = clazz.getMethods();
        }
        int count = 0;
        for (int i = 0; i < methods.length; ++i) {
            boolean bl = sawSecurityException ? methods[i].getDeclaringClass() != clazz : !Modifier.isPublic(methods[i].getModifiers());
            if (bl) {
                methods[i] = null;
                continue;
            }
            ++count;
        }
        Method[] result = new Method[count];
        int j = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] == null) continue;
            result[j++] = methods[i];
        }
        if (result.length > 0 && Context.isCachingEnabled) {
            methodsCache = result;
        }
        return result;
    }

    public void addAsConstructor(Scriptable scope, Scriptable prototype) {
        this.setParentScope(scope);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        this.setImmunePrototypeProperty(prototype);
        prototype.setParentScope(this);
        ScriptableObject.defineProperty(prototype, "constructor", this, 7);
        String name = prototype.getClassName();
        ScriptableObject.defineProperty(scope, name, this, 2);
        this.setParentScope(scope);
    }

    public static Object convertArg(Scriptable scope, Object arg, Class desired) {
        if (desired == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(arg);
        }
        if (desired == ScriptRuntime.IntegerClass || desired == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(arg));
        }
        if (desired == ScriptRuntime.BooleanClass || desired == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (desired == ScriptRuntime.DoubleClass || desired == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(arg));
        }
        if (desired == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(scope, arg);
        }
        if (desired == ScriptRuntime.ObjectClass) {
            return arg;
        }
        throw Context.reportRuntimeError1("msg.cant.convert", desired.getName());
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        short i;
        Object[] invokeArgs;
        if (this.parmsLength < 0) {
            return this.callVarargs(cx, thisObj, args, false);
        }
        if (!this.isStatic) {
            Class<Object> clazz;
            Class<Object> clazz2 = clazz = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!clazz.isInstance(thisObj)) {
                if ((thisObj = thisObj.getPrototype()) != null && this.useDynamicScope) continue;
                throw NativeGlobal.typeError1("msg.incompat.call", this.functionName, scope);
            }
        }
        if (this.parmsLength == args.length) {
            invokeArgs = args;
            i = this.types == null ? this.parmsLength : (short)0;
        } else {
            invokeArgs = new Object[this.parmsLength];
            i = 0;
        }
        while (i < this.parmsLength) {
            Object arg;
            Object object = arg = i < args.length ? args[i] : Undefined.instance;
            if (this.types != null) {
                arg = FunctionObject.convertArg(this, arg, this.types[i]);
            }
            invokeArgs[i] = arg;
            i = (short)(i + 1);
        }
        try {
            Object result = this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(thisObj, invokeArgs);
            Scriptable scriptable = this.hasVoidReturn ? Undefined.instance : result;
            return scriptable;
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(scope, e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable parent;
            Scriptable result = this.method != null ? (Scriptable)this.callVarargs(cx, null, args, true) : (Scriptable)this.call(cx, scope, null, args);
            if (result.getPrototype() == null) {
                result.setPrototype(this.getClassPrototype());
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
            return result;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable result;
            try {
                result = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw WrappedException.wrapException(e);
            }
            catch (InstantiationException e) {
                throw WrappedException.wrapException(e);
            }
            result.setPrototype(this.getClassPrototype());
            result.setParentScope(this.getParentScope());
            Object val = this.call(cx, scope, result, args);
            if (val != null && val != Undefined.instance && val instanceof Scriptable) {
                return (Scriptable)val;
            }
            return result;
        }
        return super.construct(cx, scope, args);
    }

    private final Object doInvoke(Object thisObj, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Invoker master = invokerMaster;
        if (master != null) {
            if (this.invoker == null) {
                this.invoker = master.createInvoker(this.method, this.types);
            }
            try {
                Object object = this.invoker.invoke(thisObj, args);
                return object;
            }
            catch (RuntimeException e) {
                throw new InvocationTargetException(e);
            }
        }
        return this.method.invoke(thisObj, args);
    }

    private Object callVarargs(Context cx, Scriptable thisObj, Object[] args, boolean inNewExpr) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] invokeArgs = new Object[]{cx, thisObj, args, this};
                Object result = this.doInvoke(null, invokeArgs);
                Object object = this.hasVoidReturn ? Undefined.instance : result;
                return object;
            }
            Boolean b = inNewExpr ? Boolean.TRUE : Boolean.FALSE;
            Object[] invokeArgs = new Object[]{cx, args, this, b};
            Object object = this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(null, invokeArgs);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof EvaluatorException) {
                throw (EvaluatorException)target;
            }
            if (target instanceof EcmaError) {
                throw (EcmaError)target;
            }
            Scriptable scope = thisObj == null ? this : thisObj;
            throw JavaScriptException.wrapException(scope, target);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    static void setCachingEnabled(boolean enabled) {
        if (!enabled) {
            methodsCache = null;
            invokerMaster = null;
        } else if (invokerMaster == null) {
            invokerMaster = FunctionObject.newInvokerMaster();
        }
    }

    private static Invoker newInvokerMaster() {
        return null;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        INVOKER_MASTER_CLASS = INVOKER_MASTER_CLASS;
        invokerMaster = FunctionObject.newInvokerMaster();
        VARARGS_METHOD = (short)-1;
        VARARGS_CTOR = (short)-2;
    }
}

