/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ShallowNodeIterator;
import org.mozilla.javascript.TokenStream;

public class IRFactory {
    private TokenStream ts;
    private Scriptable scope;

    public IRFactory(TokenStream ts, Scriptable scope) {
        this.ts = ts;
        this.scope = scope;
    }

    public Object createScript(Object body, String sourceName, int baseLineno, int endLineno, Object source) {
        Node result = new Node(146, sourceName);
        Node children = ((Node)body).getFirstChild();
        if (children != null) {
            result.addChildrenToBack(children);
        }
        result.putProp(16, sourceName);
        result.putProp(28, new Integer(baseLineno));
        result.putProp(29, new Integer(endLineno));
        if (source != null) {
            result.putProp(17, source);
        }
        return result;
    }

    public Object createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    public Object createLeaf(int nodeType, String id) {
        return new Node(nodeType, id);
    }

    public Object createLeaf(int nodeType, int nodeOp) {
        return new Node(nodeType, new Integer(nodeOp));
    }

    public Object createSwitch(int lineno) {
        return new Node(115, new Integer(lineno));
    }

    public Object createVariables(int lineno) {
        return new Node(123, new Integer(lineno));
    }

    public Object createExprStatement(Object expr, int lineno) {
        return new Node(140, (Node)expr, new Integer(lineno));
    }

    public Object createName(String name) {
        return new Node(44, name);
    }

    public Object createString(String string) {
        return new Node(46, string);
    }

    public Object createNumber(Number number) {
        return new Node(45, number);
    }

    public Object createCatch(String varName, Object catchCond, Object stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(109, new Integer(52));
        }
        Node result = new Node(125, (Node)this.createName(varName), (Node)catchCond, (Node)stmts);
        result.setDatum(new Integer(lineno));
        return result;
    }

    public Object createThrow(Object expr, int lineno) {
        return new Node(62, (Node)expr, new Integer(lineno));
    }

    public Object createReturn(Object expr, int lineno) {
        return expr == null ? new Node(5, new Integer(lineno)) : new Node(5, (Node)expr, new Integer(lineno));
    }

    public Object createLabel(String label, int lineno) {
        Node result = new Node(136, new Integer(lineno));
        Node name = new Node(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createBreak(String label, int lineno) {
        Node result = new Node(121, new Integer(lineno));
        if (label == null) {
            return result;
        }
        Node name = new Node(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createContinue(String label, int lineno) {
        Node result = new Node(122, new Integer(lineno));
        if (label == null) {
            return result;
        }
        Node name = new Node(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createBlock(int lineno) {
        return new Node(133, new Integer(lineno));
    }

    public Object createFunctionNode(String name, Object args, Object statements) {
        if (name == null) {
            name = "";
        }
        return new FunctionNode(name, (Node)args, (Node)statements);
    }

    public Object createFunction(String name, Object args, Object statements, String sourceName, int baseLineno, int endLineno, Object source, boolean isExpr) {
        FunctionNode f = (FunctionNode)this.createFunctionNode(name, args, statements);
        f.setFunctionType(isExpr ? (byte)2 : 1);
        f.putProp(16, sourceName);
        f.putProp(28, new Integer(baseLineno));
        f.putProp(29, new Integer(endLineno));
        if (source != null) {
            f.putProp(17, source);
        }
        Node result = new Node(110, name);
        result.putProp(5, f);
        return result;
    }

    public void setFunctionExpressionStatement(Object o) {
        Node n = (Node)o;
        FunctionNode f = (FunctionNode)n.getProp(5);
        f.setFunctionType((byte)3);
    }

    public void addChildToBack(Object parent, Object child) {
        ((Node)parent).addChildToBack((Node)child);
    }

    public Object createWhile(Object cond, Object body, int lineno) {
        Node result = (Node)this.createDoWhile(body, cond, lineno);
        Node condTarget = (Node)result.getProp(3);
        Node GOTO = new Node(6);
        GOTO.putProp(1, condTarget);
        result.addChildToFront(GOTO);
        return result;
    }

    public Object createDoWhile(Object body, Object cond, int lineno) {
        Node result = new Node(138, new Integer(lineno));
        Node bodyTarget = new Node(137);
        Node condTarget = new Node(137);
        Node IFEQ = new Node(7, (Node)cond);
        IFEQ.putProp(1, bodyTarget);
        Node breakTarget = new Node(137);
        result.addChildToBack(bodyTarget);
        result.addChildrenToBack((Node)body);
        result.addChildToBack(condTarget);
        result.addChildToBack(IFEQ);
        result.addChildToBack(breakTarget);
        result.putProp(2, breakTarget);
        result.putProp(3, condTarget);
        return result;
    }

    public Object createFor(Object init, Object test, Object incr, Object body, int lineno) {
        if (((Node)test).getType() == 132) {
            test = new Node(109, new Integer(52));
        }
        Node result = (Node)this.createWhile(test, body, lineno);
        Node initNode = (Node)init;
        if (initNode.getType() != 132) {
            if (initNode.getType() != 123) {
                initNode = new Node(57, initNode);
            }
            result.addChildToFront(initNode);
        }
        Node condTarget = (Node)result.getProp(3);
        Node incrTarget = new Node(137);
        result.addChildBefore(incrTarget, condTarget);
        if (((Node)incr).getType() != 132) {
            incr = this.createUnary(57, incr);
            result.addChildAfter((Node)incr, incrTarget);
        }
        result.putProp(3, incrTarget);
        return result;
    }

    public Object createForIn(Object lhs, Object obj, Object body, int lineno) {
        Node lhsNode = (Node)lhs;
        Node objNode = (Node)obj;
        int type = lhsNode.getType();
        Node lvalue = lhsNode;
        switch (type) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            case 123: {
                Node lastChild = lhsNode.getLastChild();
                if (lhsNode.getFirstChild() != lastChild) {
                    this.reportError("msg.mult.index");
                }
                lvalue = new Node(44, lastChild.getString());
                break;
            }
            default: {
                this.reportError("msg.bad.for.in.lhs");
                return objNode;
            }
        }
        Node init = new Node(79, objNode);
        Node next = new Node(80);
        next.putProp(4, init);
        Node temp = this.createNewTemp(next);
        Node cond = new Node(102, new Integer(15));
        cond.addChildToBack(temp);
        cond.addChildToBack(new Node(109, new Integer(49)));
        Node newBody = new Node(133);
        Node assign = (Node)this.createAssignment(128, lvalue, this.createUseTemp(temp), null, false);
        newBody.addChildToBack(new Node(57, assign));
        newBody.addChildToBack((Node)body);
        Node result = (Node)this.createWhile(cond, newBody, lineno);
        result.addChildToFront(init);
        if (type == 123) {
            result.addChildToFront(lhsNode);
        }
        Node done = new Node(139);
        done.putProp(4, init);
        result.addChildToBack(done);
        return result;
    }

    public Object createTryCatchFinally(Object tryblock, Object catchblocks, Object finallyblock, int lineno) {
        Node trynode = (Node)tryblock;
        if (trynode.getType() == 133 && !trynode.hasChildren()) {
            return trynode;
        }
        Node pn = new Node(75, trynode, new Integer(lineno));
        Node catchNodes = (Node)catchblocks;
        boolean hasCatch = catchNodes.hasChildren();
        boolean hasFinally = false;
        Node finallyNode = null;
        Node finallyTarget = null;
        if (finallyblock != null) {
            finallyNode = (Node)finallyblock;
            boolean bl = hasFinally = finallyNode.getType() != 133 || finallyNode.hasChildren();
            if (hasFinally) {
                finallyTarget = new Node(137);
                pn.putProp(21, finallyTarget);
                Node jsrFinally = new Node(143);
                jsrFinally.putProp(1, finallyTarget);
                pn.addChildToBack(jsrFinally);
            }
        }
        if (!hasFinally && !hasCatch) {
            return trynode;
        }
        Node endTarget = new Node(137);
        Node GOTOToEnd = new Node(6);
        GOTOToEnd.putProp(1, endTarget);
        pn.addChildToBack(GOTOToEnd);
        if (hasCatch) {
            Node catchTarget = new Node(137);
            pn.putProp(1, catchTarget);
            pn.addChildToBack(catchTarget);
            Node exn = this.createNewLocal(new Node(132));
            pn.addChildToBack(new Node(57, exn));
            Node endCatch = new Node(137);
            for (Node cb = catchNodes.getFirstChild(); cb != null; cb = cb.getNextSibling()) {
                Node catchStmt = new Node(133);
                int catchLineNo = (Integer)cb.getDatum();
                Node name = cb.getFirstChild();
                Node cond = name.getNextSibling();
                Node catchBlock = cond.getNextSibling();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchBlock);
                Node newScope = this.createNewLocal(new Node(77));
                Node initScope = new Node(40, newScope, new Node(46, name.getString()), this.createUseLocal(exn));
                catchStmt.addChildToBack(new Node(57, initScope));
                catchBlock.addChildToBack(new Node(4));
                Node GOTOToEndCatch = new Node(6);
                GOTOToEndCatch.putProp(1, endCatch);
                catchBlock.addChildToBack(GOTOToEndCatch);
                Node ifStmt = (Node)this.createIf(cond, catchBlock, null, catchLineNo);
                Node withStmt = (Node)this.createWith(this.createUseLocal(newScope), ifStmt, catchLineNo);
                catchStmt.addChildToBack(withStmt);
                pn.addChildToBack(catchStmt);
            }
            Node rethrow = new Node(62, this.createUseLocal(exn));
            pn.addChildToBack(rethrow);
            pn.addChildToBack(endCatch);
            if (hasFinally) {
                Node jsrFinally = new Node(143);
                jsrFinally.putProp(1, finallyTarget);
                pn.addChildToBack(jsrFinally);
                Node GOTO = new Node(6);
                GOTO.putProp(1, endTarget);
                pn.addChildToBack(GOTO);
            }
        }
        if (hasFinally) {
            pn.addChildToBack(finallyTarget);
            Node returnTemp = this.createNewLocal(new Node(132));
            Node popAndMake = new Node(57, returnTemp);
            pn.addChildToBack(popAndMake);
            pn.addChildToBack(finallyNode);
            Node ret = this.createUseLocal(returnTemp);
            ret.putProp(1, Boolean.TRUE);
            pn.addChildToBack(ret);
        }
        pn.addChildToBack(endTarget);
        return pn;
    }

    public Object createWith(Object obj, Object body, int lineno) {
        Node result = new Node(133, new Integer(lineno));
        result.addChildToBack(new Node(3, (Node)obj));
        Node bodyNode = new Node(124, (Node)body, new Integer(lineno));
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(4));
        return result;
    }

    public Object createArrayLiteral(Object obj) {
        Node temp;
        Node result;
        Node array = result = new Node(30, new Node(44, "Array"));
        result = temp = this.createNewTemp(result);
        ShallowNodeIterator children = ((Node)obj).getChildIterator();
        Node elem = null;
        int i = 0;
        while (children.hasMoreElements()) {
            elem = (Node)children.nextElement();
            if (elem.getType() == 109 && elem.getInt() == 74) {
                ++i;
                continue;
            }
            Node addelem = new Node(42, this.createUseTemp(temp), new Node(45, new Integer(i)), elem);
            ++i;
            result = new Node(96, result, addelem);
        }
        if (Context.getContext().getLanguageVersion() == 120) {
            if (elem != null && elem.getType() == 109 && elem.getInt() == 74) {
                Node setlength = new Node(40, this.createUseTemp(temp), new Node(46, "length"), new Node(45, new Integer(i)));
                result = new Node(96, result, setlength);
            }
        } else {
            array.addChildToBack(new Node(45, new Integer(i)));
        }
        return new Node(96, result, this.createUseTemp(temp));
    }

    public Object createObjectLiteral(Object obj) {
        Node temp;
        Node result = new Node(30, new Node(44, "Object"));
        result = temp = this.createNewTemp(result);
        ShallowNodeIterator children = ((Node)obj).getChildIterator();
        while (children.hasMoreElements()) {
            Node elem = (Node)children.nextElement();
            int op = elem.getType() == 44 ? 40 : 42;
            Node addelem = new Node(op, this.createUseTemp(temp), elem, (Node)children.nextElement());
            result = new Node(96, result, addelem);
        }
        return new Node(96, result, this.createUseTemp(temp));
    }

    public Object createRegExp(String string, String flags) {
        return flags.length() == 0 ? new Node(56, new Node(46, string)) : new Node(56, new Node(46, string), new Node(46, flags));
    }

    public Object createIf(Object cond, Object ifTrue, Object ifFalse, int lineno) {
        Node result = new Node(133, new Integer(lineno));
        Node ifNotTarget = new Node(137);
        Node IFNE = new Node(8, (Node)cond);
        IFNE.putProp(1, ifNotTarget);
        result.addChildToBack(IFNE);
        result.addChildrenToBack((Node)ifTrue);
        if (ifFalse != null) {
            Node GOTOToEnd = new Node(6);
            Node endTarget = new Node(137);
            GOTOToEnd.putProp(1, endTarget);
            result.addChildToBack(GOTOToEnd);
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack((Node)ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    public Object createTernary(Object cond, Object ifTrue, Object ifFalse) {
        return this.createIf(cond, ifTrue, ifFalse, -1);
    }

    public Object createUnary(int nodeType, Object child) {
        Node childNode = (Node)child;
        if (nodeType == 31) {
            Node right;
            Node left;
            int childType = childNode.getType();
            if (childType == 44) {
                childNode.setType(61);
                left = childNode;
                right = childNode.cloneNode();
                right.setType(46);
            } else if (childType == 39 || childType == 41) {
                left = childNode.getFirstChild();
                right = childNode.getLastChild();
                childNode.removeChild(left);
                childNode.removeChild(right);
            } else {
                return new Node(109, new Integer(52));
            }
            return new Node(nodeType, left, right);
        }
        return new Node(nodeType, childNode);
    }

    public Object createUnary(int nodeType, int nodeOp, Object child) {
        Node childNode = (Node)child;
        int childType = childNode.getType();
        if (nodeOp == 32 && childType == 44) {
            childNode.setType(32);
            return childNode;
        }
        if (nodeType == 106 || nodeType == 107) {
            if (!(IRFactory.hasSideEffects(childNode) || nodeOp != 131 || childType != 44 && childType != 39 && childType != 41)) {
                return new Node(nodeType, childNode);
            }
            Node rhs = (Node)this.createNumber(new Double(1.0));
            return this.createAssignment(nodeType == 106 ? 23 : 24, childNode, rhs, ScriptRuntime.NumberClass, nodeOp == 131);
        }
        Node result = new Node(nodeType, new Integer(nodeOp));
        result.addChildToBack((Node)child);
        return result;
    }

    public Object createBinary(int nodeType, Object left, Object right) {
        switch (nodeType) {
            case 108: {
                nodeType = 39;
                Node idNode = (Node)right;
                idNode.setType(46);
                String id = idNode.getString();
                if (!id.equals("__proto__") && !id.equals("__parent__")) break;
                Node result = new Node(nodeType, (Node)left);
                result.putProp(19, id);
                return result;
            }
            case 90: {
                nodeType = 41;
                break;
            }
        }
        return new Node(nodeType, (Node)left, (Node)right);
    }

    public Object createBinary(int nodeType, int nodeOp, Object left, Object right) {
        if (nodeType == 97) {
            return this.createAssignment(nodeOp, (Node)left, (Node)right, null, false);
        }
        return new Node(nodeType, (Node)left, (Node)right, new Integer(nodeOp));
    }

    public Object createAssignment(int nodeOp, Node left, Node right, Class convert, boolean postfix) {
        int nodeType = left.getType();
        Node id = null;
        switch (nodeType) {
            case 44: {
                return this.createSetName(nodeOp, left, right, convert, postfix);
            }
            case 39: {
                String idString = (String)left.getProp(19);
                if (idString != null) {
                    id = new Node(46, idString);
                }
            }
            case 41: {
                if (id == null) {
                    id = left.getLastChild();
                }
                return this.createSetProp(nodeType, nodeOp, left.getFirstChild(), id, right, convert, postfix);
            }
        }
        this.reportError("msg.bad.lhs.assign");
        return left;
    }

    private Node createConvert(Class toType, Node expr) {
        if (toType == null) {
            return expr;
        }
        Node result = new Node(142, expr);
        result.putProp(18, ScriptRuntime.NumberClass);
        return result;
    }

    private Object createSetName(int nodeOp, Node left, Node right, Class convert, boolean postfix) {
        if (nodeOp == 128) {
            left.setType(61);
            return new Node(10, left, right);
        }
        String s = left.getString();
        if (s.equals("__proto__") || s.equals("__parent__")) {
            Node result = new Node(40, left, right);
            result.putProp(19, s);
            return result;
        }
        Node opLeft = new Node(44, s);
        if (convert != null) {
            opLeft = this.createConvert(convert, opLeft);
        }
        if (postfix) {
            opLeft = this.createNewTemp(opLeft);
        }
        Node op = new Node(nodeOp, opLeft, right);
        Node lvalueLeft = new Node(61, s);
        Node result = new Node(10, lvalueLeft, op);
        if (postfix) {
            result = new Node(96, result, this.createUseTemp(opLeft));
        }
        return result;
    }

    public Node createNewTemp(Node n) {
        int type = n.getType();
        if (type == 46 || type == 45) {
            return n;
        }
        Node result = new Node(69, n);
        return result;
    }

    public Node createUseTemp(Node newTemp) {
        int type = newTemp.getType();
        if (type == 69) {
            Node result = new Node(70);
            result.putProp(6, newTemp);
            Integer n = (Integer)newTemp.getProp(11);
            if (n == null) {
                n = new Integer(1);
            } else if (n < Integer.MAX_VALUE) {
                n = new Integer(n + 1);
            }
            newTemp.putProp(11, n);
            return result;
        }
        return newTemp.cloneNode();
    }

    public Node createNewLocal(Node n) {
        Node result = new Node(144, n);
        return result;
    }

    public Node createUseLocal(Node newLocal) {
        int type = newLocal.getType();
        if (type == 144) {
            Node result = new Node(145);
            result.putProp(7, newLocal);
            return result;
        }
        return newLocal.cloneNode();
    }

    public static boolean hasSideEffects(Node exprTree) {
        switch (exprTree.getType()) {
            case 10: 
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 106: 
            case 107: {
                return true;
            }
        }
        for (Node child = exprTree.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!IRFactory.hasSideEffects(child)) continue;
            return true;
        }
        return false;
    }

    private Node createSetProp(int nodeType, int nodeOp, Node obj, Node id, Node expr, Class convert, boolean postfix) {
        Node opLeft;
        Node tmp2;
        Node tmp1;
        String s;
        int type = nodeType == 39 ? 40 : 42;
        Object datum = id.getDatum();
        if (type == 40 && datum != null && datum instanceof String && ((s = (String)datum).equals("__proto__") || s.equals("__parent__"))) {
            Node result = new Node(type, obj, expr);
            result.putProp(19, s);
            return result;
        }
        if (nodeOp == 128) {
            return new Node(type, obj, id, expr);
        }
        if (IRFactory.hasSideEffects(expr) || IRFactory.hasSideEffects(id) || obj.getType() != 44) {
            tmp1 = this.createNewTemp(obj);
            Node useTmp1 = this.createUseTemp(tmp1);
            tmp2 = this.createNewTemp(id);
            Node useTmp2 = this.createUseTemp(tmp2);
            opLeft = new Node(nodeType, useTmp1, useTmp2);
        } else {
            tmp1 = obj.cloneNode();
            tmp2 = id.cloneNode();
            opLeft = new Node(nodeType, obj, id);
        }
        if (convert != null) {
            opLeft = this.createConvert(convert, opLeft);
        }
        if (postfix) {
            opLeft = this.createNewTemp(opLeft);
        }
        Node op = new Node(nodeOp, opLeft, expr);
        Node result = new Node(type, tmp1, tmp2, op);
        if (postfix) {
            result = new Node(96, result, this.createUseTemp(opLeft));
        }
        return result;
    }

    private void reportError(String msgResource) {
        if (this.scope != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", ScriptRuntime.getMessage0(msgResource), this.scope);
        }
        String message = Context.getMessage0(msgResource);
        Context.reportError(message, this.ts.getSourceName(), this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }
}

