/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

class InterpretedFunction
extends NativeFunction
implements DebuggableScript {
    InterpreterData itsData;
    Scriptable itsClosure;

    InterpretedFunction(Context cx, InterpreterData theData, String[] argNames, short argCount) {
        this.itsData = theData;
        this.argNames = argNames;
        this.argCount = argCount;
        this.init(cx);
    }

    void init(Context cx) {
        this.functionName = this.itsData.itsName;
        this.source = this.itsData.itsSource;
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        if (cx != null) {
            this.version = (short)cx.getLanguageVersion();
        }
    }

    InterpretedFunction(InterpretedFunction theOther, Scriptable theScope, Context cx) {
        this.itsData = theOther.itsData;
        this.argNames = theOther.argNames;
        this.argCount = theOther.argCount;
        this.itsClosure = theScope;
        this.init(cx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object object;
        if (this.itsClosure != null) {
            scope = this.itsClosure;
        } else if (!this.itsData.itsUseDynamicScope) {
            scope = this.getParentScope();
        }
        if (this.itsData.itsCheckThis) {
            thisObj = ScriptRuntime.getThis(thisObj);
        }
        if (this.itsData.itsNeedsActivation) {
            scope = ScriptRuntime.initVarObj(cx, scope, this, thisObj, args);
        }
        try {
            object = Interpreter.interpret(cx, scope, thisObj, args, this, this.itsData);
            Object var7_6 = null;
            if (!this.itsData.itsNeedsActivation) return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!this.itsData.itsNeedsActivation) throw throwable;
            ScriptRuntime.popActivation(cx);
            throw throwable;
        }
        ScriptRuntime.popActivation(cx);
        return object;
    }

    public boolean isFunction() {
        return true;
    }

    public Scriptable getScriptable() {
        return this;
    }

    public String getSourceName() {
        return this.itsData.itsSourceFile;
    }

    public int[] getLineNumbers() {
        return this.itsData.itsLineNumberTable.getKeys();
    }

    public boolean placeBreakpoint(int line) {
        return this.itsData.placeBreakpoint(line);
    }

    public boolean removeBreakpoint(int line) {
        return this.itsData.removeBreakpoint(line);
    }
}

