/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.InterpreterFrame;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;

public class Interpreter
extends LabelTable {
    public static final boolean printICode = false;
    boolean itsInFunctionFlag;
    Vector itsFunctionList;
    InterpreterData itsData;
    VariableTable itsVariableTable;
    int itsTryDepth = 0;
    int itsStackDepth = 0;
    int itsEpilogLabel = -1;
    String itsSourceFile;
    int itsLineNumber = 0;
    InterpretedFunction[] itsNestedFunctions = null;
    static PrintWriter out;
    private int version;
    private boolean inLineStepMode;
    private StringBuffer debugSource;
    private static final Object DBL_MRK;

    public IRFactory createIRFactory(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new IRFactory(ts, scope);
    }

    public Node transform(Node tree, TokenStream ts, Scriptable scope) {
        return new NodeTransformer().transform(tree, null, ts, scope);
    }

    public Object compile(Context cx, Scriptable scope, Node tree, Object securityDomain, SecuritySupport securitySupport, ClassNameHelper nameHelper) throws IOException {
        this.version = cx.getLanguageVersion();
        this.itsData = new InterpreterData(0, 0, 0, securityDomain, cx.hasCompileFunctionsWithDynamicScope(), false);
        if (tree instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)tree;
            InterpretedFunction result = this.generateFunctionICode(cx, scope, f, securityDomain);
            result.itsData.itsFunctionType = f.getFunctionType();
            Interpreter.createFunctionObject(result, scope);
            return result;
        }
        return this.generateScriptICode(cx, scope, tree, securityDomain);
    }

    private void generateICodeFromTree(Node tree, VariableTable varTable, boolean needsActivation, Object securityDomain) {
        int theICodeTop = 0;
        this.itsVariableTable = varTable;
        this.itsData.itsNeedsActivation = needsActivation;
        this.itsData.itsICodeTop = theICodeTop = this.generateICode(tree, theICodeTop);
        if (this.itsEpilogLabel != -1) {
            this.markLabel(this.itsEpilogLabel, theICodeTop);
        }
        for (int i = 0; i < this.itsLabelTableTop; ++i) {
            this.itsLabelTable[i].fixGotos(this.itsData.itsICode);
        }
    }

    private Object[] generateRegExpLiterals(Context cx, Scriptable scope, Vector regexps) {
        Object[] result = new Object[regexps.size()];
        RegExpProxy rep = cx.getRegExpProxy();
        for (int i = 0; i < regexps.size(); ++i) {
            Node regexp = (Node)regexps.elementAt(i);
            Node left = regexp.getFirstChild();
            Node right = regexp.getLastChild();
            result[i] = rep.newRegExp(cx, scope, left.getString(), left != right ? right.getString() : null, false);
            regexp.putProp(12, new Integer(i));
        }
        return result;
    }

    private InterpretedScript generateScriptICode(Context cx, Scriptable scope, Node tree, Object securityDomain) {
        this.itsData.itsSourceFile = this.itsSourceFile = (String)tree.getProp(16);
        this.itsFunctionList = (Vector)tree.getProp(5);
        this.debugSource = (StringBuffer)tree.getProp(31);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scope, cx, securityDomain);
        }
        Object[] regExpLiterals = null;
        Vector regexps = (Vector)tree.getProp(12);
        if (regexps != null) {
            regExpLiterals = this.generateRegExpLiterals(cx, scope, regexps);
        }
        VariableTable varTable = (VariableTable)tree.getProp(10);
        boolean activationNeeded = cx.isGeneratingDebugChanged() && cx.isGeneratingDebug();
        this.generateICodeFromTree(tree, varTable, activationNeeded, securityDomain);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = regExpLiterals;
        String[] argNames = this.itsVariableTable.getAllNames();
        short argCount = (short)this.itsVariableTable.getParameterCount();
        InterpretedScript result = new InterpretedScript(cx, this.itsData, argNames, argCount);
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, result, this.debugSource);
        }
        return result;
    }

    private void generateNestedFunctions(Scriptable scope, Context cx, Object securityDomain) {
        this.itsNestedFunctions = new InterpretedFunction[this.itsFunctionList.size()];
        for (short i = 0; i < this.itsFunctionList.size(); i = (short)(i + 1)) {
            FunctionNode def = (FunctionNode)this.itsFunctionList.elementAt(i);
            Interpreter jsi = new Interpreter();
            jsi.itsSourceFile = this.itsSourceFile;
            jsi.itsData = new InterpreterData(0, 0, 0, securityDomain, cx.hasCompileFunctionsWithDynamicScope(), def.getCheckThis());
            jsi.itsData.itsFunctionType = def.getFunctionType();
            jsi.itsInFunctionFlag = true;
            jsi.debugSource = this.debugSource;
            this.itsNestedFunctions[i] = jsi.generateFunctionICode(cx, scope, def, securityDomain);
            def.putProp(5, new Short(i));
        }
    }

    private InterpretedFunction generateFunctionICode(Context cx, Scriptable scope, FunctionNode theFunction, Object securityDomain) {
        this.itsFunctionList = (Vector)theFunction.getProp(5);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scope, cx, securityDomain);
        }
        Object[] regExpLiterals = null;
        Vector regexps = (Vector)theFunction.getProp(12);
        if (regexps != null) {
            regExpLiterals = this.generateRegExpLiterals(cx, scope, regexps);
        }
        VariableTable varTable = theFunction.getVariableTable();
        boolean needsActivation = theFunction.requiresActivation() || cx.isGeneratingDebugChanged() && cx.isGeneratingDebug();
        this.generateICodeFromTree(theFunction.getLastChild(), varTable, needsActivation, securityDomain);
        this.itsData.itsName = theFunction.getFunctionName();
        this.itsData.itsSourceFile = (String)theFunction.getProp(16);
        this.itsData.itsSource = (String)theFunction.getProp(17);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = regExpLiterals;
        String[] argNames = this.itsVariableTable.getAllNames();
        short argCount = (short)this.itsVariableTable.getParameterCount();
        InterpretedFunction result = new InterpretedFunction(cx, this.itsData, argNames, argCount);
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, result, this.debugSource);
        }
        return result;
    }

    private int updateLineNumber(Node node, int iCodeTop) {
        Object datum = node.getDatum();
        if (datum == null || !(datum instanceof Number)) {
            return iCodeTop;
        }
        short lineNumber = ((Number)datum).shortValue();
        if (lineNumber != this.itsLineNumber) {
            this.itsLineNumber = lineNumber;
            if (this.itsData.itsLineNumberTable == null && Context.getCurrentContext().isGeneratingDebug()) {
                this.itsData.itsLineNumberTable = new UintMap();
            }
            if (this.itsData.itsLineNumberTable != null) {
                this.itsData.itsLineNumberTable.put((int)lineNumber, iCodeTop);
            }
            iCodeTop = this.addByte((byte)-109, iCodeTop);
            iCodeTop = this.addByte((byte)(lineNumber >> 8), iCodeTop);
            iCodeTop = this.addByte((byte)(lineNumber & 0xFF), iCodeTop);
        }
        return iCodeTop;
    }

    private void badTree(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : ".concat(String.valueOf(String.valueOf(node.toString()))));
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : ".concat(String.valueOf(String.valueOf(node.toString()))));
    }

    private int generateICode(Node node, int iCodeTop) {
        Node child;
        int type = node.getType();
        Node firstChild = child = node.getFirstChild();
        block0 : switch (type) {
            case 110: {
                iCodeTop = this.addByte((byte)55, iCodeTop);
                Node fn = (Node)node.getProp(5);
                Short index = (Short)fn.getProp(5);
                iCodeTop = this.addByte((byte)(index >> 8), iCodeTop);
                iCodeTop = this.addByte((byte)(index & 0xFF), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 146: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    if (child.getType() != 110) {
                        iCodeTop = this.generateICode(child, iCodeTop);
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            case 116: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                for (child = child.getNextSibling(); child != null; child = child.getNextSibling()) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNextSibling();
                }
                break;
            }
            case 96: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                break;
            }
            case 115: {
                Node branch;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                int theLocalSlot = this.itsData.itsMaxLocals++;
                iCodeTop = this.addByte((byte)69, iCodeTop);
                iCodeTop = this.addByte((byte)theLocalSlot, iCodeTop);
                iCodeTop = this.addByte((byte)57, iCodeTop);
                --this.itsStackDepth;
                Vector cases = (Vector)node.getProp(13);
                for (int i = 0; i < cases.size(); ++i) {
                    Node thisCase = (Node)cases.elementAt(i);
                    Node first = thisCase.getFirstChild();
                    iCodeTop = this.generateICode(first, iCodeTop);
                    iCodeTop = this.addByte((byte)70, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte((byte)theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte((byte)53, iCodeTop);
                    Node target = new Node(137);
                    thisCase.addChildAfter(target, first);
                    Node branch2 = new Node(7);
                    branch2.putProp(1, target);
                    iCodeTop = this.addGoto(branch2, 7, iCodeTop);
                    --this.itsStackDepth;
                }
                Node defaultNode = (Node)node.getProp(14);
                if (defaultNode != null) {
                    Node defaultTarget = new Node(137);
                    defaultNode.getFirstChild().addChildToFront(defaultTarget);
                    branch = new Node(6);
                    branch.putProp(1, defaultTarget);
                    iCodeTop = this.addGoto(branch, 6, iCodeTop);
                }
                Node breakTarget = (Node)node.getProp(2);
                branch = new Node(6);
                branch.putProp(1, breakTarget);
                iCodeTop = this.addGoto(branch, 6, iCodeTop);
                break;
            }
            case 137: {
                Object lblObect = node.getProp(20);
                if (lblObect == null) {
                    int label = this.markLabel(this.acquireLabel(), iCodeTop);
                    node.putProp(20, new Integer(label));
                } else {
                    int label = (Integer)lblObect;
                    this.markLabel(label, iCodeTop);
                }
                if (node.getProp(21) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 102: 
            case 103: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                int op = node.getInt();
                if (this.version == 120) {
                    if (op == 14) {
                        op = 53;
                    } else if (op == 15) {
                        op = 54;
                    }
                }
                iCodeTop = this.addByte((byte)op, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.itsSourceFile == null || this.itsData.itsSourceFile != null && this.itsSourceFile.equals(this.itsData.itsSourceFile))) {
                    this.itsData.itsSourceFile = this.itsSourceFile;
                }
                iCodeTop = this.addByte((byte)-108, iCodeTop);
                int childCount = 0;
                int nameIndex = -1;
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    if (nameIndex == -1) {
                        if (child.getType() == 44) {
                            nameIndex = (short)(this.itsData.itsStringTableIndex - 1);
                        } else if (child.getType() == 39) {
                            nameIndex = (short)(this.itsData.itsStringTableIndex - 1);
                        }
                    }
                    child = child.getNextSibling();
                    ++childCount;
                }
                if (node.getProp(30) != null) {
                    iCodeTop = this.addByte((byte)67, iCodeTop);
                    iCodeTop = this.addByte((byte)(this.itsLineNumber >> 8), iCodeTop);
                    iCodeTop = this.addByte((byte)(this.itsLineNumber & 0xFF), iCodeTop);
                    iCodeTop = this.addString(this.itsSourceFile, iCodeTop);
                } else {
                    iCodeTop = this.addByte((byte)type, iCodeTop);
                    iCodeTop = this.addByte((byte)(nameIndex >> 8), iCodeTop);
                    iCodeTop = this.addByte((byte)(nameIndex & 0xFF), iCodeTop);
                }
                this.itsStackDepth -= childCount - 1;
                childCount = type == 30 ? --childCount : (childCount -= 2);
                iCodeTop = this.addByte((byte)(childCount >> 8), iCodeTop);
                iCodeTop = this.addByte((byte)(childCount & 0xFF), iCodeTop);
                if (childCount > this.itsData.itsMaxArgs) {
                    this.itsData.itsMaxArgs = childCount;
                }
                iCodeTop = this.addByte((byte)-108, iCodeTop);
                break;
            }
            case 69: 
            case 144: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)69, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    iCodeTop = this.addByte((byte)66, iCodeTop);
                } else {
                    iCodeTop = this.addByte((byte)70, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node temp = (Node)node.getProp(7);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                break;
            }
            case 70: {
                iCodeTop = this.addByte((byte)70, iCodeTop);
                Node temp = (Node)node.getProp(6);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                iCodeTop = this.generateICode(child, iCodeTop);
                --this.itsStackDepth;
            }
            case 6: {
                iCodeTop = this.addGoto(node, (int)((byte)type), iCodeTop);
                break;
            }
            case 143: {
                Node target = (Node)node.getProp(1);
                target.putProp(21, node);
                iCodeTop = this.addGoto(node, 65, iCodeTop);
                break;
            }
            case 101: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int falseTarget = this.acquireLabel();
                iCodeTop = this.addGoto(falseTarget, 8, iCodeTop);
                iCodeTop = this.addByte((byte)57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.markLabel(falseTarget, iCodeTop);
                break;
            }
            case 100: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int trueTarget = this.acquireLabel();
                iCodeTop = this.addGoto(trueTarget, 7, iCodeTop);
                iCodeTop = this.addByte((byte)57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.markLabel(trueTarget, iCodeTop);
                break;
            }
            case 39: {
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(19);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte((byte)81, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte((byte)86, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)39, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 142: {
                iCodeTop = this.generateICode(child, iCodeTop);
                Object toType = node.getProp(18);
                if (toType == ScriptRuntime.NumberClass) {
                    iCodeTop = this.addByte((byte)58, iCodeTop);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 105: {
                iCodeTop = this.generateICode(child, iCodeTop);
                switch (node.getInt()) {
                    case 132: {
                        iCodeTop = this.addByte((byte)57, iCodeTop);
                        iCodeTop = this.addByte((byte)74, iCodeTop);
                        break block0;
                    }
                    case 129: {
                        int trueTarget = this.acquireLabel();
                        int beyond = this.acquireLabel();
                        iCodeTop = this.addGoto(trueTarget, 7, iCodeTop);
                        iCodeTop = this.addByte((byte)52, iCodeTop);
                        iCodeTop = this.addGoto(beyond, 6, iCodeTop);
                        this.markLabel(trueTarget, iCodeTop);
                        iCodeTop = this.addByte((byte)51, iCodeTop);
                        this.markLabel(beyond, iCodeTop);
                        break block0;
                    }
                    case 28: {
                        iCodeTop = this.addByte((byte)28, iCodeTop);
                        break block0;
                    }
                    case 32: {
                        iCodeTop = this.addByte((byte)32, iCodeTop);
                        break block0;
                    }
                    case 24: {
                        iCodeTop = this.addByte((byte)29, iCodeTop);
                        break block0;
                    }
                    case 23: {
                        iCodeTop = this.addByte((byte)58, iCodeTop);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(19);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte((byte)83, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte((byte)84, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)40, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)type, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)10, iCodeTop);
                iCodeTop = this.addString(firstChild.getString(), iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 32: {
                String name = node.getString();
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.itsVariableTable.getOrdinal(name);
                }
                if (index == -1) {
                    iCodeTop = this.addByte((byte)78, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                } else {
                    iCodeTop = this.addByte((byte)72, iCodeTop);
                    iCodeTop = this.addByte((byte)index, iCodeTop);
                    iCodeTop = this.addByte((byte)32, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 141: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)82, iCodeTop);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                iCodeTop = this.addByte((byte)type, iCodeTop);
                iCodeTop = this.addString(node.getString(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 106: 
            case 107: {
                int childType = child.getType();
                switch (childType) {
                    case 72: {
                        String name = child.getString();
                        if (this.itsData.itsNeedsActivation) {
                            iCodeTop = this.addByte((byte)85, iCodeTop);
                            iCodeTop = this.addByte((byte)46, iCodeTop);
                            iCodeTop = this.addString(name, iCodeTop);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            iCodeTop = this.addByte((byte)(type == 106 ? 34 : 37), iCodeTop);
                            --this.itsStackDepth;
                            break;
                        }
                        iCodeTop = this.addByte((byte)(type == 106 ? 59 : 60), iCodeTop);
                        int i = this.itsVariableTable.getOrdinal(name);
                        iCodeTop = this.addByte((byte)i, iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node getPropChild = child.getFirstChild();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        getPropChild = getPropChild.getNextSibling();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        iCodeTop = childType == 39 ? this.addByte((byte)(type == 106 ? 34 : 37), iCodeTop) : this.addByte((byte)(type == 106 ? 35 : 38), iCodeTop);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        iCodeTop = this.addByte((byte)(type == 106 ? 33 : 36), iCodeTop);
                        iCodeTop = this.addString(child.getString(), iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double num = node.getDouble();
                if (num == 0.0) {
                    iCodeTop = this.addByte((byte)47, iCodeTop);
                } else if (num == 1.0) {
                    iCodeTop = this.addByte((byte)48, iCodeTop);
                } else {
                    iCodeTop = this.addByte((byte)45, iCodeTop);
                    iCodeTop = this.addNumber(num, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
            }
            case 3: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 68: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)type, iCodeTop);
                break;
            }
            case 77: {
                iCodeTop = this.addByte((byte)type, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                iCodeTop = this.addByte((byte)type, iCodeTop);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node catchTarget = (Node)node.getProp(1);
                Node finallyTarget = (Node)node.getProp(21);
                if (catchTarget == null) {
                    iCodeTop = this.addByte((byte)75, iCodeTop);
                    iCodeTop = this.addByte((byte)0, iCodeTop);
                    iCodeTop = this.addByte((byte)0, iCodeTop);
                } else {
                    iCodeTop = this.addGoto(node, 75, iCodeTop);
                }
                int finallyHandler = 0;
                if (finallyTarget != null) {
                    finallyHandler = this.acquireLabel();
                    int theLabel = finallyHandler & Integer.MAX_VALUE;
                    this.itsLabelTable[theLabel].addFixup(iCodeTop);
                }
                iCodeTop = this.addByte((byte)0, iCodeTop);
                iCodeTop = this.addByte((byte)0, iCodeTop);
                Node lastChild = null;
                boolean insertedEndTry = false;
                while (child != null) {
                    if (catchTarget != null && lastChild == catchTarget) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    Node nextSibling = child.getNextSibling();
                    if (!(insertedEndTry || nextSibling == null || nextSibling != catchTarget && nextSibling != finallyTarget)) {
                        iCodeTop = this.addByte((byte)76, iCodeTop);
                        insertedEndTry = true;
                    }
                    iCodeTop = this.generateICode(child, iCodeTop);
                    lastChild = child;
                    child = child.getNextSibling();
                }
                this.itsStackDepth = 0;
                if (finallyTarget != null) {
                    int skippy = this.acquireLabel();
                    iCodeTop = this.addGoto(skippy, 6, iCodeTop);
                    this.markLabel(finallyHandler, iCodeTop);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int theLocalSlot = this.itsData.itsMaxLocals++;
                    iCodeTop = this.addByte((byte)69, iCodeTop);
                    iCodeTop = this.addByte((byte)theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte((byte)57, iCodeTop);
                    Integer finallyLabel = (Integer)finallyTarget.getProp(20);
                    iCodeTop = this.addGoto(finallyLabel, 65, iCodeTop);
                    iCodeTop = this.addByte((byte)70, iCodeTop);
                    iCodeTop = this.addByte((byte)theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte((byte)88, iCodeTop);
                    this.itsStackDepth = 0;
                    this.markLabel(skippy, iCodeTop);
                }
                --this.itsTryDepth;
                break;
            }
            case 62: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)62, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                if (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                } else {
                    iCodeTop = this.addByte((byte)74, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                iCodeTop = this.addGoto(node, 5, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 72: {
                String name = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    iCodeTop = this.addByte((byte)85, iCodeTop);
                    iCodeTop = this.addByte((byte)46, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte((byte)39, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte((byte)72, iCodeTop);
                iCodeTop = this.addByte((byte)index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    child.setType(61);
                    node.setType(10);
                    iCodeTop = this.generateICode(node, iCodeTop);
                    break;
                }
                String name = child.getString();
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte((byte)73, iCodeTop);
                iCodeTop = this.addByte((byte)index, iCodeTop);
                break;
            }
            case 109: {
                iCodeTop = this.addByte((byte)node.getInt(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte((byte)79, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 80: {
                iCodeTop = this.addByte((byte)80, iCodeTop);
                Node init = (Node)node.getProp(4);
                iCodeTop = this.addLocalRef(init, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                Node regexp = (Node)node.getProp(12);
                int index = (Integer)regexp.getProp(12);
                iCodeTop = this.addByte((byte)56, iCodeTop);
                iCodeTop = this.addByte((byte)(index >> 8), iCodeTop);
                iCodeTop = this.addByte((byte)(index & 0xFF), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
                break;
            }
        }
        return iCodeTop;
    }

    private int addLocalRef(Node node, int iCodeTop) {
        int theLocalSlot;
        Integer localProp = (Integer)node.getProp(7);
        if (localProp == null) {
            theLocalSlot = this.itsData.itsMaxLocals++;
            node.putProp(7, new Integer(theLocalSlot));
        } else {
            theLocalSlot = localProp;
        }
        iCodeTop = this.addByte((byte)theLocalSlot, iCodeTop);
        if (theLocalSlot >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = theLocalSlot + 1;
        }
        return iCodeTop;
    }

    private int addGoto(Node node, int gotoOp, int iCodeTop) {
        int targetLabel;
        if (node.getType() == 5) {
            if (this.itsEpilogLabel == -1) {
                this.itsEpilogLabel = this.acquireLabel();
            }
            targetLabel = this.itsEpilogLabel;
        } else {
            Node target = (Node)node.getProp(1);
            Object lblObect = target.getProp(20);
            if (lblObect == null) {
                targetLabel = this.acquireLabel();
                target.putProp(20, new Integer(targetLabel));
            } else {
                targetLabel = (Integer)lblObect;
            }
        }
        iCodeTop = this.addGoto(targetLabel, (int)((byte)gotoOp), iCodeTop);
        return iCodeTop;
    }

    private int addGoto(int targetLabel, int gotoOp, int iCodeTop) {
        int gotoPC = iCodeTop;
        iCodeTop = this.addByte((byte)gotoOp, iCodeTop);
        int theLabel = targetLabel & Integer.MAX_VALUE;
        short targetPC = this.itsLabelTable[theLabel].getPC();
        if (targetPC != -1) {
            short offset = (short)(targetPC - gotoPC);
            iCodeTop = this.addByte((byte)(offset >> 8), iCodeTop);
            iCodeTop = this.addByte((byte)offset, iCodeTop);
        } else {
            this.itsLabelTable[theLabel].addFixup(gotoPC + 1);
            iCodeTop = this.addByte((byte)0, iCodeTop);
            iCodeTop = this.addByte((byte)0, iCodeTop);
        }
        return iCodeTop;
    }

    private final int addByte(byte b, int iCodeTop) {
        if (this.itsData.itsICode.length == iCodeTop) {
            byte[] ba = new byte[iCodeTop * 2];
            System.arraycopy(this.itsData.itsICode, 0, ba, 0, iCodeTop);
            this.itsData.itsICode = ba;
        }
        this.itsData.itsICode[iCodeTop++] = b;
        return iCodeTop;
    }

    private final int addString(String str, int iCodeTop) {
        int index = this.itsData.itsStringTableIndex;
        if (this.itsData.itsStringTable.length == index) {
            String[] sa = new String[index * 2];
            System.arraycopy(this.itsData.itsStringTable, 0, sa, 0, index);
            this.itsData.itsStringTable = sa;
        }
        this.itsData.itsStringTable[index] = str;
        this.itsData.itsStringTableIndex = index + 1;
        iCodeTop = this.addByte((byte)(index >> 8), iCodeTop);
        iCodeTop = this.addByte((byte)(index & 0xFF), iCodeTop);
        return iCodeTop;
    }

    private final int addNumber(double num, int iCodeTop) {
        int index = this.itsData.itsNumberTableIndex;
        if (this.itsData.itsNumberTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsNumberTable, 0, na, 0, index);
            this.itsData.itsNumberTable = na;
        }
        this.itsData.itsNumberTable[index] = num;
        this.itsData.itsNumberTableIndex = index + 1;
        iCodeTop = this.addByte((byte)(index >> 8), iCodeTop);
        iCodeTop = this.addByte((byte)(index & 0xFF), iCodeTop);
        return iCodeTop;
    }

    private static String getString(String[] theStringTable, byte[] iCode, int pc) {
        int index = (iCode[pc] << 8) + (iCode[pc + 1] & 0xFF);
        return theStringTable[index];
    }

    private static double getNumber(double[] theNumberTable, byte[] iCode, int pc) {
        int index = (iCode[pc] << 8) + (iCode[pc + 1] & 0xFF);
        return theNumberTable[index];
    }

    private static int getTarget(byte[] iCode, int pc) {
        int displacement = (iCode[pc] << 8) + (iCode[pc + 1] & 0xFF);
        return pc - 1 + displacement;
    }

    private static void dumpICode(InterpreterData theData) {
    }

    private static void createFunctionObject(InterpretedFunction fn, Scriptable scope) {
        fn.setPrototype(ScriptableObject.getClassPrototype(scope, "Function"));
        fn.setParentScope(scope);
        InterpreterData id = fn.itsData;
        if (id.itsName.length() == 0) {
            return;
        }
        if (id.itsFunctionType == 1 && fn.itsClosure == null || id.itsFunctionType == 3 && fn.itsClosure != null) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    public static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) throws JavaScriptException {
        Object result;
        block196: {
            int i;
            int maxStack = theData.itsMaxStack;
            int maxVars = fnOrScript.argNames == null ? 0 : fnOrScript.argNames.length;
            int maxLocals = theData.itsMaxLocals;
            int maxTryDepth = theData.itsMaxTryDepth;
            int VAR_SHFT = maxStack;
            int LOCAL_SHFT = VAR_SHFT + maxVars;
            int TRY_SCOPE_SHFT = LOCAL_SHFT + maxLocals;
            Object DBL_MRK = Interpreter.DBL_MRK;
            Object[] stack = new Object[TRY_SCOPE_SHFT + maxTryDepth];
            double[] sDbl = new double[TRY_SCOPE_SHFT];
            int stackTop = -1;
            byte[] iCode = theData.itsICode;
            int pc = 0;
            int iCodeLength = theData.itsICodeTop;
            Scriptable undefined = Undefined.instance;
            if (maxVars != 0) {
                int definedArgs = fnOrScript.argCount;
                if (definedArgs != 0) {
                    if (definedArgs > args.length) {
                        definedArgs = args.length;
                    }
                    for (i = 0; i != definedArgs; ++i) {
                        stack[VAR_SHFT + i] = args[i];
                    }
                }
                for (i = definedArgs; i != maxVars; ++i) {
                    stack[VAR_SHFT + i] = undefined;
                }
            }
            if (theData.itsNestedFunctions != null) {
                for (i = 0; i < theData.itsNestedFunctions.length; ++i) {
                    Interpreter.createFunctionObject(theData.itsNestedFunctions[i], scope);
                }
            }
            String name = null;
            int[] catchStack = null;
            int tryStackTop = 0;
            InterpreterFrame frame = null;
            if (cx.debugger != null) {
                frame = new InterpreterFrame(scope, theData, fnOrScript);
                cx.pushFrame(frame);
            }
            if (maxTryDepth != 0) {
                catchStack = new int[maxTryDepth * 2];
            }
            Object savedSecurityDomain = cx.interpreterSecurityDomain;
            cx.interpreterSecurityDomain = theData.securityDomain;
            result = undefined;
            int pcPrevBranch = pc;
            int instructionThreshold = cx.instructionThreshold;
            int instructionCount = cx.instructionCount;
            block96: while (pc < iCodeLength) {
                try {
                    switch (iCode[pc] & 0xFF) {
                        case 76: {
                            --tryStackTop;
                            break;
                        }
                        case 75: {
                            i = Interpreter.getTarget(iCode, pc + 1);
                            if (i == pc) {
                                i = 0;
                            }
                            catchStack[tryStackTop * 2] = i;
                            i = Interpreter.getTarget(iCode, pc + 3);
                            if (i == pc + 2) {
                                i = 0;
                            }
                            catchStack[tryStackTop * 2 + 1] = i;
                            stack[TRY_SCOPE_SHFT + tryStackTop] = scope;
                            ++tryStackTop;
                            pc += 4;
                            break;
                        }
                        case 19: {
                            boolean valBln;
                            double lDbl;
                            double rDbl;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 17: {
                            boolean valBln;
                            double lDbl;
                            double rDbl;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 18: {
                            boolean valBln;
                            double lDbl;
                            double rDbl;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 16: {
                            boolean valBln;
                            double lDbl;
                            double rDbl;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 63: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.in(lhs, rhs, scope)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 64: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.instanceOf(scope, lhs, rhs)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 14: {
                            boolean valBln = Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 15: {
                            boolean valBln = !Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 53: {
                            boolean valBln = Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 54: {
                            boolean valBln = !Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 8: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? !ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) != valDbl || valDbl == 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block96;
                            }
                            pc += 2;
                            break;
                        }
                        case 7: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) == valDbl && valDbl != 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block96;
                            }
                            pc += 2;
                            break;
                        }
                        case 6: {
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block96;
                        }
                        case 65: {
                            sDbl[++stackTop] = pc + 3;
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block96;
                        }
                        case 66: {
                            int slot = iCode[pc + 1] & 0xFF;
                            if (instructionThreshold != 0 && (instructionCount += pc + 2 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = (int)sDbl[LOCAL_SHFT + slot];
                            continue block96;
                        }
                        case 57: {
                            --stackTop;
                            break;
                        }
                        case 9: {
                            stack[stackTop + 1] = stack[stackTop];
                            sDbl[stackTop + 1] = sDbl[stackTop];
                            ++stackTop;
                            break;
                        }
                        case 2: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break;
                        }
                        case 5: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            pc = Interpreter.getTarget(iCode, pc + 1);
                            break;
                        }
                        case 28: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ~rIntValue;
                            break;
                        }
                        case 13: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue & rIntValue;
                            break;
                        }
                        case 11: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue | rIntValue;
                            break;
                        }
                        case 12: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue ^ rIntValue;
                            break;
                        }
                        case 20: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue << rIntValue;
                            break;
                        }
                        case 21: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue >> rIntValue;
                            break;
                        }
                        case 22: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop) & 0x1F;
                            long lLongValue = Interpreter.stack_uint32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lLongValue >>> rIntValue;
                            break;
                        }
                        case 23: {
                            Interpreter.do_add(stack, sDbl, --stackTop);
                            break;
                        }
                        case 24: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl - rDbl;
                            break;
                        }
                        case 29: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = -rDbl;
                            break;
                        }
                        case 58: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = rDbl;
                            break;
                        }
                        case 25: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl * rDbl;
                            break;
                        }
                        case 26: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl / rDbl;
                            break;
                        }
                        case 27: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl % rDbl;
                            break;
                        }
                        case 61: {
                            stack[++stackTop] = ScriptRuntime.bind(scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 71: {
                            stack[++stackTop] = ScriptRuntime.getBase(scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 10: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setName((Scriptable)lhs, rhs, scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 31: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.delete(lhs, rhs);
                            break;
                        }
                        case 39: {
                            name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProp(lhs, name, scope);
                            break;
                        }
                        case 40: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            name = (String)stack[--stackTop];
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProp(lhs, name, rhs, scope);
                            break;
                        }
                        case 41: {
                            Object lhs;
                            Object id = stack[stackTop];
                            if (id == DBL_MRK) {
                                id = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getElem(lhs, id, scope);
                            break;
                        }
                        case 42: {
                            Object id;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((id = stack[--stackTop]) == DBL_MRK) {
                                id = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setElem(lhs, id, rhs, scope);
                            break;
                        }
                        case 34: {
                            name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrement(lhs, name, scope);
                            break;
                        }
                        case 37: {
                            name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrement(lhs, name, scope);
                            break;
                        }
                        case 35: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, scope);
                            break;
                        }
                        case 38: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, scope);
                            break;
                        }
                        case 68: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getThis((Scriptable)lhs);
                            break;
                        }
                        case 69: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[LOCAL_SHFT + slot] = stack[stackTop];
                            sDbl[LOCAL_SHFT + slot] = sDbl[stackTop];
                            break;
                        }
                        case 70: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[LOCAL_SHFT + slot];
                            sDbl[stackTop] = sDbl[LOCAL_SHFT + slot];
                            break;
                        }
                        case 67: {
                            Object val;
                            Object lhs;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int lineNum = iCode[pc + 1] << 8 | iCode[pc + 2] & 0xFF;
                            name = Interpreter.getString(theData.itsStringTable, iCode, pc + 3);
                            int count = iCode[pc + 5] << 8 | iCode[pc + 6] & 0xFF;
                            Object[] outArgs = new Object[count];
                            for (i = count - 1; i >= 0; --i) {
                                val = stack[stackTop];
                                if (val == DBL_MRK) {
                                    val = Interpreter.doubleWrap(sDbl[stackTop]);
                                }
                                outArgs[i] = val;
                                --stackTop;
                            }
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.callSpecial(cx, lhs, rhs, outArgs, thisObj, scope, name, lineNum);
                            pc += 6;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 43: {
                            Object val;
                            Object lhs;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            cx.instructionCount = instructionCount;
                            int count = iCode[pc + 3] << 8 | iCode[pc + 4] & 0xFF;
                            Object[] outArgs = new Object[count];
                            for (i = count - 1; i >= 0; --i) {
                                val = stack[stackTop];
                                if (val == DBL_MRK) {
                                    val = Interpreter.doubleWrap(sDbl[stackTop]);
                                }
                                outArgs[i] = val;
                                --stackTop;
                            }
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if (lhs == undefined) {
                                lhs = Interpreter.getString(theData.itsStringTable, iCode, pc + 1);
                            }
                            Scriptable calleeScope = scope;
                            if (theData.itsNeedsActivation) {
                                calleeScope = ScriptableObject.getTopLevelScope(scope);
                            }
                            stack[stackTop] = ScriptRuntime.call(cx, lhs, rhs, outArgs, calleeScope);
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 30: {
                            Object val;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int count = iCode[pc + 3] << 8 | iCode[pc + 4] & 0xFF;
                            Object[] outArgs = new Object[count];
                            for (i = count - 1; i >= 0; --i) {
                                val = stack[stackTop];
                                if (val == DBL_MRK) {
                                    val = Interpreter.doubleWrap(sDbl[stackTop]);
                                }
                                outArgs[i] = val;
                                --stackTop;
                            }
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if (lhs == undefined && (iCode[pc + 1] << 8) + (iCode[pc + 2] & 0xFF) != -1) {
                                lhs = Interpreter.getString(theData.itsStringTable, iCode, pc + 1);
                            }
                            stack[stackTop] = ScriptRuntime.newObject(cx, lhs, outArgs, scope);
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 32: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.typeof(lhs);
                            break;
                        }
                        case 78: {
                            name = Interpreter.getString(theData.itsStringTable, iCode, pc + 1);
                            stack[++stackTop] = ScriptRuntime.typeofName(scope, name);
                            pc += 2;
                            break;
                        }
                        case 46: {
                            stack[++stackTop] = Interpreter.getString(theData.itsStringTable, iCode, pc + 1);
                            pc += 2;
                            break;
                        }
                        case 45: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getNumber(theData.itsNumberTable, iCode, pc + 1);
                            pc += 2;
                            break;
                        }
                        case 44: {
                            stack[++stackTop] = ScriptRuntime.name(scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 33: {
                            stack[++stackTop] = ScriptRuntime.postIncrement(scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 36: {
                            stack[++stackTop] = ScriptRuntime.postDecrement(scope, Interpreter.getString(theData.itsStringTable, iCode, pc + 1));
                            pc += 2;
                            break;
                        }
                        case 73: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[VAR_SHFT + slot] = stack[stackTop];
                            sDbl[VAR_SHFT + slot] = sDbl[stackTop];
                            break;
                        }
                        case 72: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[VAR_SHFT + slot];
                            sDbl[stackTop] = sDbl[VAR_SHFT + slot];
                            break;
                        }
                        case 59: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[VAR_SHFT + slot];
                            sDbl[stackTop] = sDbl[VAR_SHFT + slot];
                            stack[VAR_SHFT + slot] = DBL_MRK;
                            sDbl[VAR_SHFT + slot] = Interpreter.stack_double(stack, sDbl, stackTop) + 1.0;
                            break;
                        }
                        case 60: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[VAR_SHFT + slot];
                            sDbl[stackTop] = sDbl[VAR_SHFT + slot];
                            stack[VAR_SHFT + slot] = DBL_MRK;
                            sDbl[VAR_SHFT + slot] = Interpreter.stack_double(stack, sDbl, stackTop) - 1.0;
                            break;
                        }
                        case 47: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 0.0;
                            break;
                        }
                        case 48: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 1.0;
                            break;
                        }
                        case 49: {
                            stack[++stackTop] = null;
                            break;
                        }
                        case 50: {
                            stack[++stackTop] = thisObj;
                            break;
                        }
                        case 87: {
                            stack[++stackTop] = fnOrScript;
                            break;
                        }
                        case 51: {
                            stack[++stackTop] = Boolean.FALSE;
                            break;
                        }
                        case 52: {
                            stack[++stackTop] = Boolean.TRUE;
                            break;
                        }
                        case 74: {
                            stack[++stackTop] = Undefined.instance;
                            break;
                        }
                        case 62: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            throw new JavaScriptException(result);
                        }
                        case 88: {
                            result = stack[stackTop];
                            --stackTop;
                            if (result instanceof JavaScriptException) {
                                throw (JavaScriptException)result;
                            }
                            throw (RuntimeException)result;
                        }
                        case 3: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            scope = ScriptRuntime.enterWith(lhs, scope);
                            break;
                        }
                        case 4: {
                            scope = ScriptRuntime.leaveWith(scope);
                            break;
                        }
                        case 77: {
                            stack[++stackTop] = ScriptRuntime.newScope();
                            break;
                        }
                        case 79: {
                            int slot = iCode[++pc] & 0xFF;
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            stack[LOCAL_SHFT + slot] = ScriptRuntime.initEnum(lhs, scope);
                            break;
                        }
                        case 80: {
                            int slot = iCode[++pc] & 0xFF;
                            Object val = stack[LOCAL_SHFT + slot];
                            stack[++stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                            break;
                        }
                        case 81: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProto(lhs, scope);
                            break;
                        }
                        case 82: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs);
                            break;
                        }
                        case 86: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs, scope);
                            break;
                        }
                        case 83: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProto(lhs, rhs, scope);
                            break;
                        }
                        case 84: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setParent(lhs, rhs, scope);
                            break;
                        }
                        case 85: {
                            stack[++stackTop] = scope;
                            break;
                        }
                        case 55: {
                            i = iCode[pc + 1] << 8 | iCode[pc + 2] & 0xFF;
                            stack[++stackTop] = new InterpretedFunction(theData.itsNestedFunctions[i], scope, cx);
                            Interpreter.createFunctionObject((InterpretedFunction)stack[stackTop], scope);
                            pc += 2;
                            break;
                        }
                        case 56: {
                            i = iCode[pc + 1] << 8 | iCode[pc + 2] & 0xFF;
                            stack[++stackTop] = theData.itsRegExpLiterals[i];
                            pc += 2;
                            break;
                        }
                        case 148: {
                            cx.interpreterSourceFile = theData.itsSourceFile;
                            break;
                        }
                        case 147: 
                        case 149: {
                            cx.interpreterLine = i = iCode[pc + 1] << 8 | iCode[pc + 2] & 0xFF;
                            if (frame != null) {
                                frame.setLineNumber(i);
                            }
                            if ((iCode[pc] & 0xFF) == 149 || cx.inLineStepMode) {
                                cx.getDebuggableEngine().getDebugger().handleBreakpointHit(cx);
                            }
                            pc += 2;
                            break;
                        }
                        default: {
                            Interpreter.dumpICode(theData);
                            throw new RuntimeException(String.valueOf(String.valueOf(new StringBuffer("Unknown icode : ").append(iCode[pc] & 0xFF).append(" @ pc : ").append(pc))));
                        }
                    }
                    ++pc;
                }
                catch (Throwable ex) {
                    int exType;
                    Object errObj;
                    cx.interpreterSecurityDomain = null;
                    if (instructionThreshold != 0) {
                        if (instructionCount < 0) {
                            instructionCount = cx.instructionCount;
                        } else {
                            cx.instructionCount = instructionCount += pc - pcPrevBranch;
                        }
                    }
                    if (ex instanceof JavaScriptException) {
                        errObj = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)ex);
                        exType = 0;
                    } else if (ex instanceof EcmaError) {
                        errObj = ((EcmaError)ex).getErrorObject();
                        exType = 1;
                    } else if (ex instanceof RuntimeException) {
                        errObj = ex;
                        exType = 2;
                    } else {
                        errObj = ex;
                        exType = 3;
                    }
                    if (exType != 3 && cx.debugger != null) {
                        cx.debugger.handleExceptionThrown(cx, errObj);
                    }
                    boolean rethrow = true;
                    if (exType != 3 && tryStackTop > 0) {
                        if ((exType == 0 || exType == 1) && (pc = catchStack[--tryStackTop * 2]) != 0) {
                            rethrow = false;
                        }
                        if (rethrow && (pc = catchStack[tryStackTop * 2 + 1]) != 0) {
                            rethrow = false;
                            errObj = ex;
                        }
                    }
                    if (rethrow) {
                        if (frame != null) {
                            cx.popFrame();
                        }
                        if (exType == 0) {
                            throw (JavaScriptException)ex;
                        }
                        if (exType == 1 || exType == 2) {
                            throw (RuntimeException)ex;
                        }
                        throw (Error)ex;
                    }
                    if (instructionThreshold != 0 && instructionCount > instructionThreshold) {
                        cx.observeInstructionCount(instructionCount);
                        instructionCount = 0;
                    }
                    pcPrevBranch = pc;
                    scope = (Scriptable)stack[TRY_SCOPE_SHFT + tryStackTop];
                    stackTop = 0;
                    stack[0] = errObj;
                    cx.interpreterSecurityDomain = theData.securityDomain;
                }
            }
            cx.interpreterSecurityDomain = savedSecurityDomain;
            if (frame != null) {
                cx.popFrame();
            }
            if (instructionThreshold == 0) break block196;
            if (instructionCount > instructionThreshold) {
                cx.observeInstructionCount(instructionCount);
                instructionCount = 0;
            }
            cx.instructionCount = instructionCount;
        }
        return result;
    }

    private static Object doubleWrap(double x) {
        return new Double(x);
    }

    private static int stack_int32(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toInt32(x) : ScriptRuntime.toInt32(stackDbl[i]);
    }

    private static long stack_uint32(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toUint32(x) : ScriptRuntime.toUint32(stackDbl[i]);
    }

    private static double stack_double(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toNumber(x) : stackDbl[i];
    }

    private static void do_add(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                int n = stackTop;
                stackDbl[n] = stackDbl[n] + rDbl;
            } else {
                Interpreter.do_add(lhs, rDbl, stack, stackDbl, stackTop, true);
            }
        } else if (lhs == DBL_MRK) {
            Interpreter.do_add(rhs, stackDbl[stackTop], stack, stackDbl, stackTop, false);
        } else {
            if (lhs instanceof Scriptable) {
                lhs = ((Scriptable)lhs).getDefaultValue(null);
            }
            if (rhs instanceof Scriptable) {
                rhs = ((Scriptable)rhs).getDefaultValue(null);
            }
            if (lhs instanceof String || rhs instanceof String) {
                stack[stackTop] = String.valueOf(String.valueOf(ScriptRuntime.toString(lhs))).concat(String.valueOf(String.valueOf(ScriptRuntime.toString(rhs))));
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(rhs);
                stack[stackTop] = DBL_MRK;
                stackDbl[stackTop] = lDbl + rDbl;
            }
        }
    }

    private static void do_add(Object lhs, double rDbl, Object[] stack, double[] stackDbl, int stackTop, boolean left_right_order) {
        if (lhs instanceof Scriptable) {
            if (lhs == Undefined.instance) {
                lhs = ScriptRuntime.NaNobj;
            }
            lhs = ((Scriptable)lhs).getDefaultValue(null);
        }
        if (lhs instanceof String) {
            stack[stackTop] = left_right_order ? String.valueOf(String.valueOf((String)lhs)).concat(String.valueOf(String.valueOf(ScriptRuntime.toString(rDbl)))) : String.valueOf(String.valueOf(ScriptRuntime.toString(rDbl))).concat(String.valueOf(String.valueOf((String)lhs)));
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
            stack[stackTop] = DBL_MRK;
            stackDbl[stackTop] = lDbl + rDbl;
        }
    }

    private static boolean do_eq(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        boolean result = rhs == DBL_MRK ? (lhs == DBL_MRK ? stackDbl[stackTop] == stackDbl[stackTop + 1] : Interpreter.do_eq(stackDbl[stackTop + 1], lhs)) : (lhs == DBL_MRK ? Interpreter.do_eq(stackDbl[stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
        return result;
    }

    private static boolean do_eq(double x, Object y) {
        while (true) {
            if (y instanceof Number) {
                return x == ((Number)y).doubleValue();
            }
            if (y instanceof String) {
                return x == ScriptRuntime.toNumber((String)y);
            }
            if (y instanceof Boolean) {
                return x == (double)((Boolean)y != false ? 1 : 0);
            }
            if (!(y instanceof Scriptable)) break;
            if (y == Undefined.instance) {
                return false;
            }
            y = ScriptRuntime.toPrimitive(y);
        }
        return false;
    }

    private static boolean do_sheq(Object[] stack, double[] stackDbl, int stackTop) {
        boolean result;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else if (rhs instanceof Number) {
            double rDbl = ((Number)rhs).doubleValue();
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else {
            result = ScriptRuntime.shallowEq(lhs, rhs);
        }
        return result;
    }

    static {
        printICode = false;
        DBL_MRK = new Object();
    }
}

