/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.UintMap;

class InterpreterData {
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    String itsName;
    String itsSource;
    String itsSourceFile;
    boolean itsNeedsActivation;
    boolean itsFromEvalCode;
    boolean itsUseDynamicScope;
    boolean itsCheckThis;
    byte itsFunctionType;
    String[] itsStringTable;
    int itsStringTableIndex;
    double[] itsNumberTable;
    int itsNumberTableIndex;
    InterpretedFunction[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode;
    int itsICodeTop;
    int itsMaxLocals;
    int itsMaxArgs;
    int itsMaxStack;
    int itsMaxTryDepth;
    UintMap itsLineNumberTable;
    Object securityDomain;

    InterpreterData(int lastICodeTop, int lastStringTableIndex, int lastNumberTableIndex, Object securityDomain, boolean useDynamicScope, boolean checkThis) {
        this.itsICodeTop = lastICodeTop == 0 ? 1024 : lastICodeTop * 2;
        this.itsICode = new byte[this.itsICodeTop];
        this.itsStringTable = new String[lastStringTableIndex == 0 ? 64 : lastStringTableIndex * 2];
        this.itsNumberTable = new double[lastNumberTableIndex == 0 ? 64 : lastNumberTableIndex * 2];
        this.itsUseDynamicScope = useDynamicScope;
        this.itsCheckThis = checkThis;
        if (securityDomain == null) {
            Context.checkSecurityDomainRequired();
        }
        this.securityDomain = securityDomain;
    }

    public boolean placeBreakpoint(int line) {
        int offset = this.getOffset(line);
        if (offset != -1 && (this.itsICode[offset] == -109 || this.itsICode[offset] == -107)) {
            this.itsICode[offset] = -107;
            return true;
        }
        return false;
    }

    public boolean removeBreakpoint(int line) {
        int offset = this.getOffset(line);
        if (offset != -1 && this.itsICode[offset] == -107) {
            this.itsICode[offset] = -109;
            return true;
        }
        return false;
    }

    private int getOffset(int line) {
        int offset = this.itsLineNumberTable.getInt(line, -1);
        if (offset >= 0 && offset <= this.itsICode.length) {
            return offset;
        }
        return -1;
    }

    static {
        INITIAL_MAX_ICODE_LENGTH = 1024;
        INITIAL_STRINGTABLE_SIZE = 64;
        INITIAL_NUMBERTABLE_SIZE = 64;
    }
}

