/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

public class Label {
    private static final int FIXUPTABLE_SIZE = 8;
    private static final boolean DEBUG = true;
    private short itsPC = (short)-1;
    private int[] itsFixupTable;
    private int itsFixupTableTop;

    public short getPC() {
        return this.itsPC;
    }

    public void fixGotos(byte[] theCodeBuffer) {
        if (this.itsPC == -1 && this.itsFixupTable != null) {
            throw new RuntimeException("Unlocated label");
        }
        if (this.itsFixupTable != null) {
            for (int i = 0; i < this.itsFixupTableTop; ++i) {
                int fixupSite = this.itsFixupTable[i];
                short offset = (short)(this.itsPC - (fixupSite - 1));
                theCodeBuffer[fixupSite++] = (byte)(offset >> 8);
                theCodeBuffer[fixupSite] = (byte)offset;
            }
        }
        this.itsFixupTable = null;
    }

    public void setPC(short thePC) {
        if (this.itsPC != -1 && this.itsPC != thePC) {
            throw new RuntimeException("Duplicate label");
        }
        this.itsPC = thePC;
    }

    public void addFixup(int fixupSite) {
        if (this.itsFixupTable == null) {
            this.itsFixupTableTop = 1;
            this.itsFixupTable = new int[8];
            this.itsFixupTable[0] = fixupSite;
        } else {
            if (this.itsFixupTableTop == this.itsFixupTable.length) {
                int oldLength = this.itsFixupTable.length;
                int[] newTable = new int[oldLength + 8];
                System.arraycopy(this.itsFixupTable, 0, newTable, 0, oldLength);
                this.itsFixupTable = newTable;
            }
            this.itsFixupTable[this.itsFixupTableTop++] = fixupSite;
        }
    }

    static {
        FIXUPTABLE_SIZE = 8;
        DEBUG = true;
    }
}

