/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;

final class LineBuffer {
    static final int BUFLEN = 256;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private int stringStart = -1;
    private StringBuffer stringSoFar = null;
    private boolean hadCFSinceStringStart = false;

    LineBuffer(Reader in, int lineno) {
        this.in = in;
        this.lineno = lineno;
    }

    int read() throws IOException {
        while (true) {
            if (this.end == this.offset && !this.fill()) {
                return -1;
            }
            if ((this.buffer[this.offset] & 0xDFD0) == 0) {
                if (this.buffer[this.offset] == '\r') {
                    if (this.offset + 1 < this.end) {
                        if (this.buffer[this.offset + 1] == '\n') {
                            ++this.offset;
                        }
                    } else {
                        this.lastWasCR = true;
                    }
                } else if (this.buffer[this.offset] != '\n' && this.buffer[this.offset] != '\u2028' && this.buffer[this.offset] != '\u2029') {
                    if (Character.getType(this.buffer[this.offset]) == 16) {
                        this.hadCFSinceStringStart = true;
                        ++this.offset;
                        continue;
                    }
                    return this.buffer[this.offset++];
                }
                ++this.offset;
                this.prevStart = this.lineStart;
                this.lineStart = this.offset;
                ++this.lineno;
                return 10;
            }
            if (this.buffer[this.offset] < '\u0080' || Character.getType(this.buffer[this.offset]) != 16) break;
            this.hadCFSinceStringStart = true;
            ++this.offset;
        }
        return this.buffer[this.offset++];
    }

    void unread() {
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        if ((this.buffer[this.offset] & 0xFFF0) == 0 && (this.buffer[this.offset] == '\r' || this.buffer[this.offset] == '\n')) {
            this.lineStart = this.prevStart;
            --this.lineno;
        }
    }

    int peek() throws IOException {
        if (this.end == this.offset && !this.fill()) {
            return -1;
        }
        if (this.buffer[this.offset] == '\r') {
            return 10;
        }
        return this.buffer[this.offset];
    }

    boolean match(char c) throws IOException {
        if (this.end == this.offset && !this.fill()) {
            return false;
        }
        if (this.buffer[this.offset] == c) {
            ++this.offset;
            return true;
        }
        return false;
    }

    String getLine() {
        StringBuffer result = new StringBuffer();
        int start = this.lineStart;
        if (start >= this.offset) {
            if (this.otherStart < this.otherEnd) {
                result.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            }
            start = 0;
        }
        result.append(this.buffer, start, this.offset - start);
        int i = this.offset;
        while (true) {
            if (i == this.buffer.length) {
                char[] newBuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
                int charsRead = 0;
                try {
                    charsRead = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (charsRead < 0) break;
                this.end += charsRead;
            }
            if (this.buffer[i] == '\r' || this.buffer[i] == '\n') break;
            ++i;
        }
        result.append(this.buffer, this.offset, i - this.offset);
        return result.toString();
    }

    int getOffset() {
        if (this.lineStart >= this.offset) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }

    void startString() {
        if (this.offset == 0) {
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.otherBuffer, this.otherEnd - 1, 1);
            this.stringStart = -1;
            this.hadCFSinceStringStart = this.otherBuffer[this.otherEnd - 1] >= '\u0080' && Character.getType(this.otherBuffer[this.otherEnd - 1]) == 16;
        } else {
            this.stringSoFar = null;
            this.stringStart = this.offset - 1;
            this.hadCFSinceStringStart = this.buffer[this.stringStart] >= '\u0080' && Character.getType(this.buffer[this.stringStart]) == 16;
        }
    }

    String getString() {
        String result;
        int loseCR;
        int n = loseCR = this.offset > 0 && this.buffer[this.offset] == '\n' && this.buffer[this.offset - 1] == '\r' ? 1 : 0;
        if (this.stringStart != -1) {
            result = new String(this.buffer, this.stringStart, this.offset - this.stringStart - loseCR);
        } else {
            if (this.stringSoFar == null) {
                this.stringSoFar = new StringBuffer();
            }
            result = this.stringSoFar.append(this.buffer, 0, this.offset - loseCR).toString();
        }
        this.stringStart = -1;
        this.stringSoFar = null;
        if (this.hadCFSinceStringStart) {
            char[] c = result.toCharArray();
            StringBuffer x = null;
            for (int i = 0; i < c.length; ++i) {
                if (Character.getType(c[i]) == 16) {
                    if (x != null) continue;
                    x = new StringBuffer();
                    x.append(c, 0, i);
                    continue;
                }
                if (x == null) continue;
                x.append(c[i]);
            }
            if (x != null) {
                result = x.toString();
            }
        }
        return result;
    }

    boolean fill() throws IOException {
        int loseCR;
        if (this.end - this.offset != 0) {
            throw new IOException("fill of non-empty buffer");
        }
        int n = loseCR = this.offset > 0 && this.lastWasCR ? 1 : 0;
        if (this.stringStart != -1) {
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.buffer, this.stringStart, this.end - this.stringStart - loseCR);
            this.stringStart = -1;
        } else if (this.stringSoFar != null) {
            this.stringSoFar.append(this.buffer, 0, this.end - loseCR);
        }
        char[] tempBuffer = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = tempBuffer;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.buffer.length + 1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    boolean eof() {
        return this.hitEOF;
    }

    static {
        BUFLEN = 256;
    }
}

