/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptable {
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int MAX_PROTOTYPE_ID = 14;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;
    private boolean prototypeFlag;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray();
        obj.prototypeFlag = true;
        obj.addAsPrototype(14, cx, scope, sealed);
    }

    public NativeArray() {
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long length) {
        int intLength = (int)length;
        if ((long)intLength == length && intLength > 0) {
            if (intLength > 10000) {
                intLength = 10000;
            }
            this.dense = new Object[intLength];
            for (int i = 0; i < intLength; ++i) {
                this.dense[i] = Scriptable.NOT_FOUND;
            }
        }
        this.length = length;
    }

    public NativeArray(Object[] array) {
        this.dense = array;
        this.length = array.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getIdDefaultAttributes(int id) {
        if (id == 1) {
            return 6;
        }
        return super.getIdDefaultAttributes(id);
    }

    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.wrap_double(this.length);
        }
        return super.getIdValue(id);
    }

    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.jsSet_length(value);
            return;
        }
        super.setIdValue(id, value);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return NativeArray.jsConstructor(cx, scope, args, f, thisObj == null);
                }
                case 3: {
                    return NativeArray.jsFunction_toString(cx, thisObj, args);
                }
                case 4: {
                    return NativeArray.jsFunction_toLocaleString(cx, thisObj, args);
                }
                case 5: {
                    return NativeArray.jsFunction_join(cx, thisObj, args);
                }
                case 6: {
                    return NativeArray.jsFunction_reverse(cx, thisObj, args);
                }
                case 7: {
                    return NativeArray.jsFunction_sort(cx, scope, thisObj, args);
                }
                case 8: {
                    return NativeArray.jsFunction_push(cx, thisObj, args);
                }
                case 9: {
                    return NativeArray.jsFunction_pop(cx, thisObj, args);
                }
                case 10: {
                    return NativeArray.jsFunction_shift(cx, thisObj, args);
                }
                case 11: {
                    return NativeArray.jsFunction_unshift(cx, thisObj, args);
                }
                case 12: {
                    return NativeArray.jsFunction_splice(cx, scope, thisObj, args);
                }
                case 13: {
                    return NativeArray.jsFunction_concat(cx, scope, thisObj, args);
                }
                case 14: {
                    return this.jsFunction_slice(cx, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    public Object get(int index, Scriptable start) {
        if (this.dense != null && index >= 0 && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start);
    }

    public boolean has(int index, Scriptable start) {
        if (this.dense != null && index >= 0 && index < this.dense.length) {
            return this.dense[index] != Scriptable.NOT_FOUND;
        }
        return super.has(index, start);
    }

    public void put(String id, Scriptable start, Object value) {
        double d;
        if (start == this && (double)ScriptRuntime.toUint32(d = ScriptRuntime.toNumber(id)) == d && ScriptRuntime.numberToString(d, 10).equals(id) && (double)this.length <= d && d != 4.294967295E9) {
            this.length = (long)d + (long)1;
        }
        super.put(id, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        if (start == this) {
            if (this.length <= (long)index) {
                this.length = (long)index + (long)1;
            }
            if (this.dense != null && index >= 0 && index < this.dense.length) {
                this.dense[index] = value;
                return;
            }
        }
        super.put(index, start, value);
    }

    public void delete(int index) {
        if (!this.isSealed() && this.dense != null && index >= 0 && index < this.dense.length) {
            this.dense[index] = Scriptable.NOT_FOUND;
            return;
        }
        super.delete(index);
    }

    public Object[] getIds() {
        Object[] superIds = super.getIds();
        if (this.dense == null) {
            return superIds;
        }
        int count = 0;
        int last = this.dense.length;
        if ((long)last > this.length) {
            last = (int)this.length;
        }
        for (int i = last - 1; i >= 0; --i) {
            if (this.dense[i] == Scriptable.NOT_FOUND) continue;
            ++count;
        }
        Object[] result = new Object[count += superIds.length];
        System.arraycopy(superIds, 0, result, 0, superIds.length);
        for (int i = last - 1; i >= 0; --i) {
            if (this.dense[i] == Scriptable.NOT_FOUND) continue;
            result[--count] = new Integer(i);
        }
        return result;
    }

    public Object getDefaultValue(Class hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(hint);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args, IdFunction ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (!inNewExpr) {
            return ctorObj.construct(cx, scope, args);
        }
        if (args.length == 0) {
            return new NativeArray();
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args);
        }
        if (args.length > 1 || !(args[0] instanceof Number)) {
            return new NativeArray(args);
        }
        long len = ScriptRuntime.toUint32(args[0]);
        if ((double)len != ((Number)args[0]).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(len);
    }

    public long jsGet_length() {
        return this.length;
    }

    private void jsSet_length(Object val) {
        if (!(val instanceof Number)) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        long longVal = ScriptRuntime.toUint32(val);
        if ((double)longVal != ((Number)val).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (longVal < this.length) {
            if (this.length - longVal > (long)4096) {
                Object[] e = this.getIds();
                for (int i = 0; i < e.length; ++i) {
                    if (e[i] instanceof String) {
                        String id = (String)e[i];
                        double d = ScriptRuntime.toNumber(id);
                        if (d != d || !(d < (double)this.length)) continue;
                        this.delete(id);
                        continue;
                    }
                    int index = ((Number)e[i]).intValue();
                    if ((long)index < longVal) continue;
                    this.delete(index);
                }
            } else {
                for (long i = longVal; i < this.length; ++i) {
                    if (!NativeArray.hasElem(this, i)) continue;
                    ScriptRuntime.delete(this, new Long(i));
                }
            }
        }
        this.length = longVal;
    }

    static double getLengthProperty(Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).jsGet_length();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).jsGet_length();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(obj, "length", obj));
    }

    static boolean hasLengthProperty(Object obj) {
        if (!(obj instanceof Scriptable) || obj == Context.getUndefinedValue()) {
            return false;
        }
        if (obj instanceof NativeString || obj instanceof NativeArray) {
            return true;
        }
        Scriptable sobj = (Scriptable)obj;
        Object property = ScriptRuntime.getProp(sobj, "length", sobj);
        return property instanceof Number;
    }

    private static boolean hasElem(Scriptable target, long index) {
        return index > (long)Integer.MAX_VALUE ? target.has(Long.toString(index), target) : target.has((int)index, target);
    }

    private static Object getElem(Scriptable target, long index) {
        if (index > (long)Integer.MAX_VALUE) {
            String id = Long.toString(index);
            return ScriptRuntime.getElem(target, id, target);
        }
        return ScriptRuntime.getElem(target, (int)index);
    }

    private static void setElem(Scriptable target, long index, Object value) {
        if (index > (long)Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptRuntime.setElem(target, id, value, target);
        } else {
            ScriptRuntime.setElem(target, (int)index, value);
        }
    }

    private static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return NativeArray.toStringHelper(cx, thisObj, cx.getLanguageVersion() == 120, false);
    }

    private static String jsFunction_toLocaleString(Context cx, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return NativeArray.toStringHelper(cx, thisObj, false, true);
    }

    private static String toStringHelper(Context cx, Scriptable thisObj, boolean toSource, boolean toLocale) throws JavaScriptException {
        String separator;
        boolean iterating;
        long length = (long)NativeArray.getLengthProperty(thisObj);
        StringBuffer result = new StringBuffer();
        if (cx.iterating == null) {
            cx.iterating = new Hashtable(31);
        }
        boolean bl = iterating = cx.iterating.get(thisObj) == Boolean.TRUE;
        if (toSource) {
            result.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i = 0L;
        if (!iterating) {
            for (i = 0L; i < length; ++i) {
                Object var16_13;
                Object elem;
                if (i > (long)0) {
                    result.append(separator);
                }
                if ((elem = NativeArray.getElem(thisObj, i)) == null || elem == Undefined.instance) {
                    haslast = false;
                    continue;
                }
                haslast = true;
                if (elem instanceof String) {
                    if (toSource) {
                        result.append('\"');
                        result.append(ScriptRuntime.escapeString(ScriptRuntime.toString(elem)));
                        result.append('\"');
                        continue;
                    }
                    result.append(ScriptRuntime.toString(elem));
                    continue;
                }
                try {
                    cx.iterating.put(thisObj, Boolean.TRUE);
                    if (toLocale && elem != Undefined.instance && elem != null) {
                        Scriptable obj = Context.toObject(elem, thisObj);
                        Object tls = ScriptRuntime.getProp(obj, "toLocaleString", thisObj);
                        elem = ScriptRuntime.call(cx, tls, elem, ScriptRuntime.emptyArgs);
                    }
                    result.append(ScriptRuntime.toString(elem));
                    var16_13 = null;
                    cx.iterating.remove(thisObj);
                }
                catch (Throwable throwable) {
                    var16_13 = null;
                    cx.iterating.remove(thisObj);
                    throw throwable;
                }
                {
                    continue;
                }
            }
        }
        if (toSource) {
            if (!haslast && i > (long)0) {
                result.append(", ]");
            } else {
                result.append(']');
            }
        }
        return result.toString();
    }

    private static String jsFunction_join(Context cx, Scriptable thisObj, Object[] args) {
        StringBuffer result = new StringBuffer();
        double length = NativeArray.getLengthProperty(thisObj);
        String separator = args.length < 1 ? "," : ScriptRuntime.toString(args[0]);
        long i = 0L;
        while ((double)i < length) {
            Object temp;
            if (i > (long)0) {
                result.append(separator);
            }
            if ((temp = NativeArray.getElem(thisObj, i)) != null && temp != Undefined.instance) {
                result.append(ScriptRuntime.toString(temp));
            }
            ++i;
        }
        return result.toString();
    }

    private static Scriptable jsFunction_reverse(Context cx, Scriptable thisObj, Object[] args) {
        long len = (long)NativeArray.getLengthProperty(thisObj);
        long half = len / (long)2;
        for (long i = 0L; i < half; ++i) {
            long j = len - i - (long)1;
            Object temp1 = NativeArray.getElem(thisObj, i);
            Object temp2 = NativeArray.getElem(thisObj, j);
            NativeArray.setElem(thisObj, i, temp2);
            NativeArray.setElem(thisObj, j, temp1);
        }
        return thisObj;
    }

    private static Scriptable jsFunction_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        long length = (long)NativeArray.getLengthProperty(thisObj);
        Object compare = args.length > 0 && Undefined.instance != args[0] ? args[0] : null;
        if (length >= (long)Integer.MAX_VALUE) {
            NativeArray.qsort_extended(cx, compare, thisObj, 0L, length - (long)1);
        } else {
            Object[] working = new Object[(int)length];
            int i = 0;
            while ((long)i < length) {
                working[i] = NativeArray.getElem(thisObj, i);
                ++i;
            }
            NativeArray.qsort(cx, compare, working, 0, (int)length - 1, scope);
            i = 0;
            while ((long)i < length) {
                NativeArray.setElem(thisObj, i, working[i]);
                ++i;
            }
        }
        return thisObj;
    }

    private static double qsortCompare(Context cx, Object jsCompare, Object x, Object y, Scriptable scope) throws JavaScriptException {
        Scriptable undef = Undefined.instance;
        if (undef == x || undef == y) {
            if (undef != x) {
                return -1.0;
            }
            if (undef != y) {
                return 1.0;
            }
            return 0.0;
        }
        if (jsCompare == null) {
            String a = ScriptRuntime.toString(x);
            String b = ScriptRuntime.toString(y);
            return a.compareTo(b);
        }
        Object[] args = new Object[]{x, y};
        double d = ScriptRuntime.toNumber(ScriptRuntime.call(cx, jsCompare, null, args, scope));
        return d == d ? d : 0.0;
    }

    private static void qsort(Context cx, Object jsCompare, Object[] working, int lo, int hi, Scriptable scope) throws JavaScriptException {
        while (lo < hi) {
            int i = lo;
            int j = hi;
            int a = i;
            Object pivot = working[a];
            while (i < j) {
                int b;
                while (true) {
                    b = --j;
                    if (NativeArray.qsortCompare(cx, jsCompare, working[j], pivot, scope) <= 0.0) break;
                }
                working[a] = working[b];
                while (i < j && NativeArray.qsortCompare(cx, jsCompare, working[a], pivot, scope) <= 0.0) {
                    a = ++i;
                }
                working[b] = working[a];
            }
            working[a] = pivot;
            if (i - lo < hi - i) {
                NativeArray.qsort(cx, jsCompare, working, lo, i - 1, scope);
                lo = i + 1;
                continue;
            }
            NativeArray.qsort(cx, jsCompare, working, i + 1, hi, scope);
            hi = i - 1;
        }
    }

    private static void qsort_extended(Context cx, Object jsCompare, Scriptable target, long lo, long hi) throws JavaScriptException {
        while (lo < hi) {
            long i = lo;
            long j = hi;
            long a = i;
            Object pivot = NativeArray.getElem(target, a);
            while (i < j) {
                long b;
                while (true) {
                    b = --j;
                    if (NativeArray.qsortCompare(cx, jsCompare, NativeArray.getElem(target, j), pivot, target) <= 0.0) break;
                }
                NativeArray.setElem(target, a, NativeArray.getElem(target, b));
                while (i < j && NativeArray.qsortCompare(cx, jsCompare, NativeArray.getElem(target, a), pivot, target) <= 0.0) {
                    a = ++i;
                }
                NativeArray.setElem(target, b, NativeArray.getElem(target, a));
            }
            NativeArray.setElem(target, a, pivot);
            if (i - lo < hi - i) {
                NativeArray.qsort_extended(cx, jsCompare, target, lo, i - (long)1);
                lo = i + (long)1;
                continue;
            }
            NativeArray.qsort_extended(cx, jsCompare, target, i + (long)1, hi);
            hi = i - (long)1;
        }
    }

    private static Object jsFunction_push(Context cx, Scriptable thisObj, Object[] args) {
        double length = NativeArray.getLengthProperty(thisObj);
        for (int i = 0; i < args.length; ++i) {
            NativeArray.setElem(thisObj, (long)length + (long)i, args[i]);
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length += (double)args.length), thisObj);
        if (cx.getLanguageVersion() == 120) {
            return args.length == 0 ? Context.getUndefinedValue() : args[args.length - 1];
        }
        return new Long((long)length);
    }

    private static Object jsFunction_pop(Context cx, Scriptable thisObj, Object[] args) {
        double length = NativeArray.getLengthProperty(thisObj);
        Object result = length > 0.0 ? NativeArray.getElem(thisObj, (long)(length -= 1.0)) : Context.getUndefinedValue();
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object jsFunction_shift(Context cx, Scriptable thisObj, Object[] args) {
        Object result;
        double length = NativeArray.getLengthProperty(thisObj);
        if (length > 0.0) {
            long i = 0L;
            length -= 1.0;
            result = NativeArray.getElem(thisObj, i);
            if (length > 0.0) {
                i = 1L;
                while ((double)i <= length) {
                    Object temp = NativeArray.getElem(thisObj, i);
                    NativeArray.setElem(thisObj, i - (long)1, temp);
                    ++i;
                }
            }
        } else {
            result = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object jsFunction_unshift(Context cx, Scriptable thisObj, Object[] args) {
        double length = NativeArray.getLengthProperty(thisObj);
        int argc = args.length;
        if (args.length > 0) {
            if (length > 0.0) {
                for (long last = (long)length - (long)1; last >= (long)0; --last) {
                    Object temp = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(thisObj, last + (long)argc, temp);
                }
            }
            for (int i = 0; i < args.length; ++i) {
                NativeArray.setElem(thisObj, i, args[i]);
            }
            ScriptRuntime.setProp(thisObj, "length", new Double(length += (double)args.length), thisObj);
        }
        return new Long((long)length);
    }

    private static Object jsFunction_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object temp;
        long last;
        double end;
        double count;
        scope = ScriptableObject.getTopLevelScope(scope);
        Object result = ScriptRuntime.newObject(cx, scope, "Array", null);
        int argc = args.length;
        if (argc == 0) {
            return result;
        }
        double length = NativeArray.getLengthProperty(thisObj);
        double begin = ScriptRuntime.toInteger(args[0]);
        if (begin < 0.0) {
            if ((begin += length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > length) {
            begin = length;
        }
        --argc;
        double delta = length - begin;
        if (args.length == 1) {
            count = delta;
            end = length;
        } else {
            count = ScriptRuntime.toInteger(args[1]);
            if (count < 0.0) {
                count = 0.0;
            } else if (count > delta) {
                count = delta;
            }
            end = begin + count;
            --argc;
        }
        long lbegin = (long)begin;
        long lend = (long)end;
        if (count > 0.0) {
            if (count == 1.0 && cx.getLanguageVersion() == 120) {
                result = NativeArray.getElem(thisObj, lbegin);
            } else {
                for (last = lbegin; last < lend; ++last) {
                    Scriptable resultArray = (Scriptable)result;
                    Object temp2 = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(resultArray, last - lbegin, temp2);
                }
            }
        } else if (count == 0.0 && cx.getLanguageVersion() == 120) {
            result = Context.getUndefinedValue();
        }
        delta = (double)argc - count;
        if (delta > 0.0) {
            for (last = (long)length - (long)1; last >= lend; --last) {
                temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + (long)delta, temp);
            }
        } else if (delta < 0.0) {
            last = lend;
            while ((double)last < length) {
                temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + (long)delta, temp);
                ++last;
            }
        }
        int argoffset = args.length - argc;
        for (int i = 0; i < argc; ++i) {
            NativeArray.setElem(thisObj, lbegin + (long)i, args[i + argoffset]);
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length + delta), thisObj);
        return result;
    }

    private static Scriptable jsFunction_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double length;
        scope = ScriptableObject.getTopLevelScope(scope);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        long slot = 0L;
        if (NativeArray.hasLengthProperty(thisObj)) {
            length = NativeArray.getLengthProperty(thisObj);
            slot = 0L;
            while ((double)slot < length) {
                Object temp = NativeArray.getElem(thisObj, slot);
                NativeArray.setElem(result, slot, temp);
                ++slot;
            }
        } else {
            NativeArray.setElem(result, slot++, thisObj);
        }
        for (int i = 0; i < args.length; ++i) {
            if (NativeArray.hasLengthProperty(args[i])) {
                Scriptable arg = (Scriptable)args[i];
                length = NativeArray.getLengthProperty(arg);
                long j = 0L;
                while ((double)j < length) {
                    Object temp = NativeArray.getElem(arg, j);
                    NativeArray.setElem(result, slot, temp);
                    ++j;
                    ++slot;
                }
                continue;
            }
            NativeArray.setElem(result, slot++, args[i]);
        }
        return result;
    }

    private Scriptable jsFunction_slice(Context cx, Scriptable thisObj, Object[] args) {
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        double length = NativeArray.getLengthProperty(thisObj);
        double begin = 0.0;
        double end = length;
        if (args.length > 0) {
            begin = ScriptRuntime.toInteger(args[0]);
            if (begin < 0.0) {
                if ((begin += length) < 0.0) {
                    begin = 0.0;
                }
            } else if (begin > length) {
                begin = length;
            }
            if (args.length > 1) {
                end = ScriptRuntime.toInteger(args[1]);
                if (end < 0.0) {
                    if ((end += length) < 0.0) {
                        end = 0.0;
                    }
                } else if (end > length) {
                    end = length;
                }
            }
        }
        long lbegin = (long)begin;
        long lend = (long)end;
        for (long slot = lbegin; slot < lend; ++slot) {
            Object temp = NativeArray.getElem(thisObj, slot);
            NativeArray.setElem(result, slot - lbegin, temp);
        }
        return result;
    }

    protected int maxInstanceId() {
        return 1;
    }

    protected String getIdName(int id) {
        if (id == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "join";
                }
                case 6: {
                    return "reverse";
                }
                case 7: {
                    return "sort";
                }
                case 8: {
                    return "push";
                }
                case 9: {
                    return "pop";
                }
                case 10: {
                    return "shift";
                }
                case 11: {
                    return "unshift";
                }
                case 12: {
                    return "splice";
                }
                case 13: {
                    return "concat";
                }
                case 14: {
                    return "slice";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (s.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeArray.toPrototypeId(s);
        }
        return 0;
    }

    private static int toPrototypeId(String s) {
        int id;
        block16: {
            id = 0;
            String X = null;
            switch (s.length()) {
                case 3: {
                    X = "pop";
                    id = 9;
                    break;
                }
                case 4: {
                    char c = s.charAt(0);
                    if (c == 'j') {
                        X = "join";
                        id = 5;
                        break;
                    }
                    if (c == 'p') {
                        X = "push";
                        id = 8;
                        break;
                    }
                    if (c != 's') break;
                    X = "sort";
                    id = 7;
                    break;
                }
                case 5: {
                    char c = s.charAt(1);
                    if (c == 'h') {
                        X = "shift";
                        id = 10;
                        break;
                    }
                    if (c != 'l') break;
                    X = "slice";
                    id = 14;
                    break;
                }
                case 6: {
                    char c = s.charAt(0);
                    if (c == 'c') {
                        X = "concat";
                        id = 13;
                        break;
                    }
                    if (c == 'l') {
                        X = "length";
                        id = 1;
                        break;
                    }
                    if (c != 's') break;
                    X = "splice";
                    id = 12;
                    break;
                }
                case 7: {
                    char c = s.charAt(0);
                    if (c == 'r') {
                        X = "reverse";
                        id = 6;
                        break;
                    }
                    if (c != 'u') break;
                    X = "unshift";
                    id = 11;
                    break;
                }
                case 8: {
                    X = "toString";
                    id = 3;
                    break;
                }
                case 11: {
                    X = "constructor";
                    id = 2;
                    break;
                }
                case 14: {
                    X = "toLocaleString";
                    id = 4;
                    break;
                }
            }
            if (X == null || X == s || X.equals(s)) break block16;
            id = 0;
        }
        return id;
    }

    static {
        Id_length = 1;
        MAX_INSTANCE_ID = 1;
        Id_constructor = 2;
        Id_toString = 3;
        Id_toLocaleString = 4;
        Id_join = 5;
        Id_reverse = 6;
        Id_sort = 7;
        Id_push = 8;
        Id_pop = 9;
        Id_shift = 10;
        Id_unshift = 11;
        Id_splice = 12;
        Id_concat = 13;
        Id_slice = 14;
        MAX_PROTOTYPE_ID = 14;
        maximumDenseLength = 10000;
    }
}

