/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class NativeBoolean
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private boolean booleanValue;
    private boolean prototypeFlag;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeBoolean obj = new NativeBoolean();
        obj.prototypeFlag = true;
        obj.addAsPrototype(3, cx, scope, sealed);
    }

    public NativeBoolean() {
    }

    public NativeBoolean(boolean b) {
        this.booleanValue = b;
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(typeHint);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return 1;
            }
            if (methodId == 2) {
                return 0;
            }
            if (methodId == 3) {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return this.jsConstructor(args, thisObj == null);
            }
            if (methodId == 2) {
                return this.realThis(thisObj, f).jsFunction_toString();
            }
            if (methodId == 3) {
                return this.wrap_boolean(this.realThis(thisObj, f).jsFunction_valueOf());
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeBoolean realThis(Scriptable thisObj, IdFunction f) {
        while (!(thisObj instanceof NativeBoolean)) {
            thisObj = this.nextInstanceCheck(thisObj, f, true);
        }
        return (NativeBoolean)thisObj;
    }

    private Object jsConstructor(Object[] args, boolean inNewExpr) {
        boolean b = ScriptRuntime.toBoolean(args, 0);
        if (inNewExpr) {
            return new NativeBoolean(b);
        }
        return this.wrap_boolean(b);
    }

    private String jsFunction_toString() {
        return this.booleanValue ? "true" : "false";
    }

    private boolean jsFunction_valueOf() {
        return this.booleanValue;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            if (id == 1) {
                return "constructor";
            }
            if (id == 2) {
                return "toString";
            }
            if (id == 3) {
                return "valueOf";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 7) {
            X = "valueOf";
            id = 3;
        } else if (s_length == 8) {
            X = "toString";
            id = 2;
        } else if (s_length == 11) {
            X = "constructor";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    static {
        Id_constructor = 1;
        Id_toString = 2;
        Id_valueOf = 3;
        MAX_PROTOTYPE_ID = 3;
    }
}

