/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    Object[] originalArgs;
    public int debugPC;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeCall obj = new NativeCall();
        obj.prototypeFlag = true;
        obj.addAsPrototype(1, cx, scope, sealed);
    }

    NativeCall(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, Object[] args) {
        this.funObj = funObj;
        this.thisObj = thisObj;
        this.setParentScope(scope);
        this.caller = cx.currentActivation;
        cx.currentActivation = this;
        this.originalArgs = args == null ? ScriptRuntime.emptyArgs : args;
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            for (int i = 0; i < funObj.argCount; ++i) {
                Scriptable val = i < args.length ? args[i] : Undefined.instance;
                super.put(argNames[i], (Scriptable)this, (Object)val);
            }
        }
        super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
    }

    private NativeCall() {
    }

    public String getClassName() {
        return "Call";
    }

    private static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            throw Context.reportRuntimeError1("msg.only.from.new", "Call");
        }
        ScriptRuntime.checkDeprecated(cx, "Call");
        NativeCall result = new NativeCall();
        result.setPrototype(ScriptableObject.getObjectPrototype(ctorObj));
        return result;
    }

    NativeCall getActivation(Function f) {
        NativeCall x = this;
        do {
            if (x.funObj != f) continue;
            return x;
        } while ((x = x.caller) != null);
        return null;
    }

    public Function getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag && methodId == 1) {
            return 1;
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag && methodId == 1) {
            return NativeCall.jsConstructor(cx, args, f, thisObj == null);
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag && id == 1) {
            return "constructor";
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        return s.equals("constructor") ? 1 : 0;
    }

    static {
        Id_constructor = 1;
        MAX_PROTOTYPE_ID = 1;
    }
}

