/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    private Hashtable fieldAndMethods;
    private Scriptable parent;

    public NativeJavaClass(Scriptable scope, Class cl) {
        super(scope, (Object)cl, JavaMembers.lookupClass(scope, cl, cl));
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public boolean has(String name, Scriptable start) {
        return this.members.has(name, true);
    }

    public Object get(String name, Scriptable start) {
        if (name.equals("prototype")) {
            return null;
        }
        Object result = Scriptable.NOT_FOUND;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.members.has(name, true)) {
            result = this.members.get(this, name, this.javaObject, true);
        } else {
            try {
                String nestedName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClassObject().getName()))).append('$').append(name)));
                Class nestedClass = ScriptRuntime.loadClassName(nestedName);
                NativeJavaClass nestedValue = NativeJavaClass.wrap(ScriptableObject.getTopLevelScope(this), nestedClass);
                nestedValue.setParentScope(this);
                result = nestedValue;
            }
            catch (ClassNotFoundException ex) {
                throw this.members.reportMemberNotFound(name);
            }
            catch (IllegalArgumentException e) {
                throw this.members.reportMemberNotFound(name);
            }
        }
        return result;
    }

    public void put(String name, Scriptable start, Object value) {
        this.members.put(this, name, this.javaObject, value, true);
    }

    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public static NativeJavaClass wrap(Scriptable scope, Class cls) {
        return new NativeJavaClass(scope, cls);
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (args.length == 1 && args[0] instanceof Scriptable) {
            Class c = this.getClassObject();
            Scriptable p = (Scriptable)args[0];
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype()) != null);
        }
        return this.construct(cx, scope, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        String msg;
        Class classObject;
        block5: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                Member[] ctors = this.members.getConstructors();
                Member member = NativeJavaMethod.findFunction(ctors, args);
                Constructor ctor = (Constructor)member;
                if (ctor == null) {
                    String sig = NativeJavaMethod.scriptSignature(args);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig);
                }
                return NativeJavaClass.constructSpecific(cx, scope, this, ctor, args);
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                Object v = topLevel.get("JavaAdapter", topLevel);
                if (v != Scriptable.NOT_FOUND) {
                    Function f = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args[0]};
                    Scriptable scriptable = f.construct(cx, topLevel, adapterArgs);
                    return scriptable;
                }
            }
            catch (Exception ex) {
                String m = ex.getMessage();
                if (m == null) break block5;
                msg = m;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName());
    }

    public static Scriptable constructSpecific(Context cx, Scriptable scope, Scriptable thisObj, Constructor ctor, Object[] args) throws JavaScriptException {
        Scriptable topLevel = ScriptableObject.getTopLevelScope(thisObj);
        Class classObject = ctor.getDeclaringClass();
        Class<?>[] paramTypes = ctor.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = NativeJavaObject.coerceType(paramTypes[i], args[i]);
        }
        try {
            Scriptable i = (Scriptable)NativeJavaObject.wrap(topLevel, ctor.newInstance(args), classObject);
            return i;
        }
        catch (InstantiationException instEx) {
            throw Context.reportRuntimeError2("msg.cant.instantiate", instEx.getMessage(), classObject.getName());
        }
        catch (IllegalArgumentException argEx) {
            String signature = NativeJavaMethod.scriptSignature(args);
            String ctorString = ctor.toString();
            throw Context.reportRuntimeError3("msg.bad.ctor.sig", argEx.getMessage(), ctorString, signature);
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(scope, e);
        }
        catch (IllegalAccessException accessEx) {
            throw Context.reportRuntimeError1("msg.java.internal.private", accessEx.getMessage());
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("[JavaClass ").append(this.getClassObject().getName()).append("]")));
    }

    public boolean hasInstance(Scriptable value) {
        if (value instanceof Wrapper && !(value instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }
}

