/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeMath
extends IdScriptable {
    private static final int Id_abs = 1;
    private static final int Id_acos = 2;
    private static final int Id_asin = 3;
    private static final int Id_atan = 4;
    private static final int Id_atan2 = 5;
    private static final int Id_ceil = 6;
    private static final int Id_cos = 7;
    private static final int Id_exp = 8;
    private static final int Id_floor = 9;
    private static final int Id_log = 10;
    private static final int Id_max = 11;
    private static final int Id_min = 12;
    private static final int Id_pow = 13;
    private static final int Id_random = 14;
    private static final int Id_round = 15;
    private static final int Id_sin = 16;
    private static final int Id_sqrt = 17;
    private static final int Id_tan = 18;
    private static final int LAST_METHOD_ID = 18;
    private static final int Id_E = 19;
    private static final int Id_PI = 20;
    private static final int Id_LN10 = 21;
    private static final int Id_LN2 = 22;
    private static final int Id_LOG2E = 23;
    private static final int Id_LOG10E = 24;
    private static final int Id_SQRT1_2 = 25;
    private static final int Id_SQRT2 = 26;
    private static final int MAX_INSTANCE_ID = 26;
    private static final double E = Math.E;
    private static final double PI = Math.PI;
    private static final double LN10 = 2.302585092994046;
    private static final double LN2 = 0.6931471805599453;
    private static final double LOG2E = 1.4426950408889634;
    private static final double LOG10E = 0.4342944819032518;
    private static final double SQRT1_2 = 0.7071067811865476;
    private static final double SQRT2 = 1.4142135623730951;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeMath obj = new NativeMath();
        obj.setSealFunctionsFlag(sealed);
        obj.setFunctionParametrs(cx);
        obj.setPrototype(ScriptableObject.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, "Math", obj, 2);
    }

    public String getClassName() {
        return "Math";
    }

    protected int getIdDefaultAttributes(int id) {
        if (id > 18) {
            return 7;
        }
        return super.getIdDefaultAttributes(id);
    }

    protected Object getIdValue(int id) {
        if (id > 18) {
            return this.cacheIdValue(id, this.wrap_double(this.getField(id)));
        }
        return super.getIdValue(id);
    }

    private double getField(int fieldId) {
        switch (fieldId) {
            case 19: {
                return Math.E;
            }
            case 20: {
                return Math.PI;
            }
            case 21: {
                return 2.302585092994046;
            }
            case 22: {
                return 0.6931471805599453;
            }
            case 23: {
                return 1.4426950408889634;
            }
            case 24: {
                return 0.4342944819032518;
            }
            case 25: {
                return 0.7071067811865476;
            }
            case 26: {
                return 1.4142135623730951;
            }
        }
        return 0.0;
    }

    public int methodArity(int methodId) {
        switch (methodId) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 1;
            }
            case 18: {
                return 1;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        switch (methodId) {
            case 1: {
                return this.wrap_double(this.js_abs(ScriptRuntime.toNumber(args, 0)));
            }
            case 2: {
                return this.wrap_double(this.js_acos(ScriptRuntime.toNumber(args, 0)));
            }
            case 3: {
                return this.wrap_double(this.js_asin(ScriptRuntime.toNumber(args, 0)));
            }
            case 4: {
                return this.wrap_double(this.js_atan(ScriptRuntime.toNumber(args, 0)));
            }
            case 5: {
                return this.wrap_double(this.js_atan2(ScriptRuntime.toNumber(args, 0), ScriptRuntime.toNumber(args, 1)));
            }
            case 6: {
                return this.wrap_double(this.js_ceil(ScriptRuntime.toNumber(args, 0)));
            }
            case 7: {
                return this.wrap_double(this.js_cos(ScriptRuntime.toNumber(args, 0)));
            }
            case 8: {
                return this.wrap_double(this.js_exp(ScriptRuntime.toNumber(args, 0)));
            }
            case 9: {
                return this.wrap_double(this.js_floor(ScriptRuntime.toNumber(args, 0)));
            }
            case 10: {
                return this.wrap_double(this.js_log(ScriptRuntime.toNumber(args, 0)));
            }
            case 11: {
                return this.wrap_double(this.js_max(args));
            }
            case 12: {
                return this.wrap_double(this.js_min(args));
            }
            case 13: {
                return this.wrap_double(this.js_pow(ScriptRuntime.toNumber(args, 0), ScriptRuntime.toNumber(args, 1)));
            }
            case 14: {
                return this.wrap_double(this.js_random());
            }
            case 15: {
                return this.wrap_double(this.js_round(ScriptRuntime.toNumber(args, 0)));
            }
            case 16: {
                return this.wrap_double(this.js_sin(ScriptRuntime.toNumber(args, 0)));
            }
            case 17: {
                return this.wrap_double(this.js_sqrt(ScriptRuntime.toNumber(args, 0)));
            }
            case 18: {
                return this.wrap_double(this.js_tan(ScriptRuntime.toNumber(args, 0)));
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private double js_abs(double x) {
        return x == 0.0 ? 0.0 : (x < 0.0 ? -x : x);
    }

    private double js_acos(double x) {
        return x == x && -1.0 <= x && x <= 1.0 ? Math.acos(x) : Double.NaN;
    }

    private double js_asin(double x) {
        return x == x && -1.0 <= x && x <= 1.0 ? Math.asin(x) : Double.NaN;
    }

    private double js_atan(double x) {
        return Math.atan(x);
    }

    private double js_atan2(double x, double y) {
        return Math.atan2(x, y);
    }

    private double js_ceil(double x) {
        return Math.ceil(x);
    }

    private double js_cos(double x) {
        return Math.cos(x);
    }

    private double js_exp(double x) {
        return x == Double.POSITIVE_INFINITY ? x : (x == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(x));
    }

    private double js_floor(double x) {
        return Math.floor(x);
    }

    private double js_log(double x) {
        return x < 0.0 ? Double.NaN : Math.log(x);
    }

    private double js_max(Object[] args) {
        double result = Double.NEGATIVE_INFINITY;
        if (args.length == 0) {
            return result;
        }
        for (int i = 0; i < args.length; ++i) {
            double d = ScriptRuntime.toNumber(args[i]);
            if (d != d) {
                return d;
            }
            result = Math.max(result, d);
        }
        return result;
    }

    private double js_min(Object[] args) {
        double result = Double.POSITIVE_INFINITY;
        if (args.length == 0) {
            return result;
        }
        for (int i = 0; i < args.length; ++i) {
            double d = ScriptRuntime.toNumber(args[i]);
            if (d != d) {
                return d;
            }
            result = Math.min(result, d);
        }
        return result;
    }

    private double js_pow(double x, double y) {
        if (y == 0.0) {
            return 1.0;
        }
        if (x == 0.0 && y < 0.0) {
            if (1.0 / x > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            int y_int = (int)y;
            if ((double)y_int == y && (y_int & 1) != 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(x, y);
    }

    private double js_random() {
        return Math.random();
    }

    private double js_round(double d) {
        if (d != d) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long l = Math.round(d);
        if (l == (long)0) {
            if (d < 0.0) {
                return ScriptRuntime.negativeZero;
            }
            return d == 0.0 ? d : 0.0;
        }
        return l;
    }

    private double js_sin(double x) {
        return Math.sin(x);
    }

    private double js_sqrt(double x) {
        return Math.sqrt(x);
    }

    private double js_tan(double x) {
        return Math.tan(x);
    }

    protected int maxInstanceId() {
        return 26;
    }

    protected String getIdName(int id) {
        switch (id) {
            case 1: {
                return "abs";
            }
            case 2: {
                return "acos";
            }
            case 3: {
                return "asin";
            }
            case 4: {
                return "atan";
            }
            case 5: {
                return "atan2";
            }
            case 6: {
                return "ceil";
            }
            case 7: {
                return "cos";
            }
            case 8: {
                return "exp";
            }
            case 9: {
                return "floor";
            }
            case 10: {
                return "log";
            }
            case 11: {
                return "max";
            }
            case 12: {
                return "min";
            }
            case 13: {
                return "pow";
            }
            case 14: {
                return "random";
            }
            case 15: {
                return "round";
            }
            case 16: {
                return "sin";
            }
            case 17: {
                return "sqrt";
            }
            case 18: {
                return "tan";
            }
            case 19: {
                return "E";
            }
            case 20: {
                return "PI";
            }
            case 21: {
                return "LN10";
            }
            case 22: {
                return "LN2";
            }
            case 23: {
                return "LOG2E";
            }
            case 24: {
                return "LOG10E";
            }
            case 25: {
                return "SQRT1_2";
            }
            case 26: {
                return "SQRT2";
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int mapNameToId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 1: {
                if (s.charAt(0) != 'E') break;
                return 19;
            }
            case 2: {
                if (s.charAt(0) != 'P' || s.charAt(1) != 'I') break;
                return 20;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'L': {
                        if (s.charAt(2) != '2' || s.charAt(1) != 'N') break;
                        return 22;
                    }
                    case 'a': {
                        if (s.charAt(2) != 's' || s.charAt(1) != 'b') break;
                        return 1;
                    }
                    case 'c': {
                        if (s.charAt(2) != 's' || s.charAt(1) != 'o') break;
                        return 7;
                    }
                    case 'e': {
                        if (s.charAt(2) != 'p' || s.charAt(1) != 'x') break;
                        return 8;
                    }
                    case 'l': {
                        if (s.charAt(2) != 'g' || s.charAt(1) != 'o') break;
                        return 10;
                    }
                    case 'm': {
                        char c = s.charAt(2);
                        if (c == 'n') {
                            if (s.charAt(1) != 'i') break;
                            return 12;
                        }
                        if (c != 'x' || s.charAt(1) != 'a') break;
                        return 11;
                    }
                    case 'p': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'o') break;
                        return 13;
                    }
                    case 's': {
                        if (s.charAt(2) != 'n' || s.charAt(1) != 'i') break;
                        return 16;
                    }
                    case 't': {
                        if (s.charAt(2) != 'n' || s.charAt(1) != 'a') break;
                        return 18;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(1)) {
                    case 'N': {
                        X = "LN10";
                        id = 21;
                        break block0;
                    }
                    case 'c': {
                        X = "acos";
                        id = 2;
                        break block0;
                    }
                    case 'e': {
                        X = "ceil";
                        id = 6;
                        break block0;
                    }
                    case 'q': {
                        X = "sqrt";
                        id = 17;
                        break block0;
                    }
                    case 's': {
                        X = "asin";
                        id = 3;
                        break block0;
                    }
                    case 't': {
                        X = "atan";
                        id = 4;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'L': {
                        X = "LOG2E";
                        id = 23;
                        break block0;
                    }
                    case 'S': {
                        X = "SQRT2";
                        id = 26;
                        break block0;
                    }
                    case 'a': {
                        X = "atan2";
                        id = 5;
                        break block0;
                    }
                    case 'f': {
                        X = "floor";
                        id = 9;
                        break block0;
                    }
                    case 'r': {
                        X = "round";
                        id = 15;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'L') {
                    X = "LOG10E";
                    id = 24;
                    break;
                }
                if (c != 'r') break;
                X = "random";
                id = 14;
                break;
            }
            case 7: {
                X = "SQRT1_2";
                id = 25;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }

    static {
        Id_abs = 1;
        Id_acos = 2;
        Id_asin = 3;
        Id_atan = 4;
        Id_atan2 = 5;
        Id_ceil = 6;
        Id_cos = 7;
        Id_exp = 8;
        Id_floor = 9;
        Id_log = 10;
        Id_max = 11;
        Id_min = 12;
        Id_pow = 13;
        Id_random = 14;
        Id_round = 15;
        Id_sin = 16;
        Id_sqrt = 17;
        Id_tan = 18;
        LAST_METHOD_ID = 18;
        Id_E = 19;
        Id_PI = 20;
        Id_LN10 = 21;
        Id_LN2 = 22;
        Id_LOG2E = 23;
        Id_LOG10E = 24;
        Id_SQRT1_2 = 25;
        Id_SQRT2 = 26;
        MAX_INSTANCE_ID = 26;
        E = Math.E;
        PI = Math.PI;
        LN10 = 2.302585092994046;
        LN2 = 0.6931471805599453;
        LOG2E = 1.4426950408889634;
        LOG10E = 0.4342944819032518;
        SQRT1_2 = 0.7071067811865476;
        SQRT2 = 1.4142135623730951;
    }
}

