/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeScript
extends NativeFunction
implements Script {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;
    private int prototypeIdShift;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeScript obj = new NativeScript();
        obj.scopeInit(cx, scope, sealed);
    }

    private void scopeInit(Context cx, Scriptable scope, boolean sealed) {
        this.prototypeIdShift = super.maxInstanceId() + 1;
        this.addAsPrototype(4 + this.prototypeIdShift - 1, cx, scope, sealed);
    }

    public String getClassName() {
        return "Script";
    }

    public void initScript(Scriptable scope) {
    }

    public int methodArity(int methodId) {
        if (this.prototypeIdShift != 0) {
            switch (methodId - this.prototypeIdShift + 1) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeIdShift != 0) {
            switch (methodId - this.prototypeIdShift + 1) {
                case 1: {
                    return NativeScript.jsConstructor(cx, scope, args);
                }
                case 2: {
                    return this.realThis(thisObj, f, true).jsFunction_toString(cx, args);
                }
                case 4: {
                    return this.realThis(thisObj, f, true).jsFunction_exec();
                }
                case 3: {
                    return this.realThis(thisObj, f, false).jsFunction_compile(ScriptRuntime.toString(args, 0));
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeScript realThis(Scriptable thisObj, IdFunction f, boolean readOnly) {
        while (!(thisObj instanceof NativeScript)) {
            thisObj = this.nextInstanceCheck(thisObj, f, readOnly);
        }
        return (NativeScript)thisObj;
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args) {
        String source = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
        return NativeScript.compile(scope, source);
    }

    public static Script compile(Scriptable scope, String source) {
        Context cx = Context.getContext();
        StringReader reader = new StringReader(source);
        try {
            int[] linep = new int[]{0};
            String filename = Context.getSourcePositionFromStack(linep);
            if (filename == null) {
                filename = "<Script object>";
                linep[0] = 1;
            }
            Object securityDomain = cx.getSecurityDomainForStackDepth(5);
            Script script = cx.compileReader(scope, reader, filename, linep[0], securityDomain);
            return script;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException");
        }
    }

    private Scriptable jsFunction_compile(String source) {
        this.script = NativeScript.compile(null, source);
        return this;
    }

    private Object jsFunction_exec() throws JavaScriptException {
        throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
    }

    private Object jsFunction_toString(Context cx, Object[] args) {
        Script thisScript = this.script;
        if (thisScript == null) {
            thisScript = this;
        }
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        return cx.decompileScript(thisScript, scope, 0);
    }

    public String getFunctionName() {
        return "";
    }

    public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(cx, scope);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return this.exec(cx, scope);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    protected String getIdName(int id) {
        if (this.prototypeIdShift != 0) {
            switch (id - this.prototypeIdShift + 1) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(id);
    }

    protected int mapNameToId(String s) {
        int id;
        if (this.prototypeIdShift != 0 && (id = NativeScript.toPrototypeId(s)) != 0) {
            return id + this.prototypeIdShift - 1;
        }
        return super.mapNameToId(s);
    }

    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 4: {
                X = "exec";
                id = 4;
                break;
            }
            case 7: {
                X = "compile";
                id = 3;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    static {
        Id_constructor = 1;
        Id_toString = 2;
        Id_compile = 3;
        Id_exec = 4;
        MAX_PROTOTYPE_ID = 4;
    }
}

