/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ShallowNodeIterator;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected Stack loops;
    protected Stack loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream ts, Scriptable scope) {
        return new IRFactory(ts, scope);
    }

    public Node transform(Node tree, Node enclosing, TokenStream ts, Scriptable scope) {
        Node node;
        this.loops = new Stack();
        this.loopEnds = new Stack();
        boolean bl = this.inFunction = tree.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(tree, this.getVariableTable(tree));
        }
        this.irFactory = this.createIRFactory(ts, scope);
        boolean hasFinally = false;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        block22: while ((node = iterator.nextNode()) != null) {
            int type = node.getType();
            switch (type) {
                case 110: {
                    if (node == tree) {
                        VariableTable vars = this.getVariableTable(tree);
                        this.addVariables(tree, vars);
                        Node stmts = node.getLastChild();
                        Node lastStmt = stmts.getLastChild();
                        if (lastStmt != null && lastStmt.getType() == 5) continue block22;
                        stmts.addChildToBack(new Node(5));
                        continue block22;
                    }
                    FunctionNode fnNode = (FunctionNode)node.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                        fnNode.setCheckThis(true);
                    }
                    this.addParameters(fnNode);
                    NodeTransformer inner = this.newInstance();
                    fnNode = (FunctionNode)inner.transform(fnNode, tree, ts, scope);
                    node.putProp(5, fnNode);
                    Vector<FunctionNode> fns = (Vector<FunctionNode>)tree.getProp(5);
                    if (fns == null) {
                        fns = new Vector<FunctionNode>(7);
                        tree.putProp(5, fns);
                    }
                    fns.addElement(fnNode);
                    continue block22;
                }
                case 136: {
                    Node next;
                    Node child = node.getFirstChild();
                    node.removeChild(child);
                    String id = child.getString();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        String otherId;
                        Node n = (Node)this.loops.elementAt(i);
                        if (n.getType() != 136 || !id.equals(otherId = (String)n.getProp(20))) continue;
                        String message = Context.getMessage1("msg.dup.label", id);
                        this.reportMessage(Context.getContext(), message, node, tree, true, scope);
                        continue block22;
                    }
                    node.putProp(20, id);
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    for (next = node.getNextSibling(); next != null && (next.getType() == 136 || next.getType() == 137); next = next.getNextSibling()) {
                    }
                    if (next == null) continue block22;
                    parent.addChildAfter(breakTarget, next);
                    node.putProp(2, breakTarget);
                    if (next.getType() == 138) {
                        node.putProp(3, next.getProp(3));
                    }
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    continue block22;
                }
                case 115: {
                    Node next;
                    Node breakTarget = new Node(137);
                    Node parent = iterator.getCurrentParent();
                    parent.addChildAfter(breakTarget, node);
                    Node sib = node;
                    Node child = node.getFirstChild().next;
                    while (child != null) {
                        next = child.next;
                        node.removeChild(child);
                        parent.addChildAfter(child, sib);
                        sib = child;
                        child = next;
                    }
                    node.putProp(2, breakTarget);
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    node.putProp(13, new Vector(13));
                    continue block22;
                }
                case 116: 
                case 117: {
                    Node sw = (Node)this.loops.peek();
                    if (type == 116) {
                        Vector cases = (Vector)sw.getProp(13);
                        cases.addElement(node);
                        continue block22;
                    }
                    sw.putProp(14, node);
                    continue block22;
                }
                case 144: {
                    Integer localCount = (Integer)tree.getProp(22);
                    if (localCount == null) {
                        tree.putProp(22, new Integer(1));
                        continue block22;
                    }
                    tree.putProp(22, new Integer(localCount + 1));
                    continue block22;
                }
                case 138: {
                    this.loops.push(node);
                    this.loopEnds.push(node.getProp(2));
                    continue block22;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    this.loops.push(node);
                    Node leave = node.getNextSibling();
                    if (leave.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(leave);
                    continue block22;
                }
                case 75: {
                    Integer localCount;
                    Node finallytarget = (Node)node.getProp(21);
                    if (finallytarget != null) {
                        hasFinally = true;
                        this.loops.push(node);
                        this.loopEnds.push(finallytarget);
                    }
                    if ((localCount = (Integer)tree.getProp(22)) == null) {
                        tree.putProp(22, new Integer(1));
                        continue block22;
                    }
                    tree.putProp(22, new Integer(localCount + 1));
                    continue block22;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.empty() || this.loopEnds.peek() != node) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    continue block22;
                }
                case 5: {
                    if (!hasFinally) continue block22;
                    Node parent = iterator.getCurrentParent();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node n = (Node)this.loops.elementAt(i);
                        int elemtype = n.getType();
                        if (elemtype == 75) {
                            Node jsrnode = new Node(143);
                            Object jsrtarget = n.getProp(21);
                            jsrnode.putProp(1, jsrtarget);
                            parent.addChildBefore(jsrnode, node);
                            continue;
                        }
                        if (elemtype != 124) continue;
                        parent.addChildBefore(new Node(4), node);
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Node target;
                    Node loop = null;
                    boolean labelled = node.hasChildren();
                    String id = null;
                    if (labelled) {
                        Node child = node.getFirstChild();
                        id = child.getString();
                        node.removeChild(child);
                    }
                    Node parent = iterator.getCurrentParent();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node n = (Node)this.loops.elementAt(i);
                        int elemtype = n.getType();
                        if (elemtype == 124) {
                            parent.addChildBefore(new Node(4), node);
                            continue;
                        }
                        if (elemtype == 75) {
                            Node jsrFinally = new Node(143);
                            Object jsrTarget = n.getProp(21);
                            jsrFinally.putProp(1, jsrTarget);
                            parent.addChildBefore(jsrFinally, node);
                            continue;
                        }
                        if (!labelled && (elemtype == 138 || elemtype == 115 && type == 121)) {
                            loop = n;
                            break;
                        }
                        if (!labelled || elemtype != 136 || !id.equals((String)n.getProp(20))) continue;
                        loop = n;
                        break;
                    }
                    int propType = type == 121 ? 2 : 3;
                    Node node2 = target = loop == null ? null : (Node)loop.getProp(propType);
                    if (loop == null || target == null) {
                        String message;
                        if (!labelled) {
                            message = type == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (loop != null) {
                            message = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            Object[] errArgs = new Object[]{id};
                            message = Context.getMessage("msg.undef.label", errArgs);
                        }
                        this.reportMessage(Context.getContext(), message, node, tree, true, scope);
                        node.setType(128);
                        continue block22;
                    }
                    node.setType(6);
                    node.putProp(1, target);
                    continue block22;
                }
                case 43: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node, tree);
                    continue block22;
                }
                case 30: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node, tree);
                    continue block22;
                }
                case 108: {
                    Node right = node.getLastChild();
                    right.setType(46);
                    continue block22;
                }
                case 140: {
                    node.setType(this.inFunction ? 57 : 2);
                    continue block22;
                }
                case 56: {
                    Vector<Node> regexps = (Vector<Node>)tree.getProp(12);
                    if (regexps == null) {
                        regexps = new Vector<Node>(3);
                        tree.putProp(12, regexps);
                    }
                    regexps.addElement(node);
                    Node n = new Node(56);
                    iterator.replaceCurrent(n);
                    n.putProp(12, node);
                    continue block22;
                }
                case 123: {
                    ShallowNodeIterator i = node.getChildIterator();
                    Node result = new Node(133);
                    while (i.hasMoreElements()) {
                        Node n = i.nextNode();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        Node asn = (Node)this.irFactory.createAssignment(128, n, init, null, false);
                        Node pop = new Node(57, asn, node.getDatum());
                        result.addChildToBack(pop);
                    }
                    iterator.replaceCurrent(result);
                    continue block22;
                }
                case 10: 
                case 31: {
                    VariableTable vars;
                    Node bind;
                    if (!this.inFunction || this.inWithStatement() || (bind = node.getFirstChild()) == null || bind.getType() != 61) continue block22;
                    String name = bind.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if ((vars = this.getVariableTable(tree)).getVariable(name) == null) continue block22;
                    if (type == 10) {
                        node.setType(73);
                        bind.setType(46);
                        continue block22;
                    }
                    Node n = new Node(109, new Integer(51));
                    iterator.replaceCurrent(n);
                    continue block22;
                }
                case 39: {
                    if (!this.inFunction) continue block22;
                    Node n = node.getFirstChild().getNextSibling();
                    String name = n == null ? "" : n.getString();
                    Context cx = Context.getCurrentContext();
                    if ((cx == null || !cx.isActivationNeeded(name)) && (!name.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)tree).setRequiresActivation(true);
                    continue block22;
                }
                case 44: {
                    VariableTable vars;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    String name = node.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if ((vars = this.getVariableTable(tree)).getVariable(name) == null) continue block22;
                    node.setType(72);
                    continue block22;
                }
            }
        }
        return tree;
    }

    protected void addVariables(Node tree, VariableTable vars) {
        Node node;
        boolean inFunction = tree.getType() == 110;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        Hashtable<String, Boolean> ht = null;
        while ((node = iterator.nextNode()) != null) {
            int nodeType = node.getType();
            if (inFunction && nodeType == 110 && node != tree && ((FunctionNode)node.getProp(5)).getFunctionType() == 3) {
                String name = node.getString();
                if (name == null) continue;
                vars.removeLocal(name);
                if (ht == null) {
                    ht = new Hashtable<String, Boolean>();
                }
                ht.put(name, Boolean.TRUE);
            }
            if (nodeType != 123) continue;
            ShallowNodeIterator i = node.getChildIterator();
            while (i.hasMoreElements()) {
                Node n = i.nextNode();
                if (ht != null && ht.get(n.getString()) != null) continue;
                vars.addLocal(n.getString());
            }
        }
        String name = (String)tree.getDatum();
        if (inFunction && ((FunctionNode)tree).getFunctionType() == 2 && name != null && name.length() > 0 && vars.getVariable(name) == null) {
            vars.addLocal(name);
            Node block = tree.getLastChild();
            Node setFn = new Node(57, new Node(73, new Node(46, name), new Node(109, new Integer(87))));
            block.addChildrenToFront(setFn);
        }
    }

    protected void addParameters(FunctionNode fnNode) {
        VariableTable vars = fnNode.getVariableTable();
        Node args = fnNode.getFirstChild();
        if (args.getType() == 94 && vars.getParameterCount() == 0) {
            ShallowNodeIterator i = args.getChildIterator();
            while (i.hasMoreElements()) {
                Node n = i.nextNode();
                String arg = n.getString();
                vars.addParameter(arg);
            }
        }
    }

    protected void visitNew(Node node, Node tree) {
    }

    protected void visitCall(Node node, Node tree) {
        Node left = node.getFirstChild();
        int argCount = 0;
        Node arg = left.getNextSibling();
        while (arg != null) {
            arg = arg.getNextSibling();
            ++argCount;
        }
        boolean addGetThis = false;
        if (left.getType() == 44) {
            VariableTable vars = this.getVariableTable(tree);
            String name = left.getString();
            if (this.inFunction && vars.getVariable(name) != null && !this.inWithStatement()) {
                left.setType(72);
            } else {
                node.removeChild(left);
                left.setType(71);
                Node str = left.cloneNode();
                str.setType(46);
                Node getProp = new Node(39, left, str);
                node.addChildToFront(getProp);
                left = getProp;
                boolean bl = addGetThis = this.inWithStatement() || !this.inFunction;
            }
        }
        if (left.getType() != 39 && left.getType() != 41) {
            node.removeChild(left);
            Node tmp = this.irFactory.createNewTemp(left);
            Node use = this.irFactory.createUseTemp(tmp);
            use.putProp(6, tmp);
            Node parent = new Node(141, use);
            node.addChildToFront(parent);
            node.addChildToFront(tmp);
            return;
        }
        Node leftLeft = left.getFirstChild();
        left.removeChild(leftLeft);
        Node tmp = this.irFactory.createNewTemp(leftLeft);
        left.addChildToFront(tmp);
        Node use = this.irFactory.createUseTemp(tmp);
        use.putProp(6, tmp);
        if (addGetThis) {
            use = new Node(68, use);
        }
        node.addChildAfter(use, left);
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node n = (Node)this.loops.elementAt(i);
            if (n.getType() != 124) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialCallName(Node tree, Node node) {
        Node left = node.getFirstChild();
        boolean isSpecial = false;
        if (left.getType() == 44) {
            String name = left.getString();
            isSpecial = name.equals("eval") || name.equals("With");
        } else if (left.getType() == 39) {
            String name = left.getLastChild().getString();
            isSpecial = name.equals("exec");
        }
        if (isSpecial) {
            if (this.inFunction) {
                ((FunctionNode)tree).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node tree) {
        if (this.inFunction) {
            return ((FunctionNode)tree).getVariableTable();
        }
        VariableTable result = (VariableTable)tree.getProp(10);
        if (result == null) {
            result = this.createVariableTable();
            tree.putProp(10, result);
        }
        return result;
    }

    protected void reportMessage(Context cx, String msg, Node stmt, Node tree, boolean isError, Scriptable scope) {
        Object prop;
        Object obj = stmt.getDatum();
        int lineno = 0;
        if (obj != null && obj instanceof Integer) {
            lineno = (Integer)obj;
        }
        Object object = prop = tree == null ? null : tree.getProp(16);
        if (isError) {
            if (scope != null) {
                throw NativeGlobal.constructError(cx, "SyntaxError", msg, scope, (String)prop, lineno, 0, null);
            }
            Context.reportError(msg, (String)prop, lineno, null, 0);
        } else {
            Context.reportWarning(msg, (String)prop, lineno, null, 0);
        }
    }
}

