/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Source;
import org.mozilla.javascript.TokenStream;

class Parser {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;

    public Parser(IRFactory nf) {
        this.nf = nf;
    }

    private void mustMatchToken(TokenStream ts, int toMatch, String messageId) throws JavaScriptException, IOException {
        int tt = ts.getToken();
        if (tt != toMatch) {
            this.reportError(ts, messageId);
            ts.ungetToken(tt);
        }
    }

    private void reportError(TokenStream ts, String messageId) throws JavaScriptException {
        this.ok = false;
        ts.reportSyntaxError(messageId, null);
        throw new JavaScriptException((Object)messageId);
    }

    public Object parse(TokenStream ts) throws IOException {
        this.ok = true;
        Source source = new Source();
        int baseLineno = ts.getLineno();
        Object tempBlock = this.nf.createLeaf(133);
        while (true) {
            ts.flags |= 0x10;
            int tt = ts.getToken();
            ts.flags &= ~16;
            if (tt <= 0) break;
            if (tt == 110) {
                try {
                    this.nf.addChildToBack(tempBlock, this.function(ts, source, false));
                    source.append('\u0001');
                    this.wellTerminated(ts, 110);
                    continue;
                }
                catch (JavaScriptException e) {
                    this.ok = false;
                    break;
                }
            }
            ts.ungetToken(tt);
            this.nf.addChildToBack(tempBlock, this.statement(ts, source));
        }
        if (!this.ok) {
            return null;
        }
        Object pn = this.nf.createScript(tempBlock, ts.getSourceName(), baseLineno, ts.getLineno(), source.buf.toString());
        return pn;
    }

    private Object parseFunctionBody(TokenStream ts, Source source) throws IOException {
        int oldflags = ts.flags;
        ts.flags &= 0xFFFFFFF3;
        ts.flags |= 2;
        Object pn = this.nf.createBlock(ts.getLineno());
        try {
            try {
                int tt;
                while ((tt = ts.peekToken()) > 0 && tt != 93) {
                    if (tt == 110) {
                        ts.getToken();
                        this.nf.addChildToBack(pn, this.function(ts, source, false));
                        source.append('\u0001');
                        this.wellTerminated(ts, 110);
                        continue;
                    }
                    this.nf.addChildToBack(pn, this.statement(ts, source));
                }
                Object var7_7 = null;
                ts.flags = oldflags;
            }
            catch (JavaScriptException e) {
                this.ok = false;
                Object var7_8 = null;
                ts.flags = oldflags;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            ts.flags = oldflags;
            throw throwable;
        }
        return pn;
    }

    private Object function(TokenStream ts, Source source, boolean isExpr) throws JavaScriptException, IOException {
        String name = null;
        Object args = this.nf.createLeaf(94);
        int baseLineno = ts.getLineno();
        source.append('n');
        source.append(source.functionNumber);
        source.functionNumber = (char)(source.functionNumber + '\u0001');
        source = new Source();
        source.append('n');
        if (ts.matchToken(44)) {
            name = ts.getString();
            source.addString(44, name);
        }
        this.mustMatchToken(ts, 94, "msg.no.paren.parms");
        source.append('^');
        if (!ts.matchToken(95)) {
            boolean first = true;
            do {
                if (!first) {
                    source.append('`');
                }
                first = false;
                this.mustMatchToken(ts, 44, "msg.no.parm");
                String s = ts.getString();
                this.nf.addChildToBack(args, this.nf.createName(s));
                source.addString(44, s);
            } while (ts.matchToken(96));
            this.mustMatchToken(ts, 95, "msg.no.paren.after.parms");
        }
        source.append('_');
        this.mustMatchToken(ts, 92, "msg.no.brace.body");
        source.append('\\');
        source.append('\u0001');
        Object body = this.parseFunctionBody(ts, source);
        this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
        source.append(']');
        return this.nf.createFunction(name, args, body, ts.getSourceName(), baseLineno, ts.getLineno(), source.buf.toString(), isExpr);
    }

    private Object statements(TokenStream ts, Source source) throws IOException {
        int tt;
        Object pn = this.nf.createBlock(ts.getLineno());
        while ((tt = ts.peekToken()) > 0 && tt != 93) {
            this.nf.addChildToBack(pn, this.statement(ts, source));
        }
        return pn;
    }

    private Object condition(TokenStream ts, Source source) throws JavaScriptException, IOException {
        this.mustMatchToken(ts, 94, "msg.no.paren.cond");
        source.append('^');
        Object pn = this.expr(ts, source, false);
        this.mustMatchToken(ts, 95, "msg.no.paren.after.cond");
        source.append('_');
        return pn;
    }

    private boolean wellTerminated(TokenStream ts, int lastExprType) throws JavaScriptException, IOException {
        int tt = ts.peekTokenSameLine();
        if (tt == -1) {
            return false;
        }
        if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
            int version = Context.getContext().getLanguageVersion();
            if ((tt == 110 || lastExprType == 110) && version < 120) {
                return true;
            }
            this.reportError(ts, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream ts) throws JavaScriptException, IOException {
        int lineno = ts.getLineno();
        String label = null;
        int tt = ts.peekTokenSameLine();
        if (tt == 44) {
            ts.getToken();
            label = ts.getString();
        }
        if (lineno == ts.getLineno()) {
            this.wellTerminated(ts, -1);
        }
        return label;
    }

    private Object statement(TokenStream ts, Source source) throws IOException {
        try {
            Object object = this.statementHelper(ts, source);
            return object;
        }
        catch (JavaScriptException e) {
            int t;
            int lineno = ts.getLineno();
            while ((t = ts.getToken()) != 89 && t != 1 && t != 0 && t != -1) {
            }
            Object object = this.nf.createExprStatement(this.nf.createName("error"), lineno);
            return object;
        }
    }

    private Object statementHelper(TokenStream ts, Source source) throws JavaScriptException, IOException {
        Object pn;
        block47: {
            pn = null;
            boolean skipsemi = false;
            int lastExprType = 0;
            int tt = ts.getToken();
            switch (tt) {
                case 113: {
                    skipsemi = true;
                    source.append('q');
                    int lineno = ts.getLineno();
                    Object cond = this.condition(ts, source);
                    source.append('\\');
                    source.append('\u0001');
                    Object ifTrue = this.statement(ts, source);
                    Object ifFalse = null;
                    if (ts.matchToken(114)) {
                        source.append(']');
                        source.append('r');
                        source.append('\\');
                        source.append('\u0001');
                        ifFalse = this.statement(ts, source);
                    }
                    source.append(']');
                    source.append('\u0001');
                    pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno);
                    break;
                }
                case 115: {
                    skipsemi = true;
                    source.append('s');
                    pn = this.nf.createSwitch(ts.getLineno());
                    Object cur_case = null;
                    this.mustMatchToken(ts, 94, "msg.no.paren.switch");
                    source.append('^');
                    this.nf.addChildToBack(pn, this.expr(ts, source, false));
                    this.mustMatchToken(ts, 95, "msg.no.paren.after.switch");
                    source.append('_');
                    this.mustMatchToken(ts, 92, "msg.no.brace.switch");
                    source.append('\\');
                    source.append('\u0001');
                    while ((tt = ts.getToken()) != 93 && tt != 0) {
                        switch (tt) {
                            case 116: {
                                source.append('t');
                                cur_case = this.nf.createUnary(116, this.expr(ts, source, false));
                                source.append('c');
                                source.append('\u0001');
                                break;
                            }
                            case 117: {
                                cur_case = this.nf.createLeaf(117);
                                source.append('u');
                                source.append('c');
                                source.append('\u0001');
                                break;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.switch");
                                break;
                            }
                        }
                        this.mustMatchToken(ts, 99, "msg.no.colon.case");
                        Object case_statements = this.nf.createLeaf(133);
                        while ((tt = ts.peekToken()) != 93 && tt != 116 && tt != 117 && tt != 0) {
                            this.nf.addChildToBack(case_statements, this.statement(ts, source));
                        }
                        this.nf.addChildToBack(cur_case, case_statements);
                        this.nf.addChildToBack(pn, cur_case);
                    }
                    source.append(']');
                    source.append('\u0001');
                    break;
                }
                case 118: {
                    skipsemi = true;
                    source.append('v');
                    int lineno = ts.getLineno();
                    Object cond = this.condition(ts, source);
                    source.append('\\');
                    source.append('\u0001');
                    Object body = this.statement(ts, source);
                    source.append(']');
                    source.append('\u0001');
                    pn = this.nf.createWhile(cond, body, lineno);
                    break;
                }
                case 119: {
                    source.append('w');
                    source.append('\\');
                    source.append('\u0001');
                    int lineno = ts.getLineno();
                    Object body = this.statement(ts, source);
                    source.append(']');
                    this.mustMatchToken(ts, 118, "msg.no.while.do");
                    source.append('v');
                    Object cond = this.condition(ts, source);
                    pn = this.nf.createDoWhile(body, cond, lineno);
                    break;
                }
                case 120: {
                    Object cond;
                    Object init;
                    skipsemi = true;
                    source.append('x');
                    int lineno = ts.getLineno();
                    Object incr = null;
                    this.mustMatchToken(ts, 94, "msg.no.paren.for");
                    source.append('^');
                    tt = ts.peekToken();
                    if (tt == 89) {
                        init = this.nf.createLeaf(132);
                    } else if (tt == 123) {
                        ts.getToken();
                        init = this.variables(ts, source, true);
                    } else {
                        init = this.expr(ts, source, true);
                    }
                    tt = ts.peekToken();
                    if (tt == 103 && ts.getOp() == 63) {
                        ts.matchToken(103);
                        source.append('?');
                        cond = this.expr(ts, source, false);
                    } else {
                        this.mustMatchToken(ts, 89, "msg.no.semi.for");
                        source.append('Y');
                        cond = ts.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(ts, source, false);
                        this.mustMatchToken(ts, 89, "msg.no.semi.for.cond");
                        source.append('Y');
                        incr = ts.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(ts, source, false);
                    }
                    this.mustMatchToken(ts, 95, "msg.no.paren.for.ctrl");
                    source.append('_');
                    source.append('\\');
                    source.append('\u0001');
                    Object body = this.statement(ts, source);
                    source.append(']');
                    source.append('\u0001');
                    if (incr == null) {
                        pn = this.nf.createForIn(init, cond, body, lineno);
                        break;
                    }
                    pn = this.nf.createFor(init, cond, incr, body, lineno);
                    break;
                }
                case 75: {
                    int lineno = ts.getLineno();
                    Object catchblocks = null;
                    Object finallyblock = null;
                    skipsemi = true;
                    source.append('K');
                    source.append('\\');
                    source.append('\u0001');
                    Object tryblock = this.statement(ts, source);
                    source.append(']');
                    source.append('\u0001');
                    catchblocks = this.nf.createLeaf(133);
                    boolean sawDefaultCatch = false;
                    int peek = ts.peekToken();
                    if (peek == 125) {
                        while (ts.matchToken(125)) {
                            if (sawDefaultCatch) {
                                this.reportError(ts, "msg.catch.unreachable");
                            }
                            source.append('}');
                            this.mustMatchToken(ts, 94, "msg.no.paren.catch");
                            source.append('^');
                            this.mustMatchToken(ts, 44, "msg.bad.catchcond");
                            String varName = ts.getString();
                            source.addString(44, varName);
                            Object catchCond = null;
                            if (ts.matchToken(113)) {
                                source.append('q');
                                catchCond = this.expr(ts, source, false);
                            } else {
                                sawDefaultCatch = true;
                            }
                            this.mustMatchToken(ts, 95, "msg.bad.catchcond");
                            source.append('_');
                            this.mustMatchToken(ts, 92, "msg.no.brace.catchblock");
                            source.append('\\');
                            source.append('\u0001');
                            this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, catchCond, this.statements(ts, source), ts.getLineno()));
                            this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
                            source.append(']');
                            source.append('\u0001');
                        }
                    } else if (peek != 126) {
                        this.mustMatchToken(ts, 126, "msg.try.no.catchfinally");
                    }
                    if (ts.matchToken(126)) {
                        source.append('~');
                        source.append('\\');
                        source.append('\u0001');
                        finallyblock = this.statement(ts, source);
                        source.append(']');
                        source.append('\u0001');
                    }
                    pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno);
                    break;
                }
                case 62: {
                    int lineno = ts.getLineno();
                    source.append('>');
                    pn = this.nf.createThrow(this.expr(ts, source, false), lineno);
                    if (lineno != ts.getLineno()) break;
                    this.wellTerminated(ts, -1);
                    break;
                }
                case 121: {
                    int lineno = ts.getLineno();
                    source.append('y');
                    String label = this.matchLabel(ts);
                    if (label != null) {
                        source.addString(44, label);
                    }
                    pn = this.nf.createBreak(label, lineno);
                    break;
                }
                case 122: {
                    int lineno = ts.getLineno();
                    source.append('z');
                    String label = this.matchLabel(ts);
                    if (label != null) {
                        source.addString(44, label);
                    }
                    pn = this.nf.createContinue(label, lineno);
                    break;
                }
                case 124: {
                    skipsemi = true;
                    source.append('|');
                    int lineno = ts.getLineno();
                    this.mustMatchToken(ts, 94, "msg.no.paren.with");
                    source.append('^');
                    Object obj = this.expr(ts, source, false);
                    this.mustMatchToken(ts, 95, "msg.no.paren.after.with");
                    source.append('_');
                    source.append('\\');
                    source.append('\u0001');
                    Object body = this.statement(ts, source);
                    source.append(']');
                    source.append('\u0001');
                    pn = this.nf.createWith(obj, body, lineno);
                    break;
                }
                case 123: {
                    int lineno = ts.getLineno();
                    pn = this.variables(ts, source, false);
                    if (ts.getLineno() != lineno) break;
                    this.wellTerminated(ts, -1);
                    break;
                }
                case 5: {
                    Object retExpr = null;
                    int lineno = 0;
                    source.append('\u0005');
                    if ((ts.flags & 2) == 0) {
                        this.reportError(ts, "msg.bad.return");
                    }
                    ts.flags |= 0x10;
                    tt = ts.peekTokenSameLine();
                    ts.flags &= ~16;
                    if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
                        lineno = ts.getLineno();
                        retExpr = this.expr(ts, source, false);
                        if (ts.getLineno() == lineno) {
                            this.wellTerminated(ts, -1);
                        }
                        ts.flags |= 4;
                    } else {
                        ts.flags |= 8;
                    }
                    pn = this.nf.createReturn(retExpr, lineno);
                    break;
                }
                case 92: {
                    skipsemi = true;
                    pn = this.statements(ts, source);
                    this.mustMatchToken(ts, 93, "msg.no.brace.block");
                    break;
                }
                case -1: 
                case 1: 
                case 89: {
                    pn = this.nf.createLeaf(132);
                    skipsemi = true;
                    break;
                }
                default: {
                    lastExprType = tt;
                    int tokenno = ts.getTokenno();
                    ts.ungetToken(tt);
                    int lineno = ts.getLineno();
                    pn = this.expr(ts, source, false);
                    if (ts.peekToken() == 99) {
                        if (lastExprType != 44 || ts.getTokenno() != tokenno) {
                            this.reportError(ts, "msg.bad.label");
                        }
                        ts.getToken();
                        String name = ts.getString();
                        pn = this.nf.createLabel(name, lineno);
                        source.append('c');
                        source.append('\u0001');
                        return pn;
                    }
                    if (lastExprType == 110) {
                        this.nf.setFunctionExpressionStatement(pn);
                    }
                    pn = this.nf.createExprStatement(pn, lineno);
                    if (ts.getLineno() != lineno && (lastExprType != 110 || ts.getLineno() != this.lastExprEndLine)) break;
                    this.wellTerminated(ts, lastExprType);
                    break;
                }
            }
            ts.matchToken(89);
            if (skipsemi) break block47;
            source.append('Y');
            source.append('\u0001');
        }
        return pn;
    }

    private Object variables(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.nf.createVariables(ts.getLineno());
        boolean first = true;
        source.append('{');
        do {
            this.mustMatchToken(ts, 44, "msg.bad.var");
            String s = ts.getString();
            if (!first) {
                source.append('`');
            }
            first = false;
            source.addString(44, s);
            Object name = this.nf.createName(s);
            if (ts.matchToken(97)) {
                if (ts.getOp() != 128) {
                    this.reportError(ts, "msg.bad.var.init");
                }
                source.append('a');
                source.append('\u0080');
                Object init = this.assignExpr(ts, source, inForInit);
                this.nf.addChildToBack(name, init);
            }
            this.nf.addChildToBack(pn, name);
        } while (ts.matchToken(96));
        return pn;
    }

    private Object expr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.assignExpr(ts, source, inForInit);
        while (ts.matchToken(96)) {
            source.append('`');
            pn = this.nf.createBinary(96, pn, this.assignExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object assignExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.condExpr(ts, source, inForInit);
        if (ts.matchToken(97)) {
            source.append('a');
            source.append((char)ts.getOp());
            pn = this.nf.createBinary(97, ts.getOp(), pn, this.assignExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object condExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.orExpr(ts, source, inForInit);
        if (ts.matchToken(98)) {
            source.append('b');
            Object ifTrue = this.assignExpr(ts, source, false);
            this.mustMatchToken(ts, 99, "msg.no.colon.cond");
            source.append('c');
            Object ifFalse = this.assignExpr(ts, source, inForInit);
            return this.nf.createTernary(pn, ifTrue, ifFalse);
        }
        return pn;
    }

    private Object orExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.andExpr(ts, source, inForInit);
        if (ts.matchToken(100)) {
            source.append('d');
            pn = this.nf.createBinary(100, pn, this.orExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object andExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.bitOrExpr(ts, source, inForInit);
        if (ts.matchToken(101)) {
            source.append('e');
            pn = this.nf.createBinary(101, pn, this.andExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object bitOrExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.bitXorExpr(ts, source, inForInit);
        while (ts.matchToken(11)) {
            source.append('\u000b');
            pn = this.nf.createBinary(11, pn, this.bitXorExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object bitXorExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.bitAndExpr(ts, source, inForInit);
        while (ts.matchToken(12)) {
            source.append('\f');
            pn = this.nf.createBinary(12, pn, this.bitAndExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object bitAndExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.eqExpr(ts, source, inForInit);
        while (ts.matchToken(13)) {
            source.append('\r');
            pn = this.nf.createBinary(13, pn, this.eqExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object eqExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.relExpr(ts, source, inForInit);
        while (ts.matchToken(102)) {
            source.append('f');
            source.append((char)ts.getOp());
            pn = this.nf.createBinary(102, ts.getOp(), pn, this.relExpr(ts, source, inForInit));
        }
        return pn;
    }

    private Object relExpr(TokenStream ts, Source source, boolean inForInit) throws JavaScriptException, IOException {
        Object pn = this.shiftExpr(ts, source);
        while (ts.matchToken(103)) {
            int op = ts.getOp();
            if (inForInit && op == 63) {
                ts.ungetToken(103);
                break;
            }
            source.append('g');
            source.append((char)op);
            pn = this.nf.createBinary(103, op, pn, this.shiftExpr(ts, source));
        }
        return pn;
    }

    private Object shiftExpr(TokenStream ts, Source source) throws JavaScriptException, IOException {
        Object pn = this.addExpr(ts, source);
        while (ts.matchToken(104)) {
            source.append('h');
            source.append((char)ts.getOp());
            pn = this.nf.createBinary(ts.getOp(), pn, this.addExpr(ts, source));
        }
        return pn;
    }

    private Object addExpr(TokenStream ts, Source source) throws JavaScriptException, IOException {
        int tt;
        Object pn = this.mulExpr(ts, source);
        while ((tt = ts.getToken()) == 23 || tt == 24) {
            source.append((char)tt);
            pn = this.nf.createBinary(tt, pn, this.mulExpr(ts, source));
        }
        ts.ungetToken(tt);
        return pn;
    }

    private Object mulExpr(TokenStream ts, Source source) throws JavaScriptException, IOException {
        int tt;
        Object pn = this.unaryExpr(ts, source);
        while ((tt = ts.peekToken()) == 25 || tt == 26 || tt == 27) {
            tt = ts.getToken();
            source.append((char)tt);
            pn = this.nf.createBinary(tt, pn, this.unaryExpr(ts, source));
        }
        return pn;
    }

    private Object unaryExpr(TokenStream ts, Source source) throws JavaScriptException, IOException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 105: {
                source.append('i');
                source.append((char)ts.getOp());
                return this.nf.createUnary(105, ts.getOp(), this.unaryExpr(ts, source));
            }
            case 23: 
            case 24: {
                source.append('i');
                source.append((char)tt);
                return this.nf.createUnary(105, tt, this.unaryExpr(ts, source));
            }
            case 106: 
            case 107: {
                source.append((char)tt);
                return this.nf.createUnary(tt, 130, this.memberExpr(ts, source, true));
            }
            case 31: {
                source.append('\u001f');
                return this.nf.createUnary(31, this.unaryExpr(ts, source));
            }
            case -1: {
                break;
            }
            default: {
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                Object pn = this.memberExpr(ts, source, true);
                int peeked = ts.peekToken();
                if ((peeked == 106 || peeked == 107) && ts.getLineno() == lineno) {
                    int pf = ts.getToken();
                    source.append((char)pf);
                    return this.nf.createUnary(pf, 131, pn);
                }
                return pn;
            }
        }
        return this.nf.createName("err");
    }

    private Object argumentList(TokenStream ts, Source source, Object listNode) throws JavaScriptException, IOException {
        ts.flags |= 0x10;
        boolean matched = ts.matchToken(95);
        ts.flags &= ~16;
        if (!matched) {
            boolean first = true;
            do {
                if (!first) {
                    source.append('`');
                }
                first = false;
                this.nf.addChildToBack(listNode, this.assignExpr(ts, source, false));
            } while (ts.matchToken(96));
            this.mustMatchToken(ts, 95, "msg.no.paren.arg");
        }
        source.append('_');
        return listNode;
    }

    private Object memberExpr(TokenStream ts, Source source, boolean allowCallSyntax) throws JavaScriptException, IOException {
        Object pn;
        ts.flags |= 0x10;
        int tt = ts.peekToken();
        ts.flags &= ~16;
        if (tt == 30) {
            ts.getToken();
            source.append('\u001e');
            pn = this.nf.createLeaf(30);
            this.nf.addChildToBack(pn, this.memberExpr(ts, source, false));
            if (ts.matchToken(94)) {
                source.append('^');
                pn = this.argumentList(ts, source, pn);
            }
            if ((tt = ts.peekToken()) == 92) {
                this.nf.addChildToBack(pn, this.primaryExpr(ts, source));
            }
        } else {
            pn = this.primaryExpr(ts, source);
        }
        this.lastExprEndLine = ts.getLineno();
        while ((tt = ts.getToken()) > 0) {
            if (tt == 108) {
                source.append('l');
                this.mustMatchToken(ts, 44, "msg.no.name.after.dot");
                String s = ts.getString();
                source.addString(44, s);
                pn = this.nf.createBinary(108, pn, this.nf.createName(ts.getString()));
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (tt == 90) {
                source.append('Z');
                pn = this.nf.createBinary(90, pn, this.expr(ts, source, false));
                this.mustMatchToken(ts, 91, "msg.no.bracket.index");
                source.append('[');
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (allowCallSyntax && tt == 94) {
                pn = this.nf.createUnary(43, pn);
                source.append('^');
                pn = this.argumentList(ts, source, pn);
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            ts.ungetToken(tt);
            break;
        }
        return pn;
    }

    private Object primaryExpr(TokenStream ts, Source source) throws JavaScriptException, IOException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 110: {
                return this.function(ts, source, true);
            }
            case 90: {
                source.append('Z');
                Object pn = this.nf.createLeaf(134);
                ts.flags |= 0x10;
                boolean matched = ts.matchToken(91);
                ts.flags &= ~16;
                if (!matched) {
                    boolean first = true;
                    do {
                        ts.flags |= 0x10;
                        tt = ts.peekToken();
                        ts.flags &= ~16;
                        if (!first) {
                            source.append('`');
                        } else {
                            first = false;
                        }
                        if (tt == 91) break;
                        if (tt == 96) {
                            this.nf.addChildToBack(pn, this.nf.createLeaf(109, 74));
                            continue;
                        }
                        this.nf.addChildToBack(pn, this.assignExpr(ts, source, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 91, "msg.no.bracket.arg");
                }
                source.append('[');
                return this.nf.createArrayLiteral(pn);
            }
            case 92: {
                Object pn = this.nf.createLeaf(135);
                source.append('\\');
                if (!ts.matchToken(93)) {
                    boolean first = true;
                    block19: do {
                        Object property;
                        if (!first) {
                            source.append('`');
                        } else {
                            first = false;
                        }
                        tt = ts.getToken();
                        switch (tt) {
                            case 44: 
                            case 46: {
                                String s = ts.getString();
                                source.addString(44, s);
                                property = this.nf.createString(ts.getString());
                                break;
                            }
                            case 45: {
                                Number n = ts.getNumber();
                                source.addNumber(n);
                                property = this.nf.createNumber(n);
                                break;
                            }
                            case 93: {
                                ts.ungetToken(tt);
                                break block19;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(ts, 99, "msg.no.colon.prop");
                        source.append('\u0087');
                        this.nf.addChildToBack(pn, property);
                        this.nf.addChildToBack(pn, this.assignExpr(ts, source, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 93, "msg.no.brace.prop");
                }
                source.append(']');
                return this.nf.createObjectLiteral(pn);
            }
            case 94: {
                source.append('^');
                Object pn = this.expr(ts, source, false);
                source.append('_');
                this.mustMatchToken(ts, 95, "msg.no.paren");
                return pn;
            }
            case 44: {
                String name = ts.getString();
                source.addString(44, name);
                return this.nf.createName(name);
            }
            case 45: {
                Number n = ts.getNumber();
                source.addNumber(n);
                return this.nf.createNumber(n);
            }
            case 46: {
                String s = ts.getString();
                source.addString(46, s);
                return this.nf.createString(s);
            }
            case 56: {
                String flags = ts.regExpFlags;
                ts.regExpFlags = null;
                String re = ts.getString();
                source.addString(56, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('/'))).append(re).append('/').append(flags))));
                return this.nf.createRegExp(re, flags);
            }
            case 109: {
                source.append('m');
                source.append((char)ts.getOp());
                return this.nf.createLeaf(109, ts.getOp());
            }
            case 127: {
                this.reportError(ts, "msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(ts, "msg.syntax");
                break;
            }
        }
        return null;
    }
}

