/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public abstract class ScriptableObject
implements Scriptable {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS;
    private static final Slot REMOVED;
    private static Hashtable exclusionList;
    private Slot[] slots;
    private int count;
    private Slot lastAccess = REMOVED;
    private static final Class ContextClass;
    static Class class$org$mozilla$javascript$Scriptable;
    static Class class$org$mozilla$javascript$ScriptableObject;
    static Class class$org$mozilla$javascript$Function;
    static Class class$org$mozilla$javascript$Context;
    static Class class$org$mozilla$javascript$FunctionObject;

    public abstract String getClassName();

    public boolean has(String name, Scriptable start) {
        return this.getSlot(name, name.hashCode(), false) != null;
    }

    public boolean has(int index, Scriptable start) {
        return this.getSlot(null, index, false) != null;
    }

    public Object get(String name, Scriptable start) {
        Slot slot = this.lastAccess;
        if (name == slot.stringKey && slot.wasDeleted == 0) {
            return slot.value;
        }
        int hashCode = name.hashCode();
        slot = this.getSlot(name, hashCode, false);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if ((slot.flags & 1) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                if (getterSlot.delegateTo == null) {
                    Class<?> clazz = getterSlot.getter.getDeclaringClass();
                    while (!clazz.isInstance(start)) {
                        if ((start = start.getPrototype()) != null) continue;
                        start = this;
                        break;
                    }
                    Object object = getterSlot.getter.invoke((Object)start, ScriptRuntime.emptyArgs);
                    return object;
                }
                Object[] args = new Object[]{this};
                Object object = getterSlot.getter.invoke(getterSlot.delegateTo, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw WrappedException.wrapException(e);
            }
            catch (IllegalAccessException e) {
                throw WrappedException.wrapException(e);
            }
        }
        slot.stringKey = name;
        this.lastAccess = slot;
        return slot.value;
    }

    public Object get(int index, Scriptable start) {
        Slot slot = this.getSlot(null, index, false);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String name, Scriptable start, Object value) {
        int hash = name.hashCode();
        Slot slot = this.getSlot(name, hash, false);
        if (slot == null) {
            if (start != this) {
                start.put(name, start, value);
                return;
            }
            slot = this.getSlotToSet(name, hash, false);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                Class<?>[] pTypes = getterSlot.setter.getParameterTypes();
                Class<?> desired = pTypes[pTypes.length - 1];
                Object actualArg = FunctionObject.convertArg(start, value, desired);
                if (getterSlot.delegateTo == null) {
                    Object[] arg = new Object[]{actualArg};
                    Class<?> clazz = getterSlot.setter.getDeclaringClass();
                    while (!clazz.isInstance(start)) {
                        if ((start = start.getPrototype()) != null) continue;
                        start = this;
                        break;
                    }
                    Object v = getterSlot.setter.invoke((Object)start, arg);
                    if (getterSlot.setterReturnsValue) {
                        slot.value = v;
                        if (!(v instanceof Method)) {
                            slot.flags = 0;
                        }
                    }
                    return;
                }
                Object[] args = new Object[]{this, actualArg};
                Object v = getterSlot.setter.invoke(getterSlot.delegateTo, args);
                if (getterSlot.setterReturnsValue) {
                    slot.value = v;
                    if (!(v instanceof Method)) {
                        slot.flags = 0;
                    }
                }
                return;
            }
            catch (InvocationTargetException e) {
                throw WrappedException.wrapException(e);
            }
            catch (IllegalAccessException e) {
                throw WrappedException.wrapException(e);
            }
        }
        if (this == start) {
            slot.value = value;
            slot.stringKey = name;
            this.lastAccess = slot;
        } else {
            start.put(name, start, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        Slot slot = this.getSlot(null, index, false);
        if (slot == null) {
            if (start != this) {
                start.put(index, start, value);
                return;
            }
            slot = this.getSlotToSet(null, index, false);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(index, start, value);
        }
    }

    public void delete(String name) {
        this.removeSlot(name, name.hashCode());
    }

    public void delete(int index) {
        this.removeSlot(null, index);
    }

    public int getAttributes(String name, Scriptable start) throws PropertyException {
        Slot slot = this.getSlot(name, name.hashCode(), false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public int getAttributes(int index, Scriptable start) throws PropertyException {
        Slot slot = this.getSlot(null, index, false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public void setAttributes(String name, Scriptable start, int attributes) throws PropertyException {
        attributes &= 7;
        Slot slot = this.getSlot(name, name.hashCode(), false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)attributes;
    }

    public void setAttributes(int index, Scriptable start, int attributes) throws PropertyException {
        Slot slot = this.getSlot(null, index, false);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)attributes;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class typeHint) {
        Context cx = null;
        try {
            for (int i = 0; i < 2; ++i) {
                Object u;
                Object hint;
                Object val;
                boolean bl = typeHint == ScriptRuntime.StringClass ? i == 0 : i == 1;
                if (bl) {
                    Object v = ScriptableObject.getProperty((Scriptable)this, "toString");
                    if (!(v instanceof Function)) continue;
                    Function fun = (Function)v;
                    if (cx == null) {
                        cx = Context.getContext();
                    }
                    val = fun.call(cx, fun.getParentScope(), this, ScriptRuntime.emptyArgs);
                } else {
                    if (typeHint == null) {
                        hint = "undefined";
                    } else if (typeHint == ScriptRuntime.StringClass) {
                        hint = "string";
                    } else if (typeHint == ScriptRuntime.ScriptableClass) {
                        hint = "object";
                    } else if (typeHint == ScriptRuntime.FunctionClass) {
                        hint = "function";
                    } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                        hint = "boolean";
                    } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                        hint = "number";
                    } else {
                        throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                    }
                    Object v = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                    if (!(v instanceof Function)) continue;
                    Function fun = (Function)v;
                    Object[] args = new Object[]{hint};
                    if (cx == null) {
                        cx = Context.getContext();
                    }
                    val = fun.call(cx, fun.getParentScope(), this, args);
                }
                if (!(val == null || val != Undefined.instance && val instanceof Scriptable && typeHint != (class$org$mozilla$javascript$Scriptable == null ? ScriptableObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable) && typeHint != (class$org$mozilla$javascript$Function == null ? ScriptableObject.class$("org.mozilla.javascript.Function") : class$org$mozilla$javascript$Function))) {
                    hint = val;
                    return hint;
                }
                if (!(val instanceof NativeJavaObject) || !((u = ((Wrapper)val).unwrap()) instanceof String)) continue;
                Object object = u;
                return object;
            }
        }
        catch (JavaScriptException i) {
            // empty catch block
        }
        String arg = typeHint == null ? "undefined" : typeHint.toString();
        throw NativeGlobal.typeError1("msg.default.value", arg, this);
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public static void defineClass(Scriptable scope, Class clazz) throws PropertyException, ClassDefinitionException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ScriptableObject.defineClass(scope, clazz, false);
    }

    public static void defineClass(Scriptable scope, Class clazz, boolean sealed) throws PropertyException, ClassDefinitionException, InvocationTargetException, InstantiationException, IllegalAccessException {
        block58: {
            FunctionObject ctor;
            Method[] methods = FunctionObject.getMethodList(clazz);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("init")) continue;
                Class<?>[] parmTypes = method.getParameterTypes();
                if (parmTypes.length == 3 && parmTypes[0] == ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                    method.invoke(null, args);
                    return;
                }
                if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method.getModifiers())) continue;
                Object[] args = new Object[]{scope};
                method.invoke(null, args);
                return;
            }
            Hashtable exclusionList = ScriptableObject.getExclusionList();
            Constructor<?>[] ctors = clazz.getConstructors();
            Constructor<?> protoCtor = null;
            for (int i = 0; i < ctors.length; ++i) {
                if (ctors[i].getParameterTypes().length != 0) continue;
                protoCtor = ctors[i];
                break;
            }
            if (protoCtor == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
            }
            Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
            proto.setPrototype(ScriptableObject.getObjectPrototype(scope));
            String className = proto.getClassName();
            boolean hasPrefix = false;
            Method[] ctorMeths = FunctionObject.findMethods(clazz, "jsConstructor");
            Executable ctorMember = null;
            if (ctorMeths != null) {
                if (ctorMeths.length > 1) {
                    throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", ctorMeths[0], ctorMeths[1]));
                }
                ctorMember = ctorMeths[0];
                hasPrefix = true;
            }
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                String prefix = null;
                if (!name.startsWith("js")) {
                    prefix = null;
                } else if (name.startsWith("js_")) {
                    prefix = "js_";
                } else if (name.startsWith("jsFunction_")) {
                    prefix = "jsFunction_";
                } else if (name.startsWith("jsStaticFunction_")) {
                    prefix = "jsStaticFunction_";
                } else if (name.startsWith("jsProperty_")) {
                    prefix = "jsProperty_";
                } else if (name.startsWith("jsGet_")) {
                    prefix = "jsGet_";
                } else if (name.startsWith("jsSet_")) {
                    prefix = "jsSet_";
                }
                if (prefix != null) {
                    hasPrefix = true;
                    name = name.substring(prefix.length());
                }
                if (!name.equals(className)) continue;
                if (ctorMember != null) {
                    throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", ctorMember, methods[i]));
                }
                ctorMember = methods[i];
            }
            if (ctorMember == null) {
                if (ctors.length == 1) {
                    ctorMember = ctors[0];
                } else if (ctors.length == 2) {
                    if (ctors[0].getParameterTypes().length == 0) {
                        ctorMember = ctors[1];
                    } else if (ctors[1].getParameterTypes().length == 0) {
                        ctorMember = ctors[0];
                    }
                }
                if (ctorMember == null) {
                    throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
                }
            }
            if ((ctor = new FunctionObject(className, ctorMember, scope)).isVarArgsMethod()) {
                throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
            }
            ctor.addAsConstructor(scope, proto);
            if (!hasPrefix && exclusionList == null) {
                exclusionList = ScriptableObject.getExclusionList();
            }
            Method finishInit = null;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] parmTypes;
                if (!hasPrefix && methods[i].getDeclaringClass() != clazz) continue;
                String name = methods[i].getName();
                if (name.equals("finishInit") && (parmTypes = methods[i].getParameterTypes()).length == 3 && parmTypes[0] == ScriptRuntime.ScriptableClass && parmTypes[1] == (class$org$mozilla$javascript$FunctionObject == null ? ScriptableObject.class$("org.mozilla.javascript.FunctionObject") : class$org$mozilla$javascript$FunctionObject) && parmTypes[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methods[i].getModifiers())) {
                    finishInit = methods[i];
                    continue;
                }
                if (name.indexOf(36) != -1 || name.equals("jsConstructor")) continue;
                String prefix = null;
                if (hasPrefix) {
                    if (name.startsWith("js_")) {
                        prefix = "js_";
                    } else if (name.startsWith("jsFunction_")) {
                        prefix = "jsFunction_";
                    } else if (name.startsWith("jsStaticFunction_")) {
                        prefix = "jsStaticFunction_";
                        if (!Modifier.isStatic(methods[i].getModifiers())) {
                            throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                        }
                    } else if (name.startsWith("jsProperty_")) {
                        prefix = "jsProperty_";
                    } else if (name.startsWith("jsGet_")) {
                        prefix = "jsGet_";
                    } else {
                        if (!name.startsWith("jsSet_")) continue;
                        prefix = "jsSet_";
                    }
                    name = name.substring(prefix.length());
                } else if (exclusionList.get(name) != null) continue;
                if (methods[i] == ctorMember || prefix != null && prefix.equals("jsSet_")) continue;
                if (prefix != null && prefix.equals("jsGet_")) {
                    if (!(proto instanceof ScriptableObject)) {
                        throw PropertyException.withMessage2("msg.extend.scriptable", proto.getClass().toString(), name);
                    }
                    Method[] setter = FunctionObject.findMethods(clazz, "jsSet_".concat(String.valueOf(String.valueOf(name))));
                    if (setter != null && setter.length != 1) {
                        throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
                    }
                    int attr = 6 | (setter != null ? 0 : 1);
                    Method m = setter == null ? null : setter[0];
                    ((ScriptableObject)proto).defineProperty(name, null, methods[i], m, attr);
                    continue;
                }
                if (!(!name.startsWith("get") && !name.startsWith("set") || name.length() <= 3 || hasPrefix && (prefix.equals("jsFunction_") || prefix.equals("jsStaticFunction_")))) {
                    if (!(proto instanceof ScriptableObject)) {
                        throw PropertyException.withMessage2("msg.extend.scriptable", proto.getClass().toString(), name);
                    }
                    if (name.startsWith("set")) continue;
                    StringBuffer buf = new StringBuffer();
                    char c = name.charAt(3);
                    buf.append(Character.toLowerCase(c));
                    if (name.length() > 4) {
                        buf.append(name.substring(4));
                    }
                    String propertyName = buf.toString();
                    buf.setCharAt(0, c);
                    buf.insert(0, "set");
                    String setterName = buf.toString();
                    Method[] setter = FunctionObject.findMethods(clazz, hasPrefix ? "js_".concat(String.valueOf(String.valueOf(setterName))) : setterName);
                    if (setter != null && setter.length != 1) {
                        throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
                    }
                    if (setter == null && hasPrefix) {
                        setter = FunctionObject.findMethods(clazz, "jsProperty_".concat(String.valueOf(String.valueOf(setterName))));
                    }
                    int attr = 6 | (setter != null ? 0 : 1);
                    Method m = setter == null ? null : setter[0];
                    ((ScriptableObject)proto).defineProperty(propertyName, null, methods[i], m, attr);
                    continue;
                }
                FunctionObject f = new FunctionObject(name, methods[i], proto);
                if (f.isVarArgsConstructor()) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
                }
                Scriptable dest = prefix == "jsStaticFunction_" ? ctor : proto;
                ScriptableObject.defineProperty(dest, name, f, 2);
                if (!sealed) continue;
                f.sealObject();
                f.addPropertyAttribute(1);
            }
            if (finishInit != null) {
                Object[] finishArgs = new Object[]{scope, ctor, proto};
                finishInit.invoke(null, finishArgs);
            }
            if (!sealed) break block58;
            ctor.sealObject();
            ctor.addPropertyAttribute(1);
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
                ((ScriptableObject)proto).addPropertyAttribute(1);
            }
        }
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.put(propertyName, (Scriptable)this, value);
        try {
            this.setAttributes(propertyName, (Scriptable)this, attributes);
        }
        catch (PropertyException e) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        if (destination instanceof ScriptableObject) {
            ScriptableObject obj = (ScriptableObject)destination;
            obj.defineProperty(propertyName, value, attributes);
        } else {
            destination.put(propertyName, destination, value);
        }
    }

    public void defineProperty(String propertyName, Class clazz, int attributes) throws PropertyException {
        StringBuffer buf = new StringBuffer(propertyName);
        buf.setCharAt(0, Character.toUpperCase(propertyName.charAt(0)));
        String s = buf.toString();
        Method[] getter = FunctionObject.findMethods(clazz, "get".concat(String.valueOf(String.valueOf(s))));
        Method[] setter = FunctionObject.findMethods(clazz, "set".concat(String.valueOf(String.valueOf(s))));
        if (setter == null) {
            attributes |= 1;
        }
        if (getter.length != 1 || setter != null && setter.length != 1) {
            throw PropertyException.withMessage2("msg.no.overload", propertyName, clazz.getName());
        }
        this.defineProperty(propertyName, null, getter[0], setter == null ? null : setter[0], attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) throws PropertyException {
        Class<?>[] parmTypes;
        int flags = 1;
        if (delegateTo == null && Modifier.isStatic(getter.getModifiers())) {
            delegateTo = HAS_STATIC_ACCESSORS;
        }
        if ((parmTypes = getter.getParameterTypes()).length != 0) {
            if (parmTypes.length != 1 || parmTypes[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", getter.toString());
            }
        } else if (delegateTo != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", getter.toString());
        }
        if (setter != null) {
            flags |= 2;
            if (delegateTo == HAS_STATIC_ACCESSORS != Modifier.isStatic(setter.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 2) {
                if (parmTypes[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (delegateTo == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", setter.toString());
                }
            } else if (parmTypes.length == 1) {
                if (delegateTo != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", setter.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
        }
        GetterSlot slot = (GetterSlot)this.getSlotToSet(propertyName, propertyName.hashCode(), true);
        slot.delegateTo = delegateTo;
        slot.getter = getter;
        slot.setter = setter;
        slot.setterReturnsValue = setter != null && setter.getReturnType() != Void.TYPE;
        slot.value = null;
        slot.attributes = (short)attributes;
        slot.flags = (byte)flags;
    }

    public void defineFunctionProperties(String[] names, Class clazz, int attributes) throws PropertyException {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Method[] m = FunctionObject.findMethods(clazz, name);
            if (m == null) {
                throw PropertyException.withMessage2("msg.method.not.found", name, clazz.getName());
            }
            if (m.length > 1) {
                throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m[0], this);
            this.defineProperty(name, f, attributes);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object ctor = ScriptRuntime.getTopLevelProp(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor == Scriptable.NOT_FOUND || !(ctor instanceof Scriptable)) {
            return null;
        }
        Scriptable ctorObj = (Scriptable)ctor;
        if (!ctorObj.has("prototype", ctorObj)) {
            return null;
        }
        Object proto = ctorObj.get("prototype", ctorObj);
        if (!(proto instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)proto;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable next = obj;
        while ((next = (obj = next).getParentScope()) != null) {
        }
        return obj;
    }

    public void sealObject() {
        this.count = -1;
    }

    public boolean isSealed() {
        return this.count == -1;
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        Scriptable start = obj;
        do {
            if (!obj.has(name, start)) continue;
            return true;
        } while ((obj = obj.getPrototype()) != null);
        return false;
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        Scriptable start = obj;
        do {
            if (!obj.has(index, start)) continue;
            return true;
        } while ((obj = obj.getPrototype()) != null);
        return false;
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return base.get(name, obj) == Scriptable.NOT_FOUND;
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return base.get(index, obj) == Scriptable.NOT_FOUND;
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        Hashtable<Object, Object> h = new Hashtable<Object, Object>();
        while (obj != null) {
            Object[] ids = obj.getIds();
            for (int i = 0; i < ids.length; ++i) {
                h.put(ids[i], ids[i]);
            }
            obj = obj.getPrototype();
        }
        Object[] result = new Object[h.size()];
        Enumeration e = h.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            result[n++] = e.nextElement();
        }
        return result;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) throws JavaScriptException {
        Object object;
        Context cx = Context.enter();
        try {
            Object fun = ScriptableObject.getProperty(obj, methodName);
            if (fun == Scriptable.NOT_FOUND) {
                fun = Undefined.instance;
            }
            object = ScriptRuntime.call(cx, fun, obj, args, ScriptableObject.getTopLevelScope(obj));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    private static Scriptable getBase(Scriptable obj, String s) {
        for (Scriptable m = obj; m != null; m = m.getPrototype()) {
            if (!m.has(s, obj)) continue;
            return m;
        }
        return null;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        for (Scriptable m = obj; m != null; m = m.getPrototype()) {
            if (!m.has(index, obj)) continue;
            return m;
        }
        return null;
    }

    synchronized void addPropertyAttribute(int attribute) {
        if (this.slots == null) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            Slot slot = this.slots[i];
            if (slot == null || slot == REMOVED || (slot.flags & 2) != 0 && attribute == 1) continue;
            slot.attributes = (short)(slot.attributes | attribute);
        }
    }

    private Slot getSlot(String id, int index, boolean shouldDelete) {
        int start;
        Slot[] slots = this.slots;
        if (slots == null) {
            return null;
        }
        int i = start = (index & Integer.MAX_VALUE) % slots.length;
        do {
            Slot slot;
            if ((slot = slots[i]) == null) {
                return null;
            }
            if (slot != REMOVED && slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                if (shouldDelete && (slot.attributes & 4) == 0) {
                    slot.wasDeleted = 1;
                    slots[i] = REMOVED;
                    --this.count;
                    if (slot == this.lastAccess) {
                        this.lastAccess = REMOVED;
                    }
                }
                return slot;
            }
            if (++i != slots.length) continue;
            i = 0;
        } while (i != start);
        return null;
    }

    private Slot getSlotToSet(String id, int index, boolean getterSlot) {
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        int start = (index & Integer.MAX_VALUE) % this.slots.length;
        boolean sawRemoved = false;
        int i = start;
        do {
            Slot slot;
            if ((slot = this.slots[i]) == null) {
                return this.addSlot(id, index, getterSlot);
            }
            if (slot == REMOVED) {
                sawRemoved = true;
            } else if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != this.slots.length) continue;
            i = 0;
        } while (i != start);
        if (sawRemoved) {
            return this.addSlot(id, index, getterSlot);
        }
        throw new RuntimeException("Hashtable internal error");
    }

    private synchronized Slot addSlot(String id, int index, boolean getterSlot) {
        int start;
        if (this.count == -1) {
            throw Context.reportRuntimeError0("msg.add.sealed");
        }
        int i = start = (index & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[i]) == null || slot == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.getSlotToSet(id, index, getterSlot);
                }
                slot = getterSlot ? new GetterSlot() : new Slot();
                slot.stringKey = id;
                slot.intKey = index;
                this.slots[i] = slot;
                ++this.count;
                return slot;
            }
            if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != this.slots.length) continue;
            i = 0;
        } while (i != start);
        throw new RuntimeException("Hashtable internal error");
    }

    private synchronized void removeSlot(String name, int index) {
        if (this.count == -1) {
            throw Context.reportRuntimeError0("msg.remove.sealed");
        }
        this.getSlot(name, index, true);
    }

    private synchronized void grow() {
        Slot[] newSlots = new Slot[this.slots.length * 2 + 1];
        for (int j = this.slots.length - 1; j >= 0; --j) {
            Slot slot = this.slots[j];
            if (slot == null || slot == REMOVED) continue;
            int k = (slot.intKey & Integer.MAX_VALUE) % newSlots.length;
            while (newSlots[k] != null) {
                if (++k != newSlots.length) continue;
                k = 0;
            }
            newSlots[k] = slot;
        }
        this.slots = newSlots;
    }

    private static Hashtable getExclusionList() {
        if (exclusionList != null) {
            return exclusionList;
        }
        Hashtable<String, Boolean> result = new Hashtable<String, Boolean>(17);
        Method[] methods = ScriptRuntime.FunctionClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            result.put(methods[i].getName(), Boolean.TRUE);
        }
        exclusionList = result;
        return result;
    }

    Object[] getIds(boolean getAll) {
        Slot[] s = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s == null) {
            return a;
        }
        int c = 0;
        for (int i = 0; i < s.length; ++i) {
            Slot slot = s[i];
            if (slot == null || slot == REMOVED || !getAll && (slot.attributes & 2) != 0) continue;
            if (c == 0) {
                a = new Object[s.length - i];
            }
            a[c++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
        }
        if (c == a.length) {
            return a;
        }
        Object[] result = new Object[c];
        System.arraycopy(a, 0, result, 0, c);
        return result;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        EMPTY = 0;
        READONLY = 1;
        DONTENUM = 2;
        PERMANENT = 4;
        HAS_STATIC_ACCESSORS = Void.TYPE;
        REMOVED = new Slot();
        exclusionList = null;
        ContextClass = class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = ScriptableObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context;
    }

    private static class GetterSlot
    extends Slot {
        Object delegateTo;
        Method getter;
        Method setter;
        boolean setterReturnsValue;

        private GetterSlot() {
        }
    }

    private static class Slot {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        byte wasDeleted;

        private Slot() {
        }

        static {
            HAS_GETTER = 1;
            HAS_SETTER = 2;
        }
    }
}

